/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.AccountScope;
import software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays;
import software.amazon.awssdk.services.costexplorer.model.PaymentOption;
import software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationDetail;
import software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationDetailsCopier;
import software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationSummary;
import software.amazon.awssdk.services.costexplorer.model.ServiceSpecification;
import software.amazon.awssdk.services.costexplorer.model.TermInYears;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservationPurchaseRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservationPurchaseRecommendation> {
    private static final SdkField<String> ACCOUNT_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountScope").getter(ReservationPurchaseRecommendation.getter(ReservationPurchaseRecommendation::accountScopeAsString)).setter(ReservationPurchaseRecommendation.setter(Builder::accountScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountScope").build()}).build();
    private static final SdkField<String> LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LookbackPeriodInDays").getter(ReservationPurchaseRecommendation.getter(ReservationPurchaseRecommendation::lookbackPeriodInDaysAsString)).setter(ReservationPurchaseRecommendation.setter(Builder::lookbackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackPeriodInDays").build()}).build();
    private static final SdkField<String> TERM_IN_YEARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TermInYears").getter(ReservationPurchaseRecommendation.getter(ReservationPurchaseRecommendation::termInYearsAsString)).setter(ReservationPurchaseRecommendation.setter(Builder::termInYears)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermInYears").build()}).build();
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaymentOption").getter(ReservationPurchaseRecommendation.getter(ReservationPurchaseRecommendation::paymentOptionAsString)).setter(ReservationPurchaseRecommendation.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()}).build();
    private static final SdkField<ServiceSpecification> SERVICE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceSpecification").getter(ReservationPurchaseRecommendation.getter(ReservationPurchaseRecommendation::serviceSpecification)).setter(ReservationPurchaseRecommendation.setter(Builder::serviceSpecification)).constructor(ServiceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSpecification").build()}).build();
    private static final SdkField<List<ReservationPurchaseRecommendationDetail>> RECOMMENDATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecommendationDetails").getter(ReservationPurchaseRecommendation.getter(ReservationPurchaseRecommendation::recommendationDetails)).setter(ReservationPurchaseRecommendation.setter(Builder::recommendationDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservationPurchaseRecommendationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ReservationPurchaseRecommendationSummary> RECOMMENDATION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecommendationSummary").getter(ReservationPurchaseRecommendation.getter(ReservationPurchaseRecommendation::recommendationSummary)).setter(ReservationPurchaseRecommendation.setter(Builder::recommendationSummary)).constructor(ReservationPurchaseRecommendationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SCOPE_FIELD, LOOKBACK_PERIOD_IN_DAYS_FIELD, TERM_IN_YEARS_FIELD, PAYMENT_OPTION_FIELD, SERVICE_SPECIFICATION_FIELD, RECOMMENDATION_DETAILS_FIELD, RECOMMENDATION_SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountScope;
    private final String lookbackPeriodInDays;
    private final String termInYears;
    private final String paymentOption;
    private final ServiceSpecification serviceSpecification;
    private final List<ReservationPurchaseRecommendationDetail> recommendationDetails;
    private final ReservationPurchaseRecommendationSummary recommendationSummary;

    private ReservationPurchaseRecommendation(BuilderImpl builder) {
        this.accountScope = builder.accountScope;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
        this.termInYears = builder.termInYears;
        this.paymentOption = builder.paymentOption;
        this.serviceSpecification = builder.serviceSpecification;
        this.recommendationDetails = builder.recommendationDetails;
        this.recommendationSummary = builder.recommendationSummary;
    }

    public AccountScope accountScope() {
        return AccountScope.fromValue(this.accountScope);
    }

    public String accountScopeAsString() {
        return this.accountScope;
    }

    public LookbackPeriodInDays lookbackPeriodInDays() {
        return LookbackPeriodInDays.fromValue(this.lookbackPeriodInDays);
    }

    public String lookbackPeriodInDaysAsString() {
        return this.lookbackPeriodInDays;
    }

    public TermInYears termInYears() {
        return TermInYears.fromValue(this.termInYears);
    }

    public String termInYearsAsString() {
        return this.termInYears;
    }

    public PaymentOption paymentOption() {
        return PaymentOption.fromValue(this.paymentOption);
    }

    public String paymentOptionAsString() {
        return this.paymentOption;
    }

    public ServiceSpecification serviceSpecification() {
        return this.serviceSpecification;
    }

    public boolean hasRecommendationDetails() {
        return this.recommendationDetails != null && !(this.recommendationDetails instanceof SdkAutoConstructList);
    }

    public List<ReservationPurchaseRecommendationDetail> recommendationDetails() {
        return this.recommendationDetails;
    }

    public ReservationPurchaseRecommendationSummary recommendationSummary() {
        return this.recommendationSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookbackPeriodInDaysAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.termInYearsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationDetails() ? this.recommendationDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationPurchaseRecommendation)) {
            return false;
        }
        ReservationPurchaseRecommendation other = (ReservationPurchaseRecommendation)obj;
        return Objects.equals(this.accountScopeAsString(), other.accountScopeAsString()) && Objects.equals(this.lookbackPeriodInDaysAsString(), other.lookbackPeriodInDaysAsString()) && Objects.equals(this.termInYearsAsString(), other.termInYearsAsString()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && Objects.equals(this.serviceSpecification(), other.serviceSpecification()) && this.hasRecommendationDetails() == other.hasRecommendationDetails() && Objects.equals(this.recommendationDetails(), other.recommendationDetails()) && Objects.equals(this.recommendationSummary(), other.recommendationSummary());
    }

    public String toString() {
        return ToString.builder((String)"ReservationPurchaseRecommendation").add("AccountScope", (Object)this.accountScopeAsString()).add("LookbackPeriodInDays", (Object)this.lookbackPeriodInDaysAsString()).add("TermInYears", (Object)this.termInYearsAsString()).add("PaymentOption", (Object)this.paymentOptionAsString()).add("ServiceSpecification", (Object)this.serviceSpecification()).add("RecommendationDetails", this.hasRecommendationDetails() ? this.recommendationDetails() : null).add("RecommendationSummary", (Object)this.recommendationSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountScope": {
                return Optional.ofNullable(clazz.cast(this.accountScopeAsString()));
            }
            case "LookbackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookbackPeriodInDaysAsString()));
            }
            case "TermInYears": {
                return Optional.ofNullable(clazz.cast(this.termInYearsAsString()));
            }
            case "PaymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "ServiceSpecification": {
                return Optional.ofNullable(clazz.cast(this.serviceSpecification()));
            }
            case "RecommendationDetails": {
                return Optional.ofNullable(clazz.cast(this.recommendationDetails()));
            }
            case "RecommendationSummary": {
                return Optional.ofNullable(clazz.cast(this.recommendationSummary()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservationPurchaseRecommendation, T> g) {
        return obj -> g.apply((ReservationPurchaseRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountScope;
        private String lookbackPeriodInDays;
        private String termInYears;
        private String paymentOption;
        private ServiceSpecification serviceSpecification;
        private List<ReservationPurchaseRecommendationDetail> recommendationDetails = DefaultSdkAutoConstructList.getInstance();
        private ReservationPurchaseRecommendationSummary recommendationSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationPurchaseRecommendation model) {
            this.accountScope(model.accountScope);
            this.lookbackPeriodInDays(model.lookbackPeriodInDays);
            this.termInYears(model.termInYears);
            this.paymentOption(model.paymentOption);
            this.serviceSpecification(model.serviceSpecification);
            this.recommendationDetails(model.recommendationDetails);
            this.recommendationSummary(model.recommendationSummary);
        }

        public final String getAccountScope() {
            return this.accountScope;
        }

        @Override
        public final Builder accountScope(String accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        @Override
        public final Builder accountScope(AccountScope accountScope) {
            this.accountScope(accountScope == null ? null : accountScope.toString());
            return this;
        }

        public final void setAccountScope(String accountScope) {
            this.accountScope = accountScope;
        }

        public final String getLookbackPeriodInDays() {
            return this.lookbackPeriodInDays;
        }

        @Override
        public final Builder lookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        @Override
        public final Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays) {
            this.lookbackPeriodInDays(lookbackPeriodInDays == null ? null : lookbackPeriodInDays.toString());
            return this;
        }

        public final void setLookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        public final String getTermInYears() {
            return this.termInYears;
        }

        @Override
        public final Builder termInYears(String termInYears) {
            this.termInYears = termInYears;
            return this;
        }

        @Override
        public final Builder termInYears(TermInYears termInYears) {
            this.termInYears(termInYears == null ? null : termInYears.toString());
            return this;
        }

        public final void setTermInYears(String termInYears) {
            this.termInYears = termInYears;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final ServiceSpecification.Builder getServiceSpecification() {
            return this.serviceSpecification != null ? this.serviceSpecification.toBuilder() : null;
        }

        @Override
        public final Builder serviceSpecification(ServiceSpecification serviceSpecification) {
            this.serviceSpecification = serviceSpecification;
            return this;
        }

        public final void setServiceSpecification(ServiceSpecification.BuilderImpl serviceSpecification) {
            this.serviceSpecification = serviceSpecification != null ? serviceSpecification.build() : null;
        }

        public final Collection<ReservationPurchaseRecommendationDetail.Builder> getRecommendationDetails() {
            if (this.recommendationDetails instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendationDetails != null ? (Collection)this.recommendationDetails.stream().map(ReservationPurchaseRecommendationDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recommendationDetails(Collection<ReservationPurchaseRecommendationDetail> recommendationDetails) {
            this.recommendationDetails = ReservationPurchaseRecommendationDetailsCopier.copy(recommendationDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationDetails(ReservationPurchaseRecommendationDetail ... recommendationDetails) {
            this.recommendationDetails(Arrays.asList(recommendationDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationDetails(Consumer<ReservationPurchaseRecommendationDetail.Builder> ... recommendationDetails) {
            this.recommendationDetails(Stream.of(recommendationDetails).map(c -> (ReservationPurchaseRecommendationDetail)((ReservationPurchaseRecommendationDetail.Builder)ReservationPurchaseRecommendationDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecommendationDetails(Collection<ReservationPurchaseRecommendationDetail.BuilderImpl> recommendationDetails) {
            this.recommendationDetails = ReservationPurchaseRecommendationDetailsCopier.copyFromBuilder(recommendationDetails);
        }

        public final ReservationPurchaseRecommendationSummary.Builder getRecommendationSummary() {
            return this.recommendationSummary != null ? this.recommendationSummary.toBuilder() : null;
        }

        @Override
        public final Builder recommendationSummary(ReservationPurchaseRecommendationSummary recommendationSummary) {
            this.recommendationSummary = recommendationSummary;
            return this;
        }

        public final void setRecommendationSummary(ReservationPurchaseRecommendationSummary.BuilderImpl recommendationSummary) {
            this.recommendationSummary = recommendationSummary != null ? recommendationSummary.build() : null;
        }

        public ReservationPurchaseRecommendation build() {
            return new ReservationPurchaseRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservationPurchaseRecommendation> {
        public Builder accountScope(String var1);

        public Builder accountScope(AccountScope var1);

        public Builder lookbackPeriodInDays(String var1);

        public Builder lookbackPeriodInDays(LookbackPeriodInDays var1);

        public Builder termInYears(String var1);

        public Builder termInYears(TermInYears var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);

        public Builder serviceSpecification(ServiceSpecification var1);

        default public Builder serviceSpecification(Consumer<ServiceSpecification.Builder> serviceSpecification) {
            return this.serviceSpecification((ServiceSpecification)((ServiceSpecification.Builder)ServiceSpecification.builder().applyMutation(serviceSpecification)).build());
        }

        public Builder recommendationDetails(Collection<ReservationPurchaseRecommendationDetail> var1);

        public Builder recommendationDetails(ReservationPurchaseRecommendationDetail ... var1);

        public Builder recommendationDetails(Consumer<ReservationPurchaseRecommendationDetail.Builder> ... var1);

        public Builder recommendationSummary(ReservationPurchaseRecommendationSummary var1);

        default public Builder recommendationSummary(Consumer<ReservationPurchaseRecommendationSummary.Builder> recommendationSummary) {
            return this.recommendationSummary((ReservationPurchaseRecommendationSummary)((ReservationPurchaseRecommendationSummary.Builder)ReservationPurchaseRecommendationSummary.builder().applyMutation(recommendationSummary)).build());
        }
    }
}

