/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.services.costexplorer.model.Group;
import software.amazon.awssdk.services.costexplorer.model.GroupsCopier;
import software.amazon.awssdk.services.costexplorer.model.MetricValue;
import software.amazon.awssdk.services.costexplorer.model.MetricsCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResultByTime
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResultByTime> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimePeriod").getter(ResultByTime.getter(ResultByTime::timePeriod)).setter(ResultByTime.setter(Builder::timePeriod)).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()}).build();
    private static final SdkField<Map<String, MetricValue>> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Total").getter(ResultByTime.getter(ResultByTime::total)).setter(ResultByTime.setter(Builder::total)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Group>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(ResultByTime.getter(ResultByTime::groups)).setter(ResultByTime.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Group::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ESTIMATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Estimated").getter(ResultByTime.getter(ResultByTime::estimated)).setter(ResultByTime.setter(Builder::estimated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Estimated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD, TOTAL_FIELD, GROUPS_FIELD, ESTIMATED_FIELD));
    private static final long serialVersionUID = 1L;
    private final DateInterval timePeriod;
    private final Map<String, MetricValue> total;
    private final List<Group> groups;
    private final Boolean estimated;

    private ResultByTime(BuilderImpl builder) {
        this.timePeriod = builder.timePeriod;
        this.total = builder.total;
        this.groups = builder.groups;
        this.estimated = builder.estimated;
    }

    public DateInterval timePeriod() {
        return this.timePeriod;
    }

    public boolean hasTotal() {
        return this.total != null && !(this.total instanceof SdkAutoConstructMap);
    }

    public Map<String, MetricValue> total() {
        return this.total;
    }

    public boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public List<Group> groups() {
        return this.groups;
    }

    public Boolean estimated() {
        return this.estimated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTotal() ? this.total() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.estimated());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultByTime)) {
            return false;
        }
        ResultByTime other = (ResultByTime)obj;
        return Objects.equals(this.timePeriod(), other.timePeriod()) && this.hasTotal() == other.hasTotal() && Objects.equals(this.total(), other.total()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.estimated(), other.estimated());
    }

    public String toString() {
        return ToString.builder((String)"ResultByTime").add("TimePeriod", (Object)this.timePeriod()).add("Total", this.hasTotal() ? this.total() : null).add("Groups", this.hasGroups() ? this.groups() : null).add("Estimated", (Object)this.estimated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Estimated": {
                return Optional.ofNullable(clazz.cast(this.estimated()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultByTime, T> g) {
        return obj -> g.apply((ResultByTime)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DateInterval timePeriod;
        private Map<String, MetricValue> total = DefaultSdkAutoConstructMap.getInstance();
        private List<Group> groups = DefaultSdkAutoConstructList.getInstance();
        private Boolean estimated;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultByTime model) {
            this.timePeriod(model.timePeriod);
            this.total(model.total);
            this.groups(model.groups);
            this.estimated(model.estimated);
        }

        public final DateInterval.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final Map<String, MetricValue.Builder> getTotal() {
            if (this.total instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.total != null ? CollectionUtils.mapValues(this.total, MetricValue::toBuilder) : null;
        }

        @Override
        public final Builder total(Map<String, MetricValue> total) {
            this.total = MetricsCopier.copy(total);
            return this;
        }

        public final void setTotal(Map<String, MetricValue.BuilderImpl> total) {
            this.total = MetricsCopier.copyFromBuilder(total);
        }

        public final Collection<Group.Builder> getGroups() {
            if (this.groups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groups != null ? (Collection)this.groups.stream().map(Group::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<Group> groups) {
            this.groups = GroupsCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Group ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<Group.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (Group)((Group.Builder)Group.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<Group.BuilderImpl> groups) {
            this.groups = GroupsCopier.copyFromBuilder(groups);
        }

        public final Boolean getEstimated() {
            return this.estimated;
        }

        @Override
        public final Builder estimated(Boolean estimated) {
            this.estimated = estimated;
            return this;
        }

        public final void setEstimated(Boolean estimated) {
            this.estimated = estimated;
        }

        public ResultByTime build() {
            return new ResultByTime(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResultByTime> {
        public Builder timePeriod(DateInterval var1);

        default public Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return this.timePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(timePeriod)).build());
        }

        public Builder total(Map<String, MetricValue> var1);

        public Builder groups(Collection<Group> var1);

        public Builder groups(Group ... var1);

        public Builder groups(Consumer<Group.Builder> ... var1);

        public Builder estimated(Boolean var1);
    }
}

