/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCostCategoryDefinitionRequest extends CostExplorerRequest implements
        ToCopyableBuilder<CreateCostCategoryDefinitionRequest.Builder, CreateCostCategoryDefinitionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateCostCategoryDefinitionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RULE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleVersion").getter(getter(CreateCostCategoryDefinitionRequest::ruleVersionAsString))
            .setter(setter(Builder::ruleVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleVersion").build()).build();

    private static final SdkField<List<CostCategoryRule>> RULES_FIELD = SdkField
            .<List<CostCategoryRule>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(CreateCostCategoryDefinitionRequest::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CostCategoryRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(CostCategoryRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue").getter(getter(CreateCostCategoryDefinitionRequest::defaultValue))
            .setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            RULE_VERSION_FIELD, RULES_FIELD, DEFAULT_VALUE_FIELD));

    private final String name;

    private final String ruleVersion;

    private final List<CostCategoryRule> rules;

    private final String defaultValue;

    private CreateCostCategoryDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.ruleVersion = builder.ruleVersion;
        this.rules = builder.rules;
        this.defaultValue = builder.defaultValue;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the RuleVersion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleVersion} will
     * return {@link CostCategoryRuleVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleVersionAsString}.
     * </p>
     * 
     * @return The value of the RuleVersion property for this object.
     * @see CostCategoryRuleVersion
     */
    public final CostCategoryRuleVersion ruleVersion() {
        return CostCategoryRuleVersion.fromValue(ruleVersion);
    }

    /**
     * Returns the value of the RuleVersion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleVersion} will
     * return {@link CostCategoryRuleVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleVersionAsString}.
     * </p>
     * 
     * @return The value of the RuleVersion property for this object.
     * @see CostCategoryRuleVersion
     */
    public final String ruleVersionAsString() {
        return ruleVersion;
    }

    /**
     * Returns true if the Rules property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Cost Category rules used to categorize costs. For more information, see <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html"
     * >CostCategoryRule</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Cost Category rules used to categorize costs. For more information, see <a
     *         href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html"
     *         >CostCategoryRule</a>.
     */
    public final List<CostCategoryRule> rules() {
        return rules;
    }

    /**
     * Returns the value of the DefaultValue property for this object.
     * 
     * @return The value of the DefaultValue property for this object.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ruleVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCostCategoryDefinitionRequest)) {
            return false;
        }
        CreateCostCategoryDefinitionRequest other = (CreateCostCategoryDefinitionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(ruleVersionAsString(), other.ruleVersionAsString())
                && hasRules() == other.hasRules() && Objects.equals(rules(), other.rules())
                && Objects.equals(defaultValue(), other.defaultValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCostCategoryDefinitionRequest").add("Name", name())
                .add("RuleVersion", ruleVersionAsString()).add("Rules", hasRules() ? rules() : null)
                .add("DefaultValue", defaultValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RuleVersion":
            return Optional.ofNullable(clazz.cast(ruleVersionAsString()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCostCategoryDefinitionRequest, T> g) {
        return obj -> g.apply((CreateCostCategoryDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCostCategoryDefinitionRequest> {
        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the RuleVersion property for this object.
         *
         * @param ruleVersion
         *        The new value for the RuleVersion property for this object.
         * @see CostCategoryRuleVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryRuleVersion
         */
        Builder ruleVersion(String ruleVersion);

        /**
         * Sets the value of the RuleVersion property for this object.
         *
         * @param ruleVersion
         *        The new value for the RuleVersion property for this object.
         * @see CostCategoryRuleVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryRuleVersion
         */
        Builder ruleVersion(CostCategoryRuleVersion ruleVersion);

        /**
         * <p>
         * The Cost Category rules used to categorize costs. For more information, see <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html"
         * >CostCategoryRule</a>.
         * </p>
         * 
         * @param rules
         *        The Cost Category rules used to categorize costs. For more information, see <a
         *        href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html"
         *        >CostCategoryRule</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<CostCategoryRule> rules);

        /**
         * <p>
         * The Cost Category rules used to categorize costs. For more information, see <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html"
         * >CostCategoryRule</a>.
         * </p>
         * 
         * @param rules
         *        The Cost Category rules used to categorize costs. For more information, see <a
         *        href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html"
         *        >CostCategoryRule</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(CostCategoryRule... rules);

        /**
         * <p>
         * The Cost Category rules used to categorize costs. For more information, see <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html"
         * >CostCategoryRule</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CostCategoryRule>.Builder} avoiding the
         * need to create one manually via {@link List<CostCategoryRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CostCategoryRule>.Builder#build()} is called immediately and
         * its result is passed to {@link #rules(List<CostCategoryRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<CostCategoryRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<CostCategoryRule>)
         */
        Builder rules(Consumer<CostCategoryRule.Builder>... rules);

        /**
         * Sets the value of the DefaultValue property for this object.
         *
         * @param defaultValue
         *        The new value for the DefaultValue property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String name;

        private String ruleVersion;

        private List<CostCategoryRule> rules = DefaultSdkAutoConstructList.getInstance();

        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCostCategoryDefinitionRequest model) {
            super(model);
            name(model.name);
            ruleVersion(model.ruleVersion);
            rules(model.rules);
            defaultValue(model.defaultValue);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRuleVersion() {
            return ruleVersion;
        }

        @Override
        public final Builder ruleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
            return this;
        }

        @Override
        public final Builder ruleVersion(CostCategoryRuleVersion ruleVersion) {
            this.ruleVersion(ruleVersion == null ? null : ruleVersion.toString());
            return this;
        }

        public final void setRuleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
        }

        public final List<CostCategoryRule.Builder> getRules() {
            List<CostCategoryRule.Builder> result = CostCategoryRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder rules(Collection<CostCategoryRule> rules) {
            this.rules = CostCategoryRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(CostCategoryRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<CostCategoryRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> CostCategoryRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<CostCategoryRule.BuilderImpl> rules) {
            this.rules = CostCategoryRulesListCopier.copyFromBuilder(rules);
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCostCategoryDefinitionRequest build() {
            return new CreateCostCategoryDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
