/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAnomalySubscriptionsRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetAnomalySubscriptionsRequest.Builder, GetAnomalySubscriptionsRequest> {
    private static final SdkField<List<String>> SUBSCRIPTION_ARN_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubscriptionArnList")
            .getter(getter(GetAnomalySubscriptionsRequest::subscriptionArnList))
            .setter(setter(Builder::subscriptionArnList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionArnList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorArn").getter(getter(GetAnomalySubscriptionsRequest::monitorArn))
            .setter(setter(Builder::monitorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetAnomalySubscriptionsRequest::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetAnomalySubscriptionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_ARN_LIST_FIELD,
            MONITOR_ARN_FIELD, NEXT_PAGE_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<String> subscriptionArnList;

    private final String monitorArn;

    private final String nextPageToken;

    private final Integer maxResults;

    private GetAnomalySubscriptionsRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionArnList = builder.subscriptionArnList;
        this.monitorArn = builder.monitorArn;
        this.nextPageToken = builder.nextPageToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * Returns true if the SubscriptionArnList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSubscriptionArnList() {
        return subscriptionArnList != null && !(subscriptionArnList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cost anomaly subscription ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubscriptionArnList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of cost anomaly subscription ARNs.
     */
    public final List<String> subscriptionArnList() {
        return subscriptionArnList;
    }

    /**
     * <p>
     * Cost anomaly monitor ARNs.
     * </p>
     * 
     * @return Cost anomaly monitor ARNs.
     */
    public final String monitorArn() {
        return monitorArn;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. AWS provides the token when the response from a previous call has
     * more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. AWS provides the token when the response from a previous
     *         call has more results than the maximum page size.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * The number of entries a paginated response contains.
     * </p>
     * 
     * @return The number of entries a paginated response contains.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscriptionArnList() ? subscriptionArnList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnomalySubscriptionsRequest)) {
            return false;
        }
        GetAnomalySubscriptionsRequest other = (GetAnomalySubscriptionsRequest) obj;
        return hasSubscriptionArnList() == other.hasSubscriptionArnList()
                && Objects.equals(subscriptionArnList(), other.subscriptionArnList())
                && Objects.equals(monitorArn(), other.monitorArn()) && Objects.equals(nextPageToken(), other.nextPageToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAnomalySubscriptionsRequest")
                .add("SubscriptionArnList", hasSubscriptionArnList() ? subscriptionArnList() : null)
                .add("MonitorArn", monitorArn()).add("NextPageToken", nextPageToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscriptionArnList":
            return Optional.ofNullable(clazz.cast(subscriptionArnList()));
        case "MonitorArn":
            return Optional.ofNullable(clazz.cast(monitorArn()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAnomalySubscriptionsRequest, T> g) {
        return obj -> g.apply((GetAnomalySubscriptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAnomalySubscriptionsRequest> {
        /**
         * <p>
         * A list of cost anomaly subscription ARNs.
         * </p>
         * 
         * @param subscriptionArnList
         *        A list of cost anomaly subscription ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionArnList(Collection<String> subscriptionArnList);

        /**
         * <p>
         * A list of cost anomaly subscription ARNs.
         * </p>
         * 
         * @param subscriptionArnList
         *        A list of cost anomaly subscription ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionArnList(String... subscriptionArnList);

        /**
         * <p>
         * Cost anomaly monitor ARNs.
         * </p>
         * 
         * @param monitorArn
         *        Cost anomaly monitor ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorArn(String monitorArn);

        /**
         * <p>
         * The token to retrieve the next set of results. AWS provides the token when the response from a previous call
         * has more results than the maximum page size.
         * </p>
         * 
         * @param nextPageToken
         *        The token to retrieve the next set of results. AWS provides the token when the response from a
         *        previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The number of entries a paginated response contains.
         * </p>
         * 
         * @param maxResults
         *        The number of entries a paginated response contains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private List<String> subscriptionArnList = DefaultSdkAutoConstructList.getInstance();

        private String monitorArn;

        private String nextPageToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnomalySubscriptionsRequest model) {
            super(model);
            subscriptionArnList(model.subscriptionArnList);
            monitorArn(model.monitorArn);
            nextPageToken(model.nextPageToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getSubscriptionArnList() {
            if (subscriptionArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return subscriptionArnList;
        }

        @Override
        public final Builder subscriptionArnList(Collection<String> subscriptionArnList) {
            this.subscriptionArnList = ValuesCopier.copy(subscriptionArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionArnList(String... subscriptionArnList) {
            subscriptionArnList(Arrays.asList(subscriptionArnList));
            return this;
        }

        public final void setSubscriptionArnList(Collection<String> subscriptionArnList) {
            this.subscriptionArnList = ValuesCopier.copy(subscriptionArnList);
        }

        public final String getMonitorArn() {
            return monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAnomalySubscriptionsRequest build() {
            return new GetAnomalySubscriptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
