/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSavingsPlansPurchaseRecommendationResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetSavingsPlansPurchaseRecommendationResponse.Builder, GetSavingsPlansPurchaseRecommendationResponse> {
    private static final SdkField<SavingsPlansPurchaseRecommendationMetadata> METADATA_FIELD = SdkField
            .<SavingsPlansPurchaseRecommendationMetadata> builder(MarshallingType.SDK_POJO).memberName("Metadata")
            .getter(getter(GetSavingsPlansPurchaseRecommendationResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(SavingsPlansPurchaseRecommendationMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<SavingsPlansPurchaseRecommendation> SAVINGS_PLANS_PURCHASE_RECOMMENDATION_FIELD = SdkField
            .<SavingsPlansPurchaseRecommendation> builder(MarshallingType.SDK_POJO)
            .memberName("SavingsPlansPurchaseRecommendation")
            .getter(getter(GetSavingsPlansPurchaseRecommendationResponse::savingsPlansPurchaseRecommendation))
            .setter(setter(Builder::savingsPlansPurchaseRecommendation))
            .constructor(SavingsPlansPurchaseRecommendation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansPurchaseRecommendation")
                    .build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetSavingsPlansPurchaseRecommendationResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD,
            SAVINGS_PLANS_PURCHASE_RECOMMENDATION_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final SavingsPlansPurchaseRecommendationMetadata metadata;

    private final SavingsPlansPurchaseRecommendation savingsPlansPurchaseRecommendation;

    private final String nextPageToken;

    private GetSavingsPlansPurchaseRecommendationResponse(BuilderImpl builder) {
        super(builder);
        this.metadata = builder.metadata;
        this.savingsPlansPurchaseRecommendation = builder.savingsPlansPurchaseRecommendation;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * Information regarding this specific recommendation set.
     * </p>
     * 
     * @return Information regarding this specific recommendation set.
     */
    public final SavingsPlansPurchaseRecommendationMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * Contains your request parameters, Savings Plan Recommendations Summary, and Details.
     * </p>
     * 
     * @return Contains your request parameters, Savings Plan Recommendations Summary, and Details.
     */
    public final SavingsPlansPurchaseRecommendation savingsPlansPurchaseRecommendation() {
        return savingsPlansPurchaseRecommendation;
    }

    /**
     * <p>
     * The token for the next set of retrievable results. AWS provides the token when the response from a previous call
     * has more results than the maximum page size.
     * </p>
     * 
     * @return The token for the next set of retrievable results. AWS provides the token when the response from a
     *         previous call has more results than the maximum page size.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansPurchaseRecommendation());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSavingsPlansPurchaseRecommendationResponse)) {
            return false;
        }
        GetSavingsPlansPurchaseRecommendationResponse other = (GetSavingsPlansPurchaseRecommendationResponse) obj;
        return Objects.equals(metadata(), other.metadata())
                && Objects.equals(savingsPlansPurchaseRecommendation(), other.savingsPlansPurchaseRecommendation())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSavingsPlansPurchaseRecommendationResponse").add("Metadata", metadata())
                .add("SavingsPlansPurchaseRecommendation", savingsPlansPurchaseRecommendation())
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "SavingsPlansPurchaseRecommendation":
            return Optional.ofNullable(clazz.cast(savingsPlansPurchaseRecommendation()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSavingsPlansPurchaseRecommendationResponse, T> g) {
        return obj -> g.apply((GetSavingsPlansPurchaseRecommendationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSavingsPlansPurchaseRecommendationResponse> {
        /**
         * <p>
         * Information regarding this specific recommendation set.
         * </p>
         * 
         * @param metadata
         *        Information regarding this specific recommendation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(SavingsPlansPurchaseRecommendationMetadata metadata);

        /**
         * <p>
         * Information regarding this specific recommendation set.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link SavingsPlansPurchaseRecommendationMetadata.Builder} avoiding the need to create one manually via
         * {@link SavingsPlansPurchaseRecommendationMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link SavingsPlansPurchaseRecommendationMetadata.Builder#build()} is
         * called immediately and its result is passed to {@link #metadata(SavingsPlansPurchaseRecommendationMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link SavingsPlansPurchaseRecommendationMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(SavingsPlansPurchaseRecommendationMetadata)
         */
        default Builder metadata(Consumer<SavingsPlansPurchaseRecommendationMetadata.Builder> metadata) {
            return metadata(SavingsPlansPurchaseRecommendationMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * Contains your request parameters, Savings Plan Recommendations Summary, and Details.
         * </p>
         * 
         * @param savingsPlansPurchaseRecommendation
         *        Contains your request parameters, Savings Plan Recommendations Summary, and Details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansPurchaseRecommendation(SavingsPlansPurchaseRecommendation savingsPlansPurchaseRecommendation);

        /**
         * <p>
         * Contains your request parameters, Savings Plan Recommendations Summary, and Details.
         * </p>
         * This is a convenience that creates an instance of the {@link SavingsPlansPurchaseRecommendation.Builder}
         * avoiding the need to create one manually via {@link SavingsPlansPurchaseRecommendation#builder()}.
         *
         * When the {@link Consumer} completes, {@link SavingsPlansPurchaseRecommendation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #savingsPlansPurchaseRecommendation(SavingsPlansPurchaseRecommendation)}.
         * 
         * @param savingsPlansPurchaseRecommendation
         *        a consumer that will call methods on {@link SavingsPlansPurchaseRecommendation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsPlansPurchaseRecommendation(SavingsPlansPurchaseRecommendation)
         */
        default Builder savingsPlansPurchaseRecommendation(
                Consumer<SavingsPlansPurchaseRecommendation.Builder> savingsPlansPurchaseRecommendation) {
            return savingsPlansPurchaseRecommendation(SavingsPlansPurchaseRecommendation.builder()
                    .applyMutation(savingsPlansPurchaseRecommendation).build());
        }

        /**
         * <p>
         * The token for the next set of retrievable results. AWS provides the token when the response from a previous
         * call has more results than the maximum page size.
         * </p>
         * 
         * @param nextPageToken
         *        The token for the next set of retrievable results. AWS provides the token when the response from a
         *        previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private SavingsPlansPurchaseRecommendationMetadata metadata;

        private SavingsPlansPurchaseRecommendation savingsPlansPurchaseRecommendation;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSavingsPlansPurchaseRecommendationResponse model) {
            super(model);
            metadata(model.metadata);
            savingsPlansPurchaseRecommendation(model.savingsPlansPurchaseRecommendation);
            nextPageToken(model.nextPageToken);
        }

        public final SavingsPlansPurchaseRecommendationMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(SavingsPlansPurchaseRecommendationMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(SavingsPlansPurchaseRecommendationMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final SavingsPlansPurchaseRecommendation.Builder getSavingsPlansPurchaseRecommendation() {
            return savingsPlansPurchaseRecommendation != null ? savingsPlansPurchaseRecommendation.toBuilder() : null;
        }

        @Override
        public final Builder savingsPlansPurchaseRecommendation(
                SavingsPlansPurchaseRecommendation savingsPlansPurchaseRecommendation) {
            this.savingsPlansPurchaseRecommendation = savingsPlansPurchaseRecommendation;
            return this;
        }

        public final void setSavingsPlansPurchaseRecommendation(
                SavingsPlansPurchaseRecommendation.BuilderImpl savingsPlansPurchaseRecommendation) {
            this.savingsPlansPurchaseRecommendation = savingsPlansPurchaseRecommendation != null ? savingsPlansPurchaseRecommendation
                    .build() : null;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetSavingsPlansPurchaseRecommendationResponse build() {
            return new GetSavingsPlansPurchaseRecommendationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
