/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSavingsPlansUtilizationRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetSavingsPlansUtilizationRequest.Builder, GetSavingsPlansUtilizationRequest> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .memberName("TimePeriod").getter(getter(GetSavingsPlansUtilizationRequest::timePeriod))
            .setter(setter(Builder::timePeriod)).constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final SdkField<String> GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Granularity").getter(getter(GetSavingsPlansUtilizationRequest::granularityAsString))
            .setter(setter(Builder::granularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()).build();

    private static final SdkField<Expression> FILTER_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("Filter").getter(getter(GetSavingsPlansUtilizationRequest::filter)).setter(setter(Builder::filter))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<SortDefinition> SORT_BY_FIELD = SdkField.<SortDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("SortBy").getter(getter(GetSavingsPlansUtilizationRequest::sortBy)).setter(setter(Builder::sortBy))
            .constructor(SortDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD,
            GRANULARITY_FIELD, FILTER_FIELD, SORT_BY_FIELD));

    private final DateInterval timePeriod;

    private final String granularity;

    private final Expression filter;

    private final SortDefinition sortBy;

    private GetSavingsPlansUtilizationRequest(BuilderImpl builder) {
        super(builder);
        this.timePeriod = builder.timePeriod;
        this.granularity = builder.granularity;
        this.filter = builder.filter;
        this.sortBy = builder.sortBy;
    }

    /**
     * <p>
     * The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The
     * <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't
     * be used as an <code>End</code> date.
     * </p>
     * 
     * @return The time period that you want the usage and costs for. The <code>Start</code> date must be within 13
     *         months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date.
     *         Future dates can't be used as an <code>End</code> date.
     */
    public final DateInterval timePeriod() {
        return timePeriod;
    }

    /**
     * <p>
     * The granularity of the Amazon Web Services utillization data for your Savings Plans.
     * </p>
     * <p>
     * The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
     * granularities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link Granularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return The granularity of the Amazon Web Services utillization data for your Savings Plans.</p>
     *         <p>
     *         The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and
     *         <code>MONTHLY</code> granularities.
     * @see Granularity
     */
    public final Granularity granularity() {
        return Granularity.fromValue(granularity);
    }

    /**
     * <p>
     * The granularity of the Amazon Web Services utillization data for your Savings Plans.
     * </p>
     * <p>
     * The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
     * granularities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link Granularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return The granularity of the Amazon Web Services utillization data for your Savings Plans.</p>
     *         <p>
     *         The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and
     *         <code>MONTHLY</code> granularities.
     * @see Granularity
     */
    public final String granularityAsString() {
        return granularity;
    }

    /**
     * <p>
     * Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the
     * following dimensions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LINKED_ACCOUNT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAVINGS_PLAN_ARN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAVINGS_PLANS_TYPE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PAYMENT_OPTION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE_TYPE_FAMILY</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>GetSavingsPlansUtilization</code> uses the same <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
     * object as the other operations, but only <code>AND</code> is supported among each dimension.
     * </p>
     * 
     * @return Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data
     *         with the following dimensions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LINKED_ACCOUNT</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAVINGS_PLAN_ARN</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAVINGS_PLANS_TYPE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PAYMENT_OPTION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTANCE_TYPE_FAMILY</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>GetSavingsPlansUtilization</code> uses the same <a
     *         href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html"
     *         >Expression</a> object as the other operations, but only <code>AND</code> is supported among each
     *         dimension.
     */
    public final Expression filter() {
        return filter;
    }

    /**
     * <p>
     * The value by which you want to sort the data.
     * </p>
     * <p>
     * The following values are supported for <code>Key</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UtilizationPercentage</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TotalCommitment</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UsedCommitment</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UnusedCommitment</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NetSavings</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
     * </p>
     * 
     * @return The value by which you want to sort the data.</p>
     *         <p>
     *         The following values are supported for <code>Key</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UtilizationPercentage</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TotalCommitment</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UsedCommitment</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UnusedCommitment</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NetSavings</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
     */
    public final SortDefinition sortBy() {
        return sortBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSavingsPlansUtilizationRequest)) {
            return false;
        }
        GetSavingsPlansUtilizationRequest other = (GetSavingsPlansUtilizationRequest) obj;
        return Objects.equals(timePeriod(), other.timePeriod())
                && Objects.equals(granularityAsString(), other.granularityAsString()) && Objects.equals(filter(), other.filter())
                && Objects.equals(sortBy(), other.sortBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSavingsPlansUtilizationRequest").add("TimePeriod", timePeriod())
                .add("Granularity", granularityAsString()).add("Filter", filter()).add("SortBy", sortBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "Granularity":
            return Optional.ofNullable(clazz.cast(granularityAsString()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSavingsPlansUtilizationRequest, T> g) {
        return obj -> g.apply((GetSavingsPlansUtilizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSavingsPlansUtilizationRequest> {
        /**
         * <p>
         * The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months.
         * The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future
         * dates can't be used as an <code>End</code> date.
         * </p>
         * 
         * @param timePeriod
         *        The time period that you want the usage and costs for. The <code>Start</code> date must be within 13
         *        months. The <code>End</code> date must be after the <code>Start</code> date, and before the current
         *        date. Future dates can't be used as an <code>End</code> date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * <p>
         * The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months.
         * The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future
         * dates can't be used as an <code>End</code> date.
         * </p>
         * This is a convenience that creates an instance of the {@link DateInterval.Builder} avoiding the need to
         * create one manually via {@link DateInterval#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }

        /**
         * <p>
         * The granularity of the Amazon Web Services utillization data for your Savings Plans.
         * </p>
         * <p>
         * The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and
         * <code>MONTHLY</code> granularities.
         * </p>
         * 
         * @param granularity
         *        The granularity of the Amazon Web Services utillization data for your Savings Plans.</p>
         *        <p>
         *        The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and
         *        <code>MONTHLY</code> granularities.
         * @see Granularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Granularity
         */
        Builder granularity(String granularity);

        /**
         * <p>
         * The granularity of the Amazon Web Services utillization data for your Savings Plans.
         * </p>
         * <p>
         * The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and
         * <code>MONTHLY</code> granularities.
         * </p>
         * 
         * @param granularity
         *        The granularity of the Amazon Web Services utillization data for your Savings Plans.</p>
         *        <p>
         *        The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and
         *        <code>MONTHLY</code> granularities.
         * @see Granularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Granularity
         */
        Builder granularity(Granularity granularity);

        /**
         * <p>
         * Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with
         * the following dimensions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LINKED_ACCOUNT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_PLAN_ARN</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_PLANS_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAYMENT_OPTION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE_TYPE_FAMILY</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>GetSavingsPlansUtilization</code> uses the same <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
         * object as the other operations, but only <code>AND</code> is supported among each dimension.
         * </p>
         * 
         * @param filter
         *        Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter
         *        data with the following dimensions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LINKED_ACCOUNT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAVINGS_PLAN_ARN</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAVINGS_PLANS_TYPE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PAYMENT_OPTION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTANCE_TYPE_FAMILY</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>GetSavingsPlansUtilization</code> uses the same <a
         *        href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html"
         *        >Expression</a> object as the other operations, but only <code>AND</code> is supported among each
         *        dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Expression filter);

        /**
         * <p>
         * Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with
         * the following dimensions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LINKED_ACCOUNT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_PLAN_ARN</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_PLANS_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAYMENT_OPTION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE_TYPE_FAMILY</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>GetSavingsPlansUtilization</code> uses the same <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
         * object as the other operations, but only <code>AND</code> is supported among each dimension.
         * </p>
         * This is a convenience that creates an instance of the {@link Expression.Builder} avoiding the need to create
         * one manually via {@link Expression#builder()}.
         *
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(Expression)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Expression)
         */
        default Builder filter(Consumer<Expression.Builder> filter) {
            return filter(Expression.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The value by which you want to sort the data.
         * </p>
         * <p>
         * The following values are supported for <code>Key</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UtilizationPercentage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TotalCommitment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UsedCommitment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UnusedCommitment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetSavings</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         * </p>
         * 
         * @param sortBy
         *        The value by which you want to sort the data.</p>
         *        <p>
         *        The following values are supported for <code>Key</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UtilizationPercentage</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TotalCommitment</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UsedCommitment</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UnusedCommitment</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NetSavings</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(SortDefinition sortBy);

        /**
         * <p>
         * The value by which you want to sort the data.
         * </p>
         * <p>
         * The following values are supported for <code>Key</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UtilizationPercentage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TotalCommitment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UsedCommitment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UnusedCommitment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetSavings</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link SortDefinition.Builder} avoiding the need to
         * create one manually via {@link SortDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link SortDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #sortBy(SortDefinition)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link SortDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(SortDefinition)
         */
        default Builder sortBy(Consumer<SortDefinition.Builder> sortBy) {
            return sortBy(SortDefinition.builder().applyMutation(sortBy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private DateInterval timePeriod;

        private String granularity;

        private Expression filter;

        private SortDefinition sortBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSavingsPlansUtilizationRequest model) {
            super(model);
            timePeriod(model.timePeriod);
            granularity(model.granularity);
            filter(model.filter);
            sortBy(model.sortBy);
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final String getGranularity() {
            return granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(Granularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        public final Expression.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final SortDefinition.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        @Override
        public final Builder sortBy(SortDefinition sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final void setSortBy(SortDefinition.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSavingsPlansUtilizationRequest build() {
            return new GetSavingsPlansUtilizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
