/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class MetricsCopier {
    static Map<String, MetricValue> copy(Map<String, ? extends MetricValue> metricsParam) {
        Map<String, MetricValue> map;
        if (metricsParam == null || metricsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, MetricValue> modifiableMap = new LinkedHashMap<>();
            metricsParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, MetricValue> copyFromBuilder(Map<String, ? extends MetricValue.Builder> metricsParam) {
        Map<String, MetricValue> map;
        if (metricsParam == null || metricsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, MetricValue> modifiableMap = new LinkedHashMap<>();
            metricsParam.forEach((key, value) -> {
                MetricValue member = value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, MetricValue.Builder> copyToBuilder(Map<String, ? extends MetricValue> metricsParam) {
        Map<String, MetricValue.Builder> map;
        if (metricsParam == null || metricsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, MetricValue.Builder> modifiableMap = new LinkedHashMap<>();
            metricsParam.forEach((key, value) -> {
                MetricValue.Builder member = value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
