/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorResponse;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionResponse;
import software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorRequest;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorResponse;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionResponse;
import software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostForecastRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostForecastResponse;
import software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetTagsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetTagsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetUsageForecastRequest;
import software.amazon.awssdk.services.costexplorer.model.GetUsageForecastResponse;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse;
import software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest;
import software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansCoveragePublisher;
import software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansUtilizationDetailsPublisher;
import software.amazon.awssdk.services.costexplorer.paginators.ListCostCategoryDefinitionsPublisher;

/**
 * Service client for accessing AWS Cost Explorer asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * You can use the Cost Explorer API to programmatically query your cost and usage data. You can query for aggregated
 * data such as total monthly costs or total daily usage. You can also query for granular data. This might include the
 * number of daily write operations for Amazon DynamoDB database tables in your production environment.
 * </p>
 * <p>
 * Service Endpoint
 * </p>
 * <p>
 * The Cost Explorer API provides the following endpoint:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>https://ce.us-east-1.amazonaws.com</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * For information about the costs that are associated with the Cost Explorer API, see <a
 * href="http://aws.amazon.com/aws-cost-management/pricing/">Amazon Web Services Cost Management Pricing</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CostExplorerAsyncClient extends SdkClient {
    String SERVICE_NAME = "ce";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ce";

    /**
     * Create a {@link CostExplorerAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CostExplorerAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CostExplorerAsyncClient}.
     */
    static CostExplorerAsyncClientBuilder builder() {
        return new DefaultCostExplorerAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates a new cost anomaly detection monitor with the requested type and monitor specification.
     * </p>
     *
     * @param createAnomalyMonitorRequest
     * @return A Java Future containing the result of the CreateAnomalyMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.CreateAnomalyMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateAnomalyMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAnomalyMonitorResponse> createAnomalyMonitor(
            CreateAnomalyMonitorRequest createAnomalyMonitorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new cost anomaly detection monitor with the requested type and monitor specification.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAnomalyMonitorRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAnomalyMonitorRequest#builder()}
     * </p>
     *
     * @param createAnomalyMonitorRequest
     *        A {@link Consumer} that will call methods on {@link CreateAnomalyMonitorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAnomalyMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.CreateAnomalyMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateAnomalyMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAnomalyMonitorResponse> createAnomalyMonitor(
            Consumer<CreateAnomalyMonitorRequest.Builder> createAnomalyMonitorRequest) {
        return createAnomalyMonitor(CreateAnomalyMonitorRequest.builder().applyMutation(createAnomalyMonitorRequest).build());
    }

    /**
     * <p>
     * Adds a subscription to a cost anomaly detection monitor. You can use each subscription to define subscribers with
     * email or SNS notifications. Email subscribers can set a dollar threshold and a time frequency for receiving
     * notifications.
     * </p>
     *
     * @param createAnomalySubscriptionRequest
     * @return A Java Future containing the result of the CreateAnomalySubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownMonitorException The cost anomaly monitor does not exist for the account.</li>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.CreateAnomalySubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateAnomalySubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAnomalySubscriptionResponse> createAnomalySubscription(
            CreateAnomalySubscriptionRequest createAnomalySubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a subscription to a cost anomaly detection monitor. You can use each subscription to define subscribers with
     * email or SNS notifications. Email subscribers can set a dollar threshold and a time frequency for receiving
     * notifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAnomalySubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAnomalySubscriptionRequest#builder()}
     * </p>
     *
     * @param createAnomalySubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateAnomalySubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAnomalySubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownMonitorException The cost anomaly monitor does not exist for the account.</li>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.CreateAnomalySubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateAnomalySubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAnomalySubscriptionResponse> createAnomalySubscription(
            Consumer<CreateAnomalySubscriptionRequest.Builder> createAnomalySubscriptionRequest) {
        return createAnomalySubscription(CreateAnomalySubscriptionRequest.builder()
                .applyMutation(createAnomalySubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates a new Cost Category with the requested name and rules.
     * </p>
     *
     * @param createCostCategoryDefinitionRequest
     * @return A Java Future containing the result of the CreateCostCategoryDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You've reached the limit on the number of resources you can create, or
     *         exceeded the size of an individual resource.</li>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.CreateCostCategoryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateCostCategoryDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCostCategoryDefinitionResponse> createCostCategoryDefinition(
            CreateCostCategoryDefinitionRequest createCostCategoryDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Cost Category with the requested name and rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCostCategoryDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCostCategoryDefinitionRequest#builder()}
     * </p>
     *
     * @param createCostCategoryDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateCostCategoryDefinitionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateCostCategoryDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You've reached the limit on the number of resources you can create, or
     *         exceeded the size of an individual resource.</li>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.CreateCostCategoryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateCostCategoryDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCostCategoryDefinitionResponse> createCostCategoryDefinition(
            Consumer<CreateCostCategoryDefinitionRequest.Builder> createCostCategoryDefinitionRequest) {
        return createCostCategoryDefinition(CreateCostCategoryDefinitionRequest.builder()
                .applyMutation(createCostCategoryDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a cost anomaly monitor.
     * </p>
     *
     * @param deleteAnomalyMonitorRequest
     * @return A Java Future containing the result of the DeleteAnomalyMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>UnknownMonitorException The cost anomaly monitor does not exist for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.DeleteAnomalyMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteAnomalyMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAnomalyMonitorResponse> deleteAnomalyMonitor(
            DeleteAnomalyMonitorRequest deleteAnomalyMonitorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a cost anomaly monitor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAnomalyMonitorRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAnomalyMonitorRequest#builder()}
     * </p>
     *
     * @param deleteAnomalyMonitorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAnomalyMonitorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAnomalyMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>UnknownMonitorException The cost anomaly monitor does not exist for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.DeleteAnomalyMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteAnomalyMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAnomalyMonitorResponse> deleteAnomalyMonitor(
            Consumer<DeleteAnomalyMonitorRequest.Builder> deleteAnomalyMonitorRequest) {
        return deleteAnomalyMonitor(DeleteAnomalyMonitorRequest.builder().applyMutation(deleteAnomalyMonitorRequest).build());
    }

    /**
     * <p>
     * Deletes a cost anomaly subscription.
     * </p>
     *
     * @param deleteAnomalySubscriptionRequest
     * @return A Java Future containing the result of the DeleteAnomalySubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>UnknownSubscriptionException The cost anomaly subscription does not exist for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.DeleteAnomalySubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteAnomalySubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAnomalySubscriptionResponse> deleteAnomalySubscription(
            DeleteAnomalySubscriptionRequest deleteAnomalySubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a cost anomaly subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAnomalySubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAnomalySubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteAnomalySubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAnomalySubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAnomalySubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>UnknownSubscriptionException The cost anomaly subscription does not exist for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.DeleteAnomalySubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteAnomalySubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAnomalySubscriptionResponse> deleteAnomalySubscription(
            Consumer<DeleteAnomalySubscriptionRequest.Builder> deleteAnomalySubscriptionRequest) {
        return deleteAnomalySubscription(DeleteAnomalySubscriptionRequest.builder()
                .applyMutation(deleteAnomalySubscriptionRequest).build());
    }

    /**
     * <p>
     * Deletes a Cost Category. Expenses from this month going forward will no longer be categorized with this Cost
     * Category.
     * </p>
     *
     * @param deleteCostCategoryDefinitionRequest
     * @return A Java Future containing the result of the DeleteCostCategoryDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.DeleteCostCategoryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteCostCategoryDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCostCategoryDefinitionResponse> deleteCostCategoryDefinition(
            DeleteCostCategoryDefinitionRequest deleteCostCategoryDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Cost Category. Expenses from this month going forward will no longer be categorized with this Cost
     * Category.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCostCategoryDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCostCategoryDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteCostCategoryDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCostCategoryDefinitionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteCostCategoryDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.DeleteCostCategoryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteCostCategoryDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCostCategoryDefinitionResponse> deleteCostCategoryDefinition(
            Consumer<DeleteCostCategoryDefinitionRequest.Builder> deleteCostCategoryDefinitionRequest) {
        return deleteCostCategoryDefinition(DeleteCostCategoryDefinitionRequest.builder()
                .applyMutation(deleteCostCategoryDefinitionRequest).build());
    }

    /**
     * <p>
     * Returns the name, ARN, rules, definition, and effective dates of a Cost Category that's defined in the account.
     * </p>
     * <p>
     * You have the option to use <code>EffectiveOn</code> to return a Cost Category that is active on a specific date.
     * If there is no <code>EffectiveOn</code> specified, you’ll see a Cost Category that is effective on the current
     * date. If Cost Category is still effective, <code>EffectiveEnd</code> is omitted in the response.
     * </p>
     *
     * @param describeCostCategoryDefinitionRequest
     * @return A Java Future containing the result of the DescribeCostCategoryDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.DescribeCostCategoryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DescribeCostCategoryDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCostCategoryDefinitionResponse> describeCostCategoryDefinition(
            DescribeCostCategoryDefinitionRequest describeCostCategoryDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the name, ARN, rules, definition, and effective dates of a Cost Category that's defined in the account.
     * </p>
     * <p>
     * You have the option to use <code>EffectiveOn</code> to return a Cost Category that is active on a specific date.
     * If there is no <code>EffectiveOn</code> specified, you’ll see a Cost Category that is effective on the current
     * date. If Cost Category is still effective, <code>EffectiveEnd</code> is omitted in the response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCostCategoryDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCostCategoryDefinitionRequest#builder()}
     * </p>
     *
     * @param describeCostCategoryDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCostCategoryDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeCostCategoryDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.DescribeCostCategoryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DescribeCostCategoryDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCostCategoryDefinitionResponse> describeCostCategoryDefinition(
            Consumer<DescribeCostCategoryDefinitionRequest.Builder> describeCostCategoryDefinitionRequest) {
        return describeCostCategoryDefinition(DescribeCostCategoryDefinitionRequest.builder()
                .applyMutation(describeCostCategoryDefinitionRequest).build());
    }

    /**
     * <p>
     * Retrieves all of the cost anomalies detected on your account during the time period that's specified by the
     * <code>DateInterval</code> object.
     * </p>
     *
     * @param getAnomaliesRequest
     * @return A Java Future containing the result of the GetAnomalies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetAnomalies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAnomaliesResponse> getAnomalies(GetAnomaliesRequest getAnomaliesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all of the cost anomalies detected on your account during the time period that's specified by the
     * <code>DateInterval</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnomaliesRequest.Builder} avoiding the need to
     * create one manually via {@link GetAnomaliesRequest#builder()}
     * </p>
     *
     * @param getAnomaliesRequest
     *        A {@link Consumer} that will call methods on {@link GetAnomaliesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAnomalies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetAnomalies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAnomaliesResponse> getAnomalies(Consumer<GetAnomaliesRequest.Builder> getAnomaliesRequest) {
        return getAnomalies(GetAnomaliesRequest.builder().applyMutation(getAnomaliesRequest).build());
    }

    /**
     * <p>
     * Retrieves the cost anomaly monitor definitions for your account. You can filter using a list of cost anomaly
     * monitor Amazon Resource Names (ARNs).
     * </p>
     *
     * @param getAnomalyMonitorsRequest
     * @return A Java Future containing the result of the GetAnomalyMonitors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>UnknownMonitorException The cost anomaly monitor does not exist for the account.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetAnomalyMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalyMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAnomalyMonitorsResponse> getAnomalyMonitors(GetAnomalyMonitorsRequest getAnomalyMonitorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the cost anomaly monitor definitions for your account. You can filter using a list of cost anomaly
     * monitor Amazon Resource Names (ARNs).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnomalyMonitorsRequest.Builder} avoiding the
     * need to create one manually via {@link GetAnomalyMonitorsRequest#builder()}
     * </p>
     *
     * @param getAnomalyMonitorsRequest
     *        A {@link Consumer} that will call methods on {@link GetAnomalyMonitorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAnomalyMonitors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>UnknownMonitorException The cost anomaly monitor does not exist for the account.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetAnomalyMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalyMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAnomalyMonitorsResponse> getAnomalyMonitors(
            Consumer<GetAnomalyMonitorsRequest.Builder> getAnomalyMonitorsRequest) {
        return getAnomalyMonitors(GetAnomalyMonitorsRequest.builder().applyMutation(getAnomalyMonitorsRequest).build());
    }

    /**
     * <p>
     * Retrieves the cost anomaly subscription objects for your account. You can filter using a list of cost anomaly
     * monitor Amazon Resource Names (ARNs).
     * </p>
     *
     * @param getAnomalySubscriptionsRequest
     * @return A Java Future containing the result of the GetAnomalySubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>UnknownSubscriptionException The cost anomaly subscription does not exist for the account.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetAnomalySubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalySubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAnomalySubscriptionsResponse> getAnomalySubscriptions(
            GetAnomalySubscriptionsRequest getAnomalySubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the cost anomaly subscription objects for your account. You can filter using a list of cost anomaly
     * monitor Amazon Resource Names (ARNs).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnomalySubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetAnomalySubscriptionsRequest#builder()}
     * </p>
     *
     * @param getAnomalySubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link GetAnomalySubscriptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAnomalySubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>UnknownSubscriptionException The cost anomaly subscription does not exist for the account.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetAnomalySubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalySubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAnomalySubscriptionsResponse> getAnomalySubscriptions(
            Consumer<GetAnomalySubscriptionsRequest.Builder> getAnomalySubscriptionsRequest) {
        return getAnomalySubscriptions(GetAnomalySubscriptionsRequest.builder().applyMutation(getAnomalySubscriptionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves cost and usage metrics for your account. You can specify which cost and usage-related metric that you
     * want the request to return. For example, you can specify <code>BlendedCosts</code> or <code>UsageQuantity</code>.
     * You can also filter and group your data by various dimensions, such as <code>SERVICE</code> or <code>AZ</code>,
     * in a specific time range. For a complete list of valid dimensions, see the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html"
     * >GetDimensionValues</a> operation. Management account in an organization in Organizations have access to all
     * member accounts.
     * </p>
     * <p>
     * For information about filter limitations, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-limits.html">Quotas and
     * restrictions</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param getCostAndUsageRequest
     * @return A Java Future containing the result of the GetCostAndUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>BillExpirationException The requested report expired. Update the date interval and try again.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>RequestChangedException Your request parameters changed between pages. Try again with the old
     *         parameters or without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetCostAndUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCostAndUsageResponse> getCostAndUsage(GetCostAndUsageRequest getCostAndUsageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves cost and usage metrics for your account. You can specify which cost and usage-related metric that you
     * want the request to return. For example, you can specify <code>BlendedCosts</code> or <code>UsageQuantity</code>.
     * You can also filter and group your data by various dimensions, such as <code>SERVICE</code> or <code>AZ</code>,
     * in a specific time range. For a complete list of valid dimensions, see the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html"
     * >GetDimensionValues</a> operation. Management account in an organization in Organizations have access to all
     * member accounts.
     * </p>
     * <p>
     * For information about filter limitations, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-limits.html">Quotas and
     * restrictions</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCostAndUsageRequest.Builder} avoiding the need
     * to create one manually via {@link GetCostAndUsageRequest#builder()}
     * </p>
     *
     * @param getCostAndUsageRequest
     *        A {@link Consumer} that will call methods on {@link GetCostAndUsageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCostAndUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>BillExpirationException The requested report expired. Update the date interval and try again.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>RequestChangedException Your request parameters changed between pages. Try again with the old
     *         parameters or without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetCostAndUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCostAndUsageResponse> getCostAndUsage(
            Consumer<GetCostAndUsageRequest.Builder> getCostAndUsageRequest) {
        return getCostAndUsage(GetCostAndUsageRequest.builder().applyMutation(getCostAndUsageRequest).build());
    }

    /**
     * <p>
     * Retrieves cost and usage metrics with resources for your account. You can specify which cost and usage-related
     * metric, such as <code>BlendedCosts</code> or <code>UsageQuantity</code>, that you want the request to return. You
     * can also filter and group your data by various dimensions, such as <code>SERVICE</code> or <code>AZ</code>, in a
     * specific time range. For a complete list of valid dimensions, see the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html"
     * >GetDimensionValues</a> operation. Management account in an organization in Organizations have access to all
     * member accounts. This API is currently available for the Amazon Elastic Compute Cloud – Compute service only.
     * </p>
     * <note>
     * <p>
     * This is an opt-in only feature. You can enable this feature from the Cost Explorer Settings page. For information
     * on how to access the Settings page, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-access.html">Controlling Access for Cost
     * Explorer</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     * </note>
     *
     * @param getCostAndUsageWithResourcesRequest
     * @return A Java Future containing the result of the GetCostAndUsageWithResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>BillExpirationException The requested report expired. Update the date interval and try again.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>RequestChangedException Your request parameters changed between pages. Try again with the old
     *         parameters or without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetCostAndUsageWithResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsageWithResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCostAndUsageWithResourcesResponse> getCostAndUsageWithResources(
            GetCostAndUsageWithResourcesRequest getCostAndUsageWithResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves cost and usage metrics with resources for your account. You can specify which cost and usage-related
     * metric, such as <code>BlendedCosts</code> or <code>UsageQuantity</code>, that you want the request to return. You
     * can also filter and group your data by various dimensions, such as <code>SERVICE</code> or <code>AZ</code>, in a
     * specific time range. For a complete list of valid dimensions, see the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html"
     * >GetDimensionValues</a> operation. Management account in an organization in Organizations have access to all
     * member accounts. This API is currently available for the Amazon Elastic Compute Cloud – Compute service only.
     * </p>
     * <note>
     * <p>
     * This is an opt-in only feature. You can enable this feature from the Cost Explorer Settings page. For information
     * on how to access the Settings page, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-access.html">Controlling Access for Cost
     * Explorer</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCostAndUsageWithResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link GetCostAndUsageWithResourcesRequest#builder()}
     * </p>
     *
     * @param getCostAndUsageWithResourcesRequest
     *        A {@link Consumer} that will call methods on {@link GetCostAndUsageWithResourcesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetCostAndUsageWithResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>BillExpirationException The requested report expired. Update the date interval and try again.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>RequestChangedException Your request parameters changed between pages. Try again with the old
     *         parameters or without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetCostAndUsageWithResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsageWithResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCostAndUsageWithResourcesResponse> getCostAndUsageWithResources(
            Consumer<GetCostAndUsageWithResourcesRequest.Builder> getCostAndUsageWithResourcesRequest) {
        return getCostAndUsageWithResources(GetCostAndUsageWithResourcesRequest.builder()
                .applyMutation(getCostAndUsageWithResourcesRequest).build());
    }

    /**
     * <p>
     * Retrieves an array of Cost Category names and values incurred cost.
     * </p>
     * <note>
     * <p>
     * If some Cost Category names and values are not associated with any cost, they will not be returned by this API.
     * </p>
     * </note>
     *
     * @param getCostCategoriesRequest
     * @return A Java Future containing the result of the GetCostCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>BillExpirationException The requested report expired. Update the date interval and try again.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>RequestChangedException Your request parameters changed between pages. Try again with the old
     *         parameters or without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetCostCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostCategories" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCostCategoriesResponse> getCostCategories(GetCostCategoriesRequest getCostCategoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an array of Cost Category names and values incurred cost.
     * </p>
     * <note>
     * <p>
     * If some Cost Category names and values are not associated with any cost, they will not be returned by this API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCostCategoriesRequest.Builder} avoiding the need
     * to create one manually via {@link GetCostCategoriesRequest#builder()}
     * </p>
     *
     * @param getCostCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link GetCostCategoriesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCostCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>BillExpirationException The requested report expired. Update the date interval and try again.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>RequestChangedException Your request parameters changed between pages. Try again with the old
     *         parameters or without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetCostCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostCategories" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCostCategoriesResponse> getCostCategories(
            Consumer<GetCostCategoriesRequest.Builder> getCostCategoriesRequest) {
        return getCostCategories(GetCostCategoriesRequest.builder().applyMutation(getCostCategoriesRequest).build());
    }

    /**
     * <p>
     * Retrieves a forecast for how much Amazon Web Services predicts that you will spend over the forecast time period
     * that you select, based on your past costs.
     * </p>
     *
     * @param getCostForecastRequest
     * @return A Java Future containing the result of the GetCostForecast operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetCostForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostForecast" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCostForecastResponse> getCostForecast(GetCostForecastRequest getCostForecastRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a forecast for how much Amazon Web Services predicts that you will spend over the forecast time period
     * that you select, based on your past costs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCostForecastRequest.Builder} avoiding the need
     * to create one manually via {@link GetCostForecastRequest#builder()}
     * </p>
     *
     * @param getCostForecastRequest
     *        A {@link Consumer} that will call methods on {@link GetCostForecastRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCostForecast operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetCostForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostForecast" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCostForecastResponse> getCostForecast(
            Consumer<GetCostForecastRequest.Builder> getCostForecastRequest) {
        return getCostForecast(GetCostForecastRequest.builder().applyMutation(getCostForecastRequest).build());
    }

    /**
     * <p>
     * Retrieves all available filter values for a specified filter over a period of time. You can search the dimension
     * values for an arbitrary string.
     * </p>
     *
     * @param getDimensionValuesRequest
     * @return A Java Future containing the result of the GetDimensionValues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>BillExpirationException The requested report expired. Update the date interval and try again.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>RequestChangedException Your request parameters changed between pages. Try again with the old
     *         parameters or without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetDimensionValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetDimensionValues" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDimensionValuesResponse> getDimensionValues(GetDimensionValuesRequest getDimensionValuesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all available filter values for a specified filter over a period of time. You can search the dimension
     * values for an arbitrary string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDimensionValuesRequest.Builder} avoiding the
     * need to create one manually via {@link GetDimensionValuesRequest#builder()}
     * </p>
     *
     * @param getDimensionValuesRequest
     *        A {@link Consumer} that will call methods on {@link GetDimensionValuesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDimensionValues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>BillExpirationException The requested report expired. Update the date interval and try again.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>RequestChangedException Your request parameters changed between pages. Try again with the old
     *         parameters or without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetDimensionValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetDimensionValues" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDimensionValuesResponse> getDimensionValues(
            Consumer<GetDimensionValuesRequest.Builder> getDimensionValuesRequest) {
        return getDimensionValues(GetDimensionValuesRequest.builder().applyMutation(getDimensionValuesRequest).build());
    }

    /**
     * <p>
     * Retrieves the reservation coverage for your account. This enables you to see how much of your Amazon Elastic
     * Compute Cloud, Amazon ElastiCache, Amazon Relational Database Service, or Amazon Redshift usage is covered by a
     * reservation. An organization's management account can see the coverage of the associated member accounts. This
     * supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data about
     * reservation usage by the following dimensions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AZ
     * </p>
     * </li>
     * <li>
     * <p>
     * CACHE_ENGINE
     * </p>
     * </li>
     * <li>
     * <p>
     * DATABASE_ENGINE
     * </p>
     * </li>
     * <li>
     * <p>
     * DEPLOYMENT_OPTION
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATING_SYSTEM
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION
     * </p>
     * </li>
     * <li>
     * <p>
     * SERVICE
     * </p>
     * </li>
     * <li>
     * <p>
     * TAG
     * </p>
     * </li>
     * <li>
     * <p>
     * TENANCY
     * </p>
     * </li>
     * </ul>
     * <p>
     * To determine valid values for a dimension, use the <code>GetDimensionValues</code> operation.
     * </p>
     *
     * @param getReservationCoverageRequest
     *        You can use the following request parameters to query for how much of your instance usage a reservation
     *        covered.
     * @return A Java Future containing the result of the GetReservationCoverage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetReservationCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReservationCoverageResponse> getReservationCoverage(
            GetReservationCoverageRequest getReservationCoverageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the reservation coverage for your account. This enables you to see how much of your Amazon Elastic
     * Compute Cloud, Amazon ElastiCache, Amazon Relational Database Service, or Amazon Redshift usage is covered by a
     * reservation. An organization's management account can see the coverage of the associated member accounts. This
     * supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data about
     * reservation usage by the following dimensions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AZ
     * </p>
     * </li>
     * <li>
     * <p>
     * CACHE_ENGINE
     * </p>
     * </li>
     * <li>
     * <p>
     * DATABASE_ENGINE
     * </p>
     * </li>
     * <li>
     * <p>
     * DEPLOYMENT_OPTION
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATING_SYSTEM
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION
     * </p>
     * </li>
     * <li>
     * <p>
     * SERVICE
     * </p>
     * </li>
     * <li>
     * <p>
     * TAG
     * </p>
     * </li>
     * <li>
     * <p>
     * TENANCY
     * </p>
     * </li>
     * </ul>
     * <p>
     * To determine valid values for a dimension, use the <code>GetDimensionValues</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReservationCoverageRequest.Builder} avoiding the
     * need to create one manually via {@link GetReservationCoverageRequest#builder()}
     * </p>
     *
     * @param getReservationCoverageRequest
     *        A {@link Consumer} that will call methods on {@link GetReservationCoverageRequest.Builder} to create a
     *        request. You can use the following request parameters to query for how much of your instance usage a
     *        reservation covered.
     * @return A Java Future containing the result of the GetReservationCoverage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetReservationCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReservationCoverageResponse> getReservationCoverage(
            Consumer<GetReservationCoverageRequest.Builder> getReservationCoverageRequest) {
        return getReservationCoverage(GetReservationCoverageRequest.builder().applyMutation(getReservationCoverageRequest)
                .build());
    }

    /**
     * <p>
     * Gets recommendations for which reservations to purchase. These recommendations could help you reduce your costs.
     * Reservations provide a discounted hourly rate (up to 75%) compared to On-Demand pricing.
     * </p>
     * <p>
     * Amazon Web Services generates your recommendations by identifying your On-Demand usage during a specific time
     * period and collecting your usage into categories that are eligible for a reservation. After Amazon Web Services
     * has these categories, it simulates every combination of reservations in each category of usage to identify the
     * best number of each type of RI to purchase to maximize your estimated savings.
     * </p>
     * <p>
     * For example, Amazon Web Services automatically aggregates your Amazon EC2 Linux, shared tenancy, and c4 family
     * usage in the US West (Oregon) Region and recommends that you buy size-flexible regional reservations to apply to
     * the c4 family usage. Amazon Web Services recommends the smallest size instance in an instance family. This makes
     * it easier to purchase a size-flexible RI. Amazon Web Services also shows the equal number of normalized units so
     * that you can purchase any instance size that you want. For this example, your RI recommendation would be for
     * <code>c4.large</code> because that is the smallest size instance in the c4 instance family.
     * </p>
     *
     * @param getReservationPurchaseRecommendationRequest
     * @return A Java Future containing the result of the GetReservationPurchaseRecommendation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetReservationPurchaseRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationPurchaseRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReservationPurchaseRecommendationResponse> getReservationPurchaseRecommendation(
            GetReservationPurchaseRecommendationRequest getReservationPurchaseRecommendationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets recommendations for which reservations to purchase. These recommendations could help you reduce your costs.
     * Reservations provide a discounted hourly rate (up to 75%) compared to On-Demand pricing.
     * </p>
     * <p>
     * Amazon Web Services generates your recommendations by identifying your On-Demand usage during a specific time
     * period and collecting your usage into categories that are eligible for a reservation. After Amazon Web Services
     * has these categories, it simulates every combination of reservations in each category of usage to identify the
     * best number of each type of RI to purchase to maximize your estimated savings.
     * </p>
     * <p>
     * For example, Amazon Web Services automatically aggregates your Amazon EC2 Linux, shared tenancy, and c4 family
     * usage in the US West (Oregon) Region and recommends that you buy size-flexible regional reservations to apply to
     * the c4 family usage. Amazon Web Services recommends the smallest size instance in an instance family. This makes
     * it easier to purchase a size-flexible RI. Amazon Web Services also shows the equal number of normalized units so
     * that you can purchase any instance size that you want. For this example, your RI recommendation would be for
     * <code>c4.large</code> because that is the smallest size instance in the c4 instance family.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetReservationPurchaseRecommendationRequest.Builder} avoiding the need to create one manually via
     * {@link GetReservationPurchaseRecommendationRequest#builder()}
     * </p>
     *
     * @param getReservationPurchaseRecommendationRequest
     *        A {@link Consumer} that will call methods on {@link GetReservationPurchaseRecommendationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetReservationPurchaseRecommendation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetReservationPurchaseRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationPurchaseRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReservationPurchaseRecommendationResponse> getReservationPurchaseRecommendation(
            Consumer<GetReservationPurchaseRecommendationRequest.Builder> getReservationPurchaseRecommendationRequest) {
        return getReservationPurchaseRecommendation(GetReservationPurchaseRecommendationRequest.builder()
                .applyMutation(getReservationPurchaseRecommendationRequest).build());
    }

    /**
     * <p>
     * Retrieves the reservation utilization for your account. Management account in an organization have access to
     * member accounts. You can filter data by dimensions in a time period. You can use <code>GetDimensionValues</code>
     * to determine the possible dimension values. Currently, you can group only by <code>SUBSCRIPTION_ID</code>.
     * </p>
     *
     * @param getReservationUtilizationRequest
     * @return A Java Future containing the result of the GetReservationUtilization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetReservationUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationUtilization" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReservationUtilizationResponse> getReservationUtilization(
            GetReservationUtilizationRequest getReservationUtilizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the reservation utilization for your account. Management account in an organization have access to
     * member accounts. You can filter data by dimensions in a time period. You can use <code>GetDimensionValues</code>
     * to determine the possible dimension values. Currently, you can group only by <code>SUBSCRIPTION_ID</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReservationUtilizationRequest.Builder} avoiding
     * the need to create one manually via {@link GetReservationUtilizationRequest#builder()}
     * </p>
     *
     * @param getReservationUtilizationRequest
     *        A {@link Consumer} that will call methods on {@link GetReservationUtilizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReservationUtilization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetReservationUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationUtilization" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReservationUtilizationResponse> getReservationUtilization(
            Consumer<GetReservationUtilizationRequest.Builder> getReservationUtilizationRequest) {
        return getReservationUtilization(GetReservationUtilizationRequest.builder()
                .applyMutation(getReservationUtilizationRequest).build());
    }

    /**
     * <p>
     * Creates recommendations that help you save cost by identifying idle and underutilized Amazon EC2 instances.
     * </p>
     * <p>
     * Recommendations are generated to either downsize or terminate instances, along with providing savings detail and
     * metrics. For details on calculation and function, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-rightsizing.html">Optimizing Your Cost with
     * Rightsizing Recommendations</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param getRightsizingRecommendationRequest
     * @return A Java Future containing the result of the GetRightsizingRecommendation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetRightsizingRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetRightsizingRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRightsizingRecommendationResponse> getRightsizingRecommendation(
            GetRightsizingRecommendationRequest getRightsizingRecommendationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates recommendations that help you save cost by identifying idle and underutilized Amazon EC2 instances.
     * </p>
     * <p>
     * Recommendations are generated to either downsize or terminate instances, along with providing savings detail and
     * metrics. For details on calculation and function, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-rightsizing.html">Optimizing Your Cost with
     * Rightsizing Recommendations</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRightsizingRecommendationRequest.Builder}
     * avoiding the need to create one manually via {@link GetRightsizingRecommendationRequest#builder()}
     * </p>
     *
     * @param getRightsizingRecommendationRequest
     *        A {@link Consumer} that will call methods on {@link GetRightsizingRecommendationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetRightsizingRecommendation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetRightsizingRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetRightsizingRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRightsizingRecommendationResponse> getRightsizingRecommendation(
            Consumer<GetRightsizingRecommendationRequest.Builder> getRightsizingRecommendationRequest) {
        return getRightsizingRecommendation(GetRightsizingRecommendationRequest.builder()
                .applyMutation(getRightsizingRecommendationRequest).build());
    }

    /**
     * <p>
     * Retrieves the Savings Plans covered for your account. This enables you to see how much of your cost is covered by
     * a Savings Plan. An organization’s management account can see the coverage of the associated member accounts. This
     * supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data for
     * Savings Plans usage with the following dimensions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LINKED_ACCOUNT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE_FAMILY</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To determine valid values for a dimension, use the <code>GetDimensionValues</code> operation.
     * </p>
     *
     * @param getSavingsPlansCoverageRequest
     * @return A Java Future containing the result of the GetSavingsPlansCoverage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetSavingsPlansCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansCoverage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSavingsPlansCoverageResponse> getSavingsPlansCoverage(
            GetSavingsPlansCoverageRequest getSavingsPlansCoverageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Savings Plans covered for your account. This enables you to see how much of your cost is covered by
     * a Savings Plan. An organization’s management account can see the coverage of the associated member accounts. This
     * supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data for
     * Savings Plans usage with the following dimensions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LINKED_ACCOUNT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE_FAMILY</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To determine valid values for a dimension, use the <code>GetDimensionValues</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSavingsPlansCoverageRequest.Builder} avoiding
     * the need to create one manually via {@link GetSavingsPlansCoverageRequest#builder()}
     * </p>
     *
     * @param getSavingsPlansCoverageRequest
     *        A {@link Consumer} that will call methods on {@link GetSavingsPlansCoverageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSavingsPlansCoverage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetSavingsPlansCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansCoverage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSavingsPlansCoverageResponse> getSavingsPlansCoverage(
            Consumer<GetSavingsPlansCoverageRequest.Builder> getSavingsPlansCoverageRequest) {
        return getSavingsPlansCoverage(GetSavingsPlansCoverageRequest.builder().applyMutation(getSavingsPlansCoverageRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the Savings Plans covered for your account. This enables you to see how much of your cost is covered by
     * a Savings Plan. An organization’s management account can see the coverage of the associated member accounts. This
     * supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data for
     * Savings Plans usage with the following dimensions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LINKED_ACCOUNT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE_FAMILY</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To determine valid values for a dimension, use the <code>GetDimensionValues</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSavingsPlansCoverage(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansCoveragePublisher publisher = client.getSavingsPlansCoveragePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansCoveragePublisher publisher = client.getSavingsPlansCoveragePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSavingsPlansCoverage(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest)}
     * operation.</b>
     * </p>
     *
     * @param getSavingsPlansCoverageRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetSavingsPlansCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansCoverage" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSavingsPlansCoveragePublisher getSavingsPlansCoveragePaginator(
            GetSavingsPlansCoverageRequest getSavingsPlansCoverageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Savings Plans covered for your account. This enables you to see how much of your cost is covered by
     * a Savings Plan. An organization’s management account can see the coverage of the associated member accounts. This
     * supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data for
     * Savings Plans usage with the following dimensions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LINKED_ACCOUNT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE_FAMILY</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To determine valid values for a dimension, use the <code>GetDimensionValues</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSavingsPlansCoverage(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansCoveragePublisher publisher = client.getSavingsPlansCoveragePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansCoveragePublisher publisher = client.getSavingsPlansCoveragePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSavingsPlansCoverage(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSavingsPlansCoverageRequest.Builder} avoiding
     * the need to create one manually via {@link GetSavingsPlansCoverageRequest#builder()}
     * </p>
     *
     * @param getSavingsPlansCoverageRequest
     *        A {@link Consumer} that will call methods on {@link GetSavingsPlansCoverageRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetSavingsPlansCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansCoverage" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSavingsPlansCoveragePublisher getSavingsPlansCoveragePaginator(
            Consumer<GetSavingsPlansCoverageRequest.Builder> getSavingsPlansCoverageRequest) {
        return getSavingsPlansCoveragePaginator(GetSavingsPlansCoverageRequest.builder()
                .applyMutation(getSavingsPlansCoverageRequest).build());
    }

    /**
     * <p>
     * Retrieves your request parameters, Savings Plan Recommendations Summary and Details.
     * </p>
     *
     * @param getSavingsPlansPurchaseRecommendationRequest
     * @return A Java Future containing the result of the GetSavingsPlansPurchaseRecommendation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetSavingsPlansPurchaseRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansPurchaseRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSavingsPlansPurchaseRecommendationResponse> getSavingsPlansPurchaseRecommendation(
            GetSavingsPlansPurchaseRecommendationRequest getSavingsPlansPurchaseRecommendationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves your request parameters, Savings Plan Recommendations Summary and Details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetSavingsPlansPurchaseRecommendationRequest.Builder} avoiding the need to create one manually via
     * {@link GetSavingsPlansPurchaseRecommendationRequest#builder()}
     * </p>
     *
     * @param getSavingsPlansPurchaseRecommendationRequest
     *        A {@link Consumer} that will call methods on {@link GetSavingsPlansPurchaseRecommendationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetSavingsPlansPurchaseRecommendation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetSavingsPlansPurchaseRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansPurchaseRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSavingsPlansPurchaseRecommendationResponse> getSavingsPlansPurchaseRecommendation(
            Consumer<GetSavingsPlansPurchaseRecommendationRequest.Builder> getSavingsPlansPurchaseRecommendationRequest) {
        return getSavingsPlansPurchaseRecommendation(GetSavingsPlansPurchaseRecommendationRequest.builder()
                .applyMutation(getSavingsPlansPurchaseRecommendationRequest).build());
    }

    /**
     * <p>
     * Retrieves the Savings Plans utilization for your account across date ranges with daily or monthly granularity.
     * Management account in an organization have access to member accounts. You can use <code>GetDimensionValues</code>
     * in <code>SAVINGS_PLANS</code> to determine the possible dimension values.
     * </p>
     * <note>
     * <p>
     * You cannot group by any dimension values for <code>GetSavingsPlansUtilization</code>.
     * </p>
     * </note>
     *
     * @param getSavingsPlansUtilizationRequest
     * @return A Java Future containing the result of the GetSavingsPlansUtilization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetSavingsPlansUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilization" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSavingsPlansUtilizationResponse> getSavingsPlansUtilization(
            GetSavingsPlansUtilizationRequest getSavingsPlansUtilizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Savings Plans utilization for your account across date ranges with daily or monthly granularity.
     * Management account in an organization have access to member accounts. You can use <code>GetDimensionValues</code>
     * in <code>SAVINGS_PLANS</code> to determine the possible dimension values.
     * </p>
     * <note>
     * <p>
     * You cannot group by any dimension values for <code>GetSavingsPlansUtilization</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSavingsPlansUtilizationRequest.Builder} avoiding
     * the need to create one manually via {@link GetSavingsPlansUtilizationRequest#builder()}
     * </p>
     *
     * @param getSavingsPlansUtilizationRequest
     *        A {@link Consumer} that will call methods on {@link GetSavingsPlansUtilizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSavingsPlansUtilization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetSavingsPlansUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilization" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSavingsPlansUtilizationResponse> getSavingsPlansUtilization(
            Consumer<GetSavingsPlansUtilizationRequest.Builder> getSavingsPlansUtilizationRequest) {
        return getSavingsPlansUtilization(GetSavingsPlansUtilizationRequest.builder()
                .applyMutation(getSavingsPlansUtilizationRequest).build());
    }

    /**
     * <p>
     * Retrieves attribute data along with aggregate utilization and savings data for a given time period. This doesn't
     * support granular or grouped data (daily/monthly) in response. You can't retrieve data by dates in a single
     * response similar to <code>GetSavingsPlanUtilization</code>, but you have the option to make multiple calls to
     * <code>GetSavingsPlanUtilizationDetails</code> by providing individual dates. You can use
     * <code>GetDimensionValues</code> in <code>SAVINGS_PLANS</code> to determine the possible dimension values.
     * </p>
     * <note>
     * <p>
     * <code>GetSavingsPlanUtilizationDetails</code> internally groups data by <code>SavingsPlansArn</code>.
     * </p>
     * </note>
     *
     * @param getSavingsPlansUtilizationDetailsRequest
     * @return A Java Future containing the result of the GetSavingsPlansUtilizationDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetSavingsPlansUtilizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSavingsPlansUtilizationDetailsResponse> getSavingsPlansUtilizationDetails(
            GetSavingsPlansUtilizationDetailsRequest getSavingsPlansUtilizationDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves attribute data along with aggregate utilization and savings data for a given time period. This doesn't
     * support granular or grouped data (daily/monthly) in response. You can't retrieve data by dates in a single
     * response similar to <code>GetSavingsPlanUtilization</code>, but you have the option to make multiple calls to
     * <code>GetSavingsPlanUtilizationDetails</code> by providing individual dates. You can use
     * <code>GetDimensionValues</code> in <code>SAVINGS_PLANS</code> to determine the possible dimension values.
     * </p>
     * <note>
     * <p>
     * <code>GetSavingsPlanUtilizationDetails</code> internally groups data by <code>SavingsPlansArn</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSavingsPlansUtilizationDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetSavingsPlansUtilizationDetailsRequest#builder()}
     * </p>
     *
     * @param getSavingsPlansUtilizationDetailsRequest
     *        A {@link Consumer} that will call methods on {@link GetSavingsPlansUtilizationDetailsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetSavingsPlansUtilizationDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetSavingsPlansUtilizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSavingsPlansUtilizationDetailsResponse> getSavingsPlansUtilizationDetails(
            Consumer<GetSavingsPlansUtilizationDetailsRequest.Builder> getSavingsPlansUtilizationDetailsRequest) {
        return getSavingsPlansUtilizationDetails(GetSavingsPlansUtilizationDetailsRequest.builder()
                .applyMutation(getSavingsPlansUtilizationDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves attribute data along with aggregate utilization and savings data for a given time period. This doesn't
     * support granular or grouped data (daily/monthly) in response. You can't retrieve data by dates in a single
     * response similar to <code>GetSavingsPlanUtilization</code>, but you have the option to make multiple calls to
     * <code>GetSavingsPlanUtilizationDetails</code> by providing individual dates. You can use
     * <code>GetDimensionValues</code> in <code>SAVINGS_PLANS</code> to determine the possible dimension values.
     * </p>
     * <note>
     * <p>
     * <code>GetSavingsPlanUtilizationDetails</code> internally groups data by <code>SavingsPlansArn</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getSavingsPlansUtilizationDetails(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansUtilizationDetailsPublisher publisher = client.getSavingsPlansUtilizationDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansUtilizationDetailsPublisher publisher = client.getSavingsPlansUtilizationDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSavingsPlansUtilizationDetails(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getSavingsPlansUtilizationDetailsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetSavingsPlansUtilizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSavingsPlansUtilizationDetailsPublisher getSavingsPlansUtilizationDetailsPaginator(
            GetSavingsPlansUtilizationDetailsRequest getSavingsPlansUtilizationDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves attribute data along with aggregate utilization and savings data for a given time period. This doesn't
     * support granular or grouped data (daily/monthly) in response. You can't retrieve data by dates in a single
     * response similar to <code>GetSavingsPlanUtilization</code>, but you have the option to make multiple calls to
     * <code>GetSavingsPlanUtilizationDetails</code> by providing individual dates. You can use
     * <code>GetDimensionValues</code> in <code>SAVINGS_PLANS</code> to determine the possible dimension values.
     * </p>
     * <note>
     * <p>
     * <code>GetSavingsPlanUtilizationDetails</code> internally groups data by <code>SavingsPlansArn</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getSavingsPlansUtilizationDetails(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansUtilizationDetailsPublisher publisher = client.getSavingsPlansUtilizationDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansUtilizationDetailsPublisher publisher = client.getSavingsPlansUtilizationDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSavingsPlansUtilizationDetails(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSavingsPlansUtilizationDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetSavingsPlansUtilizationDetailsRequest#builder()}
     * </p>
     *
     * @param getSavingsPlansUtilizationDetailsRequest
     *        A {@link Consumer} that will call methods on {@link GetSavingsPlansUtilizationDetailsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetSavingsPlansUtilizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSavingsPlansUtilizationDetailsPublisher getSavingsPlansUtilizationDetailsPaginator(
            Consumer<GetSavingsPlansUtilizationDetailsRequest.Builder> getSavingsPlansUtilizationDetailsRequest) {
        return getSavingsPlansUtilizationDetailsPaginator(GetSavingsPlansUtilizationDetailsRequest.builder()
                .applyMutation(getSavingsPlansUtilizationDetailsRequest).build());
    }

    /**
     * <p>
     * Queries for available tag keys and tag values for a specified period. You can search the tag values for an
     * arbitrary string.
     * </p>
     *
     * @param getTagsRequest
     * @return A Java Future containing the result of the GetTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>BillExpirationException The requested report expired. Update the date interval and try again.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>RequestChangedException Your request parameters changed between pages. Try again with the old
     *         parameters or without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTagsResponse> getTags(GetTagsRequest getTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Queries for available tag keys and tag values for a specified period. You can search the tag values for an
     * arbitrary string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTagsRequest.Builder} avoiding the need to create
     * one manually via {@link GetTagsRequest#builder()}
     * </p>
     *
     * @param getTagsRequest
     *        A {@link Consumer} that will call methods on {@link GetTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>BillExpirationException The requested report expired. Update the date interval and try again.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>RequestChangedException Your request parameters changed between pages. Try again with the old
     *         parameters or without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTagsResponse> getTags(Consumer<GetTagsRequest.Builder> getTagsRequest) {
        return getTags(GetTagsRequest.builder().applyMutation(getTagsRequest).build());
    }

    /**
     * <p>
     * Retrieves a forecast for how much Amazon Web Services predicts that you will use over the forecast time period
     * that you select, based on your past usage.
     * </p>
     *
     * @param getUsageForecastRequest
     * @return A Java Future containing the result of the GetUsageForecast operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>UnresolvableUsageUnitException Cost Explorer was unable to identify the usage unit. Provide
     *         <code>UsageType/UsageTypeGroup</code> filter selections that contain matching units, for example:
     *         <code>hours</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetUsageForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetUsageForecast" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUsageForecastResponse> getUsageForecast(GetUsageForecastRequest getUsageForecastRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a forecast for how much Amazon Web Services predicts that you will use over the forecast time period
     * that you select, based on your past usage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageForecastRequest.Builder} avoiding the need
     * to create one manually via {@link GetUsageForecastRequest#builder()}
     * </p>
     *
     * @param getUsageForecastRequest
     *        A {@link Consumer} that will call methods on {@link GetUsageForecastRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetUsageForecast operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>DataUnavailableException The requested data is unavailable.</li>
     *         <li>UnresolvableUsageUnitException Cost Explorer was unable to identify the usage unit. Provide
     *         <code>UsageType/UsageTypeGroup</code> filter selections that contain matching units, for example:
     *         <code>hours</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.GetUsageForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetUsageForecast" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUsageForecastResponse> getUsageForecast(
            Consumer<GetUsageForecastRequest.Builder> getUsageForecastRequest) {
        return getUsageForecast(GetUsageForecastRequest.builder().applyMutation(getUsageForecastRequest).build());
    }

    /**
     * <p>
     * Returns the name, ARN, <code>NumberOfRules</code> and effective dates of all Cost Categories defined in the
     * account. You have the option to use <code>EffectiveOn</code> to return a list of Cost Categories that were active
     * on a specific date. If there is no <code>EffectiveOn</code> specified, you’ll see Cost Categories that are
     * effective on the current date. If Cost Category is still effective, <code>EffectiveEnd</code> is omitted in the
     * response. <code>ListCostCategoryDefinitions</code> supports pagination. The request can have a
     * <code>MaxResults</code> range up to 100.
     * </p>
     *
     * @param listCostCategoryDefinitionsRequest
     * @return A Java Future containing the result of the ListCostCategoryDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.ListCostCategoryDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostCategoryDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCostCategoryDefinitionsResponse> listCostCategoryDefinitions(
            ListCostCategoryDefinitionsRequest listCostCategoryDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the name, ARN, <code>NumberOfRules</code> and effective dates of all Cost Categories defined in the
     * account. You have the option to use <code>EffectiveOn</code> to return a list of Cost Categories that were active
     * on a specific date. If there is no <code>EffectiveOn</code> specified, you’ll see Cost Categories that are
     * effective on the current date. If Cost Category is still effective, <code>EffectiveEnd</code> is omitted in the
     * response. <code>ListCostCategoryDefinitions</code> supports pagination. The request can have a
     * <code>MaxResults</code> range up to 100.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCostCategoryDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCostCategoryDefinitionsRequest#builder()}
     * </p>
     *
     * @param listCostCategoryDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListCostCategoryDefinitionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListCostCategoryDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.ListCostCategoryDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostCategoryDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCostCategoryDefinitionsResponse> listCostCategoryDefinitions(
            Consumer<ListCostCategoryDefinitionsRequest.Builder> listCostCategoryDefinitionsRequest) {
        return listCostCategoryDefinitions(ListCostCategoryDefinitionsRequest.builder()
                .applyMutation(listCostCategoryDefinitionsRequest).build());
    }

    /**
     * <p>
     * Returns the name, ARN, <code>NumberOfRules</code> and effective dates of all Cost Categories defined in the
     * account. You have the option to use <code>EffectiveOn</code> to return a list of Cost Categories that were active
     * on a specific date. If there is no <code>EffectiveOn</code> specified, you’ll see Cost Categories that are
     * effective on the current date. If Cost Category is still effective, <code>EffectiveEnd</code> is omitted in the
     * response. <code>ListCostCategoryDefinitions</code> supports pagination. The request can have a
     * <code>MaxResults</code> range up to 100.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCostCategoryDefinitions(software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.ListCostCategoryDefinitionsPublisher publisher = client.listCostCategoryDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.ListCostCategoryDefinitionsPublisher publisher = client.listCostCategoryDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCostCategoryDefinitions(software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCostCategoryDefinitionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.ListCostCategoryDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostCategoryDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCostCategoryDefinitionsPublisher listCostCategoryDefinitionsPaginator(
            ListCostCategoryDefinitionsRequest listCostCategoryDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the name, ARN, <code>NumberOfRules</code> and effective dates of all Cost Categories defined in the
     * account. You have the option to use <code>EffectiveOn</code> to return a list of Cost Categories that were active
     * on a specific date. If there is no <code>EffectiveOn</code> specified, you’ll see Cost Categories that are
     * effective on the current date. If Cost Category is still effective, <code>EffectiveEnd</code> is omitted in the
     * response. <code>ListCostCategoryDefinitions</code> supports pagination. The request can have a
     * <code>MaxResults</code> range up to 100.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCostCategoryDefinitions(software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.ListCostCategoryDefinitionsPublisher publisher = client.listCostCategoryDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.ListCostCategoryDefinitionsPublisher publisher = client.listCostCategoryDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCostCategoryDefinitions(software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCostCategoryDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCostCategoryDefinitionsRequest#builder()}
     * </p>
     *
     * @param listCostCategoryDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListCostCategoryDefinitionsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.ListCostCategoryDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostCategoryDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCostCategoryDefinitionsPublisher listCostCategoryDefinitionsPaginator(
            Consumer<ListCostCategoryDefinitionsRequest.Builder> listCostCategoryDefinitionsRequest) {
        return listCostCategoryDefinitionsPaginator(ListCostCategoryDefinitionsRequest.builder()
                .applyMutation(listCostCategoryDefinitionsRequest).build());
    }

    /**
     * <p>
     * Modifies the feedback property of a given cost anomaly.
     * </p>
     *
     * @param provideAnomalyFeedbackRequest
     * @return A Java Future containing the result of the ProvideAnomalyFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.ProvideAnomalyFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ProvideAnomalyFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ProvideAnomalyFeedbackResponse> provideAnomalyFeedback(
            ProvideAnomalyFeedbackRequest provideAnomalyFeedbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the feedback property of a given cost anomaly.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ProvideAnomalyFeedbackRequest.Builder} avoiding the
     * need to create one manually via {@link ProvideAnomalyFeedbackRequest#builder()}
     * </p>
     *
     * @param provideAnomalyFeedbackRequest
     *        A {@link Consumer} that will call methods on {@link ProvideAnomalyFeedbackRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ProvideAnomalyFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.ProvideAnomalyFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ProvideAnomalyFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ProvideAnomalyFeedbackResponse> provideAnomalyFeedback(
            Consumer<ProvideAnomalyFeedbackRequest.Builder> provideAnomalyFeedbackRequest) {
        return provideAnomalyFeedback(ProvideAnomalyFeedbackRequest.builder().applyMutation(provideAnomalyFeedbackRequest)
                .build());
    }

    /**
     * <p>
     * Updates an existing cost anomaly monitor. The changes made are applied going forward, and doesn'tt change
     * anomalies detected in the past.
     * </p>
     *
     * @param updateAnomalyMonitorRequest
     * @return A Java Future containing the result of the UpdateAnomalyMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>UnknownMonitorException The cost anomaly monitor does not exist for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.UpdateAnomalyMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateAnomalyMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAnomalyMonitorResponse> updateAnomalyMonitor(
            UpdateAnomalyMonitorRequest updateAnomalyMonitorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing cost anomaly monitor. The changes made are applied going forward, and doesn'tt change
     * anomalies detected in the past.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAnomalyMonitorRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAnomalyMonitorRequest#builder()}
     * </p>
     *
     * @param updateAnomalyMonitorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAnomalyMonitorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAnomalyMonitor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>UnknownMonitorException The cost anomaly monitor does not exist for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.UpdateAnomalyMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateAnomalyMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAnomalyMonitorResponse> updateAnomalyMonitor(
            Consumer<UpdateAnomalyMonitorRequest.Builder> updateAnomalyMonitorRequest) {
        return updateAnomalyMonitor(UpdateAnomalyMonitorRequest.builder().applyMutation(updateAnomalyMonitorRequest).build());
    }

    /**
     * <p>
     * Updates an existing cost anomaly monitor subscription.
     * </p>
     *
     * @param updateAnomalySubscriptionRequest
     * @return A Java Future containing the result of the UpdateAnomalySubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>UnknownMonitorException The cost anomaly monitor does not exist for the account.</li>
     *         <li>UnknownSubscriptionException The cost anomaly subscription does not exist for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.UpdateAnomalySubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateAnomalySubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAnomalySubscriptionResponse> updateAnomalySubscription(
            UpdateAnomalySubscriptionRequest updateAnomalySubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing cost anomaly monitor subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAnomalySubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAnomalySubscriptionRequest#builder()}
     * </p>
     *
     * @param updateAnomalySubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAnomalySubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAnomalySubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>UnknownMonitorException The cost anomaly monitor does not exist for the account.</li>
     *         <li>UnknownSubscriptionException The cost anomaly subscription does not exist for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.UpdateAnomalySubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateAnomalySubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAnomalySubscriptionResponse> updateAnomalySubscription(
            Consumer<UpdateAnomalySubscriptionRequest.Builder> updateAnomalySubscriptionRequest) {
        return updateAnomalySubscription(UpdateAnomalySubscriptionRequest.builder()
                .applyMutation(updateAnomalySubscriptionRequest).build());
    }

    /**
     * <p>
     * Updates an existing Cost Category. Changes made to the Cost Category rules will be used to categorize the current
     * month’s expenses and future expenses. This won’t change categorization for the previous months.
     * </p>
     *
     * @param updateCostCategoryDefinitionRequest
     * @return A Java Future containing the result of the UpdateCostCategoryDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>ServiceQuotaExceededException You've reached the limit on the number of resources you can create, or
     *         exceeded the size of an individual resource.</li>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.UpdateCostCategoryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateCostCategoryDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCostCategoryDefinitionResponse> updateCostCategoryDefinition(
            UpdateCostCategoryDefinitionRequest updateCostCategoryDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Cost Category. Changes made to the Cost Category rules will be used to categorize the current
     * month’s expenses and future expenses. This won’t change categorization for the previous months.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCostCategoryDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCostCategoryDefinitionRequest#builder()}
     * </p>
     *
     * @param updateCostCategoryDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCostCategoryDefinitionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateCostCategoryDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>ServiceQuotaExceededException You've reached the limit on the number of resources you can create, or
     *         exceeded the size of an individual resource.</li>
     *         <li>LimitExceededException You made too many calls in a short period of time. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostExplorerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CostExplorerAsyncClient.UpdateCostCategoryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateCostCategoryDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCostCategoryDefinitionResponse> updateCostCategoryDefinition(
            Consumer<UpdateCostCategoryDefinitionRequest.Builder> updateCostCategoryDefinitionRequest) {
        return updateCostCategoryDefinition(UpdateCostCategoryDefinitionRequest.builder()
                .applyMutation(updateCostCategoryDefinitionRequest).build());
    }
}
