/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object continuously inspects your account's cost data for anomalies. It's based on <code>MonitorType</code> and
 * <code>MonitorSpecification</code>. The content consists of detailed metadata and the current status of the monitor
 * object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalyMonitor implements SdkPojo, Serializable, ToCopyableBuilder<AnomalyMonitor.Builder, AnomalyMonitor> {
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorArn").getter(getter(AnomalyMonitor::monitorArn)).setter(setter(Builder::monitorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()).build();

    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorName").getter(getter(AnomalyMonitor::monitorName)).setter(setter(Builder::monitorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorName").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDate").getter(getter(AnomalyMonitor::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> LAST_UPDATED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedDate").getter(getter(AnomalyMonitor::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDate").build()).build();

    private static final SdkField<String> LAST_EVALUATED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastEvaluatedDate").getter(getter(AnomalyMonitor::lastEvaluatedDate))
            .setter(setter(Builder::lastEvaluatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedDate").build()).build();

    private static final SdkField<String> MONITOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorType").getter(getter(AnomalyMonitor::monitorTypeAsString)).setter(setter(Builder::monitorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorType").build()).build();

    private static final SdkField<String> MONITOR_DIMENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorDimension").getter(getter(AnomalyMonitor::monitorDimensionAsString))
            .setter(setter(Builder::monitorDimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorDimension").build()).build();

    private static final SdkField<Expression> MONITOR_SPECIFICATION_FIELD = SdkField
            .<Expression> builder(MarshallingType.SDK_POJO).memberName("MonitorSpecification")
            .getter(getter(AnomalyMonitor::monitorSpecification)).setter(setter(Builder::monitorSpecification))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorSpecification").build())
            .build();

    private static final SdkField<Integer> DIMENSIONAL_VALUE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DimensionalValueCount").getter(getter(AnomalyMonitor::dimensionalValueCount))
            .setter(setter(Builder::dimensionalValueCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionalValueCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ARN_FIELD,
            MONITOR_NAME_FIELD, CREATION_DATE_FIELD, LAST_UPDATED_DATE_FIELD, LAST_EVALUATED_DATE_FIELD, MONITOR_TYPE_FIELD,
            MONITOR_DIMENSION_FIELD, MONITOR_SPECIFICATION_FIELD, DIMENSIONAL_VALUE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String monitorArn;

    private final String monitorName;

    private final String creationDate;

    private final String lastUpdatedDate;

    private final String lastEvaluatedDate;

    private final String monitorType;

    private final String monitorDimension;

    private final Expression monitorSpecification;

    private final Integer dimensionalValueCount;

    private AnomalyMonitor(BuilderImpl builder) {
        this.monitorArn = builder.monitorArn;
        this.monitorName = builder.monitorName;
        this.creationDate = builder.creationDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.lastEvaluatedDate = builder.lastEvaluatedDate;
        this.monitorType = builder.monitorType;
        this.monitorDimension = builder.monitorDimension;
        this.monitorSpecification = builder.monitorSpecification;
        this.dimensionalValueCount = builder.dimensionalValueCount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) value.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) value.
     */
    public final String monitorArn() {
        return monitorArn;
    }

    /**
     * <p>
     * The name of the monitor.
     * </p>
     * 
     * @return The name of the monitor.
     */
    public final String monitorName() {
        return monitorName;
    }

    /**
     * <p>
     * The date when the monitor was created.
     * </p>
     * 
     * @return The date when the monitor was created.
     */
    public final String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date when the monitor was last updated.
     * </p>
     * 
     * @return The date when the monitor was last updated.
     */
    public final String lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The date when the monitor last evaluated for anomalies.
     * </p>
     * 
     * @return The date when the monitor last evaluated for anomalies.
     */
    public final String lastEvaluatedDate() {
        return lastEvaluatedDate;
    }

    /**
     * <p>
     * The possible type values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monitorType} will
     * return {@link MonitorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #monitorTypeAsString}.
     * </p>
     * 
     * @return The possible type values.
     * @see MonitorType
     */
    public final MonitorType monitorType() {
        return MonitorType.fromValue(monitorType);
    }

    /**
     * <p>
     * The possible type values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monitorType} will
     * return {@link MonitorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #monitorTypeAsString}.
     * </p>
     * 
     * @return The possible type values.
     * @see MonitorType
     */
    public final String monitorTypeAsString() {
        return monitorType;
    }

    /**
     * <p>
     * The dimensions to evaluate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monitorDimension}
     * will return {@link MonitorDimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #monitorDimensionAsString}.
     * </p>
     * 
     * @return The dimensions to evaluate.
     * @see MonitorDimension
     */
    public final MonitorDimension monitorDimension() {
        return MonitorDimension.fromValue(monitorDimension);
    }

    /**
     * <p>
     * The dimensions to evaluate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monitorDimension}
     * will return {@link MonitorDimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #monitorDimensionAsString}.
     * </p>
     * 
     * @return The dimensions to evaluate.
     * @see MonitorDimension
     */
    public final String monitorDimensionAsString() {
        return monitorDimension;
    }

    /**
     * Returns the value of the MonitorSpecification property for this object.
     * 
     * @return The value of the MonitorSpecification property for this object.
     */
    public final Expression monitorSpecification() {
        return monitorSpecification;
    }

    /**
     * <p>
     * The value for evaluated dimensions.
     * </p>
     * 
     * @return The value for evaluated dimensions.
     */
    public final Integer dimensionalValueCount() {
        return dimensionalValueCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastEvaluatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(monitorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(monitorDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(monitorSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(dimensionalValueCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyMonitor)) {
            return false;
        }
        AnomalyMonitor other = (AnomalyMonitor) obj;
        return Objects.equals(monitorArn(), other.monitorArn()) && Objects.equals(monitorName(), other.monitorName())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(lastEvaluatedDate(), other.lastEvaluatedDate())
                && Objects.equals(monitorTypeAsString(), other.monitorTypeAsString())
                && Objects.equals(monitorDimensionAsString(), other.monitorDimensionAsString())
                && Objects.equals(monitorSpecification(), other.monitorSpecification())
                && Objects.equals(dimensionalValueCount(), other.dimensionalValueCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalyMonitor").add("MonitorArn", monitorArn()).add("MonitorName", monitorName())
                .add("CreationDate", creationDate()).add("LastUpdatedDate", lastUpdatedDate())
                .add("LastEvaluatedDate", lastEvaluatedDate()).add("MonitorType", monitorTypeAsString())
                .add("MonitorDimension", monitorDimensionAsString()).add("MonitorSpecification", monitorSpecification())
                .add("DimensionalValueCount", dimensionalValueCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitorArn":
            return Optional.ofNullable(clazz.cast(monitorArn()));
        case "MonitorName":
            return Optional.ofNullable(clazz.cast(monitorName()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "LastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "LastEvaluatedDate":
            return Optional.ofNullable(clazz.cast(lastEvaluatedDate()));
        case "MonitorType":
            return Optional.ofNullable(clazz.cast(monitorTypeAsString()));
        case "MonitorDimension":
            return Optional.ofNullable(clazz.cast(monitorDimensionAsString()));
        case "MonitorSpecification":
            return Optional.ofNullable(clazz.cast(monitorSpecification()));
        case "DimensionalValueCount":
            return Optional.ofNullable(clazz.cast(dimensionalValueCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyMonitor, T> g) {
        return obj -> g.apply((AnomalyMonitor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalyMonitor> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) value.
         * </p>
         * 
         * @param monitorArn
         *        The Amazon Resource Name (ARN) value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorArn(String monitorArn);

        /**
         * <p>
         * The name of the monitor.
         * </p>
         * 
         * @param monitorName
         *        The name of the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorName(String monitorName);

        /**
         * <p>
         * The date when the monitor was created.
         * </p>
         * 
         * @param creationDate
         *        The date when the monitor was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The date when the monitor was last updated.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date when the monitor was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(String lastUpdatedDate);

        /**
         * <p>
         * The date when the monitor last evaluated for anomalies.
         * </p>
         * 
         * @param lastEvaluatedDate
         *        The date when the monitor last evaluated for anomalies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedDate(String lastEvaluatedDate);

        /**
         * <p>
         * The possible type values.
         * </p>
         * 
         * @param monitorType
         *        The possible type values.
         * @see MonitorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitorType
         */
        Builder monitorType(String monitorType);

        /**
         * <p>
         * The possible type values.
         * </p>
         * 
         * @param monitorType
         *        The possible type values.
         * @see MonitorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitorType
         */
        Builder monitorType(MonitorType monitorType);

        /**
         * <p>
         * The dimensions to evaluate.
         * </p>
         * 
         * @param monitorDimension
         *        The dimensions to evaluate.
         * @see MonitorDimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitorDimension
         */
        Builder monitorDimension(String monitorDimension);

        /**
         * <p>
         * The dimensions to evaluate.
         * </p>
         * 
         * @param monitorDimension
         *        The dimensions to evaluate.
         * @see MonitorDimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitorDimension
         */
        Builder monitorDimension(MonitorDimension monitorDimension);

        /**
         * Sets the value of the MonitorSpecification property for this object.
         *
         * @param monitorSpecification
         *        The new value for the MonitorSpecification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorSpecification(Expression monitorSpecification);

        /**
         * Sets the value of the MonitorSpecification property for this object.
         *
         * This is a convenience that creates an instance of the {@link Expression.Builder} avoiding the need to create
         * one manually via {@link Expression#builder()}.
         *
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #monitorSpecification(Expression)}.
         * 
         * @param monitorSpecification
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitorSpecification(Expression)
         */
        default Builder monitorSpecification(Consumer<Expression.Builder> monitorSpecification) {
            return monitorSpecification(Expression.builder().applyMutation(monitorSpecification).build());
        }

        /**
         * <p>
         * The value for evaluated dimensions.
         * </p>
         * 
         * @param dimensionalValueCount
         *        The value for evaluated dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionalValueCount(Integer dimensionalValueCount);
    }

    static final class BuilderImpl implements Builder {
        private String monitorArn;

        private String monitorName;

        private String creationDate;

        private String lastUpdatedDate;

        private String lastEvaluatedDate;

        private String monitorType;

        private String monitorDimension;

        private Expression monitorSpecification;

        private Integer dimensionalValueCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyMonitor model) {
            monitorArn(model.monitorArn);
            monitorName(model.monitorName);
            creationDate(model.creationDate);
            lastUpdatedDate(model.lastUpdatedDate);
            lastEvaluatedDate(model.lastEvaluatedDate);
            monitorType(model.monitorType);
            monitorDimension(model.monitorDimension);
            monitorSpecification(model.monitorSpecification);
            dimensionalValueCount(model.dimensionalValueCount);
        }

        public final String getMonitorArn() {
            return monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        @Transient
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final String getMonitorName() {
            return monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        @Transient
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(String lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        @Transient
        public final Builder lastUpdatedDate(String lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final String getLastEvaluatedDate() {
            return lastEvaluatedDate;
        }

        public final void setLastEvaluatedDate(String lastEvaluatedDate) {
            this.lastEvaluatedDate = lastEvaluatedDate;
        }

        @Override
        @Transient
        public final Builder lastEvaluatedDate(String lastEvaluatedDate) {
            this.lastEvaluatedDate = lastEvaluatedDate;
            return this;
        }

        public final String getMonitorType() {
            return monitorType;
        }

        public final void setMonitorType(String monitorType) {
            this.monitorType = monitorType;
        }

        @Override
        @Transient
        public final Builder monitorType(String monitorType) {
            this.monitorType = monitorType;
            return this;
        }

        @Override
        @Transient
        public final Builder monitorType(MonitorType monitorType) {
            this.monitorType(monitorType == null ? null : monitorType.toString());
            return this;
        }

        public final String getMonitorDimension() {
            return monitorDimension;
        }

        public final void setMonitorDimension(String monitorDimension) {
            this.monitorDimension = monitorDimension;
        }

        @Override
        @Transient
        public final Builder monitorDimension(String monitorDimension) {
            this.monitorDimension = monitorDimension;
            return this;
        }

        @Override
        @Transient
        public final Builder monitorDimension(MonitorDimension monitorDimension) {
            this.monitorDimension(monitorDimension == null ? null : monitorDimension.toString());
            return this;
        }

        public final Expression.Builder getMonitorSpecification() {
            return monitorSpecification != null ? monitorSpecification.toBuilder() : null;
        }

        public final void setMonitorSpecification(Expression.BuilderImpl monitorSpecification) {
            this.monitorSpecification = monitorSpecification != null ? monitorSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder monitorSpecification(Expression monitorSpecification) {
            this.monitorSpecification = monitorSpecification;
            return this;
        }

        public final Integer getDimensionalValueCount() {
            return dimensionalValueCount;
        }

        public final void setDimensionalValueCount(Integer dimensionalValueCount) {
            this.dimensionalValueCount = dimensionalValueCount;
        }

        @Override
        @Transient
        public final Builder dimensionalValueCount(Integer dimensionalValueCount) {
            this.dimensionalValueCount = dimensionalValueCount;
            return this;
        }

        @Override
        public AnomalyMonitor build() {
            return new AnomalyMonitor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
