/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * How much it costs to run an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoverageCost implements SdkPojo, Serializable, ToCopyableBuilder<CoverageCost.Builder, CoverageCost> {
    private static final SdkField<String> ON_DEMAND_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OnDemandCost").getter(getter(CoverageCost::onDemandCost)).setter(setter(Builder::onDemandCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandCost").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ON_DEMAND_COST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String onDemandCost;

    private CoverageCost(BuilderImpl builder) {
        this.onDemandCost = builder.onDemandCost;
    }

    /**
     * <p>
     * How much an On-Demand Instance costs.
     * </p>
     * 
     * @return How much an On-Demand Instance costs.
     */
    public final String onDemandCost() {
        return onDemandCost;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(onDemandCost());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageCost)) {
            return false;
        }
        CoverageCost other = (CoverageCost) obj;
        return Objects.equals(onDemandCost(), other.onDemandCost());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoverageCost").add("OnDemandCost", onDemandCost()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OnDemandCost":
            return Optional.ofNullable(clazz.cast(onDemandCost()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoverageCost, T> g) {
        return obj -> g.apply((CoverageCost) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoverageCost> {
        /**
         * <p>
         * How much an On-Demand Instance costs.
         * </p>
         * 
         * @param onDemandCost
         *        How much an On-Demand Instance costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandCost(String onDemandCost);
    }

    static final class BuilderImpl implements Builder {
        private String onDemandCost;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageCost model) {
            onDemandCost(model.onDemandCost);
        }

        public final String getOnDemandCost() {
            return onDemandCost;
        }

        public final void setOnDemandCost(String onDemandCost) {
            this.onDemandCost = onDemandCost;
        }

        @Override
        @Transient
        public final Builder onDemandCost(String onDemandCost) {
            this.onDemandCost = onDemandCost;
            return this;
        }

        @Override
        public CoverageCost build() {
            return new CoverageCost(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
