/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Context about the current instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CurrentInstance implements SdkPojo, Serializable, ToCopyableBuilder<CurrentInstance.Builder, CurrentInstance> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(CurrentInstance::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceName").getter(getter(CurrentInstance::instanceName)).setter(setter(Builder::instanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceName").build()).build();

    private static final SdkField<List<TagValues>> TAGS_FIELD = SdkField
            .<List<TagValues>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CurrentInstance::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagValues> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagValues::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ResourceDetails> RESOURCE_DETAILS_FIELD = SdkField
            .<ResourceDetails> builder(MarshallingType.SDK_POJO).memberName("ResourceDetails")
            .getter(getter(CurrentInstance::resourceDetails)).setter(setter(Builder::resourceDetails))
            .constructor(ResourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetails").build()).build();

    private static final SdkField<ResourceUtilization> RESOURCE_UTILIZATION_FIELD = SdkField
            .<ResourceUtilization> builder(MarshallingType.SDK_POJO).memberName("ResourceUtilization")
            .getter(getter(CurrentInstance::resourceUtilization)).setter(setter(Builder::resourceUtilization))
            .constructor(ResourceUtilization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceUtilization").build())
            .build();

    private static final SdkField<String> RESERVATION_COVERED_HOURS_IN_LOOKBACK_PERIOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservationCoveredHoursInLookbackPeriod")
            .getter(getter(CurrentInstance::reservationCoveredHoursInLookbackPeriod))
            .setter(setter(Builder::reservationCoveredHoursInLookbackPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReservationCoveredHoursInLookbackPeriod").build()).build();

    private static final SdkField<String> SAVINGS_PLANS_COVERED_HOURS_IN_LOOKBACK_PERIOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SavingsPlansCoveredHoursInLookbackPeriod")
            .getter(getter(CurrentInstance::savingsPlansCoveredHoursInLookbackPeriod))
            .setter(setter(Builder::savingsPlansCoveredHoursInLookbackPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SavingsPlansCoveredHoursInLookbackPeriod").build()).build();

    private static final SdkField<String> ON_DEMAND_HOURS_IN_LOOKBACK_PERIOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OnDemandHoursInLookbackPeriod")
            .getter(getter(CurrentInstance::onDemandHoursInLookbackPeriod))
            .setter(setter(Builder::onDemandHoursInLookbackPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandHoursInLookbackPeriod")
                    .build()).build();

    private static final SdkField<String> TOTAL_RUNNING_HOURS_IN_LOOKBACK_PERIOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TotalRunningHoursInLookbackPeriod")
            .getter(getter(CurrentInstance::totalRunningHoursInLookbackPeriod))
            .setter(setter(Builder::totalRunningHoursInLookbackPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRunningHoursInLookbackPeriod")
                    .build()).build();

    private static final SdkField<String> MONTHLY_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonthlyCost").getter(getter(CurrentInstance::monthlyCost)).setter(setter(Builder::monthlyCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonthlyCost").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(CurrentInstance::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            INSTANCE_NAME_FIELD, TAGS_FIELD, RESOURCE_DETAILS_FIELD, RESOURCE_UTILIZATION_FIELD,
            RESERVATION_COVERED_HOURS_IN_LOOKBACK_PERIOD_FIELD, SAVINGS_PLANS_COVERED_HOURS_IN_LOOKBACK_PERIOD_FIELD,
            ON_DEMAND_HOURS_IN_LOOKBACK_PERIOD_FIELD, TOTAL_RUNNING_HOURS_IN_LOOKBACK_PERIOD_FIELD, MONTHLY_COST_FIELD,
            CURRENCY_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceId;

    private final String instanceName;

    private final List<TagValues> tags;

    private final ResourceDetails resourceDetails;

    private final ResourceUtilization resourceUtilization;

    private final String reservationCoveredHoursInLookbackPeriod;

    private final String savingsPlansCoveredHoursInLookbackPeriod;

    private final String onDemandHoursInLookbackPeriod;

    private final String totalRunningHoursInLookbackPeriod;

    private final String monthlyCost;

    private final String currencyCode;

    private CurrentInstance(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.instanceName = builder.instanceName;
        this.tags = builder.tags;
        this.resourceDetails = builder.resourceDetails;
        this.resourceUtilization = builder.resourceUtilization;
        this.reservationCoveredHoursInLookbackPeriod = builder.reservationCoveredHoursInLookbackPeriod;
        this.savingsPlansCoveredHoursInLookbackPeriod = builder.savingsPlansCoveredHoursInLookbackPeriod;
        this.onDemandHoursInLookbackPeriod = builder.onDemandHoursInLookbackPeriod;
        this.totalRunningHoursInLookbackPeriod = builder.totalRunningHoursInLookbackPeriod;
        this.monthlyCost = builder.monthlyCost;
        this.currencyCode = builder.currencyCode;
    }

    /**
     * <p>
     * Resource ID of the current instance.
     * </p>
     * 
     * @return Resource ID of the current instance.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The name that you given an instance. This field shows as blank if you haven't given the instance a name.
     * </p>
     * 
     * @return The name that you given an instance. This field shows as blank if you haven't given the instance a name.
     */
    public final String instanceName() {
        return instanceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Cost allocation resource tags that are applied to the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Cost allocation resource tags that are applied to the instance.
     */
    public final List<TagValues> tags() {
        return tags;
    }

    /**
     * <p>
     * Details about the resource and utilization.
     * </p>
     * 
     * @return Details about the resource and utilization.
     */
    public final ResourceDetails resourceDetails() {
        return resourceDetails;
    }

    /**
     * <p>
     * Utilization information of the current instance during the lookback period.
     * </p>
     * 
     * @return Utilization information of the current instance during the lookback period.
     */
    public final ResourceUtilization resourceUtilization() {
        return resourceUtilization;
    }

    /**
     * <p>
     * The number of hours during the lookback period that's covered by reservations.
     * </p>
     * 
     * @return The number of hours during the lookback period that's covered by reservations.
     */
    public final String reservationCoveredHoursInLookbackPeriod() {
        return reservationCoveredHoursInLookbackPeriod;
    }

    /**
     * <p>
     * The number of hours during the lookback period that's covered by Savings Plans.
     * </p>
     * 
     * @return The number of hours during the lookback period that's covered by Savings Plans.
     */
    public final String savingsPlansCoveredHoursInLookbackPeriod() {
        return savingsPlansCoveredHoursInLookbackPeriod;
    }

    /**
     * <p>
     * The number of hours during the lookback period that's billed at On-Demand rates.
     * </p>
     * 
     * @return The number of hours during the lookback period that's billed at On-Demand rates.
     */
    public final String onDemandHoursInLookbackPeriod() {
        return onDemandHoursInLookbackPeriod;
    }

    /**
     * <p>
     * The total number of hours that the instance ran during the lookback period.
     * </p>
     * 
     * @return The total number of hours that the instance ran during the lookback period.
     */
    public final String totalRunningHoursInLookbackPeriod() {
        return totalRunningHoursInLookbackPeriod;
    }

    /**
     * <p>
     * The current On-Demand cost of operating this instance on a monthly basis.
     * </p>
     * 
     * @return The current On-Demand cost of operating this instance on a monthly basis.
     */
    public final String monthlyCost() {
        return monthlyCost;
    }

    /**
     * <p>
     * The currency code that Amazon Web Services used to calculate the costs for this instance.
     * </p>
     * 
     * @return The currency code that Amazon Web Services used to calculate the costs for this instance.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(resourceUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(reservationCoveredHoursInLookbackPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansCoveredHoursInLookbackPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandHoursInLookbackPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(totalRunningHoursInLookbackPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(monthlyCost());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CurrentInstance)) {
            return false;
        }
        CurrentInstance other = (CurrentInstance) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(instanceName(), other.instanceName())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(resourceDetails(), other.resourceDetails())
                && Objects.equals(resourceUtilization(), other.resourceUtilization())
                && Objects.equals(reservationCoveredHoursInLookbackPeriod(), other.reservationCoveredHoursInLookbackPeriod())
                && Objects.equals(savingsPlansCoveredHoursInLookbackPeriod(), other.savingsPlansCoveredHoursInLookbackPeriod())
                && Objects.equals(onDemandHoursInLookbackPeriod(), other.onDemandHoursInLookbackPeriod())
                && Objects.equals(totalRunningHoursInLookbackPeriod(), other.totalRunningHoursInLookbackPeriod())
                && Objects.equals(monthlyCost(), other.monthlyCost()) && Objects.equals(currencyCode(), other.currencyCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CurrentInstance").add("ResourceId", resourceId()).add("InstanceName", instanceName())
                .add("Tags", hasTags() ? tags() : null).add("ResourceDetails", resourceDetails())
                .add("ResourceUtilization", resourceUtilization())
                .add("ReservationCoveredHoursInLookbackPeriod", reservationCoveredHoursInLookbackPeriod())
                .add("SavingsPlansCoveredHoursInLookbackPeriod", savingsPlansCoveredHoursInLookbackPeriod())
                .add("OnDemandHoursInLookbackPeriod", onDemandHoursInLookbackPeriod())
                .add("TotalRunningHoursInLookbackPeriod", totalRunningHoursInLookbackPeriod()).add("MonthlyCost", monthlyCost())
                .add("CurrencyCode", currencyCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "InstanceName":
            return Optional.ofNullable(clazz.cast(instanceName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ResourceDetails":
            return Optional.ofNullable(clazz.cast(resourceDetails()));
        case "ResourceUtilization":
            return Optional.ofNullable(clazz.cast(resourceUtilization()));
        case "ReservationCoveredHoursInLookbackPeriod":
            return Optional.ofNullable(clazz.cast(reservationCoveredHoursInLookbackPeriod()));
        case "SavingsPlansCoveredHoursInLookbackPeriod":
            return Optional.ofNullable(clazz.cast(savingsPlansCoveredHoursInLookbackPeriod()));
        case "OnDemandHoursInLookbackPeriod":
            return Optional.ofNullable(clazz.cast(onDemandHoursInLookbackPeriod()));
        case "TotalRunningHoursInLookbackPeriod":
            return Optional.ofNullable(clazz.cast(totalRunningHoursInLookbackPeriod()));
        case "MonthlyCost":
            return Optional.ofNullable(clazz.cast(monthlyCost()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CurrentInstance, T> g) {
        return obj -> g.apply((CurrentInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CurrentInstance> {
        /**
         * <p>
         * Resource ID of the current instance.
         * </p>
         * 
         * @param resourceId
         *        Resource ID of the current instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The name that you given an instance. This field shows as blank if you haven't given the instance a name.
         * </p>
         * 
         * @param instanceName
         *        The name that you given an instance. This field shows as blank if you haven't given the instance a
         *        name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * Cost allocation resource tags that are applied to the instance.
         * </p>
         * 
         * @param tags
         *        Cost allocation resource tags that are applied to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagValues> tags);

        /**
         * <p>
         * Cost allocation resource tags that are applied to the instance.
         * </p>
         * 
         * @param tags
         *        Cost allocation resource tags that are applied to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagValues... tags);

        /**
         * <p>
         * Cost allocation resource tags that are applied to the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagValues>.Builder} avoiding the need to
         * create one manually via {@link List<TagValues>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagValues>.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<TagValues>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<TagValues>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<TagValues>)
         */
        Builder tags(Consumer<TagValues.Builder>... tags);

        /**
         * <p>
         * Details about the resource and utilization.
         * </p>
         * 
         * @param resourceDetails
         *        Details about the resource and utilization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDetails(ResourceDetails resourceDetails);

        /**
         * <p>
         * Details about the resource and utilization.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceDetails.Builder} avoiding the need to
         * create one manually via {@link ResourceDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceDetails(ResourceDetails)}.
         * 
         * @param resourceDetails
         *        a consumer that will call methods on {@link ResourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceDetails(ResourceDetails)
         */
        default Builder resourceDetails(Consumer<ResourceDetails.Builder> resourceDetails) {
            return resourceDetails(ResourceDetails.builder().applyMutation(resourceDetails).build());
        }

        /**
         * <p>
         * Utilization information of the current instance during the lookback period.
         * </p>
         * 
         * @param resourceUtilization
         *        Utilization information of the current instance during the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceUtilization(ResourceUtilization resourceUtilization);

        /**
         * <p>
         * Utilization information of the current instance during the lookback period.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceUtilization.Builder} avoiding the need
         * to create one manually via {@link ResourceUtilization#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceUtilization.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceUtilization(ResourceUtilization)}.
         * 
         * @param resourceUtilization
         *        a consumer that will call methods on {@link ResourceUtilization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceUtilization(ResourceUtilization)
         */
        default Builder resourceUtilization(Consumer<ResourceUtilization.Builder> resourceUtilization) {
            return resourceUtilization(ResourceUtilization.builder().applyMutation(resourceUtilization).build());
        }

        /**
         * <p>
         * The number of hours during the lookback period that's covered by reservations.
         * </p>
         * 
         * @param reservationCoveredHoursInLookbackPeriod
         *        The number of hours during the lookback period that's covered by reservations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationCoveredHoursInLookbackPeriod(String reservationCoveredHoursInLookbackPeriod);

        /**
         * <p>
         * The number of hours during the lookback period that's covered by Savings Plans.
         * </p>
         * 
         * @param savingsPlansCoveredHoursInLookbackPeriod
         *        The number of hours during the lookback period that's covered by Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansCoveredHoursInLookbackPeriod(String savingsPlansCoveredHoursInLookbackPeriod);

        /**
         * <p>
         * The number of hours during the lookback period that's billed at On-Demand rates.
         * </p>
         * 
         * @param onDemandHoursInLookbackPeriod
         *        The number of hours during the lookback period that's billed at On-Demand rates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandHoursInLookbackPeriod(String onDemandHoursInLookbackPeriod);

        /**
         * <p>
         * The total number of hours that the instance ran during the lookback period.
         * </p>
         * 
         * @param totalRunningHoursInLookbackPeriod
         *        The total number of hours that the instance ran during the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRunningHoursInLookbackPeriod(String totalRunningHoursInLookbackPeriod);

        /**
         * <p>
         * The current On-Demand cost of operating this instance on a monthly basis.
         * </p>
         * 
         * @param monthlyCost
         *        The current On-Demand cost of operating this instance on a monthly basis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlyCost(String monthlyCost);

        /**
         * <p>
         * The currency code that Amazon Web Services used to calculate the costs for this instance.
         * </p>
         * 
         * @param currencyCode
         *        The currency code that Amazon Web Services used to calculate the costs for this instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);
    }

    static final class BuilderImpl implements Builder {
        private String resourceId;

        private String instanceName;

        private List<TagValues> tags = DefaultSdkAutoConstructList.getInstance();

        private ResourceDetails resourceDetails;

        private ResourceUtilization resourceUtilization;

        private String reservationCoveredHoursInLookbackPeriod;

        private String savingsPlansCoveredHoursInLookbackPeriod;

        private String onDemandHoursInLookbackPeriod;

        private String totalRunningHoursInLookbackPeriod;

        private String monthlyCost;

        private String currencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CurrentInstance model) {
            resourceId(model.resourceId);
            instanceName(model.instanceName);
            tags(model.tags);
            resourceDetails(model.resourceDetails);
            resourceUtilization(model.resourceUtilization);
            reservationCoveredHoursInLookbackPeriod(model.reservationCoveredHoursInLookbackPeriod);
            savingsPlansCoveredHoursInLookbackPeriod(model.savingsPlansCoveredHoursInLookbackPeriod);
            onDemandHoursInLookbackPeriod(model.onDemandHoursInLookbackPeriod);
            totalRunningHoursInLookbackPeriod(model.totalRunningHoursInLookbackPeriod);
            monthlyCost(model.monthlyCost);
            currencyCode(model.currencyCode);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        @Transient
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getInstanceName() {
            return instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        @Transient
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final List<TagValues.Builder> getTags() {
            List<TagValues.Builder> result = TagValuesListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagValues.BuilderImpl> tags) {
            this.tags = TagValuesListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<TagValues> tags) {
            this.tags = TagValuesListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(TagValues... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<TagValues.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagValues.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ResourceDetails.Builder getResourceDetails() {
            return resourceDetails != null ? resourceDetails.toBuilder() : null;
        }

        public final void setResourceDetails(ResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceDetails(ResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        public final ResourceUtilization.Builder getResourceUtilization() {
            return resourceUtilization != null ? resourceUtilization.toBuilder() : null;
        }

        public final void setResourceUtilization(ResourceUtilization.BuilderImpl resourceUtilization) {
            this.resourceUtilization = resourceUtilization != null ? resourceUtilization.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceUtilization(ResourceUtilization resourceUtilization) {
            this.resourceUtilization = resourceUtilization;
            return this;
        }

        public final String getReservationCoveredHoursInLookbackPeriod() {
            return reservationCoveredHoursInLookbackPeriod;
        }

        public final void setReservationCoveredHoursInLookbackPeriod(String reservationCoveredHoursInLookbackPeriod) {
            this.reservationCoveredHoursInLookbackPeriod = reservationCoveredHoursInLookbackPeriod;
        }

        @Override
        @Transient
        public final Builder reservationCoveredHoursInLookbackPeriod(String reservationCoveredHoursInLookbackPeriod) {
            this.reservationCoveredHoursInLookbackPeriod = reservationCoveredHoursInLookbackPeriod;
            return this;
        }

        public final String getSavingsPlansCoveredHoursInLookbackPeriod() {
            return savingsPlansCoveredHoursInLookbackPeriod;
        }

        public final void setSavingsPlansCoveredHoursInLookbackPeriod(String savingsPlansCoveredHoursInLookbackPeriod) {
            this.savingsPlansCoveredHoursInLookbackPeriod = savingsPlansCoveredHoursInLookbackPeriod;
        }

        @Override
        @Transient
        public final Builder savingsPlansCoveredHoursInLookbackPeriod(String savingsPlansCoveredHoursInLookbackPeriod) {
            this.savingsPlansCoveredHoursInLookbackPeriod = savingsPlansCoveredHoursInLookbackPeriod;
            return this;
        }

        public final String getOnDemandHoursInLookbackPeriod() {
            return onDemandHoursInLookbackPeriod;
        }

        public final void setOnDemandHoursInLookbackPeriod(String onDemandHoursInLookbackPeriod) {
            this.onDemandHoursInLookbackPeriod = onDemandHoursInLookbackPeriod;
        }

        @Override
        @Transient
        public final Builder onDemandHoursInLookbackPeriod(String onDemandHoursInLookbackPeriod) {
            this.onDemandHoursInLookbackPeriod = onDemandHoursInLookbackPeriod;
            return this;
        }

        public final String getTotalRunningHoursInLookbackPeriod() {
            return totalRunningHoursInLookbackPeriod;
        }

        public final void setTotalRunningHoursInLookbackPeriod(String totalRunningHoursInLookbackPeriod) {
            this.totalRunningHoursInLookbackPeriod = totalRunningHoursInLookbackPeriod;
        }

        @Override
        @Transient
        public final Builder totalRunningHoursInLookbackPeriod(String totalRunningHoursInLookbackPeriod) {
            this.totalRunningHoursInLookbackPeriod = totalRunningHoursInLookbackPeriod;
            return this;
        }

        public final String getMonthlyCost() {
            return monthlyCost;
        }

        public final void setMonthlyCost(String monthlyCost) {
            this.monthlyCost = monthlyCost;
        }

        @Override
        @Transient
        public final Builder monthlyCost(String monthlyCost) {
            this.monthlyCost = monthlyCost;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        @Transient
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public CurrentInstance build() {
            return new CurrentInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
