/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field that contains a list of disk (local storage) metrics that are associated with the current instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiskResourceUtilization implements SdkPojo, Serializable,
        ToCopyableBuilder<DiskResourceUtilization.Builder, DiskResourceUtilization> {
    private static final SdkField<String> DISK_READ_OPS_PER_SECOND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiskReadOpsPerSecond").getter(getter(DiskResourceUtilization::diskReadOpsPerSecond))
            .setter(setter(Builder::diskReadOpsPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskReadOpsPerSecond").build())
            .build();

    private static final SdkField<String> DISK_WRITE_OPS_PER_SECOND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiskWriteOpsPerSecond").getter(getter(DiskResourceUtilization::diskWriteOpsPerSecond))
            .setter(setter(Builder::diskWriteOpsPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskWriteOpsPerSecond").build())
            .build();

    private static final SdkField<String> DISK_READ_BYTES_PER_SECOND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiskReadBytesPerSecond").getter(getter(DiskResourceUtilization::diskReadBytesPerSecond))
            .setter(setter(Builder::diskReadBytesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskReadBytesPerSecond").build())
            .build();

    private static final SdkField<String> DISK_WRITE_BYTES_PER_SECOND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiskWriteBytesPerSecond").getter(getter(DiskResourceUtilization::diskWriteBytesPerSecond))
            .setter(setter(Builder::diskWriteBytesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskWriteBytesPerSecond").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DISK_READ_OPS_PER_SECOND_FIELD, DISK_WRITE_OPS_PER_SECOND_FIELD, DISK_READ_BYTES_PER_SECOND_FIELD,
            DISK_WRITE_BYTES_PER_SECOND_FIELD));

    private static final long serialVersionUID = 1L;

    private final String diskReadOpsPerSecond;

    private final String diskWriteOpsPerSecond;

    private final String diskReadBytesPerSecond;

    private final String diskWriteBytesPerSecond;

    private DiskResourceUtilization(BuilderImpl builder) {
        this.diskReadOpsPerSecond = builder.diskReadOpsPerSecond;
        this.diskWriteOpsPerSecond = builder.diskWriteOpsPerSecond;
        this.diskReadBytesPerSecond = builder.diskReadBytesPerSecond;
        this.diskWriteBytesPerSecond = builder.diskWriteBytesPerSecond;
    }

    /**
     * <p>
     * The maximum number of read operations per second.
     * </p>
     * 
     * @return The maximum number of read operations per second.
     */
    public final String diskReadOpsPerSecond() {
        return diskReadOpsPerSecond;
    }

    /**
     * <p>
     * The maximum number of write operations per second.
     * </p>
     * 
     * @return The maximum number of write operations per second.
     */
    public final String diskWriteOpsPerSecond() {
        return diskWriteOpsPerSecond;
    }

    /**
     * <p>
     * The maximum read throughput operations per second.
     * </p>
     * 
     * @return The maximum read throughput operations per second.
     */
    public final String diskReadBytesPerSecond() {
        return diskReadBytesPerSecond;
    }

    /**
     * <p>
     * The maximum write throughput operations per second.
     * </p>
     * 
     * @return The maximum write throughput operations per second.
     */
    public final String diskWriteBytesPerSecond() {
        return diskWriteBytesPerSecond;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(diskReadOpsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(diskWriteOpsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(diskReadBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(diskWriteBytesPerSecond());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskResourceUtilization)) {
            return false;
        }
        DiskResourceUtilization other = (DiskResourceUtilization) obj;
        return Objects.equals(diskReadOpsPerSecond(), other.diskReadOpsPerSecond())
                && Objects.equals(diskWriteOpsPerSecond(), other.diskWriteOpsPerSecond())
                && Objects.equals(diskReadBytesPerSecond(), other.diskReadBytesPerSecond())
                && Objects.equals(diskWriteBytesPerSecond(), other.diskWriteBytesPerSecond());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiskResourceUtilization").add("DiskReadOpsPerSecond", diskReadOpsPerSecond())
                .add("DiskWriteOpsPerSecond", diskWriteOpsPerSecond()).add("DiskReadBytesPerSecond", diskReadBytesPerSecond())
                .add("DiskWriteBytesPerSecond", diskWriteBytesPerSecond()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DiskReadOpsPerSecond":
            return Optional.ofNullable(clazz.cast(diskReadOpsPerSecond()));
        case "DiskWriteOpsPerSecond":
            return Optional.ofNullable(clazz.cast(diskWriteOpsPerSecond()));
        case "DiskReadBytesPerSecond":
            return Optional.ofNullable(clazz.cast(diskReadBytesPerSecond()));
        case "DiskWriteBytesPerSecond":
            return Optional.ofNullable(clazz.cast(diskWriteBytesPerSecond()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiskResourceUtilization, T> g) {
        return obj -> g.apply((DiskResourceUtilization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DiskResourceUtilization> {
        /**
         * <p>
         * The maximum number of read operations per second.
         * </p>
         * 
         * @param diskReadOpsPerSecond
         *        The maximum number of read operations per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskReadOpsPerSecond(String diskReadOpsPerSecond);

        /**
         * <p>
         * The maximum number of write operations per second.
         * </p>
         * 
         * @param diskWriteOpsPerSecond
         *        The maximum number of write operations per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskWriteOpsPerSecond(String diskWriteOpsPerSecond);

        /**
         * <p>
         * The maximum read throughput operations per second.
         * </p>
         * 
         * @param diskReadBytesPerSecond
         *        The maximum read throughput operations per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskReadBytesPerSecond(String diskReadBytesPerSecond);

        /**
         * <p>
         * The maximum write throughput operations per second.
         * </p>
         * 
         * @param diskWriteBytesPerSecond
         *        The maximum write throughput operations per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskWriteBytesPerSecond(String diskWriteBytesPerSecond);
    }

    static final class BuilderImpl implements Builder {
        private String diskReadOpsPerSecond;

        private String diskWriteOpsPerSecond;

        private String diskReadBytesPerSecond;

        private String diskWriteBytesPerSecond;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskResourceUtilization model) {
            diskReadOpsPerSecond(model.diskReadOpsPerSecond);
            diskWriteOpsPerSecond(model.diskWriteOpsPerSecond);
            diskReadBytesPerSecond(model.diskReadBytesPerSecond);
            diskWriteBytesPerSecond(model.diskWriteBytesPerSecond);
        }

        public final String getDiskReadOpsPerSecond() {
            return diskReadOpsPerSecond;
        }

        public final void setDiskReadOpsPerSecond(String diskReadOpsPerSecond) {
            this.diskReadOpsPerSecond = diskReadOpsPerSecond;
        }

        @Override
        @Transient
        public final Builder diskReadOpsPerSecond(String diskReadOpsPerSecond) {
            this.diskReadOpsPerSecond = diskReadOpsPerSecond;
            return this;
        }

        public final String getDiskWriteOpsPerSecond() {
            return diskWriteOpsPerSecond;
        }

        public final void setDiskWriteOpsPerSecond(String diskWriteOpsPerSecond) {
            this.diskWriteOpsPerSecond = diskWriteOpsPerSecond;
        }

        @Override
        @Transient
        public final Builder diskWriteOpsPerSecond(String diskWriteOpsPerSecond) {
            this.diskWriteOpsPerSecond = diskWriteOpsPerSecond;
            return this;
        }

        public final String getDiskReadBytesPerSecond() {
            return diskReadBytesPerSecond;
        }

        public final void setDiskReadBytesPerSecond(String diskReadBytesPerSecond) {
            this.diskReadBytesPerSecond = diskReadBytesPerSecond;
        }

        @Override
        @Transient
        public final Builder diskReadBytesPerSecond(String diskReadBytesPerSecond) {
            this.diskReadBytesPerSecond = diskReadBytesPerSecond;
            return this;
        }

        public final String getDiskWriteBytesPerSecond() {
            return diskWriteBytesPerSecond;
        }

        public final void setDiskWriteBytesPerSecond(String diskWriteBytesPerSecond) {
            this.diskWriteBytesPerSecond = diskWriteBytesPerSecond;
        }

        @Override
        @Transient
        public final Builder diskWriteBytesPerSecond(String diskWriteBytesPerSecond) {
            this.diskWriteBytesPerSecond = diskWriteBytesPerSecond;
            return this;
        }

        @Override
        public DiskResourceUtilization build() {
            return new DiskResourceUtilization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
