/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReservationPurchaseRecommendationRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetReservationPurchaseRecommendationRequest.Builder, GetReservationPurchaseRecommendationRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(GetReservationPurchaseRecommendationRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Service")
            .getter(getter(GetReservationPurchaseRecommendationRequest::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final SdkField<Expression> FILTER_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("Filter").getter(getter(GetReservationPurchaseRecommendationRequest::filter))
            .setter(setter(Builder::filter)).constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<String> ACCOUNT_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountScope").getter(getter(GetReservationPurchaseRecommendationRequest::accountScopeAsString))
            .setter(setter(Builder::accountScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountScope").build()).build();

    private static final SdkField<String> LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LookbackPeriodInDays")
            .getter(getter(GetReservationPurchaseRecommendationRequest::lookbackPeriodInDaysAsString))
            .setter(setter(Builder::lookbackPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackPeriodInDays").build())
            .build();

    private static final SdkField<String> TERM_IN_YEARS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TermInYears").getter(getter(GetReservationPurchaseRecommendationRequest::termInYearsAsString))
            .setter(setter(Builder::termInYears))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermInYears").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaymentOption").getter(getter(GetReservationPurchaseRecommendationRequest::paymentOptionAsString))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()).build();

    private static final SdkField<ServiceSpecification> SERVICE_SPECIFICATION_FIELD = SdkField
            .<ServiceSpecification> builder(MarshallingType.SDK_POJO).memberName("ServiceSpecification")
            .getter(getter(GetReservationPurchaseRecommendationRequest::serviceSpecification))
            .setter(setter(Builder::serviceSpecification)).constructor(ServiceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSpecification").build())
            .build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(GetReservationPurchaseRecommendationRequest::pageSize))
            .setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetReservationPurchaseRecommendationRequest::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            SERVICE_FIELD, FILTER_FIELD, ACCOUNT_SCOPE_FIELD, LOOKBACK_PERIOD_IN_DAYS_FIELD, TERM_IN_YEARS_FIELD,
            PAYMENT_OPTION_FIELD, SERVICE_SPECIFICATION_FIELD, PAGE_SIZE_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final String accountId;

    private final String service;

    private final Expression filter;

    private final String accountScope;

    private final String lookbackPeriodInDays;

    private final String termInYears;

    private final String paymentOption;

    private final ServiceSpecification serviceSpecification;

    private final Integer pageSize;

    private final String nextPageToken;

    private GetReservationPurchaseRecommendationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.service = builder.service;
        this.filter = builder.filter;
        this.accountScope = builder.accountScope;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
        this.termInYears = builder.termInYears;
        this.paymentOption = builder.paymentOption;
        this.serviceSpecification = builder.serviceSpecification;
        this.pageSize = builder.pageSize;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * The account ID that is associated with the recommendation.
     * </p>
     * 
     * @return The account ID that is associated with the recommendation.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The specific service that you want recommendations for.
     * </p>
     * 
     * @return The specific service that you want recommendations for.
     */
    public final String service() {
        return service;
    }

    /**
     * Returns the value of the Filter property for this object.
     * 
     * @return The value of the Filter property for this object.
     */
    public final Expression filter() {
        return filter;
    }

    /**
     * <p>
     * The account scope that you want your recommendations for. Amazon Web Services calculates recommendations
     * including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is
     * <code>LINKED</code>, recommendations are calculated for individual member accounts only.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountScope} will
     * return {@link AccountScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accountScopeAsString}.
     * </p>
     * 
     * @return The account scope that you want your recommendations for. Amazon Web Services calculates recommendations
     *         including the management account and member accounts if the value is set to <code>PAYER</code>. If the
     *         value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.
     * @see AccountScope
     */
    public final AccountScope accountScope() {
        return AccountScope.fromValue(accountScope);
    }

    /**
     * <p>
     * The account scope that you want your recommendations for. Amazon Web Services calculates recommendations
     * including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is
     * <code>LINKED</code>, recommendations are calculated for individual member accounts only.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountScope} will
     * return {@link AccountScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accountScopeAsString}.
     * </p>
     * 
     * @return The account scope that you want your recommendations for. Amazon Web Services calculates recommendations
     *         including the management account and member accounts if the value is set to <code>PAYER</code>. If the
     *         value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.
     * @see AccountScope
     */
    public final String accountScopeAsString() {
        return accountScope;
    }

    /**
     * <p>
     * The number of previous days that you want Amazon Web Services to consider when it calculates your
     * recommendations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookbackPeriodInDays} will return {@link LookbackPeriodInDays#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookbackPeriodInDaysAsString}.
     * </p>
     * 
     * @return The number of previous days that you want Amazon Web Services to consider when it calculates your
     *         recommendations.
     * @see LookbackPeriodInDays
     */
    public final LookbackPeriodInDays lookbackPeriodInDays() {
        return LookbackPeriodInDays.fromValue(lookbackPeriodInDays);
    }

    /**
     * <p>
     * The number of previous days that you want Amazon Web Services to consider when it calculates your
     * recommendations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookbackPeriodInDays} will return {@link LookbackPeriodInDays#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookbackPeriodInDaysAsString}.
     * </p>
     * 
     * @return The number of previous days that you want Amazon Web Services to consider when it calculates your
     *         recommendations.
     * @see LookbackPeriodInDays
     */
    public final String lookbackPeriodInDaysAsString() {
        return lookbackPeriodInDays;
    }

    /**
     * <p>
     * The reservation term that you want recommendations for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #termInYears} will
     * return {@link TermInYears#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termInYearsAsString}.
     * </p>
     * 
     * @return The reservation term that you want recommendations for.
     * @see TermInYears
     */
    public final TermInYears termInYears() {
        return TermInYears.fromValue(termInYears);
    }

    /**
     * <p>
     * The reservation term that you want recommendations for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #termInYears} will
     * return {@link TermInYears#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termInYearsAsString}.
     * </p>
     * 
     * @return The reservation term that you want recommendations for.
     * @see TermInYears
     */
    public final String termInYearsAsString() {
        return termInYears;
    }

    /**
     * <p>
     * The reservation purchase option that you want recommendations for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The reservation purchase option that you want recommendations for.
     * @see PaymentOption
     */
    public final PaymentOption paymentOption() {
        return PaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The reservation purchase option that you want recommendations for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The reservation purchase option that you want recommendations for.
     * @see PaymentOption
     */
    public final String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * <p>
     * The hardware specifications for the service instances that you want recommendations for, such as standard or
     * convertible Amazon EC2 instances.
     * </p>
     * 
     * @return The hardware specifications for the service instances that you want recommendations for, such as standard
     *         or convertible Amazon EC2 instances.
     */
    public final ServiceSpecification serviceSpecification() {
        return serviceSpecification;
    }

    /**
     * <p>
     * The number of recommendations that you want returned in a single response object.
     * </p>
     * 
     * @return The number of recommendations that you want returned in a single response object.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results that you want to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results that you want to retrieve.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(accountScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lookbackPeriodInDaysAsString());
        hashCode = 31 * hashCode + Objects.hashCode(termInYearsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservationPurchaseRecommendationRequest)) {
            return false;
        }
        GetReservationPurchaseRecommendationRequest other = (GetReservationPurchaseRecommendationRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(service(), other.service())
                && Objects.equals(filter(), other.filter())
                && Objects.equals(accountScopeAsString(), other.accountScopeAsString())
                && Objects.equals(lookbackPeriodInDaysAsString(), other.lookbackPeriodInDaysAsString())
                && Objects.equals(termInYearsAsString(), other.termInYearsAsString())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && Objects.equals(serviceSpecification(), other.serviceSpecification())
                && Objects.equals(pageSize(), other.pageSize()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReservationPurchaseRecommendationRequest").add("AccountId", accountId())
                .add("Service", service()).add("Filter", filter()).add("AccountScope", accountScopeAsString())
                .add("LookbackPeriodInDays", lookbackPeriodInDaysAsString()).add("TermInYears", termInYearsAsString())
                .add("PaymentOption", paymentOptionAsString()).add("ServiceSpecification", serviceSpecification())
                .add("PageSize", pageSize()).add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "AccountScope":
            return Optional.ofNullable(clazz.cast(accountScopeAsString()));
        case "LookbackPeriodInDays":
            return Optional.ofNullable(clazz.cast(lookbackPeriodInDaysAsString()));
        case "TermInYears":
            return Optional.ofNullable(clazz.cast(termInYearsAsString()));
        case "PaymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "ServiceSpecification":
            return Optional.ofNullable(clazz.cast(serviceSpecification()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReservationPurchaseRecommendationRequest, T> g) {
        return obj -> g.apply((GetReservationPurchaseRecommendationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetReservationPurchaseRecommendationRequest> {
        /**
         * <p>
         * The account ID that is associated with the recommendation.
         * </p>
         * 
         * @param accountId
         *        The account ID that is associated with the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The specific service that you want recommendations for.
         * </p>
         * 
         * @param service
         *        The specific service that you want recommendations for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * Sets the value of the Filter property for this object.
         *
         * @param filter
         *        The new value for the Filter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Expression filter);

        /**
         * Sets the value of the Filter property for this object.
         *
         * This is a convenience that creates an instance of the {@link Expression.Builder} avoiding the need to create
         * one manually via {@link Expression#builder()}.
         *
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(Expression)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Expression)
         */
        default Builder filter(Consumer<Expression.Builder> filter) {
            return filter(Expression.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The account scope that you want your recommendations for. Amazon Web Services calculates recommendations
         * including the management account and member accounts if the value is set to <code>PAYER</code>. If the value
         * is <code>LINKED</code>, recommendations are calculated for individual member accounts only.
         * </p>
         * 
         * @param accountScope
         *        The account scope that you want your recommendations for. Amazon Web Services calculates
         *        recommendations including the management account and member accounts if the value is set to
         *        <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual
         *        member accounts only.
         * @see AccountScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountScope
         */
        Builder accountScope(String accountScope);

        /**
         * <p>
         * The account scope that you want your recommendations for. Amazon Web Services calculates recommendations
         * including the management account and member accounts if the value is set to <code>PAYER</code>. If the value
         * is <code>LINKED</code>, recommendations are calculated for individual member accounts only.
         * </p>
         * 
         * @param accountScope
         *        The account scope that you want your recommendations for. Amazon Web Services calculates
         *        recommendations including the management account and member accounts if the value is set to
         *        <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual
         *        member accounts only.
         * @see AccountScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountScope
         */
        Builder accountScope(AccountScope accountScope);

        /**
         * <p>
         * The number of previous days that you want Amazon Web Services to consider when it calculates your
         * recommendations.
         * </p>
         * 
         * @param lookbackPeriodInDays
         *        The number of previous days that you want Amazon Web Services to consider when it calculates your
         *        recommendations.
         * @see LookbackPeriodInDays
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookbackPeriodInDays
         */
        Builder lookbackPeriodInDays(String lookbackPeriodInDays);

        /**
         * <p>
         * The number of previous days that you want Amazon Web Services to consider when it calculates your
         * recommendations.
         * </p>
         * 
         * @param lookbackPeriodInDays
         *        The number of previous days that you want Amazon Web Services to consider when it calculates your
         *        recommendations.
         * @see LookbackPeriodInDays
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookbackPeriodInDays
         */
        Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays);

        /**
         * <p>
         * The reservation term that you want recommendations for.
         * </p>
         * 
         * @param termInYears
         *        The reservation term that you want recommendations for.
         * @see TermInYears
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermInYears
         */
        Builder termInYears(String termInYears);

        /**
         * <p>
         * The reservation term that you want recommendations for.
         * </p>
         * 
         * @param termInYears
         *        The reservation term that you want recommendations for.
         * @see TermInYears
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermInYears
         */
        Builder termInYears(TermInYears termInYears);

        /**
         * <p>
         * The reservation purchase option that you want recommendations for.
         * </p>
         * 
         * @param paymentOption
         *        The reservation purchase option that you want recommendations for.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The reservation purchase option that you want recommendations for.
         * </p>
         * 
         * @param paymentOption
         *        The reservation purchase option that you want recommendations for.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(PaymentOption paymentOption);

        /**
         * <p>
         * The hardware specifications for the service instances that you want recommendations for, such as standard or
         * convertible Amazon EC2 instances.
         * </p>
         * 
         * @param serviceSpecification
         *        The hardware specifications for the service instances that you want recommendations for, such as
         *        standard or convertible Amazon EC2 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSpecification(ServiceSpecification serviceSpecification);

        /**
         * <p>
         * The hardware specifications for the service instances that you want recommendations for, such as standard or
         * convertible Amazon EC2 instances.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceSpecification.Builder} avoiding the need
         * to create one manually via {@link ServiceSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceSpecification(ServiceSpecification)}.
         * 
         * @param serviceSpecification
         *        a consumer that will call methods on {@link ServiceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSpecification(ServiceSpecification)
         */
        default Builder serviceSpecification(Consumer<ServiceSpecification.Builder> serviceSpecification) {
            return serviceSpecification(ServiceSpecification.builder().applyMutation(serviceSpecification).build());
        }

        /**
         * <p>
         * The number of recommendations that you want returned in a single response object.
         * </p>
         * 
         * @param pageSize
         *        The number of recommendations that you want returned in a single response object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * The pagination token that indicates the next set of results that you want to retrieve.
         * </p>
         * 
         * @param nextPageToken
         *        The pagination token that indicates the next set of results that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String accountId;

        private String service;

        private Expression filter;

        private String accountScope;

        private String lookbackPeriodInDays;

        private String termInYears;

        private String paymentOption;

        private ServiceSpecification serviceSpecification;

        private Integer pageSize;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservationPurchaseRecommendationRequest model) {
            super(model);
            accountId(model.accountId);
            service(model.service);
            filter(model.filter);
            accountScope(model.accountScope);
            lookbackPeriodInDays(model.lookbackPeriodInDays);
            termInYears(model.termInYears);
            paymentOption(model.paymentOption);
            serviceSpecification(model.serviceSpecification);
            pageSize(model.pageSize);
            nextPageToken(model.nextPageToken);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        @Transient
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Expression.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        @Transient
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final String getAccountScope() {
            return accountScope;
        }

        public final void setAccountScope(String accountScope) {
            this.accountScope = accountScope;
        }

        @Override
        @Transient
        public final Builder accountScope(String accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        @Override
        @Transient
        public final Builder accountScope(AccountScope accountScope) {
            this.accountScope(accountScope == null ? null : accountScope.toString());
            return this;
        }

        public final String getLookbackPeriodInDays() {
            return lookbackPeriodInDays;
        }

        public final void setLookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        @Override
        @Transient
        public final Builder lookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        @Override
        @Transient
        public final Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays) {
            this.lookbackPeriodInDays(lookbackPeriodInDays == null ? null : lookbackPeriodInDays.toString());
            return this;
        }

        public final String getTermInYears() {
            return termInYears;
        }

        public final void setTermInYears(String termInYears) {
            this.termInYears = termInYears;
        }

        @Override
        @Transient
        public final Builder termInYears(String termInYears) {
            this.termInYears = termInYears;
            return this;
        }

        @Override
        @Transient
        public final Builder termInYears(TermInYears termInYears) {
            this.termInYears(termInYears == null ? null : termInYears.toString());
            return this;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        @Transient
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        @Transient
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final ServiceSpecification.Builder getServiceSpecification() {
            return serviceSpecification != null ? serviceSpecification.toBuilder() : null;
        }

        public final void setServiceSpecification(ServiceSpecification.BuilderImpl serviceSpecification) {
            this.serviceSpecification = serviceSpecification != null ? serviceSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder serviceSpecification(ServiceSpecification serviceSpecification) {
            this.serviceSpecification = serviceSpecification;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        @Transient
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        @Transient
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReservationPurchaseRecommendationRequest build() {
            return new GetReservationPurchaseRecommendationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
