/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The network field that contains a list of network metrics that are associated with the current instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkResourceUtilization implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkResourceUtilization.Builder, NetworkResourceUtilization> {
    private static final SdkField<String> NETWORK_IN_BYTES_PER_SECOND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInBytesPerSecond").getter(getter(NetworkResourceUtilization::networkInBytesPerSecond))
            .setter(setter(Builder::networkInBytesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInBytesPerSecond").build())
            .build();

    private static final SdkField<String> NETWORK_OUT_BYTES_PER_SECOND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkOutBytesPerSecond").getter(getter(NetworkResourceUtilization::networkOutBytesPerSecond))
            .setter(setter(Builder::networkOutBytesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkOutBytesPerSecond").build())
            .build();

    private static final SdkField<String> NETWORK_PACKETS_IN_PER_SECOND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkPacketsInPerSecond").getter(getter(NetworkResourceUtilization::networkPacketsInPerSecond))
            .setter(setter(Builder::networkPacketsInPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPacketsInPerSecond").build())
            .build();

    private static final SdkField<String> NETWORK_PACKETS_OUT_PER_SECOND_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkPacketsOutPerSecond")
            .getter(getter(NetworkResourceUtilization::networkPacketsOutPerSecond))
            .setter(setter(Builder::networkPacketsOutPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPacketsOutPerSecond").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NETWORK_IN_BYTES_PER_SECOND_FIELD, NETWORK_OUT_BYTES_PER_SECOND_FIELD, NETWORK_PACKETS_IN_PER_SECOND_FIELD,
            NETWORK_PACKETS_OUT_PER_SECOND_FIELD));

    private static final long serialVersionUID = 1L;

    private final String networkInBytesPerSecond;

    private final String networkOutBytesPerSecond;

    private final String networkPacketsInPerSecond;

    private final String networkPacketsOutPerSecond;

    private NetworkResourceUtilization(BuilderImpl builder) {
        this.networkInBytesPerSecond = builder.networkInBytesPerSecond;
        this.networkOutBytesPerSecond = builder.networkOutBytesPerSecond;
        this.networkPacketsInPerSecond = builder.networkPacketsInPerSecond;
        this.networkPacketsOutPerSecond = builder.networkPacketsOutPerSecond;
    }

    /**
     * <p>
     * The network inbound throughput utilization measured in Bytes per second.
     * </p>
     * 
     * @return The network inbound throughput utilization measured in Bytes per second.
     */
    public final String networkInBytesPerSecond() {
        return networkInBytesPerSecond;
    }

    /**
     * <p>
     * The network outbound throughput utilization measured in Bytes per second.
     * </p>
     * 
     * @return The network outbound throughput utilization measured in Bytes per second.
     */
    public final String networkOutBytesPerSecond() {
        return networkOutBytesPerSecond;
    }

    /**
     * <p>
     * The network ingress packets that are measured in packets per second.
     * </p>
     * 
     * @return The network ingress packets that are measured in packets per second.
     */
    public final String networkPacketsInPerSecond() {
        return networkPacketsInPerSecond;
    }

    /**
     * <p>
     * The network outgress packets that are measured in packets per second.
     * </p>
     * 
     * @return The network outgress packets that are measured in packets per second.
     */
    public final String networkPacketsOutPerSecond() {
        return networkPacketsOutPerSecond;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(networkOutBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(networkPacketsInPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(networkPacketsOutPerSecond());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkResourceUtilization)) {
            return false;
        }
        NetworkResourceUtilization other = (NetworkResourceUtilization) obj;
        return Objects.equals(networkInBytesPerSecond(), other.networkInBytesPerSecond())
                && Objects.equals(networkOutBytesPerSecond(), other.networkOutBytesPerSecond())
                && Objects.equals(networkPacketsInPerSecond(), other.networkPacketsInPerSecond())
                && Objects.equals(networkPacketsOutPerSecond(), other.networkPacketsOutPerSecond());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkResourceUtilization").add("NetworkInBytesPerSecond", networkInBytesPerSecond())
                .add("NetworkOutBytesPerSecond", networkOutBytesPerSecond())
                .add("NetworkPacketsInPerSecond", networkPacketsInPerSecond())
                .add("NetworkPacketsOutPerSecond", networkPacketsOutPerSecond()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInBytesPerSecond":
            return Optional.ofNullable(clazz.cast(networkInBytesPerSecond()));
        case "NetworkOutBytesPerSecond":
            return Optional.ofNullable(clazz.cast(networkOutBytesPerSecond()));
        case "NetworkPacketsInPerSecond":
            return Optional.ofNullable(clazz.cast(networkPacketsInPerSecond()));
        case "NetworkPacketsOutPerSecond":
            return Optional.ofNullable(clazz.cast(networkPacketsOutPerSecond()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkResourceUtilization, T> g) {
        return obj -> g.apply((NetworkResourceUtilization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkResourceUtilization> {
        /**
         * <p>
         * The network inbound throughput utilization measured in Bytes per second.
         * </p>
         * 
         * @param networkInBytesPerSecond
         *        The network inbound throughput utilization measured in Bytes per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInBytesPerSecond(String networkInBytesPerSecond);

        /**
         * <p>
         * The network outbound throughput utilization measured in Bytes per second.
         * </p>
         * 
         * @param networkOutBytesPerSecond
         *        The network outbound throughput utilization measured in Bytes per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkOutBytesPerSecond(String networkOutBytesPerSecond);

        /**
         * <p>
         * The network ingress packets that are measured in packets per second.
         * </p>
         * 
         * @param networkPacketsInPerSecond
         *        The network ingress packets that are measured in packets per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPacketsInPerSecond(String networkPacketsInPerSecond);

        /**
         * <p>
         * The network outgress packets that are measured in packets per second.
         * </p>
         * 
         * @param networkPacketsOutPerSecond
         *        The network outgress packets that are measured in packets per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPacketsOutPerSecond(String networkPacketsOutPerSecond);
    }

    static final class BuilderImpl implements Builder {
        private String networkInBytesPerSecond;

        private String networkOutBytesPerSecond;

        private String networkPacketsInPerSecond;

        private String networkPacketsOutPerSecond;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkResourceUtilization model) {
            networkInBytesPerSecond(model.networkInBytesPerSecond);
            networkOutBytesPerSecond(model.networkOutBytesPerSecond);
            networkPacketsInPerSecond(model.networkPacketsInPerSecond);
            networkPacketsOutPerSecond(model.networkPacketsOutPerSecond);
        }

        public final String getNetworkInBytesPerSecond() {
            return networkInBytesPerSecond;
        }

        public final void setNetworkInBytesPerSecond(String networkInBytesPerSecond) {
            this.networkInBytesPerSecond = networkInBytesPerSecond;
        }

        @Override
        @Transient
        public final Builder networkInBytesPerSecond(String networkInBytesPerSecond) {
            this.networkInBytesPerSecond = networkInBytesPerSecond;
            return this;
        }

        public final String getNetworkOutBytesPerSecond() {
            return networkOutBytesPerSecond;
        }

        public final void setNetworkOutBytesPerSecond(String networkOutBytesPerSecond) {
            this.networkOutBytesPerSecond = networkOutBytesPerSecond;
        }

        @Override
        @Transient
        public final Builder networkOutBytesPerSecond(String networkOutBytesPerSecond) {
            this.networkOutBytesPerSecond = networkOutBytesPerSecond;
            return this;
        }

        public final String getNetworkPacketsInPerSecond() {
            return networkPacketsInPerSecond;
        }

        public final void setNetworkPacketsInPerSecond(String networkPacketsInPerSecond) {
            this.networkPacketsInPerSecond = networkPacketsInPerSecond;
        }

        @Override
        @Transient
        public final Builder networkPacketsInPerSecond(String networkPacketsInPerSecond) {
            this.networkPacketsInPerSecond = networkPacketsInPerSecond;
            return this;
        }

        public final String getNetworkPacketsOutPerSecond() {
            return networkPacketsOutPerSecond;
        }

        public final void setNetworkPacketsOutPerSecond(String networkPacketsOutPerSecond) {
            this.networkPacketsOutPerSecond = networkPacketsOutPerSecond;
        }

        @Override
        @Transient
        public final Builder networkPacketsOutPerSecond(String networkPacketsOutPerSecond) {
            this.networkPacketsOutPerSecond = networkPacketsOutPerSecond;
            return this;
        }

        @Override
        public NetworkResourceUtilization build() {
            return new NetworkResourceUtilization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
