/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the Amazon Redshift instances that Amazon Web Services recommends that you purchase.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftInstanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftInstanceDetails.Builder, RedshiftInstanceDetails> {
    private static final SdkField<String> FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Family")
            .getter(getter(RedshiftInstanceDetails::family)).setter(setter(Builder::family))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Family").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(RedshiftInstanceDetails::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(RedshiftInstanceDetails::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<Boolean> CURRENT_GENERATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CurrentGeneration").getter(getter(RedshiftInstanceDetails::currentGeneration))
            .setter(setter(Builder::currentGeneration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentGeneration").build()).build();

    private static final SdkField<Boolean> SIZE_FLEX_ELIGIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SizeFlexEligible").getter(getter(RedshiftInstanceDetails::sizeFlexEligible))
            .setter(setter(Builder::sizeFlexEligible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeFlexEligible").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILY_FIELD, NODE_TYPE_FIELD,
            REGION_FIELD, CURRENT_GENERATION_FIELD, SIZE_FLEX_ELIGIBLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String family;

    private final String nodeType;

    private final String region;

    private final Boolean currentGeneration;

    private final Boolean sizeFlexEligible;

    private RedshiftInstanceDetails(BuilderImpl builder) {
        this.family = builder.family;
        this.nodeType = builder.nodeType;
        this.region = builder.region;
        this.currentGeneration = builder.currentGeneration;
        this.sizeFlexEligible = builder.sizeFlexEligible;
    }

    /**
     * <p>
     * The instance family of the recommended reservation.
     * </p>
     * 
     * @return The instance family of the recommended reservation.
     */
    public final String family() {
        return family;
    }

    /**
     * <p>
     * The type of node that Amazon Web Services recommends.
     * </p>
     * 
     * @return The type of node that Amazon Web Services recommends.
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the recommended reservation.
     * </p>
     * 
     * @return The Amazon Web Services Region of the recommended reservation.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * Determines whether the recommendation is for a current-generation instance.
     * </p>
     * 
     * @return Determines whether the recommendation is for a current-generation instance.
     */
    public final Boolean currentGeneration() {
        return currentGeneration;
    }

    /**
     * <p>
     * Determines whether the recommended reservation is size flexible.
     * </p>
     * 
     * @return Determines whether the recommended reservation is size flexible.
     */
    public final Boolean sizeFlexEligible() {
        return sizeFlexEligible;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(family());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(currentGeneration());
        hashCode = 31 * hashCode + Objects.hashCode(sizeFlexEligible());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftInstanceDetails)) {
            return false;
        }
        RedshiftInstanceDetails other = (RedshiftInstanceDetails) obj;
        return Objects.equals(family(), other.family()) && Objects.equals(nodeType(), other.nodeType())
                && Objects.equals(region(), other.region()) && Objects.equals(currentGeneration(), other.currentGeneration())
                && Objects.equals(sizeFlexEligible(), other.sizeFlexEligible());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftInstanceDetails").add("Family", family()).add("NodeType", nodeType())
                .add("Region", region()).add("CurrentGeneration", currentGeneration())
                .add("SizeFlexEligible", sizeFlexEligible()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Family":
            return Optional.ofNullable(clazz.cast(family()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "CurrentGeneration":
            return Optional.ofNullable(clazz.cast(currentGeneration()));
        case "SizeFlexEligible":
            return Optional.ofNullable(clazz.cast(sizeFlexEligible()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftInstanceDetails, T> g) {
        return obj -> g.apply((RedshiftInstanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftInstanceDetails> {
        /**
         * <p>
         * The instance family of the recommended reservation.
         * </p>
         * 
         * @param family
         *        The instance family of the recommended reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder family(String family);

        /**
         * <p>
         * The type of node that Amazon Web Services recommends.
         * </p>
         * 
         * @param nodeType
         *        The type of node that Amazon Web Services recommends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The Amazon Web Services Region of the recommended reservation.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region of the recommended reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * Determines whether the recommendation is for a current-generation instance.
         * </p>
         * 
         * @param currentGeneration
         *        Determines whether the recommendation is for a current-generation instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentGeneration(Boolean currentGeneration);

        /**
         * <p>
         * Determines whether the recommended reservation is size flexible.
         * </p>
         * 
         * @param sizeFlexEligible
         *        Determines whether the recommended reservation is size flexible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeFlexEligible(Boolean sizeFlexEligible);
    }

    static final class BuilderImpl implements Builder {
        private String family;

        private String nodeType;

        private String region;

        private Boolean currentGeneration;

        private Boolean sizeFlexEligible;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftInstanceDetails model) {
            family(model.family);
            nodeType(model.nodeType);
            region(model.region);
            currentGeneration(model.currentGeneration);
            sizeFlexEligible(model.sizeFlexEligible);
        }

        public final String getFamily() {
            return family;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        @Override
        @Transient
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        @Transient
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Boolean getCurrentGeneration() {
            return currentGeneration;
        }

        public final void setCurrentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
        }

        @Override
        @Transient
        public final Builder currentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
            return this;
        }

        public final Boolean getSizeFlexEligible() {
            return sizeFlexEligible;
        }

        public final void setSizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
        }

        @Override
        @Transient
        public final Builder sizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
            return this;
        }

        @Override
        public RedshiftInstanceDetails build() {
            return new RedshiftInstanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
