/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The combination of Amazon Web Services service, linked account, Region, and usage type where a cost anomaly is
 * observed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RootCause implements SdkPojo, Serializable, ToCopyableBuilder<RootCause.Builder, RootCause> {
    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Service")
            .getter(getter(RootCause::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(RootCause::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> LINKED_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LinkedAccount").getter(getter(RootCause::linkedAccount)).setter(setter(Builder::linkedAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkedAccount").build()).build();

    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsageType").getter(getter(RootCause::usageType)).setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, REGION_FIELD,
            LINKED_ACCOUNT_FIELD, USAGE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String service;

    private final String region;

    private final String linkedAccount;

    private final String usageType;

    private RootCause(BuilderImpl builder) {
        this.service = builder.service;
        this.region = builder.region;
        this.linkedAccount = builder.linkedAccount;
        this.usageType = builder.usageType;
    }

    /**
     * <p>
     * The Amazon Web Services service name that's associated with the cost anomaly.
     * </p>
     * 
     * @return The Amazon Web Services service name that's associated with the cost anomaly.
     */
    public final String service() {
        return service;
    }

    /**
     * <p>
     * The Amazon Web Services Region that's associated with the cost anomaly.
     * </p>
     * 
     * @return The Amazon Web Services Region that's associated with the cost anomaly.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The member account value that's associated with the cost anomaly.
     * </p>
     * 
     * @return The member account value that's associated with the cost anomaly.
     */
    public final String linkedAccount() {
        return linkedAccount;
    }

    /**
     * <p>
     * The <code>UsageType</code> value that's associated with the cost anomaly.
     * </p>
     * 
     * @return The <code>UsageType</code> value that's associated with the cost anomaly.
     */
    public final String usageType() {
        return usageType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(linkedAccount());
        hashCode = 31 * hashCode + Objects.hashCode(usageType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RootCause)) {
            return false;
        }
        RootCause other = (RootCause) obj;
        return Objects.equals(service(), other.service()) && Objects.equals(region(), other.region())
                && Objects.equals(linkedAccount(), other.linkedAccount()) && Objects.equals(usageType(), other.usageType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RootCause").add("Service", service()).add("Region", region())
                .add("LinkedAccount", linkedAccount()).add("UsageType", usageType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "LinkedAccount":
            return Optional.ofNullable(clazz.cast(linkedAccount()));
        case "UsageType":
            return Optional.ofNullable(clazz.cast(usageType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RootCause, T> g) {
        return obj -> g.apply((RootCause) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RootCause> {
        /**
         * <p>
         * The Amazon Web Services service name that's associated with the cost anomaly.
         * </p>
         * 
         * @param service
         *        The Amazon Web Services service name that's associated with the cost anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * The Amazon Web Services Region that's associated with the cost anomaly.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region that's associated with the cost anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The member account value that's associated with the cost anomaly.
         * </p>
         * 
         * @param linkedAccount
         *        The member account value that's associated with the cost anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedAccount(String linkedAccount);

        /**
         * <p>
         * The <code>UsageType</code> value that's associated with the cost anomaly.
         * </p>
         * 
         * @param usageType
         *        The <code>UsageType</code> value that's associated with the cost anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageType(String usageType);
    }

    static final class BuilderImpl implements Builder {
        private String service;

        private String region;

        private String linkedAccount;

        private String usageType;

        private BuilderImpl() {
        }

        private BuilderImpl(RootCause model) {
            service(model.service);
            region(model.region);
            linkedAccount(model.linkedAccount);
            usageType(model.usageType);
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        @Transient
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getLinkedAccount() {
            return linkedAccount;
        }

        public final void setLinkedAccount(String linkedAccount) {
            this.linkedAccount = linkedAccount;
        }

        @Override
        @Transient
        public final Builder linkedAccount(String linkedAccount) {
            this.linkedAccount = linkedAccount;
            return this;
        }

        public final String getUsageType() {
            return usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        @Transient
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        @Override
        public RootCause build() {
            return new RootCause(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
