/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure of Cost Categories. This includes detailed metadata and the set of rules for the
 * <code>CostCategory</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CostCategory implements SdkPojo, Serializable, ToCopyableBuilder<CostCategory.Builder, CostCategory> {
    private static final SdkField<String> COST_CATEGORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CostCategoryArn").getter(getter(CostCategory::costCategoryArn)).setter(setter(Builder::costCategoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryArn").build()).build();

    private static final SdkField<String> EFFECTIVE_START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EffectiveStart").getter(getter(CostCategory::effectiveStart)).setter(setter(Builder::effectiveStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveStart").build()).build();

    private static final SdkField<String> EFFECTIVE_END_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EffectiveEnd").getter(getter(CostCategory::effectiveEnd)).setter(setter(Builder::effectiveEnd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveEnd").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CostCategory::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RULE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleVersion").getter(getter(CostCategory::ruleVersionAsString)).setter(setter(Builder::ruleVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleVersion").build()).build();

    private static final SdkField<List<CostCategoryRule>> RULES_FIELD = SdkField
            .<List<CostCategoryRule>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(CostCategory::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CostCategoryRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(CostCategoryRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CostCategorySplitChargeRule>> SPLIT_CHARGE_RULES_FIELD = SdkField
            .<List<CostCategorySplitChargeRule>> builder(MarshallingType.LIST)
            .memberName("SplitChargeRules")
            .getter(getter(CostCategory::splitChargeRules))
            .setter(setter(Builder::splitChargeRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplitChargeRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CostCategorySplitChargeRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(CostCategorySplitChargeRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CostCategoryProcessingStatus>> PROCESSING_STATUS_FIELD = SdkField
            .<List<CostCategoryProcessingStatus>> builder(MarshallingType.LIST)
            .memberName("ProcessingStatus")
            .getter(getter(CostCategory::processingStatus))
            .setter(setter(Builder::processingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CostCategoryProcessingStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(CostCategoryProcessingStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue").getter(getter(CostCategory::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_CATEGORY_ARN_FIELD,
            EFFECTIVE_START_FIELD, EFFECTIVE_END_FIELD, NAME_FIELD, RULE_VERSION_FIELD, RULES_FIELD, SPLIT_CHARGE_RULES_FIELD,
            PROCESSING_STATUS_FIELD, DEFAULT_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String costCategoryArn;

    private final String effectiveStart;

    private final String effectiveEnd;

    private final String name;

    private final String ruleVersion;

    private final List<CostCategoryRule> rules;

    private final List<CostCategorySplitChargeRule> splitChargeRules;

    private final List<CostCategoryProcessingStatus> processingStatus;

    private final String defaultValue;

    private CostCategory(BuilderImpl builder) {
        this.costCategoryArn = builder.costCategoryArn;
        this.effectiveStart = builder.effectiveStart;
        this.effectiveEnd = builder.effectiveEnd;
        this.name = builder.name;
        this.ruleVersion = builder.ruleVersion;
        this.rules = builder.rules;
        this.splitChargeRules = builder.splitChargeRules;
        this.processingStatus = builder.processingStatus;
        this.defaultValue = builder.defaultValue;
    }

    /**
     * <p>
     * The unique identifier for your Cost Category.
     * </p>
     * 
     * @return The unique identifier for your Cost Category.
     */
    public final String costCategoryArn() {
        return costCategoryArn;
    }

    /**
     * <p>
     * The effective state data of your Cost Category.
     * </p>
     * 
     * @return The effective state data of your Cost Category.
     */
    public final String effectiveStart() {
        return effectiveStart;
    }

    /**
     * <p>
     * The effective end data of your Cost Category.
     * </p>
     * 
     * @return The effective end data of your Cost Category.
     */
    public final String effectiveEnd() {
        return effectiveEnd;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the RuleVersion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleVersion} will
     * return {@link CostCategoryRuleVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleVersionAsString}.
     * </p>
     * 
     * @return The value of the RuleVersion property for this object.
     * @see CostCategoryRuleVersion
     */
    public final CostCategoryRuleVersion ruleVersion() {
        return CostCategoryRuleVersion.fromValue(ruleVersion);
    }

    /**
     * Returns the value of the RuleVersion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleVersion} will
     * return {@link CostCategoryRuleVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleVersionAsString}.
     * </p>
     * 
     * @return The value of the RuleVersion property for this object.
     * @see CostCategoryRuleVersion
     */
    public final String ruleVersionAsString() {
        return ruleVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules are processed in order. If there are multiple rules that match the line item, then the first rule to
     * match is used to determine that Cost Category value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The rules are processed in order. If there are multiple rules that match the line item, then the first
     *         rule to match is used to determine that Cost Category value.
     */
    public final List<CostCategoryRule> rules() {
        return rules;
    }

    /**
     * For responses, this returns true if the service returned a value for the SplitChargeRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSplitChargeRules() {
        return splitChargeRules != null && !(splitChargeRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The split charge rules that are used to allocate your charges between your Cost Category values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSplitChargeRules} method.
     * </p>
     * 
     * @return The split charge rules that are used to allocate your charges between your Cost Category values.
     */
    public final List<CostCategorySplitChargeRule> splitChargeRules() {
        return splitChargeRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProcessingStatus property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProcessingStatus() {
        return processingStatus != null && !(processingStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of processing statuses for Cost Management products for a specific cost category.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessingStatus} method.
     * </p>
     * 
     * @return The list of processing statuses for Cost Management products for a specific cost category.
     */
    public final List<CostCategoryProcessingStatus> processingStatus() {
        return processingStatus;
    }

    /**
     * Returns the value of the DefaultValue property for this object.
     * 
     * @return The value of the DefaultValue property for this object.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(costCategoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveStart());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveEnd());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ruleVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSplitChargeRules() ? splitChargeRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessingStatus() ? processingStatus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostCategory)) {
            return false;
        }
        CostCategory other = (CostCategory) obj;
        return Objects.equals(costCategoryArn(), other.costCategoryArn())
                && Objects.equals(effectiveStart(), other.effectiveStart())
                && Objects.equals(effectiveEnd(), other.effectiveEnd()) && Objects.equals(name(), other.name())
                && Objects.equals(ruleVersionAsString(), other.ruleVersionAsString()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules()) && hasSplitChargeRules() == other.hasSplitChargeRules()
                && Objects.equals(splitChargeRules(), other.splitChargeRules())
                && hasProcessingStatus() == other.hasProcessingStatus()
                && Objects.equals(processingStatus(), other.processingStatus())
                && Objects.equals(defaultValue(), other.defaultValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CostCategory").add("CostCategoryArn", costCategoryArn()).add("EffectiveStart", effectiveStart())
                .add("EffectiveEnd", effectiveEnd()).add("Name", name()).add("RuleVersion", ruleVersionAsString())
                .add("Rules", hasRules() ? rules() : null)
                .add("SplitChargeRules", hasSplitChargeRules() ? splitChargeRules() : null)
                .add("ProcessingStatus", hasProcessingStatus() ? processingStatus() : null).add("DefaultValue", defaultValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CostCategoryArn":
            return Optional.ofNullable(clazz.cast(costCategoryArn()));
        case "EffectiveStart":
            return Optional.ofNullable(clazz.cast(effectiveStart()));
        case "EffectiveEnd":
            return Optional.ofNullable(clazz.cast(effectiveEnd()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RuleVersion":
            return Optional.ofNullable(clazz.cast(ruleVersionAsString()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "SplitChargeRules":
            return Optional.ofNullable(clazz.cast(splitChargeRules()));
        case "ProcessingStatus":
            return Optional.ofNullable(clazz.cast(processingStatus()));
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CostCategory, T> g) {
        return obj -> g.apply((CostCategory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CostCategory> {
        /**
         * <p>
         * The unique identifier for your Cost Category.
         * </p>
         * 
         * @param costCategoryArn
         *        The unique identifier for your Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryArn(String costCategoryArn);

        /**
         * <p>
         * The effective state data of your Cost Category.
         * </p>
         * 
         * @param effectiveStart
         *        The effective state data of your Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveStart(String effectiveStart);

        /**
         * <p>
         * The effective end data of your Cost Category.
         * </p>
         * 
         * @param effectiveEnd
         *        The effective end data of your Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveEnd(String effectiveEnd);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the RuleVersion property for this object.
         *
         * @param ruleVersion
         *        The new value for the RuleVersion property for this object.
         * @see CostCategoryRuleVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryRuleVersion
         */
        Builder ruleVersion(String ruleVersion);

        /**
         * Sets the value of the RuleVersion property for this object.
         *
         * @param ruleVersion
         *        The new value for the RuleVersion property for this object.
         * @see CostCategoryRuleVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryRuleVersion
         */
        Builder ruleVersion(CostCategoryRuleVersion ruleVersion);

        /**
         * <p>
         * The rules are processed in order. If there are multiple rules that match the line item, then the first rule
         * to match is used to determine that Cost Category value.
         * </p>
         * 
         * @param rules
         *        The rules are processed in order. If there are multiple rules that match the line item, then the first
         *        rule to match is used to determine that Cost Category value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<CostCategoryRule> rules);

        /**
         * <p>
         * The rules are processed in order. If there are multiple rules that match the line item, then the first rule
         * to match is used to determine that Cost Category value.
         * </p>
         * 
         * @param rules
         *        The rules are processed in order. If there are multiple rules that match the line item, then the first
         *        rule to match is used to determine that Cost Category value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(CostCategoryRule... rules);

        /**
         * <p>
         * The rules are processed in order. If there are multiple rules that match the line item, then the first rule
         * to match is used to determine that Cost Category value.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<CostCategoryRule>.Builder} avoiding
         * the need to create one manually via {@link List<CostCategoryRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CostCategoryRule>.Builder#build()} is called immediately and
         * its result is passed to {@link #rules(List<CostCategoryRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<CostCategoryRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<CostCategoryRule>)
         */
        Builder rules(Consumer<CostCategoryRule.Builder>... rules);

        /**
         * <p>
         * The split charge rules that are used to allocate your charges between your Cost Category values.
         * </p>
         * 
         * @param splitChargeRules
         *        The split charge rules that are used to allocate your charges between your Cost Category values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splitChargeRules(Collection<CostCategorySplitChargeRule> splitChargeRules);

        /**
         * <p>
         * The split charge rules that are used to allocate your charges between your Cost Category values.
         * </p>
         * 
         * @param splitChargeRules
         *        The split charge rules that are used to allocate your charges between your Cost Category values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splitChargeRules(CostCategorySplitChargeRule... splitChargeRules);

        /**
         * <p>
         * The split charge rules that are used to allocate your charges between your Cost Category values.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <CostCategorySplitChargeRule>.Builder} avoiding the need to create one manually via {@link List
         * <CostCategorySplitChargeRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CostCategorySplitChargeRule>.Builder#build()} is called
         * immediately and its result is passed to {@link #splitChargeRules(List<CostCategorySplitChargeRule>)}.
         * 
         * @param splitChargeRules
         *        a consumer that will call methods on {@link List<CostCategorySplitChargeRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #splitChargeRules(List<CostCategorySplitChargeRule>)
         */
        Builder splitChargeRules(Consumer<CostCategorySplitChargeRule.Builder>... splitChargeRules);

        /**
         * <p>
         * The list of processing statuses for Cost Management products for a specific cost category.
         * </p>
         * 
         * @param processingStatus
         *        The list of processing statuses for Cost Management products for a specific cost category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingStatus(Collection<CostCategoryProcessingStatus> processingStatus);

        /**
         * <p>
         * The list of processing statuses for Cost Management products for a specific cost category.
         * </p>
         * 
         * @param processingStatus
         *        The list of processing statuses for Cost Management products for a specific cost category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingStatus(CostCategoryProcessingStatus... processingStatus);

        /**
         * <p>
         * The list of processing statuses for Cost Management products for a specific cost category.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <CostCategoryProcessingStatus>.Builder} avoiding the need to create one manually via {@link List
         * <CostCategoryProcessingStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CostCategoryProcessingStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link #processingStatus(List<CostCategoryProcessingStatus>)}.
         * 
         * @param processingStatus
         *        a consumer that will call methods on {@link List<CostCategoryProcessingStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingStatus(List<CostCategoryProcessingStatus>)
         */
        Builder processingStatus(Consumer<CostCategoryProcessingStatus.Builder>... processingStatus);

        /**
         * Sets the value of the DefaultValue property for this object.
         *
         * @param defaultValue
         *        The new value for the DefaultValue property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);
    }

    static final class BuilderImpl implements Builder {
        private String costCategoryArn;

        private String effectiveStart;

        private String effectiveEnd;

        private String name;

        private String ruleVersion;

        private List<CostCategoryRule> rules = DefaultSdkAutoConstructList.getInstance();

        private List<CostCategorySplitChargeRule> splitChargeRules = DefaultSdkAutoConstructList.getInstance();

        private List<CostCategoryProcessingStatus> processingStatus = DefaultSdkAutoConstructList.getInstance();

        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CostCategory model) {
            costCategoryArn(model.costCategoryArn);
            effectiveStart(model.effectiveStart);
            effectiveEnd(model.effectiveEnd);
            name(model.name);
            ruleVersion(model.ruleVersion);
            rules(model.rules);
            splitChargeRules(model.splitChargeRules);
            processingStatus(model.processingStatus);
            defaultValue(model.defaultValue);
        }

        public final String getCostCategoryArn() {
            return costCategoryArn;
        }

        public final void setCostCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
        }

        @Override
        public final Builder costCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
            return this;
        }

        public final String getEffectiveStart() {
            return effectiveStart;
        }

        public final void setEffectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
        }

        @Override
        public final Builder effectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
            return this;
        }

        public final String getEffectiveEnd() {
            return effectiveEnd;
        }

        public final void setEffectiveEnd(String effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
        }

        @Override
        public final Builder effectiveEnd(String effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuleVersion() {
            return ruleVersion;
        }

        public final void setRuleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
        }

        @Override
        public final Builder ruleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
            return this;
        }

        @Override
        public final Builder ruleVersion(CostCategoryRuleVersion ruleVersion) {
            this.ruleVersion(ruleVersion == null ? null : ruleVersion.toString());
            return this;
        }

        public final List<CostCategoryRule.Builder> getRules() {
            List<CostCategoryRule.Builder> result = CostCategoryRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<CostCategoryRule.BuilderImpl> rules) {
            this.rules = CostCategoryRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<CostCategoryRule> rules) {
            this.rules = CostCategoryRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(CostCategoryRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<CostCategoryRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> CostCategoryRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CostCategorySplitChargeRule.Builder> getSplitChargeRules() {
            List<CostCategorySplitChargeRule.Builder> result = CostCategorySplitChargeRulesListCopier
                    .copyToBuilder(this.splitChargeRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSplitChargeRules(Collection<CostCategorySplitChargeRule.BuilderImpl> splitChargeRules) {
            this.splitChargeRules = CostCategorySplitChargeRulesListCopier.copyFromBuilder(splitChargeRules);
        }

        @Override
        public final Builder splitChargeRules(Collection<CostCategorySplitChargeRule> splitChargeRules) {
            this.splitChargeRules = CostCategorySplitChargeRulesListCopier.copy(splitChargeRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder splitChargeRules(CostCategorySplitChargeRule... splitChargeRules) {
            splitChargeRules(Arrays.asList(splitChargeRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder splitChargeRules(Consumer<CostCategorySplitChargeRule.Builder>... splitChargeRules) {
            splitChargeRules(Stream.of(splitChargeRules).map(c -> CostCategorySplitChargeRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CostCategoryProcessingStatus.Builder> getProcessingStatus() {
            List<CostCategoryProcessingStatus.Builder> result = CostCategoryProcessingStatusListCopier
                    .copyToBuilder(this.processingStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessingStatus(Collection<CostCategoryProcessingStatus.BuilderImpl> processingStatus) {
            this.processingStatus = CostCategoryProcessingStatusListCopier.copyFromBuilder(processingStatus);
        }

        @Override
        public final Builder processingStatus(Collection<CostCategoryProcessingStatus> processingStatus) {
            this.processingStatus = CostCategoryProcessingStatusListCopier.copy(processingStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingStatus(CostCategoryProcessingStatus... processingStatus) {
            processingStatus(Arrays.asList(processingStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingStatus(Consumer<CostCategoryProcessingStatus.Builder>... processingStatus) {
            processingStatus(Stream.of(processingStatus)
                    .map(c -> CostCategoryProcessingStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        public CostCategory build() {
            return new CostCategory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
