/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCostCategoryDefinitionRequest extends CostExplorerRequest implements
        ToCopyableBuilder<CreateCostCategoryDefinitionRequest.Builder, CreateCostCategoryDefinitionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateCostCategoryDefinitionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RULE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleVersion").getter(getter(CreateCostCategoryDefinitionRequest::ruleVersionAsString))
            .setter(setter(Builder::ruleVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleVersion").build()).build();

    private static final SdkField<List<CostCategoryRule>> RULES_FIELD = SdkField
            .<List<CostCategoryRule>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(CreateCostCategoryDefinitionRequest::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CostCategoryRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(CostCategoryRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue").getter(getter(CreateCostCategoryDefinitionRequest::defaultValue))
            .setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final SdkField<List<CostCategorySplitChargeRule>> SPLIT_CHARGE_RULES_FIELD = SdkField
            .<List<CostCategorySplitChargeRule>> builder(MarshallingType.LIST)
            .memberName("SplitChargeRules")
            .getter(getter(CreateCostCategoryDefinitionRequest::splitChargeRules))
            .setter(setter(Builder::splitChargeRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplitChargeRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CostCategorySplitChargeRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(CostCategorySplitChargeRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField
            .<List<ResourceTag>> builder(MarshallingType.LIST)
            .memberName("ResourceTags")
            .getter(getter(CreateCostCategoryDefinitionRequest::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            RULE_VERSION_FIELD, RULES_FIELD, DEFAULT_VALUE_FIELD, SPLIT_CHARGE_RULES_FIELD, RESOURCE_TAGS_FIELD));

    private final String name;

    private final String ruleVersion;

    private final List<CostCategoryRule> rules;

    private final String defaultValue;

    private final List<CostCategorySplitChargeRule> splitChargeRules;

    private final List<ResourceTag> resourceTags;

    private CreateCostCategoryDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.ruleVersion = builder.ruleVersion;
        this.rules = builder.rules;
        this.defaultValue = builder.defaultValue;
        this.splitChargeRules = builder.splitChargeRules;
        this.resourceTags = builder.resourceTags;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the RuleVersion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleVersion} will
     * return {@link CostCategoryRuleVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleVersionAsString}.
     * </p>
     * 
     * @return The value of the RuleVersion property for this object.
     * @see CostCategoryRuleVersion
     */
    public final CostCategoryRuleVersion ruleVersion() {
        return CostCategoryRuleVersion.fromValue(ruleVersion);
    }

    /**
     * Returns the value of the RuleVersion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleVersion} will
     * return {@link CostCategoryRuleVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleVersionAsString}.
     * </p>
     * 
     * @return The value of the RuleVersion property for this object.
     * @see CostCategoryRuleVersion
     */
    public final String ruleVersionAsString() {
        return ruleVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Cost Category rules used to categorize costs. For more information, see <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html"
     * >CostCategoryRule</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The Cost Category rules used to categorize costs. For more information, see <a
     *         href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html"
     *         >CostCategoryRule</a>.
     */
    public final List<CostCategoryRule> rules() {
        return rules;
    }

    /**
     * Returns the value of the DefaultValue property for this object.
     * 
     * @return The value of the DefaultValue property for this object.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the SplitChargeRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSplitChargeRules() {
        return splitChargeRules != null && !(splitChargeRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The split charge rules used to allocate your charges between your Cost Category values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSplitChargeRules} method.
     * </p>
     * 
     * @return The split charge rules used to allocate your charges between your Cost Category values.
     */
    public final List<CostCategorySplitChargeRule> splitChargeRules() {
        return splitChargeRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of tags to associate with the specified <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategory.html">
     * <code>CostCategory</code> </a>. You can use resource tags to control access to your <code>cost category</code>
     * using IAM policies.
     * </p>
     * <p>
     * Each tag consists of a key and a value, and each key must be unique for the resource. The following restrictions
     * apply to resource tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Although the maximum number of array members is 200, you can assign a maximum of 50 user-tags to one resource.
     * The remaining are reserved for Amazon Web Services use
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum length of a key is 128 characters
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum length of a value is 256 characters
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid characters for keys and values are: <code>A-Z</code>, <code>a-z</code>, spaces, <code>_.:/=+-</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Keys and values are case sensitive
     * </p>
     * </li>
     * <li>
     * <p>
     * Keys and values are trimmed for any leading or trailing whitespaces
     * </p>
     * </li>
     * <li>
     * <p>
     * Don’t use <code>aws:</code> as a prefix for your keys. This prefix is reserved for Amazon Web Services use
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTags} method.
     * </p>
     * 
     * @return An optional list of tags to associate with the specified <a
     *         href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategory.html">
     *         <code>CostCategory</code> </a>. You can use resource tags to control access to your
     *         <code>cost category</code> using IAM policies.</p>
     *         <p>
     *         Each tag consists of a key and a value, and each key must be unique for the resource. The following
     *         restrictions apply to resource tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Although the maximum number of array members is 200, you can assign a maximum of 50 user-tags to one
     *         resource. The remaining are reserved for Amazon Web Services use
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The maximum length of a key is 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The maximum length of a value is 256 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid characters for keys and values are: <code>A-Z</code>, <code>a-z</code>, spaces,
     *         <code>_.:/=+-</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Keys and values are case sensitive
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Keys and values are trimmed for any leading or trailing whitespaces
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Don’t use <code>aws:</code> as a prefix for your keys. This prefix is reserved for Amazon Web Services
     *         use
     *         </p>
     *         </li>
     */
    public final List<ResourceTag> resourceTags() {
        return resourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ruleVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasSplitChargeRules() ? splitChargeRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCostCategoryDefinitionRequest)) {
            return false;
        }
        CreateCostCategoryDefinitionRequest other = (CreateCostCategoryDefinitionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(ruleVersionAsString(), other.ruleVersionAsString())
                && hasRules() == other.hasRules() && Objects.equals(rules(), other.rules())
                && Objects.equals(defaultValue(), other.defaultValue()) && hasSplitChargeRules() == other.hasSplitChargeRules()
                && Objects.equals(splitChargeRules(), other.splitChargeRules()) && hasResourceTags() == other.hasResourceTags()
                && Objects.equals(resourceTags(), other.resourceTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCostCategoryDefinitionRequest").add("Name", name())
                .add("RuleVersion", ruleVersionAsString()).add("Rules", hasRules() ? rules() : null)
                .add("DefaultValue", defaultValue()).add("SplitChargeRules", hasSplitChargeRules() ? splitChargeRules() : null)
                .add("ResourceTags", hasResourceTags() ? resourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RuleVersion":
            return Optional.ofNullable(clazz.cast(ruleVersionAsString()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "SplitChargeRules":
            return Optional.ofNullable(clazz.cast(splitChargeRules()));
        case "ResourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCostCategoryDefinitionRequest, T> g) {
        return obj -> g.apply((CreateCostCategoryDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCostCategoryDefinitionRequest> {
        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the RuleVersion property for this object.
         *
         * @param ruleVersion
         *        The new value for the RuleVersion property for this object.
         * @see CostCategoryRuleVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryRuleVersion
         */
        Builder ruleVersion(String ruleVersion);

        /**
         * Sets the value of the RuleVersion property for this object.
         *
         * @param ruleVersion
         *        The new value for the RuleVersion property for this object.
         * @see CostCategoryRuleVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryRuleVersion
         */
        Builder ruleVersion(CostCategoryRuleVersion ruleVersion);

        /**
         * <p>
         * The Cost Category rules used to categorize costs. For more information, see <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html"
         * >CostCategoryRule</a>.
         * </p>
         * 
         * @param rules
         *        The Cost Category rules used to categorize costs. For more information, see <a
         *        href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html"
         *        >CostCategoryRule</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<CostCategoryRule> rules);

        /**
         * <p>
         * The Cost Category rules used to categorize costs. For more information, see <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html"
         * >CostCategoryRule</a>.
         * </p>
         * 
         * @param rules
         *        The Cost Category rules used to categorize costs. For more information, see <a
         *        href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html"
         *        >CostCategoryRule</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(CostCategoryRule... rules);

        /**
         * <p>
         * The Cost Category rules used to categorize costs. For more information, see <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html"
         * >CostCategoryRule</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<CostCategoryRule>.Builder} avoiding
         * the need to create one manually via {@link List<CostCategoryRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CostCategoryRule>.Builder#build()} is called immediately and
         * its result is passed to {@link #rules(List<CostCategoryRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<CostCategoryRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<CostCategoryRule>)
         */
        Builder rules(Consumer<CostCategoryRule.Builder>... rules);

        /**
         * Sets the value of the DefaultValue property for this object.
         *
         * @param defaultValue
         *        The new value for the DefaultValue property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The split charge rules used to allocate your charges between your Cost Category values.
         * </p>
         * 
         * @param splitChargeRules
         *        The split charge rules used to allocate your charges between your Cost Category values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splitChargeRules(Collection<CostCategorySplitChargeRule> splitChargeRules);

        /**
         * <p>
         * The split charge rules used to allocate your charges between your Cost Category values.
         * </p>
         * 
         * @param splitChargeRules
         *        The split charge rules used to allocate your charges between your Cost Category values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splitChargeRules(CostCategorySplitChargeRule... splitChargeRules);

        /**
         * <p>
         * The split charge rules used to allocate your charges between your Cost Category values.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <CostCategorySplitChargeRule>.Builder} avoiding the need to create one manually via {@link List
         * <CostCategorySplitChargeRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CostCategorySplitChargeRule>.Builder#build()} is called
         * immediately and its result is passed to {@link #splitChargeRules(List<CostCategorySplitChargeRule>)}.
         * 
         * @param splitChargeRules
         *        a consumer that will call methods on {@link List<CostCategorySplitChargeRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #splitChargeRules(List<CostCategorySplitChargeRule>)
         */
        Builder splitChargeRules(Consumer<CostCategorySplitChargeRule.Builder>... splitChargeRules);

        /**
         * <p>
         * An optional list of tags to associate with the specified <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategory.html">
         * <code>CostCategory</code> </a>. You can use resource tags to control access to your
         * <code>cost category</code> using IAM policies.
         * </p>
         * <p>
         * Each tag consists of a key and a value, and each key must be unique for the resource. The following
         * restrictions apply to resource tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Although the maximum number of array members is 200, you can assign a maximum of 50 user-tags to one
         * resource. The remaining are reserved for Amazon Web Services use
         * </p>
         * </li>
         * <li>
         * <p>
         * The maximum length of a key is 128 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * The maximum length of a value is 256 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid characters for keys and values are: <code>A-Z</code>, <code>a-z</code>, spaces, <code>_.:/=+-</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys and values are case sensitive
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys and values are trimmed for any leading or trailing whitespaces
         * </p>
         * </li>
         * <li>
         * <p>
         * Don’t use <code>aws:</code> as a prefix for your keys. This prefix is reserved for Amazon Web Services use
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceTags
         *        An optional list of tags to associate with the specified <a
         *        href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategory.html">
         *        <code>CostCategory</code> </a>. You can use resource tags to control access to your
         *        <code>cost category</code> using IAM policies.</p>
         *        <p>
         *        Each tag consists of a key and a value, and each key must be unique for the resource. The following
         *        restrictions apply to resource tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Although the maximum number of array members is 200, you can assign a maximum of 50 user-tags to one
         *        resource. The remaining are reserved for Amazon Web Services use
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The maximum length of a key is 128 characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The maximum length of a value is 256 characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid characters for keys and values are: <code>A-Z</code>, <code>a-z</code>, spaces,
         *        <code>_.:/=+-</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Keys and values are case sensitive
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Keys and values are trimmed for any leading or trailing whitespaces
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Don’t use <code>aws:</code> as a prefix for your keys. This prefix is reserved for Amazon Web Services
         *        use
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Collection<ResourceTag> resourceTags);

        /**
         * <p>
         * An optional list of tags to associate with the specified <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategory.html">
         * <code>CostCategory</code> </a>. You can use resource tags to control access to your
         * <code>cost category</code> using IAM policies.
         * </p>
         * <p>
         * Each tag consists of a key and a value, and each key must be unique for the resource. The following
         * restrictions apply to resource tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Although the maximum number of array members is 200, you can assign a maximum of 50 user-tags to one
         * resource. The remaining are reserved for Amazon Web Services use
         * </p>
         * </li>
         * <li>
         * <p>
         * The maximum length of a key is 128 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * The maximum length of a value is 256 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid characters for keys and values are: <code>A-Z</code>, <code>a-z</code>, spaces, <code>_.:/=+-</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys and values are case sensitive
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys and values are trimmed for any leading or trailing whitespaces
         * </p>
         * </li>
         * <li>
         * <p>
         * Don’t use <code>aws:</code> as a prefix for your keys. This prefix is reserved for Amazon Web Services use
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceTags
         *        An optional list of tags to associate with the specified <a
         *        href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategory.html">
         *        <code>CostCategory</code> </a>. You can use resource tags to control access to your
         *        <code>cost category</code> using IAM policies.</p>
         *        <p>
         *        Each tag consists of a key and a value, and each key must be unique for the resource. The following
         *        restrictions apply to resource tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Although the maximum number of array members is 200, you can assign a maximum of 50 user-tags to one
         *        resource. The remaining are reserved for Amazon Web Services use
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The maximum length of a key is 128 characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The maximum length of a value is 256 characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid characters for keys and values are: <code>A-Z</code>, <code>a-z</code>, spaces,
         *        <code>_.:/=+-</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Keys and values are case sensitive
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Keys and values are trimmed for any leading or trailing whitespaces
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Don’t use <code>aws:</code> as a prefix for your keys. This prefix is reserved for Amazon Web Services
         *        use
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(ResourceTag... resourceTags);

        /**
         * <p>
         * An optional list of tags to associate with the specified <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategory.html">
         * <code>CostCategory</code> </a>. You can use resource tags to control access to your
         * <code>cost category</code> using IAM policies.
         * </p>
         * <p>
         * Each tag consists of a key and a value, and each key must be unique for the resource. The following
         * restrictions apply to resource tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Although the maximum number of array members is 200, you can assign a maximum of 50 user-tags to one
         * resource. The remaining are reserved for Amazon Web Services use
         * </p>
         * </li>
         * <li>
         * <p>
         * The maximum length of a key is 128 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * The maximum length of a value is 256 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid characters for keys and values are: <code>A-Z</code>, <code>a-z</code>, spaces, <code>_.:/=+-</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys and values are case sensitive
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys and values are trimmed for any leading or trailing whitespaces
         * </p>
         * </li>
         * <li>
         * <p>
         * Don’t use <code>aws:</code> as a prefix for your keys. This prefix is reserved for Amazon Web Services use
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link List<ResourceTag>.Builder} avoiding the
         * need to create one manually via {@link List<ResourceTag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceTag>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceTags(List<ResourceTag>)}.
         * 
         * @param resourceTags
         *        a consumer that will call methods on {@link List<ResourceTag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTags(List<ResourceTag>)
         */
        Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String name;

        private String ruleVersion;

        private List<CostCategoryRule> rules = DefaultSdkAutoConstructList.getInstance();

        private String defaultValue;

        private List<CostCategorySplitChargeRule> splitChargeRules = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCostCategoryDefinitionRequest model) {
            super(model);
            name(model.name);
            ruleVersion(model.ruleVersion);
            rules(model.rules);
            defaultValue(model.defaultValue);
            splitChargeRules(model.splitChargeRules);
            resourceTags(model.resourceTags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuleVersion() {
            return ruleVersion;
        }

        public final void setRuleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
        }

        @Override
        public final Builder ruleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
            return this;
        }

        @Override
        public final Builder ruleVersion(CostCategoryRuleVersion ruleVersion) {
            this.ruleVersion(ruleVersion == null ? null : ruleVersion.toString());
            return this;
        }

        public final List<CostCategoryRule.Builder> getRules() {
            List<CostCategoryRule.Builder> result = CostCategoryRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<CostCategoryRule.BuilderImpl> rules) {
            this.rules = CostCategoryRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<CostCategoryRule> rules) {
            this.rules = CostCategoryRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(CostCategoryRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<CostCategoryRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> CostCategoryRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final List<CostCategorySplitChargeRule.Builder> getSplitChargeRules() {
            List<CostCategorySplitChargeRule.Builder> result = CostCategorySplitChargeRulesListCopier
                    .copyToBuilder(this.splitChargeRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSplitChargeRules(Collection<CostCategorySplitChargeRule.BuilderImpl> splitChargeRules) {
            this.splitChargeRules = CostCategorySplitChargeRulesListCopier.copyFromBuilder(splitChargeRules);
        }

        @Override
        public final Builder splitChargeRules(Collection<CostCategorySplitChargeRule> splitChargeRules) {
            this.splitChargeRules = CostCategorySplitChargeRulesListCopier.copy(splitChargeRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder splitChargeRules(CostCategorySplitChargeRule... splitChargeRules) {
            splitChargeRules(Arrays.asList(splitChargeRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder splitChargeRules(Consumer<CostCategorySplitChargeRule.Builder>... splitChargeRules) {
            splitChargeRules(Stream.of(splitChargeRules).map(c -> CostCategorySplitChargeRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag... resourceTags) {
            resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags) {
            resourceTags(Stream.of(resourceTags).map(c -> ResourceTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCostCategoryDefinitionRequest build() {
            return new CreateCostCategoryDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
