/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCostCategoriesResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetCostCategoriesResponse.Builder, GetCostCategoriesResponse> {
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetCostCategoriesResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final SdkField<List<String>> COST_CATEGORY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CostCategoryNames")
            .getter(getter(GetCostCategoriesResponse::costCategoryNames))
            .setter(setter(Builder::costCategoryNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> COST_CATEGORY_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CostCategoryValues")
            .getter(getter(GetCostCategoriesResponse::costCategoryValues))
            .setter(setter(Builder::costCategoryValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> RETURN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReturnSize").getter(getter(GetCostCategoriesResponse::returnSize)).setter(setter(Builder::returnSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnSize").build()).build();

    private static final SdkField<Integer> TOTAL_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalSize").getter(getter(GetCostCategoriesResponse::totalSize)).setter(setter(Builder::totalSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_PAGE_TOKEN_FIELD,
            COST_CATEGORY_NAMES_FIELD, COST_CATEGORY_VALUES_FIELD, RETURN_SIZE_FIELD, TOTAL_SIZE_FIELD));

    private final String nextPageToken;

    private final List<String> costCategoryNames;

    private final List<String> costCategoryValues;

    private final Integer returnSize;

    private final Integer totalSize;

    private GetCostCategoriesResponse(BuilderImpl builder) {
        super(builder);
        this.nextPageToken = builder.nextPageToken;
        this.costCategoryNames = builder.costCategoryNames;
        this.costCategoryValues = builder.costCategoryValues;
        this.returnSize = builder.returnSize;
        this.totalSize = builder.totalSize;
    }

    /**
     * <p>
     * If the number of objects that are still available for retrieval exceeds the limit, Amazon Web Services returns a
     * NextPageToken value in the response. To retrieve the next batch of objects, provide the marker from the prior
     * call in your next request.
     * </p>
     * 
     * @return If the number of objects that are still available for retrieval exceeds the limit, Amazon Web Services
     *         returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the marker
     *         from the prior call in your next request.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CostCategoryNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCostCategoryNames() {
        return costCategoryNames != null && !(costCategoryNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the Cost Categories.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCostCategoryNames} method.
     * </p>
     * 
     * @return The names of the Cost Categories.
     */
    public final List<String> costCategoryNames() {
        return costCategoryNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the CostCategoryValues property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCostCategoryValues() {
        return costCategoryValues != null && !(costCategoryValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Cost Category values.
     * </p>
     * <p>
     * <code>CostCategoryValues</code> are not returned if <code>CostCategoryName</code> is not specified in the
     * request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCostCategoryValues} method.
     * </p>
     * 
     * @return The Cost Category values.</p>
     *         <p>
     *         <code>CostCategoryValues</code> are not returned if <code>CostCategoryName</code> is not specified in the
     *         request.
     */
    public final List<String> costCategoryValues() {
        return costCategoryValues;
    }

    /**
     * <p>
     * The number of objects returned.
     * </p>
     * 
     * @return The number of objects returned.
     */
    public final Integer returnSize() {
        return returnSize;
    }

    /**
     * <p>
     * The total number of objects.
     * </p>
     * 
     * @return The total number of objects.
     */
    public final Integer totalSize() {
        return totalSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCostCategoryNames() ? costCategoryNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCostCategoryValues() ? costCategoryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(returnSize());
        hashCode = 31 * hashCode + Objects.hashCode(totalSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostCategoriesResponse)) {
            return false;
        }
        GetCostCategoriesResponse other = (GetCostCategoriesResponse) obj;
        return Objects.equals(nextPageToken(), other.nextPageToken()) && hasCostCategoryNames() == other.hasCostCategoryNames()
                && Objects.equals(costCategoryNames(), other.costCategoryNames())
                && hasCostCategoryValues() == other.hasCostCategoryValues()
                && Objects.equals(costCategoryValues(), other.costCategoryValues())
                && Objects.equals(returnSize(), other.returnSize()) && Objects.equals(totalSize(), other.totalSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCostCategoriesResponse").add("NextPageToken", nextPageToken())
                .add("CostCategoryNames", hasCostCategoryNames() ? costCategoryNames() : null)
                .add("CostCategoryValues", hasCostCategoryValues() ? costCategoryValues() : null).add("ReturnSize", returnSize())
                .add("TotalSize", totalSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "CostCategoryNames":
            return Optional.ofNullable(clazz.cast(costCategoryNames()));
        case "CostCategoryValues":
            return Optional.ofNullable(clazz.cast(costCategoryValues()));
        case "ReturnSize":
            return Optional.ofNullable(clazz.cast(returnSize()));
        case "TotalSize":
            return Optional.ofNullable(clazz.cast(totalSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCostCategoriesResponse, T> g) {
        return obj -> g.apply((GetCostCategoriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCostCategoriesResponse> {
        /**
         * <p>
         * If the number of objects that are still available for retrieval exceeds the limit, Amazon Web Services
         * returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the marker from
         * the prior call in your next request.
         * </p>
         * 
         * @param nextPageToken
         *        If the number of objects that are still available for retrieval exceeds the limit, Amazon Web Services
         *        returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the
         *        marker from the prior call in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The names of the Cost Categories.
         * </p>
         * 
         * @param costCategoryNames
         *        The names of the Cost Categories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryNames(Collection<String> costCategoryNames);

        /**
         * <p>
         * The names of the Cost Categories.
         * </p>
         * 
         * @param costCategoryNames
         *        The names of the Cost Categories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryNames(String... costCategoryNames);

        /**
         * <p>
         * The Cost Category values.
         * </p>
         * <p>
         * <code>CostCategoryValues</code> are not returned if <code>CostCategoryName</code> is not specified in the
         * request.
         * </p>
         * 
         * @param costCategoryValues
         *        The Cost Category values.</p>
         *        <p>
         *        <code>CostCategoryValues</code> are not returned if <code>CostCategoryName</code> is not specified in
         *        the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryValues(Collection<String> costCategoryValues);

        /**
         * <p>
         * The Cost Category values.
         * </p>
         * <p>
         * <code>CostCategoryValues</code> are not returned if <code>CostCategoryName</code> is not specified in the
         * request.
         * </p>
         * 
         * @param costCategoryValues
         *        The Cost Category values.</p>
         *        <p>
         *        <code>CostCategoryValues</code> are not returned if <code>CostCategoryName</code> is not specified in
         *        the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryValues(String... costCategoryValues);

        /**
         * <p>
         * The number of objects returned.
         * </p>
         * 
         * @param returnSize
         *        The number of objects returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnSize(Integer returnSize);

        /**
         * <p>
         * The total number of objects.
         * </p>
         * 
         * @param totalSize
         *        The total number of objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSize(Integer totalSize);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private String nextPageToken;

        private List<String> costCategoryNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> costCategoryValues = DefaultSdkAutoConstructList.getInstance();

        private Integer returnSize;

        private Integer totalSize;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostCategoriesResponse model) {
            super(model);
            nextPageToken(model.nextPageToken);
            costCategoryNames(model.costCategoryNames);
            costCategoryValues(model.costCategoryValues);
            returnSize(model.returnSize);
            totalSize(model.totalSize);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final Collection<String> getCostCategoryNames() {
            if (costCategoryNames instanceof SdkAutoConstructList) {
                return null;
            }
            return costCategoryNames;
        }

        public final void setCostCategoryNames(Collection<String> costCategoryNames) {
            this.costCategoryNames = CostCategoryNamesListCopier.copy(costCategoryNames);
        }

        @Override
        public final Builder costCategoryNames(Collection<String> costCategoryNames) {
            this.costCategoryNames = CostCategoryNamesListCopier.copy(costCategoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costCategoryNames(String... costCategoryNames) {
            costCategoryNames(Arrays.asList(costCategoryNames));
            return this;
        }

        public final Collection<String> getCostCategoryValues() {
            if (costCategoryValues instanceof SdkAutoConstructList) {
                return null;
            }
            return costCategoryValues;
        }

        public final void setCostCategoryValues(Collection<String> costCategoryValues) {
            this.costCategoryValues = CostCategoryValuesListCopier.copy(costCategoryValues);
        }

        @Override
        public final Builder costCategoryValues(Collection<String> costCategoryValues) {
            this.costCategoryValues = CostCategoryValuesListCopier.copy(costCategoryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costCategoryValues(String... costCategoryValues) {
            costCategoryValues(Arrays.asList(costCategoryValues));
            return this;
        }

        public final Integer getReturnSize() {
            return returnSize;
        }

        public final void setReturnSize(Integer returnSize) {
            this.returnSize = returnSize;
        }

        @Override
        public final Builder returnSize(Integer returnSize) {
            this.returnSize = returnSize;
            return this;
        }

        public final Integer getTotalSize() {
            return totalSize;
        }

        public final void setTotalSize(Integer totalSize) {
            this.totalSize = totalSize;
        }

        @Override
        public final Builder totalSize(Integer totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        @Override
        public GetCostCategoriesResponse build() {
            return new GetCostCategoriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
