/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDimensionValuesRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetDimensionValuesRequest.Builder, GetDimensionValuesRequest> {
    private static final SdkField<String> SEARCH_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchString").getter(getter(GetDimensionValuesRequest::searchString))
            .setter(setter(Builder::searchString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchString").build()).build();

    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .memberName("TimePeriod").getter(getter(GetDimensionValuesRequest::timePeriod)).setter(setter(Builder::timePeriod))
            .constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final SdkField<String> DIMENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Dimension").getter(getter(GetDimensionValuesRequest::dimensionAsString))
            .setter(setter(Builder::dimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimension").build()).build();

    private static final SdkField<String> CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Context")
            .getter(getter(GetDimensionValuesRequest::contextAsString)).setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build()).build();

    private static final SdkField<Expression> FILTER_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("Filter").getter(getter(GetDimensionValuesRequest::filter)).setter(setter(Builder::filter))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<List<SortDefinition>> SORT_BY_FIELD = SdkField
            .<List<SortDefinition>> builder(MarshallingType.LIST)
            .memberName("SortBy")
            .getter(getter(GetDimensionValuesRequest::sortBy))
            .setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SortDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(SortDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetDimensionValuesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetDimensionValuesRequest::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_STRING_FIELD,
            TIME_PERIOD_FIELD, DIMENSION_FIELD, CONTEXT_FIELD, FILTER_FIELD, SORT_BY_FIELD, MAX_RESULTS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final String searchString;

    private final DateInterval timePeriod;

    private final String dimension;

    private final String context;

    private final Expression filter;

    private final List<SortDefinition> sortBy;

    private final Integer maxResults;

    private final String nextPageToken;

    private GetDimensionValuesRequest(BuilderImpl builder) {
        super(builder);
        this.searchString = builder.searchString;
        this.timePeriod = builder.timePeriod;
        this.dimension = builder.dimension;
        this.context = builder.context;
        this.filter = builder.filter;
        this.sortBy = builder.sortBy;
        this.maxResults = builder.maxResults;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * The value that you want to search the filter values for.
     * </p>
     * 
     * @return The value that you want to search the filter values for.
     */
    public final String searchString() {
        return searchString;
    }

    /**
     * <p>
     * The start date and end date for retrieving the dimension values. The start date is inclusive, but the end date is
     * exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is
     * <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
     * including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
     * </p>
     * 
     * @return The start date and end date for retrieving the dimension values. The start date is inclusive, but the end
     *         date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is
     *         <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
     *         including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
     */
    public final DateInterval timePeriod() {
        return timePeriod;
    }

    /**
     * <p>
     * The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>. For
     * more information, see <code>Context</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dimension} will
     * return {@link Dimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dimensionAsString}.
     * </p>
     * 
     * @return The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>.
     *         For more information, see <code>Context</code>.
     * @see Dimension
     */
    public final Dimension dimension() {
        return Dimension.fromValue(dimension);
    }

    /**
     * <p>
     * The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>. For
     * more information, see <code>Context</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dimension} will
     * return {@link Dimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dimensionAsString}.
     * </p>
     * 
     * @return The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>.
     *         For more information, see <code>Context</code>.
     * @see Dimension
     */
    public final String dimensionAsString() {
        return dimension;
    }

    /**
     * <p>
     * The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or
     * <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to
     * <code>RESERVATIONS</code>, the resulting dimension values can be used in the
     * <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>, the
     * resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.
     * </p>
     * <p>
     * If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * BILLING_ENTITY - The Amazon Web Services seller that your account is with. Possible values are the following:
     * </p>
     * <p>
     * - Amazon Web Services(Amazon Web Services): The entity that sells Amazon Web Services services.
     * </p>
     * <p>
     * - AISPL (Amazon Internet Services Pvt. Ltd.): The local Indian entity that is an acting reseller for Amazon Web
     * Services services in India.
     * </p>
     * <p>
     * - Amazon Web Services Marketplace: The entity that supports the sale of solutions built on Amazon Web Services by
     * third-party software providers.
     * </p>
     * </li>
     * <li>
     * <p>
     * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
     * <code>SingleAZ</code> and <code>MultiAZ</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE_FAMILY - A family of instance types optimized to fit different use cases. Examples are
     * <code>Compute Optimized</code> (<code>C4</code>, <code>C5</code>, <code>C6g</code>, <code>C7g</code> etc.),
     * <code>Memory Optimization</code> (<code>R4</code>, <code>R5n</code>, <code>R5b</code>, <code>R6g</code> etc).
     * </p>
     * </li>
     * <li>
     * <p>
     * INVOICING_ENTITY - The name of the entity issuing the Amazon Web Services invoice.
     * </p>
     * </li>
     * <li>
     * <p>
     * LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web
     * Services.
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
     * value field contains the Amazon Web Services ID of the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand
     * Instances and Standard Reserved Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * RESERVATION_ID - The unique identifier for an Amazon Web Services Reservation Instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
     * </p>
     * </li>
     * <li>
     * <p>
     * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute).
     * </p>
     * </li>
     * <li>
     * <p>
     * SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
     * </p>
     * </li>
     * <li>
     * <p>
     * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     * </p>
     * </li>
     * <li>
     * <p>
     * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
     * <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
     * </p>
     * </li>
     * <li>
     * <p>
     * USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
     * response for this operation includes a unit attribute.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION - The Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
     * </p>
     * </li>
     * <li>
     * <p>
     * RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14
     * days for EC2-Compute Service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
     * <code>SingleAZ</code> and <code>MultiAZ</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
     * value field contains the Amazon Web Services ID of the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION - The Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability
     * Zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
     * </p>
     * </li>
     * <li>
     * <p>
     * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
     * </p>
     * </li>
     * <li>
     * <p>
     * PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION - The Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
     * value field contains the Amazon Web Services ID of the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #context} will
     * return {@link Context#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contextAsString}.
     * </p>
     * 
     * @return The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or
     *         <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to
     *         <code>RESERVATIONS</code>, the resulting dimension values can be used in the
     *         <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>,
     *         the resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.</p>
     *         <p>
     *         If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for
     *         searching:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BILLING_ENTITY - The Amazon Web Services seller that your account is with. Possible values are the
     *         following:
     *         </p>
     *         <p>
     *         - Amazon Web Services(Amazon Web Services): The entity that sells Amazon Web Services services.
     *         </p>
     *         <p>
     *         - AISPL (Amazon Internet Services Pvt. Ltd.): The local Indian entity that is an acting reseller for
     *         Amazon Web Services services in India.
     *         </p>
     *         <p>
     *         - Amazon Web Services Marketplace: The entity that supports the sale of solutions built on Amazon Web
     *         Services by third-party software providers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
     *         <code>SingleAZ</code> and <code>MultiAZ</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE_FAMILY - A family of instance types optimized to fit different use cases. Examples are
     *         <code>Compute Optimized</code> (<code>C4</code>, <code>C5</code>, <code>C6g</code>, <code>C7g</code>
     *         etc.), <code>Memory Optimization</code> (<code>R4</code>, <code>R5n</code>, <code>R5b</code>,
     *         <code>R6g</code> etc).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVOICING_ENTITY - The name of the entity issuing the Amazon Web Services invoice.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as
     *         Amazon Web Services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account.
     *         The value field contains the Amazon Web Services ID of the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
     *         On-Demand Instances and Standard Reserved Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RESERVATION_ID - The unique identifier for an Amazon Web Services Reservation Instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
     *         <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
     *         response for this operation includes a unit attribute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGION - The Amazon Web Services Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for
     *         last 14 days for EC2-Compute Service.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
     *         <code>SingleAZ</code> and <code>MultiAZ</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account.
     *         The value field contains the Amazon Web Services ID of the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGION - The Amazon Web Services Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
     *         Availability Zone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGION - The Amazon Web Services Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account.
     *         The value field contains the Amazon Web Services ID of the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
     *         </p>
     *         </li>
     * @see Context
     */
    public final Context context() {
        return Context.fromValue(context);
    }

    /**
     * <p>
     * The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or
     * <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to
     * <code>RESERVATIONS</code>, the resulting dimension values can be used in the
     * <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>, the
     * resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.
     * </p>
     * <p>
     * If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * BILLING_ENTITY - The Amazon Web Services seller that your account is with. Possible values are the following:
     * </p>
     * <p>
     * - Amazon Web Services(Amazon Web Services): The entity that sells Amazon Web Services services.
     * </p>
     * <p>
     * - AISPL (Amazon Internet Services Pvt. Ltd.): The local Indian entity that is an acting reseller for Amazon Web
     * Services services in India.
     * </p>
     * <p>
     * - Amazon Web Services Marketplace: The entity that supports the sale of solutions built on Amazon Web Services by
     * third-party software providers.
     * </p>
     * </li>
     * <li>
     * <p>
     * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
     * <code>SingleAZ</code> and <code>MultiAZ</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE_FAMILY - A family of instance types optimized to fit different use cases. Examples are
     * <code>Compute Optimized</code> (<code>C4</code>, <code>C5</code>, <code>C6g</code>, <code>C7g</code> etc.),
     * <code>Memory Optimization</code> (<code>R4</code>, <code>R5n</code>, <code>R5b</code>, <code>R6g</code> etc).
     * </p>
     * </li>
     * <li>
     * <p>
     * INVOICING_ENTITY - The name of the entity issuing the Amazon Web Services invoice.
     * </p>
     * </li>
     * <li>
     * <p>
     * LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web
     * Services.
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
     * value field contains the Amazon Web Services ID of the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand
     * Instances and Standard Reserved Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * RESERVATION_ID - The unique identifier for an Amazon Web Services Reservation Instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
     * </p>
     * </li>
     * <li>
     * <p>
     * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute).
     * </p>
     * </li>
     * <li>
     * <p>
     * SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
     * </p>
     * </li>
     * <li>
     * <p>
     * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     * </p>
     * </li>
     * <li>
     * <p>
     * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
     * <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
     * </p>
     * </li>
     * <li>
     * <p>
     * USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
     * response for this operation includes a unit attribute.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION - The Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
     * </p>
     * </li>
     * <li>
     * <p>
     * RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14
     * days for EC2-Compute Service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
     * <code>SingleAZ</code> and <code>MultiAZ</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
     * value field contains the Amazon Web Services ID of the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION - The Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability
     * Zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
     * </p>
     * </li>
     * <li>
     * <p>
     * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
     * </p>
     * </li>
     * <li>
     * <p>
     * PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION - The Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
     * value field contains the Amazon Web Services ID of the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #context} will
     * return {@link Context#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contextAsString}.
     * </p>
     * 
     * @return The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or
     *         <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to
     *         <code>RESERVATIONS</code>, the resulting dimension values can be used in the
     *         <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>,
     *         the resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.</p>
     *         <p>
     *         If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for
     *         searching:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BILLING_ENTITY - The Amazon Web Services seller that your account is with. Possible values are the
     *         following:
     *         </p>
     *         <p>
     *         - Amazon Web Services(Amazon Web Services): The entity that sells Amazon Web Services services.
     *         </p>
     *         <p>
     *         - AISPL (Amazon Internet Services Pvt. Ltd.): The local Indian entity that is an acting reseller for
     *         Amazon Web Services services in India.
     *         </p>
     *         <p>
     *         - Amazon Web Services Marketplace: The entity that supports the sale of solutions built on Amazon Web
     *         Services by third-party software providers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
     *         <code>SingleAZ</code> and <code>MultiAZ</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE_FAMILY - A family of instance types optimized to fit different use cases. Examples are
     *         <code>Compute Optimized</code> (<code>C4</code>, <code>C5</code>, <code>C6g</code>, <code>C7g</code>
     *         etc.), <code>Memory Optimization</code> (<code>R4</code>, <code>R5n</code>, <code>R5b</code>,
     *         <code>R6g</code> etc).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVOICING_ENTITY - The name of the entity issuing the Amazon Web Services invoice.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as
     *         Amazon Web Services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account.
     *         The value field contains the Amazon Web Services ID of the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
     *         On-Demand Instances and Standard Reserved Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RESERVATION_ID - The unique identifier for an Amazon Web Services Reservation Instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
     *         <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
     *         response for this operation includes a unit attribute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGION - The Amazon Web Services Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for
     *         last 14 days for EC2-Compute Service.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
     *         <code>SingleAZ</code> and <code>MultiAZ</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account.
     *         The value field contains the Amazon Web Services ID of the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGION - The Amazon Web Services Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
     *         Availability Zone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGION - The Amazon Web Services Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account.
     *         The value field contains the Amazon Web Services ID of the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
     *         </p>
     *         </li>
     * @see Context
     */
    public final String contextAsString() {
        return context;
    }

    /**
     * Returns the value of the Filter property for this object.
     * 
     * @return The value of the Filter property for this object.
     */
    public final Expression filter() {
        return filter;
    }

    /**
     * For responses, this returns true if the service returned a value for the SortBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSortBy() {
        return sortBy != null && !(sortBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value by which you want to sort the data.
     * </p>
     * <p>
     * The key represents cost and usage metrics. The following values are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BlendedCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UnblendedCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AmortizedCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NetAmortizedCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NetUnblendedCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UsageQuantity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NormalizedUsageAmount</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
     * </p>
     * <p>
     * When you specify a <code>SortBy</code> paramater, the context must be <code>COST_AND_USAGE</code>. Further, when
     * using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSortBy} method.
     * </p>
     * 
     * @return The value by which you want to sort the data.</p>
     *         <p>
     *         The key represents cost and usage metrics. The following values are supported:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BlendedCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UnblendedCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AmortizedCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NetAmortizedCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NetUnblendedCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UsageQuantity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NormalizedUsageAmount</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
     *         </p>
     *         <p>
     *         When you specify a <code>SortBy</code> paramater, the context must be <code>COST_AND_USAGE</code>.
     *         Further, when using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not
     *         supported.
     */
    public final List<SortDefinition> sortBy() {
        return sortBy;
    }

    /**
     * <p>
     * This field is only used when SortBy is provided in the request. The maximum number of objects that to be returned
     * for this request. If MaxResults is not specified with SortBy, the request will return 1000 results as the default
     * value for this parameter.
     * </p>
     * <p>
     * For <code>GetDimensionValues</code>, MaxResults has an upper limit of 1000.
     * </p>
     * 
     * @return This field is only used when SortBy is provided in the request. The maximum number of objects that to be
     *         returned for this request. If MaxResults is not specified with SortBy, the request will return 1000
     *         results as the default value for this parameter.</p>
     *         <p>
     *         For <code>GetDimensionValues</code>, MaxResults has an upper limit of 1000.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a
     * previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. Amazon Web Services provides the token when the response
     *         from a previous call has more results than the maximum page size.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(searchString());
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(dimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contextAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(hasSortBy() ? sortBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDimensionValuesRequest)) {
            return false;
        }
        GetDimensionValuesRequest other = (GetDimensionValuesRequest) obj;
        return Objects.equals(searchString(), other.searchString()) && Objects.equals(timePeriod(), other.timePeriod())
                && Objects.equals(dimensionAsString(), other.dimensionAsString())
                && Objects.equals(contextAsString(), other.contextAsString()) && Objects.equals(filter(), other.filter())
                && hasSortBy() == other.hasSortBy() && Objects.equals(sortBy(), other.sortBy())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDimensionValuesRequest").add("SearchString", searchString()).add("TimePeriod", timePeriod())
                .add("Dimension", dimensionAsString()).add("Context", contextAsString()).add("Filter", filter())
                .add("SortBy", hasSortBy() ? sortBy() : null).add("MaxResults", maxResults())
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SearchString":
            return Optional.ofNullable(clazz.cast(searchString()));
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "Dimension":
            return Optional.ofNullable(clazz.cast(dimensionAsString()));
        case "Context":
            return Optional.ofNullable(clazz.cast(contextAsString()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDimensionValuesRequest, T> g) {
        return obj -> g.apply((GetDimensionValuesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDimensionValuesRequest> {
        /**
         * <p>
         * The value that you want to search the filter values for.
         * </p>
         * 
         * @param searchString
         *        The value that you want to search the filter values for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchString(String searchString);

        /**
         * <p>
         * The start date and end date for retrieving the dimension values. The start date is inclusive, but the end
         * date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is
         * <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
         * including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
         * </p>
         * 
         * @param timePeriod
         *        The start date and end date for retrieving the dimension values. The start date is inclusive, but the
         *        end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and
         *        <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from
         *        <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including
         *        <code>2017-05-01</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * <p>
         * The start date and end date for retrieving the dimension values. The start date is inclusive, but the end
         * date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is
         * <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
         * including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateInterval.Builder} avoiding the need
         * to create one manually via {@link DateInterval#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }

        /**
         * <p>
         * The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>. For
         * more information, see <code>Context</code>.
         * </p>
         * 
         * @param dimension
         *        The name of the dimension. Each <code>Dimension</code> is available for a different
         *        <code>Context</code>. For more information, see <code>Context</code>.
         * @see Dimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Dimension
         */
        Builder dimension(String dimension);

        /**
         * <p>
         * The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>. For
         * more information, see <code>Context</code>.
         * </p>
         * 
         * @param dimension
         *        The name of the dimension. Each <code>Dimension</code> is available for a different
         *        <code>Context</code>. For more information, see <code>Context</code>.
         * @see Dimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Dimension
         */
        Builder dimension(Dimension dimension);

        /**
         * <p>
         * The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or
         * <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to
         * <code>RESERVATIONS</code>, the resulting dimension values can be used in the
         * <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>, the
         * resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.
         * </p>
         * <p>
         * If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * BILLING_ENTITY - The Amazon Web Services seller that your account is with. Possible values are the following:
         * </p>
         * <p>
         * - Amazon Web Services(Amazon Web Services): The entity that sells Amazon Web Services services.
         * </p>
         * <p>
         * - AISPL (Amazon Internet Services Pvt. Ltd.): The local Indian entity that is an acting reseller for Amazon
         * Web Services services in India.
         * </p>
         * <p>
         * - Amazon Web Services Marketplace: The entity that supports the sale of solutions built on Amazon Web
         * Services by third-party software providers.
         * </p>
         * </li>
         * <li>
         * <p>
         * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         * <code>SingleAZ</code> and <code>MultiAZ</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE_FAMILY - A family of instance types optimized to fit different use cases. Examples are
         * <code>Compute Optimized</code> (<code>C4</code>, <code>C5</code>, <code>C6g</code>, <code>C7g</code> etc.),
         * <code>Memory Optimization</code> (<code>R4</code>, <code>R5n</code>, <code>R5b</code>, <code>R6g</code> etc).
         * </p>
         * </li>
         * <li>
         * <p>
         * INVOICING_ENTITY - The name of the entity issuing the Amazon Web Services invoice.
         * </p>
         * </li>
         * <li>
         * <p>
         * LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon
         * Web Services.
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the Amazon Web Services ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
         * On-Demand Instances and Standard Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * RESERVATION_ID - The unique identifier for an Amazon Web Services Reservation Instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
         * </p>
         * </li>
         * <li>
         * <p>
         * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute).
         * </p>
         * </li>
         * <li>
         * <p>
         * SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
         * </p>
         * </li>
         * <li>
         * <p>
         * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         * </p>
         * </li>
         * <li>
         * <p>
         * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
         * <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
         * </p>
         * </li>
         * <li>
         * <p>
         * USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
         * response for this operation includes a unit attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION - The Amazon Web Services Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
         * </p>
         * </li>
         * <li>
         * <p>
         * RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last
         * 14 days for EC2-Compute Service.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         * <code>SingleAZ</code> and <code>MultiAZ</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the Amazon Web Services ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION - The Amazon Web Services Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
         * Availability Zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
         * </p>
         * </li>
         * <li>
         * <p>
         * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
         * </p>
         * </li>
         * <li>
         * <p>
         * PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION - The Amazon Web Services Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the Amazon Web Services ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
         * </p>
         * </li>
         * </ul>
         * 
         * @param context
         *        The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or
         *        <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set
         *        to <code>RESERVATIONS</code>, the resulting dimension values can be used in the
         *        <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>
         *        , the resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.</p>
         *        <p>
         *        If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BILLING_ENTITY - The Amazon Web Services seller that your account is with. Possible values are the
         *        following:
         *        </p>
         *        <p>
         *        - Amazon Web Services(Amazon Web Services): The entity that sells Amazon Web Services services.
         *        </p>
         *        <p>
         *        - AISPL (Amazon Internet Services Pvt. Ltd.): The local Indian entity that is an acting reseller for
         *        Amazon Web Services services in India.
         *        </p>
         *        <p>
         *        - Amazon Web Services Marketplace: The entity that supports the sale of solutions built on Amazon Web
         *        Services by third-party software providers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         *        <code>SingleAZ</code> and <code>MultiAZ</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE_FAMILY - A family of instance types optimized to fit different use cases. Examples are
         *        <code>Compute Optimized</code> (<code>C4</code>, <code>C5</code>, <code>C6g</code>, <code>C7g</code>
         *        etc.), <code>Memory Optimization</code> (<code>R4</code>, <code>R5n</code>, <code>R5b</code>,
         *        <code>R6g</code> etc).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INVOICING_ENTITY - The name of the entity issuing the Amazon Web Services invoice.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as
         *        Amazon Web Services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the Amazon Web Services ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATION - The action performed. Examples include <code>RunInstance</code> and
         *        <code>CreateBucket</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
         *        On-Demand Instances and Standard Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RESERVATION_ID - The unique identifier for an Amazon Web Services Reservation Instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
         *        <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms.
         *        The response for this operation includes a unit attribute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION - The Amazon Web Services Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available
         *        for last 14 days for EC2-Compute Service.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         *        <code>SingleAZ</code> and <code>MultiAZ</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the Amazon Web Services ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION - The Amazon Web Services Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
         *        Availability Zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION - The Amazon Web Services Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the Amazon Web Services ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
         *        </p>
         *        </li>
         * @see Context
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Context
         */
        Builder context(String context);

        /**
         * <p>
         * The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or
         * <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to
         * <code>RESERVATIONS</code>, the resulting dimension values can be used in the
         * <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>, the
         * resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.
         * </p>
         * <p>
         * If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * BILLING_ENTITY - The Amazon Web Services seller that your account is with. Possible values are the following:
         * </p>
         * <p>
         * - Amazon Web Services(Amazon Web Services): The entity that sells Amazon Web Services services.
         * </p>
         * <p>
         * - AISPL (Amazon Internet Services Pvt. Ltd.): The local Indian entity that is an acting reseller for Amazon
         * Web Services services in India.
         * </p>
         * <p>
         * - Amazon Web Services Marketplace: The entity that supports the sale of solutions built on Amazon Web
         * Services by third-party software providers.
         * </p>
         * </li>
         * <li>
         * <p>
         * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         * <code>SingleAZ</code> and <code>MultiAZ</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE_FAMILY - A family of instance types optimized to fit different use cases. Examples are
         * <code>Compute Optimized</code> (<code>C4</code>, <code>C5</code>, <code>C6g</code>, <code>C7g</code> etc.),
         * <code>Memory Optimization</code> (<code>R4</code>, <code>R5n</code>, <code>R5b</code>, <code>R6g</code> etc).
         * </p>
         * </li>
         * <li>
         * <p>
         * INVOICING_ENTITY - The name of the entity issuing the Amazon Web Services invoice.
         * </p>
         * </li>
         * <li>
         * <p>
         * LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon
         * Web Services.
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the Amazon Web Services ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
         * On-Demand Instances and Standard Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * RESERVATION_ID - The unique identifier for an Amazon Web Services Reservation Instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
         * </p>
         * </li>
         * <li>
         * <p>
         * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute).
         * </p>
         * </li>
         * <li>
         * <p>
         * SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
         * </p>
         * </li>
         * <li>
         * <p>
         * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         * </p>
         * </li>
         * <li>
         * <p>
         * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
         * <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
         * </p>
         * </li>
         * <li>
         * <p>
         * USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
         * response for this operation includes a unit attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION - The Amazon Web Services Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
         * </p>
         * </li>
         * <li>
         * <p>
         * RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last
         * 14 days for EC2-Compute Service.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         * <code>SingleAZ</code> and <code>MultiAZ</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the Amazon Web Services ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION - The Amazon Web Services Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
         * Availability Zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
         * </p>
         * </li>
         * <li>
         * <p>
         * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
         * </p>
         * </li>
         * <li>
         * <p>
         * PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION - The Amazon Web Services Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the Amazon Web Services ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
         * </p>
         * </li>
         * </ul>
         * 
         * @param context
         *        The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or
         *        <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set
         *        to <code>RESERVATIONS</code>, the resulting dimension values can be used in the
         *        <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>
         *        , the resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.</p>
         *        <p>
         *        If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BILLING_ENTITY - The Amazon Web Services seller that your account is with. Possible values are the
         *        following:
         *        </p>
         *        <p>
         *        - Amazon Web Services(Amazon Web Services): The entity that sells Amazon Web Services services.
         *        </p>
         *        <p>
         *        - AISPL (Amazon Internet Services Pvt. Ltd.): The local Indian entity that is an acting reseller for
         *        Amazon Web Services services in India.
         *        </p>
         *        <p>
         *        - Amazon Web Services Marketplace: The entity that supports the sale of solutions built on Amazon Web
         *        Services by third-party software providers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         *        <code>SingleAZ</code> and <code>MultiAZ</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE_FAMILY - A family of instance types optimized to fit different use cases. Examples are
         *        <code>Compute Optimized</code> (<code>C4</code>, <code>C5</code>, <code>C6g</code>, <code>C7g</code>
         *        etc.), <code>Memory Optimization</code> (<code>R4</code>, <code>R5n</code>, <code>R5b</code>,
         *        <code>R6g</code> etc).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INVOICING_ENTITY - The name of the entity issuing the Amazon Web Services invoice.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as
         *        Amazon Web Services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the Amazon Web Services ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATION - The action performed. Examples include <code>RunInstance</code> and
         *        <code>CreateBucket</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
         *        On-Demand Instances and Standard Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RESERVATION_ID - The unique identifier for an Amazon Web Services Reservation Instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
         *        <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms.
         *        The response for this operation includes a unit attribute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION - The Amazon Web Services Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available
         *        for last 14 days for EC2-Compute Service.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         *        <code>SingleAZ</code> and <code>MultiAZ</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the Amazon Web Services ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION - The Amazon Web Services Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
         *        Availability Zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION - The Amazon Web Services Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the Amazon Web Services ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
         *        </p>
         *        </li>
         * @see Context
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Context
         */
        Builder context(Context context);

        /**
         * Sets the value of the Filter property for this object.
         *
         * @param filter
         *        The new value for the Filter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Expression filter);

        /**
         * Sets the value of the Filter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(Expression)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Expression)
         */
        default Builder filter(Consumer<Expression.Builder> filter) {
            return filter(Expression.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The value by which you want to sort the data.
         * </p>
         * <p>
         * The key represents cost and usage metrics. The following values are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BlendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetAmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetUnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UsageQuantity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NormalizedUsageAmount</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         * </p>
         * <p>
         * When you specify a <code>SortBy</code> paramater, the context must be <code>COST_AND_USAGE</code>. Further,
         * when using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.
         * </p>
         * 
         * @param sortBy
         *        The value by which you want to sort the data.</p>
         *        <p>
         *        The key represents cost and usage metrics. The following values are supported:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BlendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UnblendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AmortizedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NetAmortizedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NetUnblendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UsageQuantity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NormalizedUsageAmount</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         *        </p>
         *        <p>
         *        When you specify a <code>SortBy</code> paramater, the context must be <code>COST_AND_USAGE</code>.
         *        Further, when using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are
         *        not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(Collection<SortDefinition> sortBy);

        /**
         * <p>
         * The value by which you want to sort the data.
         * </p>
         * <p>
         * The key represents cost and usage metrics. The following values are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BlendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetAmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetUnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UsageQuantity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NormalizedUsageAmount</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         * </p>
         * <p>
         * When you specify a <code>SortBy</code> paramater, the context must be <code>COST_AND_USAGE</code>. Further,
         * when using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.
         * </p>
         * 
         * @param sortBy
         *        The value by which you want to sort the data.</p>
         *        <p>
         *        The key represents cost and usage metrics. The following values are supported:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BlendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UnblendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AmortizedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NetAmortizedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NetUnblendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UsageQuantity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NormalizedUsageAmount</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         *        </p>
         *        <p>
         *        When you specify a <code>SortBy</code> paramater, the context must be <code>COST_AND_USAGE</code>.
         *        Further, when using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are
         *        not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(SortDefinition... sortBy);

        /**
         * <p>
         * The value by which you want to sort the data.
         * </p>
         * <p>
         * The key represents cost and usage metrics. The following values are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BlendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetAmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetUnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UsageQuantity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NormalizedUsageAmount</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         * </p>
         * <p>
         * When you specify a <code>SortBy</code> paramater, the context must be <code>COST_AND_USAGE</code>. Further,
         * when using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<SortDefinition>.Builder} avoiding
         * the need to create one manually via {@link List<SortDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SortDefinition>.Builder#build()} is called immediately and
         * its result is passed to {@link #sortBy(List<SortDefinition>)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link List<SortDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(List<SortDefinition>)
         */
        Builder sortBy(Consumer<SortDefinition.Builder>... sortBy);

        /**
         * <p>
         * This field is only used when SortBy is provided in the request. The maximum number of objects that to be
         * returned for this request. If MaxResults is not specified with SortBy, the request will return 1000 results
         * as the default value for this parameter.
         * </p>
         * <p>
         * For <code>GetDimensionValues</code>, MaxResults has an upper limit of 1000.
         * </p>
         * 
         * @param maxResults
         *        This field is only used when SortBy is provided in the request. The maximum number of objects that to
         *        be returned for this request. If MaxResults is not specified with SortBy, the request will return 1000
         *        results as the default value for this parameter.</p>
         *        <p>
         *        For <code>GetDimensionValues</code>, MaxResults has an upper limit of 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from
         * a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextPageToken
         *        The token to retrieve the next set of results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String searchString;

        private DateInterval timePeriod;

        private String dimension;

        private String context;

        private Expression filter;

        private List<SortDefinition> sortBy = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDimensionValuesRequest model) {
            super(model);
            searchString(model.searchString);
            timePeriod(model.timePeriod);
            dimension(model.dimension);
            context(model.context);
            filter(model.filter);
            sortBy(model.sortBy);
            maxResults(model.maxResults);
            nextPageToken(model.nextPageToken);
        }

        public final String getSearchString() {
            return searchString;
        }

        public final void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        @Override
        public final Builder searchString(String searchString) {
            this.searchString = searchString;
            return this;
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final String getDimension() {
            return dimension;
        }

        public final void setDimension(String dimension) {
            this.dimension = dimension;
        }

        @Override
        public final Builder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        @Override
        public final Builder dimension(Dimension dimension) {
            this.dimension(dimension == null ? null : dimension.toString());
            return this;
        }

        public final String getContext() {
            return context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        @Override
        public final Builder context(Context context) {
            this.context(context == null ? null : context.toString());
            return this;
        }

        public final Expression.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final List<SortDefinition.Builder> getSortBy() {
            List<SortDefinition.Builder> result = SortDefinitionsCopier.copyToBuilder(this.sortBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortBy(Collection<SortDefinition.BuilderImpl> sortBy) {
            this.sortBy = SortDefinitionsCopier.copyFromBuilder(sortBy);
        }

        @Override
        public final Builder sortBy(Collection<SortDefinition> sortBy) {
            this.sortBy = SortDefinitionsCopier.copy(sortBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortBy(SortDefinition... sortBy) {
            sortBy(Arrays.asList(sortBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortBy(Consumer<SortDefinition.Builder>... sortBy) {
            sortBy(Stream.of(sortBy).map(c -> SortDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDimensionValuesRequest build() {
            return new GetDimensionValuesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
