/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReservationCoverageResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetReservationCoverageResponse.Builder, GetReservationCoverageResponse> {
    private static final SdkField<List<CoverageByTime>> COVERAGES_BY_TIME_FIELD = SdkField
            .<List<CoverageByTime>> builder(MarshallingType.LIST)
            .memberName("CoveragesByTime")
            .getter(getter(GetReservationCoverageResponse::coveragesByTime))
            .setter(setter(Builder::coveragesByTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoveragesByTime").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageByTime> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageByTime::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Coverage> TOTAL_FIELD = SdkField.<Coverage> builder(MarshallingType.SDK_POJO)
            .memberName("Total").getter(getter(GetReservationCoverageResponse::total)).setter(setter(Builder::total))
            .constructor(Coverage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetReservationCoverageResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COVERAGES_BY_TIME_FIELD,
            TOTAL_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final List<CoverageByTime> coveragesByTime;

    private final Coverage total;

    private final String nextPageToken;

    private GetReservationCoverageResponse(BuilderImpl builder) {
        super(builder);
        this.coveragesByTime = builder.coveragesByTime;
        this.total = builder.total;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CoveragesByTime property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCoveragesByTime() {
        return coveragesByTime != null && !(coveragesByTime instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The amount of time that your reservations covered.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCoveragesByTime} method.
     * </p>
     * 
     * @return The amount of time that your reservations covered.
     */
    public final List<CoverageByTime> coveragesByTime() {
        return coveragesByTime;
    }

    /**
     * <p>
     * The total amount of instance usage that a reservation covered.
     * </p>
     * 
     * @return The total amount of instance usage that a reservation covered.
     */
    public final Coverage total() {
        return total;
    }

    /**
     * <p>
     * The token for the next set of retrievable results. Amazon Web Services provides the token when the response from
     * a previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token for the next set of retrievable results. Amazon Web Services provides the token when the
     *         response from a previous call has more results than the maximum page size.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCoveragesByTime() ? coveragesByTime() : null);
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservationCoverageResponse)) {
            return false;
        }
        GetReservationCoverageResponse other = (GetReservationCoverageResponse) obj;
        return hasCoveragesByTime() == other.hasCoveragesByTime() && Objects.equals(coveragesByTime(), other.coveragesByTime())
                && Objects.equals(total(), other.total()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReservationCoverageResponse")
                .add("CoveragesByTime", hasCoveragesByTime() ? coveragesByTime() : null).add("Total", total())
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoveragesByTime":
            return Optional.ofNullable(clazz.cast(coveragesByTime()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReservationCoverageResponse, T> g) {
        return obj -> g.apply((GetReservationCoverageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetReservationCoverageResponse> {
        /**
         * <p>
         * The amount of time that your reservations covered.
         * </p>
         * 
         * @param coveragesByTime
         *        The amount of time that your reservations covered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coveragesByTime(Collection<CoverageByTime> coveragesByTime);

        /**
         * <p>
         * The amount of time that your reservations covered.
         * </p>
         * 
         * @param coveragesByTime
         *        The amount of time that your reservations covered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coveragesByTime(CoverageByTime... coveragesByTime);

        /**
         * <p>
         * The amount of time that your reservations covered.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<CoverageByTime>.Builder} avoiding
         * the need to create one manually via {@link List<CoverageByTime>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CoverageByTime>.Builder#build()} is called immediately and
         * its result is passed to {@link #coveragesByTime(List<CoverageByTime>)}.
         * 
         * @param coveragesByTime
         *        a consumer that will call methods on {@link List<CoverageByTime>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coveragesByTime(List<CoverageByTime>)
         */
        Builder coveragesByTime(Consumer<CoverageByTime.Builder>... coveragesByTime);

        /**
         * <p>
         * The total amount of instance usage that a reservation covered.
         * </p>
         * 
         * @param total
         *        The total amount of instance usage that a reservation covered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Coverage total);

        /**
         * <p>
         * The total amount of instance usage that a reservation covered.
         * </p>
         * This is a convenience method that creates an instance of the {@link Coverage.Builder} avoiding the need to
         * create one manually via {@link Coverage#builder()}.
         *
         * When the {@link Consumer} completes, {@link Coverage.Builder#build()} is called immediately and its result is
         * passed to {@link #total(Coverage)}.
         * 
         * @param total
         *        a consumer that will call methods on {@link Coverage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #total(Coverage)
         */
        default Builder total(Consumer<Coverage.Builder> total) {
            return total(Coverage.builder().applyMutation(total).build());
        }

        /**
         * <p>
         * The token for the next set of retrievable results. Amazon Web Services provides the token when the response
         * from a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextPageToken
         *        The token for the next set of retrievable results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private List<CoverageByTime> coveragesByTime = DefaultSdkAutoConstructList.getInstance();

        private Coverage total;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservationCoverageResponse model) {
            super(model);
            coveragesByTime(model.coveragesByTime);
            total(model.total);
            nextPageToken(model.nextPageToken);
        }

        public final List<CoverageByTime.Builder> getCoveragesByTime() {
            List<CoverageByTime.Builder> result = CoveragesByTimeCopier.copyToBuilder(this.coveragesByTime);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCoveragesByTime(Collection<CoverageByTime.BuilderImpl> coveragesByTime) {
            this.coveragesByTime = CoveragesByTimeCopier.copyFromBuilder(coveragesByTime);
        }

        @Override
        public final Builder coveragesByTime(Collection<CoverageByTime> coveragesByTime) {
            this.coveragesByTime = CoveragesByTimeCopier.copy(coveragesByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coveragesByTime(CoverageByTime... coveragesByTime) {
            coveragesByTime(Arrays.asList(coveragesByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coveragesByTime(Consumer<CoverageByTime.Builder>... coveragesByTime) {
            coveragesByTime(Stream.of(coveragesByTime).map(c -> CoverageByTime.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Coverage.Builder getTotal() {
            return total != null ? total.toBuilder() : null;
        }

        public final void setTotal(Coverage.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        @Override
        public final Builder total(Coverage total) {
            this.total = total;
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetReservationCoverageResponse build() {
            return new GetReservationCoverageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
