/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReservationPurchaseRecommendationResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetReservationPurchaseRecommendationResponse.Builder, GetReservationPurchaseRecommendationResponse> {
    private static final SdkField<ReservationPurchaseRecommendationMetadata> METADATA_FIELD = SdkField
            .<ReservationPurchaseRecommendationMetadata> builder(MarshallingType.SDK_POJO).memberName("Metadata")
            .getter(getter(GetReservationPurchaseRecommendationResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(ReservationPurchaseRecommendationMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<List<ReservationPurchaseRecommendation>> RECOMMENDATIONS_FIELD = SdkField
            .<List<ReservationPurchaseRecommendation>> builder(MarshallingType.LIST)
            .memberName("Recommendations")
            .getter(getter(GetReservationPurchaseRecommendationResponse::recommendations))
            .setter(setter(Builder::recommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recommendations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReservationPurchaseRecommendation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservationPurchaseRecommendation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetReservationPurchaseRecommendationResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD,
            RECOMMENDATIONS_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final ReservationPurchaseRecommendationMetadata metadata;

    private final List<ReservationPurchaseRecommendation> recommendations;

    private final String nextPageToken;

    private GetReservationPurchaseRecommendationResponse(BuilderImpl builder) {
        super(builder);
        this.metadata = builder.metadata;
        this.recommendations = builder.recommendations;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * Information about this specific recommendation call, such as the time stamp for when Cost Explorer generated this
     * recommendation.
     * </p>
     * 
     * @return Information about this specific recommendation call, such as the time stamp for when Cost Explorer
     *         generated this recommendation.
     */
    public final ReservationPurchaseRecommendationMetadata metadata() {
        return metadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the Recommendations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecommendations() {
        return recommendations != null && !(recommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Recommendations for reservations to purchase.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendations} method.
     * </p>
     * 
     * @return Recommendations for reservations to purchase.
     */
    public final List<ReservationPurchaseRecommendation> recommendations() {
        return recommendations;
    }

    /**
     * <p>
     * The pagination token for the next set of retrievable results.
     * </p>
     * 
     * @return The pagination token for the next set of retrievable results.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendations() ? recommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservationPurchaseRecommendationResponse)) {
            return false;
        }
        GetReservationPurchaseRecommendationResponse other = (GetReservationPurchaseRecommendationResponse) obj;
        return Objects.equals(metadata(), other.metadata()) && hasRecommendations() == other.hasRecommendations()
                && Objects.equals(recommendations(), other.recommendations())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReservationPurchaseRecommendationResponse").add("Metadata", metadata())
                .add("Recommendations", hasRecommendations() ? recommendations() : null).add("NextPageToken", nextPageToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "Recommendations":
            return Optional.ofNullable(clazz.cast(recommendations()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReservationPurchaseRecommendationResponse, T> g) {
        return obj -> g.apply((GetReservationPurchaseRecommendationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetReservationPurchaseRecommendationResponse> {
        /**
         * <p>
         * Information about this specific recommendation call, such as the time stamp for when Cost Explorer generated
         * this recommendation.
         * </p>
         * 
         * @param metadata
         *        Information about this specific recommendation call, such as the time stamp for when Cost Explorer
         *        generated this recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ReservationPurchaseRecommendationMetadata metadata);

        /**
         * <p>
         * Information about this specific recommendation call, such as the time stamp for when Cost Explorer generated
         * this recommendation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ReservationPurchaseRecommendationMetadata.Builder} avoiding the need to create one manually via
         * {@link ReservationPurchaseRecommendationMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservationPurchaseRecommendationMetadata.Builder#build()} is
         * called immediately and its result is passed to {@link #metadata(ReservationPurchaseRecommendationMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link ReservationPurchaseRecommendationMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(ReservationPurchaseRecommendationMetadata)
         */
        default Builder metadata(Consumer<ReservationPurchaseRecommendationMetadata.Builder> metadata) {
            return metadata(ReservationPurchaseRecommendationMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * Recommendations for reservations to purchase.
         * </p>
         * 
         * @param recommendations
         *        Recommendations for reservations to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendations(Collection<ReservationPurchaseRecommendation> recommendations);

        /**
         * <p>
         * Recommendations for reservations to purchase.
         * </p>
         * 
         * @param recommendations
         *        Recommendations for reservations to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendations(ReservationPurchaseRecommendation... recommendations);

        /**
         * <p>
         * Recommendations for reservations to purchase.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ReservationPurchaseRecommendation>.Builder} avoiding the need to create one manually via {@link List
         * <ReservationPurchaseRecommendation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservationPurchaseRecommendation>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #recommendations(List<ReservationPurchaseRecommendation>)}.
         * 
         * @param recommendations
         *        a consumer that will call methods on {@link List<ReservationPurchaseRecommendation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendations(List<ReservationPurchaseRecommendation>)
         */
        Builder recommendations(Consumer<ReservationPurchaseRecommendation.Builder>... recommendations);

        /**
         * <p>
         * The pagination token for the next set of retrievable results.
         * </p>
         * 
         * @param nextPageToken
         *        The pagination token for the next set of retrievable results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private ReservationPurchaseRecommendationMetadata metadata;

        private List<ReservationPurchaseRecommendation> recommendations = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservationPurchaseRecommendationResponse model) {
            super(model);
            metadata(model.metadata);
            recommendations(model.recommendations);
            nextPageToken(model.nextPageToken);
        }

        public final ReservationPurchaseRecommendationMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(ReservationPurchaseRecommendationMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(ReservationPurchaseRecommendationMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final List<ReservationPurchaseRecommendation.Builder> getRecommendations() {
            List<ReservationPurchaseRecommendation.Builder> result = ReservationPurchaseRecommendationsCopier
                    .copyToBuilder(this.recommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendations(Collection<ReservationPurchaseRecommendation.BuilderImpl> recommendations) {
            this.recommendations = ReservationPurchaseRecommendationsCopier.copyFromBuilder(recommendations);
        }

        @Override
        public final Builder recommendations(Collection<ReservationPurchaseRecommendation> recommendations) {
            this.recommendations = ReservationPurchaseRecommendationsCopier.copy(recommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(ReservationPurchaseRecommendation... recommendations) {
            recommendations(Arrays.asList(recommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(Consumer<ReservationPurchaseRecommendation.Builder>... recommendations) {
            recommendations(Stream.of(recommendations)
                    .map(c -> ReservationPurchaseRecommendation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetReservationPurchaseRecommendationResponse build() {
            return new GetReservationPurchaseRecommendationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
