/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSavingsPlansUtilizationDetailsRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetSavingsPlansUtilizationDetailsRequest.Builder, GetSavingsPlansUtilizationDetailsRequest> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .memberName("TimePeriod").getter(getter(GetSavingsPlansUtilizationDetailsRequest::timePeriod))
            .setter(setter(Builder::timePeriod)).constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final SdkField<Expression> FILTER_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("Filter").getter(getter(GetSavingsPlansUtilizationDetailsRequest::filter))
            .setter(setter(Builder::filter)).constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<List<String>> DATA_TYPE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DataType")
            .getter(getter(GetSavingsPlansUtilizationDetailsRequest::dataTypeAsStrings))
            .setter(setter(Builder::dataTypeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetSavingsPlansUtilizationDetailsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetSavingsPlansUtilizationDetailsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<SortDefinition> SORT_BY_FIELD = SdkField.<SortDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("SortBy").getter(getter(GetSavingsPlansUtilizationDetailsRequest::sortBy))
            .setter(setter(Builder::sortBy)).constructor(SortDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD,
            FILTER_FIELD, DATA_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SORT_BY_FIELD));

    private final DateInterval timePeriod;

    private final Expression filter;

    private final List<String> dataType;

    private final String nextToken;

    private final Integer maxResults;

    private final SortDefinition sortBy;

    private GetSavingsPlansUtilizationDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.timePeriod = builder.timePeriod;
        this.filter = builder.filter;
        this.dataType = builder.dataType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sortBy = builder.sortBy;
    }

    /**
     * <p>
     * The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The
     * <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't
     * be used as an <code>End</code> date.
     * </p>
     * 
     * @return The time period that you want the usage and costs for. The <code>Start</code> date must be within 13
     *         months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date.
     *         Future dates can't be used as an <code>End</code> date.
     */
    public final DateInterval timePeriod() {
        return timePeriod;
    }

    /**
     * <p>
     * Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the
     * following dimensions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LINKED_ACCOUNT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAVINGS_PLAN_ARN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PAYMENT_OPTION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE_TYPE_FAMILY</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>GetSavingsPlansUtilizationDetails</code> uses the same <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
     * object as the other operations, but only <code>AND</code> is supported among each dimension.
     * </p>
     * 
     * @return Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data
     *         with the following dimensions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LINKED_ACCOUNT</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAVINGS_PLAN_ARN</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PAYMENT_OPTION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTANCE_TYPE_FAMILY</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>GetSavingsPlansUtilizationDetails</code> uses the same <a
     *         href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html"
     *         >Expression</a> object as the other operations, but only <code>AND</code> is supported among each
     *         dimension.
     */
    public final Expression filter() {
        return filter;
    }

    /**
     * <p>
     * The data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataType} method.
     * </p>
     * 
     * @return The data type.
     */
    public final List<SavingsPlansDataType> dataType() {
        return SavingsPlansDataTypesCopier.copyStringToEnum(dataType);
    }

    /**
     * For responses, this returns true if the service returned a value for the DataType property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDataType() {
        return dataType != null && !(dataType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataType} method.
     * </p>
     * 
     * @return The data type.
     */
    public final List<String> dataTypeAsStrings() {
        return dataType;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a
     * previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. Amazon Web Services provides the token when the response
     *         from a previous call has more results than the maximum page size.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of
     * <code>1</code>.
     * </p>
     * 
     * @return The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of
     *         <code>1</code>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The value by which you want to sort the data.
     * </p>
     * <p>
     * The following values are supported for <code>Key</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UtilizationPercentage</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TotalCommitment</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UsedCommitment</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UnusedCommitment</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NetSavings</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AmortizedRecurringCommitment</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AmortizedUpfrontCommitment</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
     * </p>
     * 
     * @return The value by which you want to sort the data.</p>
     *         <p>
     *         The following values are supported for <code>Key</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UtilizationPercentage</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TotalCommitment</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UsedCommitment</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UnusedCommitment</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NetSavings</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AmortizedRecurringCommitment</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AmortizedUpfrontCommitment</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
     */
    public final SortDefinition sortBy() {
        return sortBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataType() ? dataTypeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSavingsPlansUtilizationDetailsRequest)) {
            return false;
        }
        GetSavingsPlansUtilizationDetailsRequest other = (GetSavingsPlansUtilizationDetailsRequest) obj;
        return Objects.equals(timePeriod(), other.timePeriod()) && Objects.equals(filter(), other.filter())
                && hasDataType() == other.hasDataType() && Objects.equals(dataTypeAsStrings(), other.dataTypeAsStrings())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(sortBy(), other.sortBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSavingsPlansUtilizationDetailsRequest").add("TimePeriod", timePeriod())
                .add("Filter", filter()).add("DataType", hasDataType() ? dataTypeAsStrings() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).add("SortBy", sortBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "DataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsStrings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSavingsPlansUtilizationDetailsRequest, T> g) {
        return obj -> g.apply((GetSavingsPlansUtilizationDetailsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSavingsPlansUtilizationDetailsRequest> {
        /**
         * <p>
         * The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months.
         * The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future
         * dates can't be used as an <code>End</code> date.
         * </p>
         * 
         * @param timePeriod
         *        The time period that you want the usage and costs for. The <code>Start</code> date must be within 13
         *        months. The <code>End</code> date must be after the <code>Start</code> date, and before the current
         *        date. Future dates can't be used as an <code>End</code> date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * <p>
         * The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months.
         * The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future
         * dates can't be used as an <code>End</code> date.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateInterval.Builder} avoiding the need
         * to create one manually via {@link DateInterval#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }

        /**
         * <p>
         * Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with
         * the following dimensions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LINKED_ACCOUNT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_PLAN_ARN</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAYMENT_OPTION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE_TYPE_FAMILY</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>GetSavingsPlansUtilizationDetails</code> uses the same <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
         * object as the other operations, but only <code>AND</code> is supported among each dimension.
         * </p>
         * 
         * @param filter
         *        Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter
         *        data with the following dimensions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LINKED_ACCOUNT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAVINGS_PLAN_ARN</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PAYMENT_OPTION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTANCE_TYPE_FAMILY</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>GetSavingsPlansUtilizationDetails</code> uses the same <a
         *        href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html"
         *        >Expression</a> object as the other operations, but only <code>AND</code> is supported among each
         *        dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Expression filter);

        /**
         * <p>
         * Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with
         * the following dimensions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LINKED_ACCOUNT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_PLAN_ARN</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAYMENT_OPTION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE_TYPE_FAMILY</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>GetSavingsPlansUtilizationDetails</code> uses the same <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
         * object as the other operations, but only <code>AND</code> is supported among each dimension.
         * </p>
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(Expression)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Expression)
         */
        default Builder filter(Consumer<Expression.Builder> filter) {
            return filter(Expression.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The data type.
         * </p>
         * 
         * @param dataType
         *        The data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTypeWithStrings(Collection<String> dataType);

        /**
         * <p>
         * The data type.
         * </p>
         * 
         * @param dataType
         *        The data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTypeWithStrings(String... dataType);

        /**
         * <p>
         * The data type.
         * </p>
         * 
         * @param dataType
         *        The data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataType(Collection<SavingsPlansDataType> dataType);

        /**
         * <p>
         * The data type.
         * </p>
         * 
         * @param dataType
         *        The data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataType(SavingsPlansDataType... dataType);

        /**
         * <p>
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from
         * a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of
         * <code>1</code>.
         * </p>
         * 
         * @param maxResults
         *        The number of items to be returned in a response. The default is <code>20</code>, with a minimum value
         *        of <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The value by which you want to sort the data.
         * </p>
         * <p>
         * The following values are supported for <code>Key</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UtilizationPercentage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TotalCommitment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UsedCommitment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UnusedCommitment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetSavings</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AmortizedRecurringCommitment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AmortizedUpfrontCommitment</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         * </p>
         * 
         * @param sortBy
         *        The value by which you want to sort the data.</p>
         *        <p>
         *        The following values are supported for <code>Key</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UtilizationPercentage</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TotalCommitment</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UsedCommitment</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UnusedCommitment</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NetSavings</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AmortizedRecurringCommitment</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AmortizedUpfrontCommitment</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(SortDefinition sortBy);

        /**
         * <p>
         * The value by which you want to sort the data.
         * </p>
         * <p>
         * The following values are supported for <code>Key</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UtilizationPercentage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TotalCommitment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UsedCommitment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UnusedCommitment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetSavings</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AmortizedRecurringCommitment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AmortizedUpfrontCommitment</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SortDefinition.Builder} avoiding the need
         * to create one manually via {@link SortDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link SortDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #sortBy(SortDefinition)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link SortDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(SortDefinition)
         */
        default Builder sortBy(Consumer<SortDefinition.Builder> sortBy) {
            return sortBy(SortDefinition.builder().applyMutation(sortBy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private DateInterval timePeriod;

        private Expression filter;

        private List<String> dataType = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private SortDefinition sortBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSavingsPlansUtilizationDetailsRequest model) {
            super(model);
            timePeriod(model.timePeriod);
            filter(model.filter);
            dataTypeWithStrings(model.dataType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            sortBy(model.sortBy);
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final Expression.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final Collection<String> getDataType() {
            if (dataType instanceof SdkAutoConstructList) {
                return null;
            }
            return dataType;
        }

        public final void setDataType(Collection<String> dataType) {
            this.dataType = SavingsPlansDataTypesCopier.copy(dataType);
        }

        @Override
        public final Builder dataTypeWithStrings(Collection<String> dataType) {
            this.dataType = SavingsPlansDataTypesCopier.copy(dataType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataTypeWithStrings(String... dataType) {
            dataTypeWithStrings(Arrays.asList(dataType));
            return this;
        }

        @Override
        public final Builder dataType(Collection<SavingsPlansDataType> dataType) {
            this.dataType = SavingsPlansDataTypesCopier.copyEnumToString(dataType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataType(SavingsPlansDataType... dataType) {
            dataType(Arrays.asList(dataType));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final SortDefinition.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        public final void setSortBy(SortDefinition.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(SortDefinition sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSavingsPlansUtilizationDetailsRequest build() {
            return new GetSavingsPlansUtilizationDetailsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
