/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Recommendations to rightsize resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RightsizingRecommendation implements SdkPojo, Serializable,
        ToCopyableBuilder<RightsizingRecommendation.Builder, RightsizingRecommendation> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(RightsizingRecommendation::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<CurrentInstance> CURRENT_INSTANCE_FIELD = SdkField
            .<CurrentInstance> builder(MarshallingType.SDK_POJO).memberName("CurrentInstance")
            .getter(getter(RightsizingRecommendation::currentInstance)).setter(setter(Builder::currentInstance))
            .constructor(CurrentInstance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInstance").build()).build();

    private static final SdkField<String> RIGHTSIZING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RightsizingType").getter(getter(RightsizingRecommendation::rightsizingTypeAsString))
            .setter(setter(Builder::rightsizingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RightsizingType").build()).build();

    private static final SdkField<ModifyRecommendationDetail> MODIFY_RECOMMENDATION_DETAIL_FIELD = SdkField
            .<ModifyRecommendationDetail> builder(MarshallingType.SDK_POJO)
            .memberName("ModifyRecommendationDetail")
            .getter(getter(RightsizingRecommendation::modifyRecommendationDetail))
            .setter(setter(Builder::modifyRecommendationDetail))
            .constructor(ModifyRecommendationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifyRecommendationDetail").build())
            .build();

    private static final SdkField<TerminateRecommendationDetail> TERMINATE_RECOMMENDATION_DETAIL_FIELD = SdkField
            .<TerminateRecommendationDetail> builder(MarshallingType.SDK_POJO)
            .memberName("TerminateRecommendationDetail")
            .getter(getter(RightsizingRecommendation::terminateRecommendationDetail))
            .setter(setter(Builder::terminateRecommendationDetail))
            .constructor(TerminateRecommendationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateRecommendationDetail")
                    .build()).build();

    private static final SdkField<List<String>> FINDING_REASON_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FindingReasonCodes")
            .getter(getter(RightsizingRecommendation::findingReasonCodesAsStrings))
            .setter(setter(Builder::findingReasonCodesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingReasonCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            CURRENT_INSTANCE_FIELD, RIGHTSIZING_TYPE_FIELD, MODIFY_RECOMMENDATION_DETAIL_FIELD,
            TERMINATE_RECOMMENDATION_DETAIL_FIELD, FINDING_REASON_CODES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final CurrentInstance currentInstance;

    private final String rightsizingType;

    private final ModifyRecommendationDetail modifyRecommendationDetail;

    private final TerminateRecommendationDetail terminateRecommendationDetail;

    private final List<String> findingReasonCodes;

    private RightsizingRecommendation(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.currentInstance = builder.currentInstance;
        this.rightsizingType = builder.rightsizingType;
        this.modifyRecommendationDetail = builder.modifyRecommendationDetail;
        this.terminateRecommendationDetail = builder.terminateRecommendationDetail;
        this.findingReasonCodes = builder.findingReasonCodes;
    }

    /**
     * <p>
     * The account that this recommendation is for.
     * </p>
     * 
     * @return The account that this recommendation is for.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Context regarding the current instance.
     * </p>
     * 
     * @return Context regarding the current instance.
     */
    public final CurrentInstance currentInstance() {
        return currentInstance;
    }

    /**
     * <p>
     * A recommendation to either terminate or modify the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rightsizingType}
     * will return {@link RightsizingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rightsizingTypeAsString}.
     * </p>
     * 
     * @return A recommendation to either terminate or modify the resource.
     * @see RightsizingType
     */
    public final RightsizingType rightsizingType() {
        return RightsizingType.fromValue(rightsizingType);
    }

    /**
     * <p>
     * A recommendation to either terminate or modify the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rightsizingType}
     * will return {@link RightsizingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rightsizingTypeAsString}.
     * </p>
     * 
     * @return A recommendation to either terminate or modify the resource.
     * @see RightsizingType
     */
    public final String rightsizingTypeAsString() {
        return rightsizingType;
    }

    /**
     * <p>
     * The details for the modification recommendations.
     * </p>
     * 
     * @return The details for the modification recommendations.
     */
    public final ModifyRecommendationDetail modifyRecommendationDetail() {
        return modifyRecommendationDetail;
    }

    /**
     * <p>
     * The details for termination recommendations.
     * </p>
     * 
     * @return The details for termination recommendations.
     */
    public final TerminateRecommendationDetail terminateRecommendationDetail() {
        return terminateRecommendationDetail;
    }

    /**
     * <p>
     * The list of possible reasons why the recommendation is generated such as under or over utilization of specific
     * metrics (for example, CPU, Memory, Network).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingReasonCodes} method.
     * </p>
     * 
     * @return The list of possible reasons why the recommendation is generated such as under or over utilization of
     *         specific metrics (for example, CPU, Memory, Network).
     */
    public final List<FindingReasonCode> findingReasonCodes() {
        return FindingReasonCodesCopier.copyStringToEnum(findingReasonCodes);
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingReasonCodes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFindingReasonCodes() {
        return findingReasonCodes != null && !(findingReasonCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of possible reasons why the recommendation is generated such as under or over utilization of specific
     * metrics (for example, CPU, Memory, Network).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingReasonCodes} method.
     * </p>
     * 
     * @return The list of possible reasons why the recommendation is generated such as under or over utilization of
     *         specific metrics (for example, CPU, Memory, Network).
     */
    public final List<String> findingReasonCodesAsStrings() {
        return findingReasonCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(currentInstance());
        hashCode = 31 * hashCode + Objects.hashCode(rightsizingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modifyRecommendationDetail());
        hashCode = 31 * hashCode + Objects.hashCode(terminateRecommendationDetail());
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingReasonCodes() ? findingReasonCodesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RightsizingRecommendation)) {
            return false;
        }
        RightsizingRecommendation other = (RightsizingRecommendation) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(currentInstance(), other.currentInstance())
                && Objects.equals(rightsizingTypeAsString(), other.rightsizingTypeAsString())
                && Objects.equals(modifyRecommendationDetail(), other.modifyRecommendationDetail())
                && Objects.equals(terminateRecommendationDetail(), other.terminateRecommendationDetail())
                && hasFindingReasonCodes() == other.hasFindingReasonCodes()
                && Objects.equals(findingReasonCodesAsStrings(), other.findingReasonCodesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RightsizingRecommendation").add("AccountId", accountId())
                .add("CurrentInstance", currentInstance()).add("RightsizingType", rightsizingTypeAsString())
                .add("ModifyRecommendationDetail", modifyRecommendationDetail())
                .add("TerminateRecommendationDetail", terminateRecommendationDetail())
                .add("FindingReasonCodes", hasFindingReasonCodes() ? findingReasonCodesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "CurrentInstance":
            return Optional.ofNullable(clazz.cast(currentInstance()));
        case "RightsizingType":
            return Optional.ofNullable(clazz.cast(rightsizingTypeAsString()));
        case "ModifyRecommendationDetail":
            return Optional.ofNullable(clazz.cast(modifyRecommendationDetail()));
        case "TerminateRecommendationDetail":
            return Optional.ofNullable(clazz.cast(terminateRecommendationDetail()));
        case "FindingReasonCodes":
            return Optional.ofNullable(clazz.cast(findingReasonCodesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RightsizingRecommendation, T> g) {
        return obj -> g.apply((RightsizingRecommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RightsizingRecommendation> {
        /**
         * <p>
         * The account that this recommendation is for.
         * </p>
         * 
         * @param accountId
         *        The account that this recommendation is for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Context regarding the current instance.
         * </p>
         * 
         * @param currentInstance
         *        Context regarding the current instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentInstance(CurrentInstance currentInstance);

        /**
         * <p>
         * Context regarding the current instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link CurrentInstance.Builder} avoiding the
         * need to create one manually via {@link CurrentInstance#builder()}.
         *
         * When the {@link Consumer} completes, {@link CurrentInstance.Builder#build()} is called immediately and its
         * result is passed to {@link #currentInstance(CurrentInstance)}.
         * 
         * @param currentInstance
         *        a consumer that will call methods on {@link CurrentInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentInstance(CurrentInstance)
         */
        default Builder currentInstance(Consumer<CurrentInstance.Builder> currentInstance) {
            return currentInstance(CurrentInstance.builder().applyMutation(currentInstance).build());
        }

        /**
         * <p>
         * A recommendation to either terminate or modify the resource.
         * </p>
         * 
         * @param rightsizingType
         *        A recommendation to either terminate or modify the resource.
         * @see RightsizingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RightsizingType
         */
        Builder rightsizingType(String rightsizingType);

        /**
         * <p>
         * A recommendation to either terminate or modify the resource.
         * </p>
         * 
         * @param rightsizingType
         *        A recommendation to either terminate or modify the resource.
         * @see RightsizingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RightsizingType
         */
        Builder rightsizingType(RightsizingType rightsizingType);

        /**
         * <p>
         * The details for the modification recommendations.
         * </p>
         * 
         * @param modifyRecommendationDetail
         *        The details for the modification recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifyRecommendationDetail(ModifyRecommendationDetail modifyRecommendationDetail);

        /**
         * <p>
         * The details for the modification recommendations.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModifyRecommendationDetail.Builder}
         * avoiding the need to create one manually via {@link ModifyRecommendationDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModifyRecommendationDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #modifyRecommendationDetail(ModifyRecommendationDetail)}.
         * 
         * @param modifyRecommendationDetail
         *        a consumer that will call methods on {@link ModifyRecommendationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modifyRecommendationDetail(ModifyRecommendationDetail)
         */
        default Builder modifyRecommendationDetail(Consumer<ModifyRecommendationDetail.Builder> modifyRecommendationDetail) {
            return modifyRecommendationDetail(ModifyRecommendationDetail.builder().applyMutation(modifyRecommendationDetail)
                    .build());
        }

        /**
         * <p>
         * The details for termination recommendations.
         * </p>
         * 
         * @param terminateRecommendationDetail
         *        The details for termination recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateRecommendationDetail(TerminateRecommendationDetail terminateRecommendationDetail);

        /**
         * <p>
         * The details for termination recommendations.
         * </p>
         * This is a convenience method that creates an instance of the {@link TerminateRecommendationDetail.Builder}
         * avoiding the need to create one manually via {@link TerminateRecommendationDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link TerminateRecommendationDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #terminateRecommendationDetail(TerminateRecommendationDetail)}
         * .
         * 
         * @param terminateRecommendationDetail
         *        a consumer that will call methods on {@link TerminateRecommendationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terminateRecommendationDetail(TerminateRecommendationDetail)
         */
        default Builder terminateRecommendationDetail(
                Consumer<TerminateRecommendationDetail.Builder> terminateRecommendationDetail) {
            return terminateRecommendationDetail(TerminateRecommendationDetail.builder()
                    .applyMutation(terminateRecommendationDetail).build());
        }

        /**
         * <p>
         * The list of possible reasons why the recommendation is generated such as under or over utilization of
         * specific metrics (for example, CPU, Memory, Network).
         * </p>
         * 
         * @param findingReasonCodes
         *        The list of possible reasons why the recommendation is generated such as under or over utilization of
         *        specific metrics (for example, CPU, Memory, Network).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingReasonCodesWithStrings(Collection<String> findingReasonCodes);

        /**
         * <p>
         * The list of possible reasons why the recommendation is generated such as under or over utilization of
         * specific metrics (for example, CPU, Memory, Network).
         * </p>
         * 
         * @param findingReasonCodes
         *        The list of possible reasons why the recommendation is generated such as under or over utilization of
         *        specific metrics (for example, CPU, Memory, Network).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingReasonCodesWithStrings(String... findingReasonCodes);

        /**
         * <p>
         * The list of possible reasons why the recommendation is generated such as under or over utilization of
         * specific metrics (for example, CPU, Memory, Network).
         * </p>
         * 
         * @param findingReasonCodes
         *        The list of possible reasons why the recommendation is generated such as under or over utilization of
         *        specific metrics (for example, CPU, Memory, Network).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingReasonCodes(Collection<FindingReasonCode> findingReasonCodes);

        /**
         * <p>
         * The list of possible reasons why the recommendation is generated such as under or over utilization of
         * specific metrics (for example, CPU, Memory, Network).
         * </p>
         * 
         * @param findingReasonCodes
         *        The list of possible reasons why the recommendation is generated such as under or over utilization of
         *        specific metrics (for example, CPU, Memory, Network).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingReasonCodes(FindingReasonCode... findingReasonCodes);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private CurrentInstance currentInstance;

        private String rightsizingType;

        private ModifyRecommendationDetail modifyRecommendationDetail;

        private TerminateRecommendationDetail terminateRecommendationDetail;

        private List<String> findingReasonCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RightsizingRecommendation model) {
            accountId(model.accountId);
            currentInstance(model.currentInstance);
            rightsizingType(model.rightsizingType);
            modifyRecommendationDetail(model.modifyRecommendationDetail);
            terminateRecommendationDetail(model.terminateRecommendationDetail);
            findingReasonCodesWithStrings(model.findingReasonCodes);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final CurrentInstance.Builder getCurrentInstance() {
            return currentInstance != null ? currentInstance.toBuilder() : null;
        }

        public final void setCurrentInstance(CurrentInstance.BuilderImpl currentInstance) {
            this.currentInstance = currentInstance != null ? currentInstance.build() : null;
        }

        @Override
        public final Builder currentInstance(CurrentInstance currentInstance) {
            this.currentInstance = currentInstance;
            return this;
        }

        public final String getRightsizingType() {
            return rightsizingType;
        }

        public final void setRightsizingType(String rightsizingType) {
            this.rightsizingType = rightsizingType;
        }

        @Override
        public final Builder rightsizingType(String rightsizingType) {
            this.rightsizingType = rightsizingType;
            return this;
        }

        @Override
        public final Builder rightsizingType(RightsizingType rightsizingType) {
            this.rightsizingType(rightsizingType == null ? null : rightsizingType.toString());
            return this;
        }

        public final ModifyRecommendationDetail.Builder getModifyRecommendationDetail() {
            return modifyRecommendationDetail != null ? modifyRecommendationDetail.toBuilder() : null;
        }

        public final void setModifyRecommendationDetail(ModifyRecommendationDetail.BuilderImpl modifyRecommendationDetail) {
            this.modifyRecommendationDetail = modifyRecommendationDetail != null ? modifyRecommendationDetail.build() : null;
        }

        @Override
        public final Builder modifyRecommendationDetail(ModifyRecommendationDetail modifyRecommendationDetail) {
            this.modifyRecommendationDetail = modifyRecommendationDetail;
            return this;
        }

        public final TerminateRecommendationDetail.Builder getTerminateRecommendationDetail() {
            return terminateRecommendationDetail != null ? terminateRecommendationDetail.toBuilder() : null;
        }

        public final void setTerminateRecommendationDetail(TerminateRecommendationDetail.BuilderImpl terminateRecommendationDetail) {
            this.terminateRecommendationDetail = terminateRecommendationDetail != null ? terminateRecommendationDetail.build()
                    : null;
        }

        @Override
        public final Builder terminateRecommendationDetail(TerminateRecommendationDetail terminateRecommendationDetail) {
            this.terminateRecommendationDetail = terminateRecommendationDetail;
            return this;
        }

        public final Collection<String> getFindingReasonCodes() {
            if (findingReasonCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return findingReasonCodes;
        }

        public final void setFindingReasonCodes(Collection<String> findingReasonCodes) {
            this.findingReasonCodes = FindingReasonCodesCopier.copy(findingReasonCodes);
        }

        @Override
        public final Builder findingReasonCodesWithStrings(Collection<String> findingReasonCodes) {
            this.findingReasonCodes = FindingReasonCodesCopier.copy(findingReasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingReasonCodesWithStrings(String... findingReasonCodes) {
            findingReasonCodesWithStrings(Arrays.asList(findingReasonCodes));
            return this;
        }

        @Override
        public final Builder findingReasonCodes(Collection<FindingReasonCode> findingReasonCodes) {
            this.findingReasonCodes = FindingReasonCodesCopier.copyEnumToString(findingReasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingReasonCodes(FindingReasonCode... findingReasonCodes) {
            findingReasonCodes(Arrays.asList(findingReasonCodes));
            return this;
        }

        @Override
        public RightsizingRecommendation build() {
            return new RightsizingRecommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
