/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnomalySubscriptionRequest extends CostExplorerRequest implements
        ToCopyableBuilder<CreateAnomalySubscriptionRequest.Builder, CreateAnomalySubscriptionRequest> {
    private static final SdkField<AnomalySubscription> ANOMALY_SUBSCRIPTION_FIELD = SdkField
            .<AnomalySubscription> builder(MarshallingType.SDK_POJO).memberName("AnomalySubscription")
            .getter(getter(CreateAnomalySubscriptionRequest::anomalySubscription)).setter(setter(Builder::anomalySubscription))
            .constructor(AnomalySubscription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalySubscription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_SUBSCRIPTION_FIELD));

    private final AnomalySubscription anomalySubscription;

    private CreateAnomalySubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.anomalySubscription = builder.anomalySubscription;
    }

    /**
     * <p>
     * The cost anomaly subscription object that you want to create.
     * </p>
     * 
     * @return The cost anomaly subscription object that you want to create.
     */
    public final AnomalySubscription anomalySubscription() {
        return anomalySubscription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalySubscription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnomalySubscriptionRequest)) {
            return false;
        }
        CreateAnomalySubscriptionRequest other = (CreateAnomalySubscriptionRequest) obj;
        return Objects.equals(anomalySubscription(), other.anomalySubscription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnomalySubscriptionRequest").add("AnomalySubscription", anomalySubscription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalySubscription":
            return Optional.ofNullable(clazz.cast(anomalySubscription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAnomalySubscriptionRequest, T> g) {
        return obj -> g.apply((CreateAnomalySubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAnomalySubscriptionRequest> {
        /**
         * <p>
         * The cost anomaly subscription object that you want to create.
         * </p>
         * 
         * @param anomalySubscription
         *        The cost anomaly subscription object that you want to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalySubscription(AnomalySubscription anomalySubscription);

        /**
         * <p>
         * The cost anomaly subscription object that you want to create.
         * </p>
         * This is a convenience that creates an instance of the {@link AnomalySubscription.Builder} avoiding the need
         * to create one manually via {@link AnomalySubscription#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnomalySubscription.Builder#build()} is called immediately and
         * its result is passed to {@link #anomalySubscription(AnomalySubscription)}.
         * 
         * @param anomalySubscription
         *        a consumer that will call methods on {@link AnomalySubscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalySubscription(AnomalySubscription)
         */
        default Builder anomalySubscription(Consumer<AnomalySubscription.Builder> anomalySubscription) {
            return anomalySubscription(AnomalySubscription.builder().applyMutation(anomalySubscription).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private AnomalySubscription anomalySubscription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnomalySubscriptionRequest model) {
            super(model);
            anomalySubscription(model.anomalySubscription);
        }

        public final AnomalySubscription.Builder getAnomalySubscription() {
            return anomalySubscription != null ? anomalySubscription.toBuilder() : null;
        }

        public final void setAnomalySubscription(AnomalySubscription.BuilderImpl anomalySubscription) {
            this.anomalySubscription = anomalySubscription != null ? anomalySubscription.build() : null;
        }

        @Override
        @Transient
        public final Builder anomalySubscription(AnomalySubscription anomalySubscription) {
            this.anomalySubscription = anomalySubscription;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnomalySubscriptionRequest build() {
            return new CreateAnomalySubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
