/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTagsResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetTagsResponse.Builder, GetTagsResponse> {
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetTagsResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final SdkField<List<String>> TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(GetTagsResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> RETURN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReturnSize").getter(getter(GetTagsResponse::returnSize)).setter(setter(Builder::returnSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnSize").build()).build();

    private static final SdkField<Integer> TOTAL_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalSize").getter(getter(GetTagsResponse::totalSize)).setter(setter(Builder::totalSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_PAGE_TOKEN_FIELD,
            TAGS_FIELD, RETURN_SIZE_FIELD, TOTAL_SIZE_FIELD));

    private final String nextPageToken;

    private final List<String> tags;

    private final Integer returnSize;

    private final Integer totalSize;

    private GetTagsResponse(BuilderImpl builder) {
        super(builder);
        this.nextPageToken = builder.nextPageToken;
        this.tags = builder.tags;
        this.returnSize = builder.returnSize;
        this.totalSize = builder.totalSize;
    }

    /**
     * <p>
     * The token for the next set of retrievable results. Amazon Web Services provides the token when the response from
     * a previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token for the next set of retrievable results. Amazon Web Services provides the token when the
     *         response from a previous call has more results than the maximum page size.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags that match your request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that match your request.
     */
    public final List<String> tags() {
        return tags;
    }

    /**
     * <p>
     * The number of query results that Amazon Web Services returns at a time.
     * </p>
     * 
     * @return The number of query results that Amazon Web Services returns at a time.
     */
    public final Integer returnSize() {
        return returnSize;
    }

    /**
     * <p>
     * The total number of query results.
     * </p>
     * 
     * @return The total number of query results.
     */
    public final Integer totalSize() {
        return totalSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(returnSize());
        hashCode = 31 * hashCode + Objects.hashCode(totalSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTagsResponse)) {
            return false;
        }
        GetTagsResponse other = (GetTagsResponse) obj;
        return Objects.equals(nextPageToken(), other.nextPageToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(returnSize(), other.returnSize())
                && Objects.equals(totalSize(), other.totalSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTagsResponse").add("NextPageToken", nextPageToken()).add("Tags", hasTags() ? tags() : null)
                .add("ReturnSize", returnSize()).add("TotalSize", totalSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ReturnSize":
            return Optional.ofNullable(clazz.cast(returnSize()));
        case "TotalSize":
            return Optional.ofNullable(clazz.cast(totalSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTagsResponse, T> g) {
        return obj -> g.apply((GetTagsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTagsResponse> {
        /**
         * <p>
         * The token for the next set of retrievable results. Amazon Web Services provides the token when the response
         * from a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextPageToken
         *        The token for the next set of retrievable results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The tags that match your request.
         * </p>
         * 
         * @param tags
         *        The tags that match your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<String> tags);

        /**
         * <p>
         * The tags that match your request.
         * </p>
         * 
         * @param tags
         *        The tags that match your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(String... tags);

        /**
         * <p>
         * The number of query results that Amazon Web Services returns at a time.
         * </p>
         * 
         * @param returnSize
         *        The number of query results that Amazon Web Services returns at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnSize(Integer returnSize);

        /**
         * <p>
         * The total number of query results.
         * </p>
         * 
         * @param totalSize
         *        The total number of query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSize(Integer totalSize);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private String nextPageToken;

        private List<String> tags = DefaultSdkAutoConstructList.getInstance();

        private Integer returnSize;

        private Integer totalSize;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTagsResponse model) {
            super(model);
            nextPageToken(model.nextPageToken);
            tags(model.tags);
            returnSize(model.returnSize);
            totalSize(model.totalSize);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        @Transient
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final Collection<String> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags;
        }

        public final void setTags(Collection<String> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<String> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(String... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final Integer getReturnSize() {
            return returnSize;
        }

        public final void setReturnSize(Integer returnSize) {
            this.returnSize = returnSize;
        }

        @Override
        @Transient
        public final Builder returnSize(Integer returnSize) {
            this.returnSize = returnSize;
            return this;
        }

        public final Integer getTotalSize() {
            return totalSize;
        }

        public final void setTotalSize(Integer totalSize) {
            this.totalSize = totalSize;
        }

        @Override
        @Transient
        public final Builder totalSize(Integer totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        @Override
        public GetTagsResponse build() {
            return new GetTagsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
