/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The dollar value of the anomaly.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Impact implements SdkPojo, Serializable, ToCopyableBuilder<Impact.Builder, Impact> {
    private static final SdkField<Double> MAX_IMPACT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaxImpact").getter(getter(Impact::maxImpact)).setter(setter(Builder::maxImpact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxImpact").build()).build();

    private static final SdkField<Double> TOTAL_IMPACT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TotalImpact").getter(getter(Impact::totalImpact)).setter(setter(Builder::totalImpact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalImpact").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_IMPACT_FIELD,
            TOTAL_IMPACT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double maxImpact;

    private final Double totalImpact;

    private Impact(BuilderImpl builder) {
        this.maxImpact = builder.maxImpact;
        this.totalImpact = builder.totalImpact;
    }

    /**
     * <p>
     * The maximum dollar value that's observed for an anomaly.
     * </p>
     * 
     * @return The maximum dollar value that's observed for an anomaly.
     */
    public final Double maxImpact() {
        return maxImpact;
    }

    /**
     * <p>
     * The cumulative dollar value that's observed for an anomaly.
     * </p>
     * 
     * @return The cumulative dollar value that's observed for an anomaly.
     */
    public final Double totalImpact() {
        return totalImpact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxImpact());
        hashCode = 31 * hashCode + Objects.hashCode(totalImpact());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Impact)) {
            return false;
        }
        Impact other = (Impact) obj;
        return Objects.equals(maxImpact(), other.maxImpact()) && Objects.equals(totalImpact(), other.totalImpact());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Impact").add("MaxImpact", maxImpact()).add("TotalImpact", totalImpact()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxImpact":
            return Optional.ofNullable(clazz.cast(maxImpact()));
        case "TotalImpact":
            return Optional.ofNullable(clazz.cast(totalImpact()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Impact, T> g) {
        return obj -> g.apply((Impact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Impact> {
        /**
         * <p>
         * The maximum dollar value that's observed for an anomaly.
         * </p>
         * 
         * @param maxImpact
         *        The maximum dollar value that's observed for an anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxImpact(Double maxImpact);

        /**
         * <p>
         * The cumulative dollar value that's observed for an anomaly.
         * </p>
         * 
         * @param totalImpact
         *        The cumulative dollar value that's observed for an anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalImpact(Double totalImpact);
    }

    static final class BuilderImpl implements Builder {
        private Double maxImpact;

        private Double totalImpact;

        private BuilderImpl() {
        }

        private BuilderImpl(Impact model) {
            maxImpact(model.maxImpact);
            totalImpact(model.totalImpact);
        }

        public final Double getMaxImpact() {
            return maxImpact;
        }

        public final void setMaxImpact(Double maxImpact) {
            this.maxImpact = maxImpact;
        }

        @Override
        @Transient
        public final Builder maxImpact(Double maxImpact) {
            this.maxImpact = maxImpact;
            return this;
        }

        public final Double getTotalImpact() {
            return totalImpact;
        }

        public final void setTotalImpact(Double totalImpact) {
            this.totalImpact = totalImpact;
        }

        @Override
        @Transient
        public final Builder totalImpact(Double totalImpact) {
            this.totalImpact = totalImpact;
            return this;
        }

        @Override
        public Impact build() {
            return new Impact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
