/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary about this recommendation, such as the currency code, the amount that Amazon Web Services estimates that
 * you could save, and the total amount of reservation to purchase.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservationPurchaseRecommendationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservationPurchaseRecommendationSummary.Builder, ReservationPurchaseRecommendationSummary> {
    private static final SdkField<String> TOTAL_ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TotalEstimatedMonthlySavingsAmount")
            .getter(getter(ReservationPurchaseRecommendationSummary::totalEstimatedMonthlySavingsAmount))
            .setter(setter(Builder::totalEstimatedMonthlySavingsAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalEstimatedMonthlySavingsAmount")
                    .build()).build();

    private static final SdkField<String> TOTAL_ESTIMATED_MONTHLY_SAVINGS_PERCENTAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TotalEstimatedMonthlySavingsPercentage")
            .getter(getter(ReservationPurchaseRecommendationSummary::totalEstimatedMonthlySavingsPercentage))
            .setter(setter(Builder::totalEstimatedMonthlySavingsPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TotalEstimatedMonthlySavingsPercentage").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(ReservationPurchaseRecommendationSummary::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TOTAL_ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD, TOTAL_ESTIMATED_MONTHLY_SAVINGS_PERCENTAGE_FIELD, CURRENCY_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String totalEstimatedMonthlySavingsAmount;

    private final String totalEstimatedMonthlySavingsPercentage;

    private final String currencyCode;

    private ReservationPurchaseRecommendationSummary(BuilderImpl builder) {
        this.totalEstimatedMonthlySavingsAmount = builder.totalEstimatedMonthlySavingsAmount;
        this.totalEstimatedMonthlySavingsPercentage = builder.totalEstimatedMonthlySavingsPercentage;
        this.currencyCode = builder.currencyCode;
    }

    /**
     * <p>
     * The total amount that Amazon Web Services estimates that this recommendation could save you in a month.
     * </p>
     * 
     * @return The total amount that Amazon Web Services estimates that this recommendation could save you in a month.
     */
    public final String totalEstimatedMonthlySavingsAmount() {
        return totalEstimatedMonthlySavingsAmount;
    }

    /**
     * <p>
     * The total amount that Amazon Web Services estimates that this recommendation could save you in a month, as a
     * percentage of your costs.
     * </p>
     * 
     * @return The total amount that Amazon Web Services estimates that this recommendation could save you in a month,
     *         as a percentage of your costs.
     */
    public final String totalEstimatedMonthlySavingsPercentage() {
        return totalEstimatedMonthlySavingsPercentage;
    }

    /**
     * <p>
     * The currency code used for this recommendation.
     * </p>
     * 
     * @return The currency code used for this recommendation.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalEstimatedMonthlySavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(totalEstimatedMonthlySavingsPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationPurchaseRecommendationSummary)) {
            return false;
        }
        ReservationPurchaseRecommendationSummary other = (ReservationPurchaseRecommendationSummary) obj;
        return Objects.equals(totalEstimatedMonthlySavingsAmount(), other.totalEstimatedMonthlySavingsAmount())
                && Objects.equals(totalEstimatedMonthlySavingsPercentage(), other.totalEstimatedMonthlySavingsPercentage())
                && Objects.equals(currencyCode(), other.currencyCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservationPurchaseRecommendationSummary")
                .add("TotalEstimatedMonthlySavingsAmount", totalEstimatedMonthlySavingsAmount())
                .add("TotalEstimatedMonthlySavingsPercentage", totalEstimatedMonthlySavingsPercentage())
                .add("CurrencyCode", currencyCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalEstimatedMonthlySavingsAmount":
            return Optional.ofNullable(clazz.cast(totalEstimatedMonthlySavingsAmount()));
        case "TotalEstimatedMonthlySavingsPercentage":
            return Optional.ofNullable(clazz.cast(totalEstimatedMonthlySavingsPercentage()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservationPurchaseRecommendationSummary, T> g) {
        return obj -> g.apply((ReservationPurchaseRecommendationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservationPurchaseRecommendationSummary> {
        /**
         * <p>
         * The total amount that Amazon Web Services estimates that this recommendation could save you in a month.
         * </p>
         * 
         * @param totalEstimatedMonthlySavingsAmount
         *        The total amount that Amazon Web Services estimates that this recommendation could save you in a
         *        month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalEstimatedMonthlySavingsAmount(String totalEstimatedMonthlySavingsAmount);

        /**
         * <p>
         * The total amount that Amazon Web Services estimates that this recommendation could save you in a month, as a
         * percentage of your costs.
         * </p>
         * 
         * @param totalEstimatedMonthlySavingsPercentage
         *        The total amount that Amazon Web Services estimates that this recommendation could save you in a
         *        month, as a percentage of your costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalEstimatedMonthlySavingsPercentage(String totalEstimatedMonthlySavingsPercentage);

        /**
         * <p>
         * The currency code used for this recommendation.
         * </p>
         * 
         * @param currencyCode
         *        The currency code used for this recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);
    }

    static final class BuilderImpl implements Builder {
        private String totalEstimatedMonthlySavingsAmount;

        private String totalEstimatedMonthlySavingsPercentage;

        private String currencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationPurchaseRecommendationSummary model) {
            totalEstimatedMonthlySavingsAmount(model.totalEstimatedMonthlySavingsAmount);
            totalEstimatedMonthlySavingsPercentage(model.totalEstimatedMonthlySavingsPercentage);
            currencyCode(model.currencyCode);
        }

        public final String getTotalEstimatedMonthlySavingsAmount() {
            return totalEstimatedMonthlySavingsAmount;
        }

        public final void setTotalEstimatedMonthlySavingsAmount(String totalEstimatedMonthlySavingsAmount) {
            this.totalEstimatedMonthlySavingsAmount = totalEstimatedMonthlySavingsAmount;
        }

        @Override
        @Transient
        public final Builder totalEstimatedMonthlySavingsAmount(String totalEstimatedMonthlySavingsAmount) {
            this.totalEstimatedMonthlySavingsAmount = totalEstimatedMonthlySavingsAmount;
            return this;
        }

        public final String getTotalEstimatedMonthlySavingsPercentage() {
            return totalEstimatedMonthlySavingsPercentage;
        }

        public final void setTotalEstimatedMonthlySavingsPercentage(String totalEstimatedMonthlySavingsPercentage) {
            this.totalEstimatedMonthlySavingsPercentage = totalEstimatedMonthlySavingsPercentage;
        }

        @Override
        @Transient
        public final Builder totalEstimatedMonthlySavingsPercentage(String totalEstimatedMonthlySavingsPercentage) {
            this.totalEstimatedMonthlySavingsPercentage = totalEstimatedMonthlySavingsPercentage;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        @Transient
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public ReservationPurchaseRecommendationSummary build() {
            return new ReservationPurchaseRecommendationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
