/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specific coverage percentage, On-Demand costs, and spend covered by Savings Plans, and total Savings Plans costs for
 * an account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansCoverageData implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansCoverageData.Builder, SavingsPlansCoverageData> {
    private static final SdkField<String> SPEND_COVERED_BY_SAVINGS_PLANS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpendCoveredBySavingsPlans")
            .getter(getter(SavingsPlansCoverageData::spendCoveredBySavingsPlans))
            .setter(setter(Builder::spendCoveredBySavingsPlans))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpendCoveredBySavingsPlans").build())
            .build();

    private static final SdkField<String> ON_DEMAND_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OnDemandCost").getter(getter(SavingsPlansCoverageData::onDemandCost))
            .setter(setter(Builder::onDemandCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandCost").build()).build();

    private static final SdkField<String> TOTAL_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TotalCost").getter(getter(SavingsPlansCoverageData::totalCost)).setter(setter(Builder::totalCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCost").build()).build();

    private static final SdkField<String> COVERAGE_PERCENTAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoveragePercentage").getter(getter(SavingsPlansCoverageData::coveragePercentage))
            .setter(setter(Builder::coveragePercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoveragePercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SPEND_COVERED_BY_SAVINGS_PLANS_FIELD, ON_DEMAND_COST_FIELD, TOTAL_COST_FIELD, COVERAGE_PERCENTAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String spendCoveredBySavingsPlans;

    private final String onDemandCost;

    private final String totalCost;

    private final String coveragePercentage;

    private SavingsPlansCoverageData(BuilderImpl builder) {
        this.spendCoveredBySavingsPlans = builder.spendCoveredBySavingsPlans;
        this.onDemandCost = builder.onDemandCost;
        this.totalCost = builder.totalCost;
        this.coveragePercentage = builder.coveragePercentage;
    }

    /**
     * <p>
     * The amount of your Amazon Web Services usage that is covered by a Savings Plans.
     * </p>
     * 
     * @return The amount of your Amazon Web Services usage that is covered by a Savings Plans.
     */
    public final String spendCoveredBySavingsPlans() {
        return spendCoveredBySavingsPlans;
    }

    /**
     * <p>
     * The cost of your Amazon Web Services usage at the public On-Demand rate.
     * </p>
     * 
     * @return The cost of your Amazon Web Services usage at the public On-Demand rate.
     */
    public final String onDemandCost() {
        return onDemandCost;
    }

    /**
     * <p>
     * The total cost of your Amazon Web Services usage, regardless of your purchase option.
     * </p>
     * 
     * @return The total cost of your Amazon Web Services usage, regardless of your purchase option.
     */
    public final String totalCost() {
        return totalCost;
    }

    /**
     * <p>
     * The percentage of your existing Savings Plans covered usage, divided by all of your eligible Savings Plans usage
     * in an account (or set of accounts).
     * </p>
     * 
     * @return The percentage of your existing Savings Plans covered usage, divided by all of your eligible Savings
     *         Plans usage in an account (or set of accounts).
     */
    public final String coveragePercentage() {
        return coveragePercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spendCoveredBySavingsPlans());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandCost());
        hashCode = 31 * hashCode + Objects.hashCode(totalCost());
        hashCode = 31 * hashCode + Objects.hashCode(coveragePercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansCoverageData)) {
            return false;
        }
        SavingsPlansCoverageData other = (SavingsPlansCoverageData) obj;
        return Objects.equals(spendCoveredBySavingsPlans(), other.spendCoveredBySavingsPlans())
                && Objects.equals(onDemandCost(), other.onDemandCost()) && Objects.equals(totalCost(), other.totalCost())
                && Objects.equals(coveragePercentage(), other.coveragePercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlansCoverageData").add("SpendCoveredBySavingsPlans", spendCoveredBySavingsPlans())
                .add("OnDemandCost", onDemandCost()).add("TotalCost", totalCost())
                .add("CoveragePercentage", coveragePercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpendCoveredBySavingsPlans":
            return Optional.ofNullable(clazz.cast(spendCoveredBySavingsPlans()));
        case "OnDemandCost":
            return Optional.ofNullable(clazz.cast(onDemandCost()));
        case "TotalCost":
            return Optional.ofNullable(clazz.cast(totalCost()));
        case "CoveragePercentage":
            return Optional.ofNullable(clazz.cast(coveragePercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansCoverageData, T> g) {
        return obj -> g.apply((SavingsPlansCoverageData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansCoverageData> {
        /**
         * <p>
         * The amount of your Amazon Web Services usage that is covered by a Savings Plans.
         * </p>
         * 
         * @param spendCoveredBySavingsPlans
         *        The amount of your Amazon Web Services usage that is covered by a Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spendCoveredBySavingsPlans(String spendCoveredBySavingsPlans);

        /**
         * <p>
         * The cost of your Amazon Web Services usage at the public On-Demand rate.
         * </p>
         * 
         * @param onDemandCost
         *        The cost of your Amazon Web Services usage at the public On-Demand rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandCost(String onDemandCost);

        /**
         * <p>
         * The total cost of your Amazon Web Services usage, regardless of your purchase option.
         * </p>
         * 
         * @param totalCost
         *        The total cost of your Amazon Web Services usage, regardless of your purchase option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCost(String totalCost);

        /**
         * <p>
         * The percentage of your existing Savings Plans covered usage, divided by all of your eligible Savings Plans
         * usage in an account (or set of accounts).
         * </p>
         * 
         * @param coveragePercentage
         *        The percentage of your existing Savings Plans covered usage, divided by all of your eligible Savings
         *        Plans usage in an account (or set of accounts).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coveragePercentage(String coveragePercentage);
    }

    static final class BuilderImpl implements Builder {
        private String spendCoveredBySavingsPlans;

        private String onDemandCost;

        private String totalCost;

        private String coveragePercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansCoverageData model) {
            spendCoveredBySavingsPlans(model.spendCoveredBySavingsPlans);
            onDemandCost(model.onDemandCost);
            totalCost(model.totalCost);
            coveragePercentage(model.coveragePercentage);
        }

        public final String getSpendCoveredBySavingsPlans() {
            return spendCoveredBySavingsPlans;
        }

        public final void setSpendCoveredBySavingsPlans(String spendCoveredBySavingsPlans) {
            this.spendCoveredBySavingsPlans = spendCoveredBySavingsPlans;
        }

        @Override
        @Transient
        public final Builder spendCoveredBySavingsPlans(String spendCoveredBySavingsPlans) {
            this.spendCoveredBySavingsPlans = spendCoveredBySavingsPlans;
            return this;
        }

        public final String getOnDemandCost() {
            return onDemandCost;
        }

        public final void setOnDemandCost(String onDemandCost) {
            this.onDemandCost = onDemandCost;
        }

        @Override
        @Transient
        public final Builder onDemandCost(String onDemandCost) {
            this.onDemandCost = onDemandCost;
            return this;
        }

        public final String getTotalCost() {
            return totalCost;
        }

        public final void setTotalCost(String totalCost) {
            this.totalCost = totalCost;
        }

        @Override
        @Transient
        public final Builder totalCost(String totalCost) {
            this.totalCost = totalCost;
            return this;
        }

        public final String getCoveragePercentage() {
            return coveragePercentage;
        }

        public final void setCoveragePercentage(String coveragePercentage) {
            this.coveragePercentage = coveragePercentage;
        }

        @Override
        @Transient
        public final Builder coveragePercentage(String coveragePercentage) {
            this.coveragePercentage = coveragePercentage;
            return this;
        }

        @Override
        public SavingsPlansCoverageData build() {
            return new SavingsPlansCoverageData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
