/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The aggregated utilization metrics for your Savings Plans usage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansUtilizationAggregates implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansUtilizationAggregates.Builder, SavingsPlansUtilizationAggregates> {
    private static final SdkField<SavingsPlansUtilization> UTILIZATION_FIELD = SdkField
            .<SavingsPlansUtilization> builder(MarshallingType.SDK_POJO).memberName("Utilization")
            .getter(getter(SavingsPlansUtilizationAggregates::utilization)).setter(setter(Builder::utilization))
            .constructor(SavingsPlansUtilization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Utilization").build()).build();

    private static final SdkField<SavingsPlansSavings> SAVINGS_FIELD = SdkField
            .<SavingsPlansSavings> builder(MarshallingType.SDK_POJO).memberName("Savings")
            .getter(getter(SavingsPlansUtilizationAggregates::savings)).setter(setter(Builder::savings))
            .constructor(SavingsPlansSavings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Savings").build()).build();

    private static final SdkField<SavingsPlansAmortizedCommitment> AMORTIZED_COMMITMENT_FIELD = SdkField
            .<SavingsPlansAmortizedCommitment> builder(MarshallingType.SDK_POJO).memberName("AmortizedCommitment")
            .getter(getter(SavingsPlansUtilizationAggregates::amortizedCommitment)).setter(setter(Builder::amortizedCommitment))
            .constructor(SavingsPlansAmortizedCommitment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmortizedCommitment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UTILIZATION_FIELD,
            SAVINGS_FIELD, AMORTIZED_COMMITMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final SavingsPlansUtilization utilization;

    private final SavingsPlansSavings savings;

    private final SavingsPlansAmortizedCommitment amortizedCommitment;

    private SavingsPlansUtilizationAggregates(BuilderImpl builder) {
        this.utilization = builder.utilization;
        this.savings = builder.savings;
        this.amortizedCommitment = builder.amortizedCommitment;
    }

    /**
     * <p>
     * A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans
     * eligible.
     * </p>
     * 
     * @return A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings
     *         Plans eligible.
     */
    public final SavingsPlansUtilization utilization() {
        return utilization;
    }

    /**
     * <p>
     * The amount saved by using existing Savings Plans. Savings returns both net savings from Savings Plans, as well as
     * the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.
     * </p>
     * 
     * @return The amount saved by using existing Savings Plans. Savings returns both net savings from Savings Plans, as
     *         well as the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization
     *         rate.
     */
    public final SavingsPlansSavings savings() {
        return savings;
    }

    /**
     * <p>
     * The total amortized commitment for a Savings Plans. This includes the sum of the upfront and recurring Savings
     * Plans fees.
     * </p>
     * 
     * @return The total amortized commitment for a Savings Plans. This includes the sum of the upfront and recurring
     *         Savings Plans fees.
     */
    public final SavingsPlansAmortizedCommitment amortizedCommitment() {
        return amortizedCommitment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(utilization());
        hashCode = 31 * hashCode + Objects.hashCode(savings());
        hashCode = 31 * hashCode + Objects.hashCode(amortizedCommitment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansUtilizationAggregates)) {
            return false;
        }
        SavingsPlansUtilizationAggregates other = (SavingsPlansUtilizationAggregates) obj;
        return Objects.equals(utilization(), other.utilization()) && Objects.equals(savings(), other.savings())
                && Objects.equals(amortizedCommitment(), other.amortizedCommitment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlansUtilizationAggregates").add("Utilization", utilization()).add("Savings", savings())
                .add("AmortizedCommitment", amortizedCommitment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Utilization":
            return Optional.ofNullable(clazz.cast(utilization()));
        case "Savings":
            return Optional.ofNullable(clazz.cast(savings()));
        case "AmortizedCommitment":
            return Optional.ofNullable(clazz.cast(amortizedCommitment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansUtilizationAggregates, T> g) {
        return obj -> g.apply((SavingsPlansUtilizationAggregates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansUtilizationAggregates> {
        /**
         * <p>
         * A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans
         * eligible.
         * </p>
         * 
         * @param utilization
         *        A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings
         *        Plans eligible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utilization(SavingsPlansUtilization utilization);

        /**
         * <p>
         * A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans
         * eligible.
         * </p>
         * This is a convenience that creates an instance of the {@link SavingsPlansUtilization.Builder} avoiding the
         * need to create one manually via {@link SavingsPlansUtilization#builder()}.
         *
         * When the {@link Consumer} completes, {@link SavingsPlansUtilization.Builder#build()} is called immediately
         * and its result is passed to {@link #utilization(SavingsPlansUtilization)}.
         * 
         * @param utilization
         *        a consumer that will call methods on {@link SavingsPlansUtilization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #utilization(SavingsPlansUtilization)
         */
        default Builder utilization(Consumer<SavingsPlansUtilization.Builder> utilization) {
            return utilization(SavingsPlansUtilization.builder().applyMutation(utilization).build());
        }

        /**
         * <p>
         * The amount saved by using existing Savings Plans. Savings returns both net savings from Savings Plans, as
         * well as the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.
         * </p>
         * 
         * @param savings
         *        The amount saved by using existing Savings Plans. Savings returns both net savings from Savings Plans,
         *        as well as the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the
         *        utilization rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savings(SavingsPlansSavings savings);

        /**
         * <p>
         * The amount saved by using existing Savings Plans. Savings returns both net savings from Savings Plans, as
         * well as the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.
         * </p>
         * This is a convenience that creates an instance of the {@link SavingsPlansSavings.Builder} avoiding the need
         * to create one manually via {@link SavingsPlansSavings#builder()}.
         *
         * When the {@link Consumer} completes, {@link SavingsPlansSavings.Builder#build()} is called immediately and
         * its result is passed to {@link #savings(SavingsPlansSavings)}.
         * 
         * @param savings
         *        a consumer that will call methods on {@link SavingsPlansSavings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savings(SavingsPlansSavings)
         */
        default Builder savings(Consumer<SavingsPlansSavings.Builder> savings) {
            return savings(SavingsPlansSavings.builder().applyMutation(savings).build());
        }

        /**
         * <p>
         * The total amortized commitment for a Savings Plans. This includes the sum of the upfront and recurring
         * Savings Plans fees.
         * </p>
         * 
         * @param amortizedCommitment
         *        The total amortized commitment for a Savings Plans. This includes the sum of the upfront and recurring
         *        Savings Plans fees.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amortizedCommitment(SavingsPlansAmortizedCommitment amortizedCommitment);

        /**
         * <p>
         * The total amortized commitment for a Savings Plans. This includes the sum of the upfront and recurring
         * Savings Plans fees.
         * </p>
         * This is a convenience that creates an instance of the {@link SavingsPlansAmortizedCommitment.Builder}
         * avoiding the need to create one manually via {@link SavingsPlansAmortizedCommitment#builder()}.
         *
         * When the {@link Consumer} completes, {@link SavingsPlansAmortizedCommitment.Builder#build()} is called
         * immediately and its result is passed to {@link #amortizedCommitment(SavingsPlansAmortizedCommitment)}.
         * 
         * @param amortizedCommitment
         *        a consumer that will call methods on {@link SavingsPlansAmortizedCommitment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amortizedCommitment(SavingsPlansAmortizedCommitment)
         */
        default Builder amortizedCommitment(Consumer<SavingsPlansAmortizedCommitment.Builder> amortizedCommitment) {
            return amortizedCommitment(SavingsPlansAmortizedCommitment.builder().applyMutation(amortizedCommitment).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SavingsPlansUtilization utilization;

        private SavingsPlansSavings savings;

        private SavingsPlansAmortizedCommitment amortizedCommitment;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansUtilizationAggregates model) {
            utilization(model.utilization);
            savings(model.savings);
            amortizedCommitment(model.amortizedCommitment);
        }

        public final SavingsPlansUtilization.Builder getUtilization() {
            return utilization != null ? utilization.toBuilder() : null;
        }

        public final void setUtilization(SavingsPlansUtilization.BuilderImpl utilization) {
            this.utilization = utilization != null ? utilization.build() : null;
        }

        @Override
        @Transient
        public final Builder utilization(SavingsPlansUtilization utilization) {
            this.utilization = utilization;
            return this;
        }

        public final SavingsPlansSavings.Builder getSavings() {
            return savings != null ? savings.toBuilder() : null;
        }

        public final void setSavings(SavingsPlansSavings.BuilderImpl savings) {
            this.savings = savings != null ? savings.build() : null;
        }

        @Override
        @Transient
        public final Builder savings(SavingsPlansSavings savings) {
            this.savings = savings;
            return this;
        }

        public final SavingsPlansAmortizedCommitment.Builder getAmortizedCommitment() {
            return amortizedCommitment != null ? amortizedCommitment.toBuilder() : null;
        }

        public final void setAmortizedCommitment(SavingsPlansAmortizedCommitment.BuilderImpl amortizedCommitment) {
            this.amortizedCommitment = amortizedCommitment != null ? amortizedCommitment.build() : null;
        }

        @Override
        @Transient
        public final Builder amortizedCommitment(SavingsPlansAmortizedCommitment amortizedCommitment) {
            this.amortizedCommitment = amortizedCommitment;
            return this;
        }

        @Override
        public SavingsPlansUtilizationAggregates build() {
            return new SavingsPlansUtilizationAggregates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
