/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Hardware specifications for the service that you want recommendations for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceSpecification.Builder, ServiceSpecification> {
    private static final SdkField<EC2Specification> EC2_SPECIFICATION_FIELD = SdkField
            .<EC2Specification> builder(MarshallingType.SDK_POJO).memberName("EC2Specification")
            .getter(getter(ServiceSpecification::ec2Specification)).setter(setter(Builder::ec2Specification))
            .constructor(EC2Specification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2Specification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_SPECIFICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final EC2Specification ec2Specification;

    private ServiceSpecification(BuilderImpl builder) {
        this.ec2Specification = builder.ec2Specification;
    }

    /**
     * <p>
     * The Amazon EC2 hardware specifications that you want Amazon Web Services to provide recommendations for.
     * </p>
     * 
     * @return The Amazon EC2 hardware specifications that you want Amazon Web Services to provide recommendations for.
     */
    public final EC2Specification ec2Specification() {
        return ec2Specification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2Specification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSpecification)) {
            return false;
        }
        ServiceSpecification other = (ServiceSpecification) obj;
        return Objects.equals(ec2Specification(), other.ec2Specification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceSpecification").add("EC2Specification", ec2Specification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EC2Specification":
            return Optional.ofNullable(clazz.cast(ec2Specification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceSpecification, T> g) {
        return obj -> g.apply((ServiceSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceSpecification> {
        /**
         * <p>
         * The Amazon EC2 hardware specifications that you want Amazon Web Services to provide recommendations for.
         * </p>
         * 
         * @param ec2Specification
         *        The Amazon EC2 hardware specifications that you want Amazon Web Services to provide recommendations
         *        for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2Specification(EC2Specification ec2Specification);

        /**
         * <p>
         * The Amazon EC2 hardware specifications that you want Amazon Web Services to provide recommendations for.
         * </p>
         * This is a convenience that creates an instance of the {@link EC2Specification.Builder} avoiding the need to
         * create one manually via {@link EC2Specification#builder()}.
         *
         * When the {@link Consumer} completes, {@link EC2Specification.Builder#build()} is called immediately and its
         * result is passed to {@link #ec2Specification(EC2Specification)}.
         * 
         * @param ec2Specification
         *        a consumer that will call methods on {@link EC2Specification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2Specification(EC2Specification)
         */
        default Builder ec2Specification(Consumer<EC2Specification.Builder> ec2Specification) {
            return ec2Specification(EC2Specification.builder().applyMutation(ec2Specification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EC2Specification ec2Specification;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSpecification model) {
            ec2Specification(model.ec2Specification);
        }

        public final EC2Specification.Builder getEc2Specification() {
            return ec2Specification != null ? ec2Specification.toBuilder() : null;
        }

        public final void setEc2Specification(EC2Specification.BuilderImpl ec2Specification) {
            this.ec2Specification = ec2Specification != null ? ec2Specification.build() : null;
        }

        @Override
        @Transient
        public final Builder ec2Specification(EC2Specification ec2Specification) {
            this.ec2Specification = ec2Specification;
            return this;
        }

        @Override
        public ServiceSpecification build() {
            return new ServiceSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
