/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on termination recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminateRecommendationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<TerminateRecommendationDetail.Builder, TerminateRecommendationDetail> {
    private static final SdkField<String> ESTIMATED_MONTHLY_SAVINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedMonthlySavings").getter(getter(TerminateRecommendationDetail::estimatedMonthlySavings))
            .setter(setter(Builder::estimatedMonthlySavings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlySavings").build())
            .build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(TerminateRecommendationDetail::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ESTIMATED_MONTHLY_SAVINGS_FIELD, CURRENCY_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String estimatedMonthlySavings;

    private final String currencyCode;

    private TerminateRecommendationDetail(BuilderImpl builder) {
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
        this.currencyCode = builder.currencyCode;
    }

    /**
     * <p>
     * The estimated savings that result from modification, on a monthly basis.
     * </p>
     * 
     * @return The estimated savings that result from modification, on a monthly basis.
     */
    public final String estimatedMonthlySavings() {
        return estimatedMonthlySavings;
    }

    /**
     * <p>
     * The currency code that Amazon Web Services used to calculate the costs for this instance.
     * </p>
     * 
     * @return The currency code that Amazon Web Services used to calculate the costs for this instance.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlySavings());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateRecommendationDetail)) {
            return false;
        }
        TerminateRecommendationDetail other = (TerminateRecommendationDetail) obj;
        return Objects.equals(estimatedMonthlySavings(), other.estimatedMonthlySavings())
                && Objects.equals(currencyCode(), other.currencyCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TerminateRecommendationDetail").add("EstimatedMonthlySavings", estimatedMonthlySavings())
                .add("CurrencyCode", currencyCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EstimatedMonthlySavings":
            return Optional.ofNullable(clazz.cast(estimatedMonthlySavings()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminateRecommendationDetail, T> g) {
        return obj -> g.apply((TerminateRecommendationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TerminateRecommendationDetail> {
        /**
         * <p>
         * The estimated savings that result from modification, on a monthly basis.
         * </p>
         * 
         * @param estimatedMonthlySavings
         *        The estimated savings that result from modification, on a monthly basis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlySavings(String estimatedMonthlySavings);

        /**
         * <p>
         * The currency code that Amazon Web Services used to calculate the costs for this instance.
         * </p>
         * 
         * @param currencyCode
         *        The currency code that Amazon Web Services used to calculate the costs for this instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);
    }

    static final class BuilderImpl implements Builder {
        private String estimatedMonthlySavings;

        private String currencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateRecommendationDetail model) {
            estimatedMonthlySavings(model.estimatedMonthlySavings);
            currencyCode(model.currencyCode);
        }

        public final String getEstimatedMonthlySavings() {
            return estimatedMonthlySavings;
        }

        public final void setEstimatedMonthlySavings(String estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
        }

        @Override
        @Transient
        public final Builder estimatedMonthlySavings(String estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        @Transient
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public TerminateRecommendationDetail build() {
            return new TerminateRecommendationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
