/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The amount of utilization, in hours.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UtilizationByTime implements SdkPojo, Serializable,
        ToCopyableBuilder<UtilizationByTime.Builder, UtilizationByTime> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .memberName("TimePeriod").getter(getter(UtilizationByTime::timePeriod)).setter(setter(Builder::timePeriod))
            .constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final SdkField<List<ReservationUtilizationGroup>> GROUPS_FIELD = SdkField
            .<List<ReservationUtilizationGroup>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(UtilizationByTime::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReservationUtilizationGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservationUtilizationGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ReservationAggregates> TOTAL_FIELD = SdkField
            .<ReservationAggregates> builder(MarshallingType.SDK_POJO).memberName("Total")
            .getter(getter(UtilizationByTime::total)).setter(setter(Builder::total)).constructor(ReservationAggregates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD,
            GROUPS_FIELD, TOTAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final DateInterval timePeriod;

    private final List<ReservationUtilizationGroup> groups;

    private final ReservationAggregates total;

    private UtilizationByTime(BuilderImpl builder) {
        this.timePeriod = builder.timePeriod;
        this.groups = builder.groups;
        this.total = builder.total;
    }

    /**
     * <p>
     * The period of time that this utilization was used for.
     * </p>
     * 
     * @return The period of time that this utilization was used for.
     */
    public final DateInterval timePeriod() {
        return timePeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The groups that this utilization result uses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return The groups that this utilization result uses.
     */
    public final List<ReservationUtilizationGroup> groups() {
        return groups;
    }

    /**
     * <p>
     * The total number of reservation hours that were used.
     * </p>
     * 
     * @return The total number of reservation hours that were used.
     */
    public final ReservationAggregates total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtilizationByTime)) {
            return false;
        }
        UtilizationByTime other = (UtilizationByTime) obj;
        return Objects.equals(timePeriod(), other.timePeriod()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups()) && Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UtilizationByTime").add("TimePeriod", timePeriod()).add("Groups", hasGroups() ? groups() : null)
                .add("Total", total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UtilizationByTime, T> g) {
        return obj -> g.apply((UtilizationByTime) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UtilizationByTime> {
        /**
         * <p>
         * The period of time that this utilization was used for.
         * </p>
         * 
         * @param timePeriod
         *        The period of time that this utilization was used for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * <p>
         * The period of time that this utilization was used for.
         * </p>
         * This is a convenience that creates an instance of the {@link DateInterval.Builder} avoiding the need to
         * create one manually via {@link DateInterval#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }

        /**
         * <p>
         * The groups that this utilization result uses.
         * </p>
         * 
         * @param groups
         *        The groups that this utilization result uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<ReservationUtilizationGroup> groups);

        /**
         * <p>
         * The groups that this utilization result uses.
         * </p>
         * 
         * @param groups
         *        The groups that this utilization result uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(ReservationUtilizationGroup... groups);

        /**
         * <p>
         * The groups that this utilization result uses.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReservationUtilizationGroup>.Builder}
         * avoiding the need to create one manually via {@link List<ReservationUtilizationGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservationUtilizationGroup>.Builder#build()} is called
         * immediately and its result is passed to {@link #groups(List<ReservationUtilizationGroup>)}.
         * 
         * @param groups
         *        a consumer that will call methods on {@link List<ReservationUtilizationGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(List<ReservationUtilizationGroup>)
         */
        Builder groups(Consumer<ReservationUtilizationGroup.Builder>... groups);

        /**
         * <p>
         * The total number of reservation hours that were used.
         * </p>
         * 
         * @param total
         *        The total number of reservation hours that were used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(ReservationAggregates total);

        /**
         * <p>
         * The total number of reservation hours that were used.
         * </p>
         * This is a convenience that creates an instance of the {@link ReservationAggregates.Builder} avoiding the need
         * to create one manually via {@link ReservationAggregates#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservationAggregates.Builder#build()} is called immediately and
         * its result is passed to {@link #total(ReservationAggregates)}.
         * 
         * @param total
         *        a consumer that will call methods on {@link ReservationAggregates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #total(ReservationAggregates)
         */
        default Builder total(Consumer<ReservationAggregates.Builder> total) {
            return total(ReservationAggregates.builder().applyMutation(total).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DateInterval timePeriod;

        private List<ReservationUtilizationGroup> groups = DefaultSdkAutoConstructList.getInstance();

        private ReservationAggregates total;

        private BuilderImpl() {
        }

        private BuilderImpl(UtilizationByTime model) {
            timePeriod(model.timePeriod);
            groups(model.groups);
            total(model.total);
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        @Transient
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final List<ReservationUtilizationGroup.Builder> getGroups() {
            List<ReservationUtilizationGroup.Builder> result = ReservationUtilizationGroupsCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<ReservationUtilizationGroup.BuilderImpl> groups) {
            this.groups = ReservationUtilizationGroupsCopier.copyFromBuilder(groups);
        }

        @Override
        @Transient
        public final Builder groups(Collection<ReservationUtilizationGroup> groups) {
            this.groups = ReservationUtilizationGroupsCopier.copy(groups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groups(ReservationUtilizationGroup... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groups(Consumer<ReservationUtilizationGroup.Builder>... groups) {
            groups(Stream.of(groups).map(c -> ReservationUtilizationGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ReservationAggregates.Builder getTotal() {
            return total != null ? total.toBuilder() : null;
        }

        public final void setTotal(ReservationAggregates.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        @Override
        @Transient
        public final Builder total(ReservationAggregates total) {
            this.total = total;
            return this;
        }

        @Override
        public UtilizationByTime build() {
            return new UtilizationByTime(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
