/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCostAllocationTagBackfillResponse extends CostExplorerResponse implements
        ToCopyableBuilder<StartCostAllocationTagBackfillResponse.Builder, StartCostAllocationTagBackfillResponse> {
    private static final SdkField<CostAllocationTagBackfillRequest> BACKFILL_REQUEST_FIELD = SdkField
            .<CostAllocationTagBackfillRequest> builder(MarshallingType.SDK_POJO).memberName("BackfillRequest")
            .getter(getter(StartCostAllocationTagBackfillResponse::backfillRequest)).setter(setter(Builder::backfillRequest))
            .constructor(CostAllocationTagBackfillRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackfillRequest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKFILL_REQUEST_FIELD));

    private final CostAllocationTagBackfillRequest backfillRequest;

    private StartCostAllocationTagBackfillResponse(BuilderImpl builder) {
        super(builder);
        this.backfillRequest = builder.backfillRequest;
    }

    /**
     * <p>
     * An object containing detailed metadata of your new backfill request.
     * </p>
     * 
     * @return An object containing detailed metadata of your new backfill request.
     */
    public final CostAllocationTagBackfillRequest backfillRequest() {
        return backfillRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backfillRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCostAllocationTagBackfillResponse)) {
            return false;
        }
        StartCostAllocationTagBackfillResponse other = (StartCostAllocationTagBackfillResponse) obj;
        return Objects.equals(backfillRequest(), other.backfillRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCostAllocationTagBackfillResponse").add("BackfillRequest", backfillRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackfillRequest":
            return Optional.ofNullable(clazz.cast(backfillRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartCostAllocationTagBackfillResponse, T> g) {
        return obj -> g.apply((StartCostAllocationTagBackfillResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartCostAllocationTagBackfillResponse> {
        /**
         * <p>
         * An object containing detailed metadata of your new backfill request.
         * </p>
         * 
         * @param backfillRequest
         *        An object containing detailed metadata of your new backfill request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backfillRequest(CostAllocationTagBackfillRequest backfillRequest);

        /**
         * <p>
         * An object containing detailed metadata of your new backfill request.
         * </p>
         * This is a convenience method that creates an instance of the {@link CostAllocationTagBackfillRequest.Builder}
         * avoiding the need to create one manually via {@link CostAllocationTagBackfillRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CostAllocationTagBackfillRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #backfillRequest(CostAllocationTagBackfillRequest)}.
         * 
         * @param backfillRequest
         *        a consumer that will call methods on {@link CostAllocationTagBackfillRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backfillRequest(CostAllocationTagBackfillRequest)
         */
        default Builder backfillRequest(Consumer<CostAllocationTagBackfillRequest.Builder> backfillRequest) {
            return backfillRequest(CostAllocationTagBackfillRequest.builder().applyMutation(backfillRequest).build());
        }
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private CostAllocationTagBackfillRequest backfillRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCostAllocationTagBackfillResponse model) {
            super(model);
            backfillRequest(model.backfillRequest);
        }

        public final CostAllocationTagBackfillRequest.Builder getBackfillRequest() {
            return backfillRequest != null ? backfillRequest.toBuilder() : null;
        }

        public final void setBackfillRequest(CostAllocationTagBackfillRequest.BuilderImpl backfillRequest) {
            this.backfillRequest = backfillRequest != null ? backfillRequest.build() : null;
        }

        @Override
        public final Builder backfillRequest(CostAllocationTagBackfillRequest backfillRequest) {
            this.backfillRequest = backfillRequest;
            return this;
        }

        @Override
        public StartCostAllocationTagBackfillResponse build() {
            return new StartCostAllocationTagBackfillResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
