/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata for a recommendation set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RightsizingRecommendationMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<RightsizingRecommendationMetadata.Builder, RightsizingRecommendationMetadata> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationId").getter(getter(RightsizingRecommendationMetadata::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()).build();

    private static final SdkField<String> GENERATION_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GenerationTimestamp").getter(getter(RightsizingRecommendationMetadata::generationTimestamp))
            .setter(setter(Builder::generationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationTimestamp").build())
            .build();

    private static final SdkField<String> LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LookbackPeriodInDays").getter(getter(RightsizingRecommendationMetadata::lookbackPeriodInDaysAsString))
            .setter(setter(Builder::lookbackPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackPeriodInDays").build())
            .build();

    private static final SdkField<String> ADDITIONAL_METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdditionalMetadata").getter(getter(RightsizingRecommendationMetadata::additionalMetadata))
            .setter(setter(Builder::additionalMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalMetadata").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD,
            GENERATION_TIMESTAMP_FIELD, LOOKBACK_PERIOD_IN_DAYS_FIELD, ADDITIONAL_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recommendationId;

    private final String generationTimestamp;

    private final String lookbackPeriodInDays;

    private final String additionalMetadata;

    private RightsizingRecommendationMetadata(BuilderImpl builder) {
        this.recommendationId = builder.recommendationId;
        this.generationTimestamp = builder.generationTimestamp;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
        this.additionalMetadata = builder.additionalMetadata;
    }

    /**
     * <p>
     * The ID for the recommendation.
     * </p>
     * 
     * @return The ID for the recommendation.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * The timestamp for when Amazon Web Services made the recommendation.
     * </p>
     * 
     * @return The timestamp for when Amazon Web Services made the recommendation.
     */
    public final String generationTimestamp() {
        return generationTimestamp;
    }

    /**
     * <p>
     * The number of days of previous usage that Amazon Web Services considers when making the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookbackPeriodInDays} will return {@link LookbackPeriodInDays#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookbackPeriodInDaysAsString}.
     * </p>
     * 
     * @return The number of days of previous usage that Amazon Web Services considers when making the recommendation.
     * @see LookbackPeriodInDays
     */
    public final LookbackPeriodInDays lookbackPeriodInDays() {
        return LookbackPeriodInDays.fromValue(lookbackPeriodInDays);
    }

    /**
     * <p>
     * The number of days of previous usage that Amazon Web Services considers when making the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookbackPeriodInDays} will return {@link LookbackPeriodInDays#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookbackPeriodInDaysAsString}.
     * </p>
     * 
     * @return The number of days of previous usage that Amazon Web Services considers when making the recommendation.
     * @see LookbackPeriodInDays
     */
    public final String lookbackPeriodInDaysAsString() {
        return lookbackPeriodInDays;
    }

    /**
     * <p>
     * Additional metadata that might be applicable to the recommendation.
     * </p>
     * 
     * @return Additional metadata that might be applicable to the recommendation.
     */
    public final String additionalMetadata() {
        return additionalMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(generationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lookbackPeriodInDaysAsString());
        hashCode = 31 * hashCode + Objects.hashCode(additionalMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RightsizingRecommendationMetadata)) {
            return false;
        }
        RightsizingRecommendationMetadata other = (RightsizingRecommendationMetadata) obj;
        return Objects.equals(recommendationId(), other.recommendationId())
                && Objects.equals(generationTimestamp(), other.generationTimestamp())
                && Objects.equals(lookbackPeriodInDaysAsString(), other.lookbackPeriodInDaysAsString())
                && Objects.equals(additionalMetadata(), other.additionalMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RightsizingRecommendationMetadata").add("RecommendationId", recommendationId())
                .add("GenerationTimestamp", generationTimestamp()).add("LookbackPeriodInDays", lookbackPeriodInDaysAsString())
                .add("AdditionalMetadata", additionalMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "GenerationTimestamp":
            return Optional.ofNullable(clazz.cast(generationTimestamp()));
        case "LookbackPeriodInDays":
            return Optional.ofNullable(clazz.cast(lookbackPeriodInDaysAsString()));
        case "AdditionalMetadata":
            return Optional.ofNullable(clazz.cast(additionalMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RightsizingRecommendationMetadata, T> g) {
        return obj -> g.apply((RightsizingRecommendationMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RightsizingRecommendationMetadata> {
        /**
         * <p>
         * The ID for the recommendation.
         * </p>
         * 
         * @param recommendationId
         *        The ID for the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * The timestamp for when Amazon Web Services made the recommendation.
         * </p>
         * 
         * @param generationTimestamp
         *        The timestamp for when Amazon Web Services made the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationTimestamp(String generationTimestamp);

        /**
         * <p>
         * The number of days of previous usage that Amazon Web Services considers when making the recommendation.
         * </p>
         * 
         * @param lookbackPeriodInDays
         *        The number of days of previous usage that Amazon Web Services considers when making the
         *        recommendation.
         * @see LookbackPeriodInDays
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookbackPeriodInDays
         */
        Builder lookbackPeriodInDays(String lookbackPeriodInDays);

        /**
         * <p>
         * The number of days of previous usage that Amazon Web Services considers when making the recommendation.
         * </p>
         * 
         * @param lookbackPeriodInDays
         *        The number of days of previous usage that Amazon Web Services considers when making the
         *        recommendation.
         * @see LookbackPeriodInDays
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookbackPeriodInDays
         */
        Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays);

        /**
         * <p>
         * Additional metadata that might be applicable to the recommendation.
         * </p>
         * 
         * @param additionalMetadata
         *        Additional metadata that might be applicable to the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMetadata(String additionalMetadata);
    }

    static final class BuilderImpl implements Builder {
        private String recommendationId;

        private String generationTimestamp;

        private String lookbackPeriodInDays;

        private String additionalMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(RightsizingRecommendationMetadata model) {
            recommendationId(model.recommendationId);
            generationTimestamp(model.generationTimestamp);
            lookbackPeriodInDays(model.lookbackPeriodInDays);
            additionalMetadata(model.additionalMetadata);
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getGenerationTimestamp() {
            return generationTimestamp;
        }

        public final void setGenerationTimestamp(String generationTimestamp) {
            this.generationTimestamp = generationTimestamp;
        }

        @Override
        public final Builder generationTimestamp(String generationTimestamp) {
            this.generationTimestamp = generationTimestamp;
            return this;
        }

        public final String getLookbackPeriodInDays() {
            return lookbackPeriodInDays;
        }

        public final void setLookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        @Override
        public final Builder lookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        @Override
        public final Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays) {
            this.lookbackPeriodInDays(lookbackPeriodInDays == null ? null : lookbackPeriodInDays.toString());
            return this;
        }

        public final String getAdditionalMetadata() {
            return additionalMetadata;
        }

        public final void setAdditionalMetadata(String additionalMetadata) {
            this.additionalMetadata = additionalMetadata;
        }

        @Override
        public final Builder additionalMetadata(String additionalMetadata) {
            this.additionalMetadata = additionalMetadata;
            return this;
        }

        @Override
        public RightsizingRecommendationMetadata build() {
            return new RightsizingRecommendationMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
