/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCostAllocationTagBackfillRequest extends CostExplorerRequest implements
        ToCopyableBuilder<StartCostAllocationTagBackfillRequest.Builder, StartCostAllocationTagBackfillRequest> {
    private static final SdkField<String> BACKFILL_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackfillFrom").getter(getter(StartCostAllocationTagBackfillRequest::backfillFrom))
            .setter(setter(Builder::backfillFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackfillFrom").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKFILL_FROM_FIELD));

    private final String backfillFrom;

    private StartCostAllocationTagBackfillRequest(BuilderImpl builder) {
        super(builder);
        this.backfillFrom = builder.backfillFrom;
    }

    /**
     * <p>
     * The date you want the backfill to start from. The date can only be a first day of the month (a billing start
     * date). Dates can't precede the previous twelve months, or in the future.
     * </p>
     * 
     * @return The date you want the backfill to start from. The date can only be a first day of the month (a billing
     *         start date). Dates can't precede the previous twelve months, or in the future.
     */
    public final String backfillFrom() {
        return backfillFrom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backfillFrom());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCostAllocationTagBackfillRequest)) {
            return false;
        }
        StartCostAllocationTagBackfillRequest other = (StartCostAllocationTagBackfillRequest) obj;
        return Objects.equals(backfillFrom(), other.backfillFrom());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCostAllocationTagBackfillRequest").add("BackfillFrom", backfillFrom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackfillFrom":
            return Optional.ofNullable(clazz.cast(backfillFrom()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartCostAllocationTagBackfillRequest, T> g) {
        return obj -> g.apply((StartCostAllocationTagBackfillRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartCostAllocationTagBackfillRequest> {
        /**
         * <p>
         * The date you want the backfill to start from. The date can only be a first day of the month (a billing start
         * date). Dates can't precede the previous twelve months, or in the future.
         * </p>
         * 
         * @param backfillFrom
         *        The date you want the backfill to start from. The date can only be a first day of the month (a billing
         *        start date). Dates can't precede the previous twelve months, or in the future.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backfillFrom(String backfillFrom);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String backfillFrom;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCostAllocationTagBackfillRequest model) {
            super(model);
            backfillFrom(model.backfillFrom);
        }

        public final String getBackfillFrom() {
            return backfillFrom;
        }

        public final void setBackfillFrom(String backfillFrom) {
            this.backfillFrom = backfillFrom;
        }

        @Override
        public final Builder backfillFrom(String backfillFrom) {
            this.backfillFrom = backfillFrom;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCostAllocationTagBackfillRequest build() {
            return new StartCostAllocationTagBackfillRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
