/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.AccountScope;
import software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays;
import software.amazon.awssdk.services.costexplorer.model.MetricsOverLookbackPeriodCopier;
import software.amazon.awssdk.services.costexplorer.model.PaymentOption;
import software.amazon.awssdk.services.costexplorer.model.RecommendationDetailHourlyMetrics;
import software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType;
import software.amazon.awssdk.services.costexplorer.model.TermInYears;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationDetailData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationDetailData> {
    private static final SdkField<String> ACCOUNT_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountScope").getter(RecommendationDetailData.getter(RecommendationDetailData::accountScopeAsString)).setter(RecommendationDetailData.setter(Builder::accountScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountScope").build()}).build();
    private static final SdkField<String> LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LookbackPeriodInDays").getter(RecommendationDetailData.getter(RecommendationDetailData::lookbackPeriodInDaysAsString)).setter(RecommendationDetailData.setter(Builder::lookbackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackPeriodInDays").build()}).build();
    private static final SdkField<String> SAVINGS_PLANS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SavingsPlansType").getter(RecommendationDetailData.getter(RecommendationDetailData::savingsPlansTypeAsString)).setter(RecommendationDetailData.setter(Builder::savingsPlansType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansType").build()}).build();
    private static final SdkField<String> TERM_IN_YEARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TermInYears").getter(RecommendationDetailData.getter(RecommendationDetailData::termInYearsAsString)).setter(RecommendationDetailData.setter(Builder::termInYears)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermInYears").build()}).build();
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaymentOption").getter(RecommendationDetailData.getter(RecommendationDetailData::paymentOptionAsString)).setter(RecommendationDetailData.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(RecommendationDetailData.getter(RecommendationDetailData::accountId)).setter(RecommendationDetailData.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(RecommendationDetailData.getter(RecommendationDetailData::currencyCode)).setter(RecommendationDetailData.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceFamily").getter(RecommendationDetailData.getter(RecommendationDetailData::instanceFamily)).setter(RecommendationDetailData.setter(Builder::instanceFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(RecommendationDetailData.getter(RecommendationDetailData::region)).setter(RecommendationDetailData.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingId").getter(RecommendationDetailData.getter(RecommendationDetailData::offeringId)).setter(RecommendationDetailData.setter(Builder::offeringId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingId").build()}).build();
    private static final SdkField<String> GENERATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GenerationTimestamp").getter(RecommendationDetailData.getter(RecommendationDetailData::generationTimestamp)).setter(RecommendationDetailData.setter(Builder::generationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationTimestamp").build()}).build();
    private static final SdkField<String> LATEST_USAGE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestUsageTimestamp").getter(RecommendationDetailData.getter(RecommendationDetailData::latestUsageTimestamp)).setter(RecommendationDetailData.setter(Builder::latestUsageTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestUsageTimestamp").build()}).build();
    private static final SdkField<String> CURRENT_AVERAGE_HOURLY_ON_DEMAND_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentAverageHourlyOnDemandSpend").getter(RecommendationDetailData.getter(RecommendationDetailData::currentAverageHourlyOnDemandSpend)).setter(RecommendationDetailData.setter(Builder::currentAverageHourlyOnDemandSpend)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAverageHourlyOnDemandSpend").build()}).build();
    private static final SdkField<String> CURRENT_MAXIMUM_HOURLY_ON_DEMAND_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentMaximumHourlyOnDemandSpend").getter(RecommendationDetailData.getter(RecommendationDetailData::currentMaximumHourlyOnDemandSpend)).setter(RecommendationDetailData.setter(Builder::currentMaximumHourlyOnDemandSpend)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentMaximumHourlyOnDemandSpend").build()}).build();
    private static final SdkField<String> CURRENT_MINIMUM_HOURLY_ON_DEMAND_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentMinimumHourlyOnDemandSpend").getter(RecommendationDetailData.getter(RecommendationDetailData::currentMinimumHourlyOnDemandSpend)).setter(RecommendationDetailData.setter(Builder::currentMinimumHourlyOnDemandSpend)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentMinimumHourlyOnDemandSpend").build()}).build();
    private static final SdkField<String> ESTIMATED_AVERAGE_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedAverageUtilization").getter(RecommendationDetailData.getter(RecommendationDetailData::estimatedAverageUtilization)).setter(RecommendationDetailData.setter(Builder::estimatedAverageUtilization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedAverageUtilization").build()}).build();
    private static final SdkField<String> ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedMonthlySavingsAmount").getter(RecommendationDetailData.getter(RecommendationDetailData::estimatedMonthlySavingsAmount)).setter(RecommendationDetailData.setter(Builder::estimatedMonthlySavingsAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlySavingsAmount").build()}).build();
    private static final SdkField<String> ESTIMATED_ON_DEMAND_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedOnDemandCost").getter(RecommendationDetailData.getter(RecommendationDetailData::estimatedOnDemandCost)).setter(RecommendationDetailData.setter(Builder::estimatedOnDemandCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedOnDemandCost").build()}).build();
    private static final SdkField<String> ESTIMATED_ON_DEMAND_COST_WITH_CURRENT_COMMITMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedOnDemandCostWithCurrentCommitment").getter(RecommendationDetailData.getter(RecommendationDetailData::estimatedOnDemandCostWithCurrentCommitment)).setter(RecommendationDetailData.setter(Builder::estimatedOnDemandCostWithCurrentCommitment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedOnDemandCostWithCurrentCommitment").build()}).build();
    private static final SdkField<String> ESTIMATED_ROI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedROI").getter(RecommendationDetailData.getter(RecommendationDetailData::estimatedROI)).setter(RecommendationDetailData.setter(Builder::estimatedROI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedROI").build()}).build();
    private static final SdkField<String> ESTIMATED_SP_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedSPCost").getter(RecommendationDetailData.getter(RecommendationDetailData::estimatedSPCost)).setter(RecommendationDetailData.setter(Builder::estimatedSPCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSPCost").build()}).build();
    private static final SdkField<String> ESTIMATED_SAVINGS_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedSavingsAmount").getter(RecommendationDetailData.getter(RecommendationDetailData::estimatedSavingsAmount)).setter(RecommendationDetailData.setter(Builder::estimatedSavingsAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSavingsAmount").build()}).build();
    private static final SdkField<String> ESTIMATED_SAVINGS_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedSavingsPercentage").getter(RecommendationDetailData.getter(RecommendationDetailData::estimatedSavingsPercentage)).setter(RecommendationDetailData.setter(Builder::estimatedSavingsPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSavingsPercentage").build()}).build();
    private static final SdkField<String> EXISTING_HOURLY_COMMITMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExistingHourlyCommitment").getter(RecommendationDetailData.getter(RecommendationDetailData::existingHourlyCommitment)).setter(RecommendationDetailData.setter(Builder::existingHourlyCommitment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExistingHourlyCommitment").build()}).build();
    private static final SdkField<String> HOURLY_COMMITMENT_TO_PURCHASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HourlyCommitmentToPurchase").getter(RecommendationDetailData.getter(RecommendationDetailData::hourlyCommitmentToPurchase)).setter(RecommendationDetailData.setter(Builder::hourlyCommitmentToPurchase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyCommitmentToPurchase").build()}).build();
    private static final SdkField<String> UPFRONT_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpfrontCost").getter(RecommendationDetailData.getter(RecommendationDetailData::upfrontCost)).setter(RecommendationDetailData.setter(Builder::upfrontCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontCost").build()}).build();
    private static final SdkField<String> CURRENT_AVERAGE_COVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentAverageCoverage").getter(RecommendationDetailData.getter(RecommendationDetailData::currentAverageCoverage)).setter(RecommendationDetailData.setter(Builder::currentAverageCoverage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAverageCoverage").build()}).build();
    private static final SdkField<String> ESTIMATED_AVERAGE_COVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedAverageCoverage").getter(RecommendationDetailData.getter(RecommendationDetailData::estimatedAverageCoverage)).setter(RecommendationDetailData.setter(Builder::estimatedAverageCoverage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedAverageCoverage").build()}).build();
    private static final SdkField<List<RecommendationDetailHourlyMetrics>> METRICS_OVER_LOOKBACK_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricsOverLookbackPeriod").getter(RecommendationDetailData.getter(RecommendationDetailData::metricsOverLookbackPeriod)).setter(RecommendationDetailData.setter(Builder::metricsOverLookbackPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsOverLookbackPeriod").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationDetailHourlyMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SCOPE_FIELD, LOOKBACK_PERIOD_IN_DAYS_FIELD, SAVINGS_PLANS_TYPE_FIELD, TERM_IN_YEARS_FIELD, PAYMENT_OPTION_FIELD, ACCOUNT_ID_FIELD, CURRENCY_CODE_FIELD, INSTANCE_FAMILY_FIELD, REGION_FIELD, OFFERING_ID_FIELD, GENERATION_TIMESTAMP_FIELD, LATEST_USAGE_TIMESTAMP_FIELD, CURRENT_AVERAGE_HOURLY_ON_DEMAND_SPEND_FIELD, CURRENT_MAXIMUM_HOURLY_ON_DEMAND_SPEND_FIELD, CURRENT_MINIMUM_HOURLY_ON_DEMAND_SPEND_FIELD, ESTIMATED_AVERAGE_UTILIZATION_FIELD, ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD, ESTIMATED_ON_DEMAND_COST_FIELD, ESTIMATED_ON_DEMAND_COST_WITH_CURRENT_COMMITMENT_FIELD, ESTIMATED_ROI_FIELD, ESTIMATED_SP_COST_FIELD, ESTIMATED_SAVINGS_AMOUNT_FIELD, ESTIMATED_SAVINGS_PERCENTAGE_FIELD, EXISTING_HOURLY_COMMITMENT_FIELD, HOURLY_COMMITMENT_TO_PURCHASE_FIELD, UPFRONT_COST_FIELD, CURRENT_AVERAGE_COVERAGE_FIELD, ESTIMATED_AVERAGE_COVERAGE_FIELD, METRICS_OVER_LOOKBACK_PERIOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountScope;
    private final String lookbackPeriodInDays;
    private final String savingsPlansType;
    private final String termInYears;
    private final String paymentOption;
    private final String accountId;
    private final String currencyCode;
    private final String instanceFamily;
    private final String region;
    private final String offeringId;
    private final String generationTimestamp;
    private final String latestUsageTimestamp;
    private final String currentAverageHourlyOnDemandSpend;
    private final String currentMaximumHourlyOnDemandSpend;
    private final String currentMinimumHourlyOnDemandSpend;
    private final String estimatedAverageUtilization;
    private final String estimatedMonthlySavingsAmount;
    private final String estimatedOnDemandCost;
    private final String estimatedOnDemandCostWithCurrentCommitment;
    private final String estimatedROI;
    private final String estimatedSPCost;
    private final String estimatedSavingsAmount;
    private final String estimatedSavingsPercentage;
    private final String existingHourlyCommitment;
    private final String hourlyCommitmentToPurchase;
    private final String upfrontCost;
    private final String currentAverageCoverage;
    private final String estimatedAverageCoverage;
    private final List<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod;

    private RecommendationDetailData(BuilderImpl builder) {
        this.accountScope = builder.accountScope;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
        this.savingsPlansType = builder.savingsPlansType;
        this.termInYears = builder.termInYears;
        this.paymentOption = builder.paymentOption;
        this.accountId = builder.accountId;
        this.currencyCode = builder.currencyCode;
        this.instanceFamily = builder.instanceFamily;
        this.region = builder.region;
        this.offeringId = builder.offeringId;
        this.generationTimestamp = builder.generationTimestamp;
        this.latestUsageTimestamp = builder.latestUsageTimestamp;
        this.currentAverageHourlyOnDemandSpend = builder.currentAverageHourlyOnDemandSpend;
        this.currentMaximumHourlyOnDemandSpend = builder.currentMaximumHourlyOnDemandSpend;
        this.currentMinimumHourlyOnDemandSpend = builder.currentMinimumHourlyOnDemandSpend;
        this.estimatedAverageUtilization = builder.estimatedAverageUtilization;
        this.estimatedMonthlySavingsAmount = builder.estimatedMonthlySavingsAmount;
        this.estimatedOnDemandCost = builder.estimatedOnDemandCost;
        this.estimatedOnDemandCostWithCurrentCommitment = builder.estimatedOnDemandCostWithCurrentCommitment;
        this.estimatedROI = builder.estimatedROI;
        this.estimatedSPCost = builder.estimatedSPCost;
        this.estimatedSavingsAmount = builder.estimatedSavingsAmount;
        this.estimatedSavingsPercentage = builder.estimatedSavingsPercentage;
        this.existingHourlyCommitment = builder.existingHourlyCommitment;
        this.hourlyCommitmentToPurchase = builder.hourlyCommitmentToPurchase;
        this.upfrontCost = builder.upfrontCost;
        this.currentAverageCoverage = builder.currentAverageCoverage;
        this.estimatedAverageCoverage = builder.estimatedAverageCoverage;
        this.metricsOverLookbackPeriod = builder.metricsOverLookbackPeriod;
    }

    public final AccountScope accountScope() {
        return AccountScope.fromValue(this.accountScope);
    }

    public final String accountScopeAsString() {
        return this.accountScope;
    }

    public final LookbackPeriodInDays lookbackPeriodInDays() {
        return LookbackPeriodInDays.fromValue(this.lookbackPeriodInDays);
    }

    public final String lookbackPeriodInDaysAsString() {
        return this.lookbackPeriodInDays;
    }

    public final SupportedSavingsPlansType savingsPlansType() {
        return SupportedSavingsPlansType.fromValue(this.savingsPlansType);
    }

    public final String savingsPlansTypeAsString() {
        return this.savingsPlansType;
    }

    public final TermInYears termInYears() {
        return TermInYears.fromValue(this.termInYears);
    }

    public final String termInYearsAsString() {
        return this.termInYears;
    }

    public final PaymentOption paymentOption() {
        return PaymentOption.fromValue(this.paymentOption);
    }

    public final String paymentOptionAsString() {
        return this.paymentOption;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final String instanceFamily() {
        return this.instanceFamily;
    }

    public final String region() {
        return this.region;
    }

    public final String offeringId() {
        return this.offeringId;
    }

    public final String generationTimestamp() {
        return this.generationTimestamp;
    }

    public final String latestUsageTimestamp() {
        return this.latestUsageTimestamp;
    }

    public final String currentAverageHourlyOnDemandSpend() {
        return this.currentAverageHourlyOnDemandSpend;
    }

    public final String currentMaximumHourlyOnDemandSpend() {
        return this.currentMaximumHourlyOnDemandSpend;
    }

    public final String currentMinimumHourlyOnDemandSpend() {
        return this.currentMinimumHourlyOnDemandSpend;
    }

    public final String estimatedAverageUtilization() {
        return this.estimatedAverageUtilization;
    }

    public final String estimatedMonthlySavingsAmount() {
        return this.estimatedMonthlySavingsAmount;
    }

    public final String estimatedOnDemandCost() {
        return this.estimatedOnDemandCost;
    }

    public final String estimatedOnDemandCostWithCurrentCommitment() {
        return this.estimatedOnDemandCostWithCurrentCommitment;
    }

    public final String estimatedROI() {
        return this.estimatedROI;
    }

    public final String estimatedSPCost() {
        return this.estimatedSPCost;
    }

    public final String estimatedSavingsAmount() {
        return this.estimatedSavingsAmount;
    }

    public final String estimatedSavingsPercentage() {
        return this.estimatedSavingsPercentage;
    }

    public final String existingHourlyCommitment() {
        return this.existingHourlyCommitment;
    }

    public final String hourlyCommitmentToPurchase() {
        return this.hourlyCommitmentToPurchase;
    }

    public final String upfrontCost() {
        return this.upfrontCost;
    }

    public final String currentAverageCoverage() {
        return this.currentAverageCoverage;
    }

    public final String estimatedAverageCoverage() {
        return this.estimatedAverageCoverage;
    }

    public final boolean hasMetricsOverLookbackPeriod() {
        return this.metricsOverLookbackPeriod != null && !(this.metricsOverLookbackPeriod instanceof SdkAutoConstructList);
    }

    public final List<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod() {
        return this.metricsOverLookbackPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookbackPeriodInDaysAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlansTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.termInYearsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestUsageTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentAverageHourlyOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentMaximumHourlyOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentMinimumHourlyOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedAverageUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlySavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedOnDemandCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedOnDemandCostWithCurrentCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedROI());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedSPCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedSavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedSavingsPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.existingHourlyCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(this.hourlyCommitmentToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(this.upfrontCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentAverageCoverage());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedAverageCoverage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricsOverLookbackPeriod() ? this.metricsOverLookbackPeriod() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationDetailData)) {
            return false;
        }
        RecommendationDetailData other = (RecommendationDetailData)obj;
        return Objects.equals(this.accountScopeAsString(), other.accountScopeAsString()) && Objects.equals(this.lookbackPeriodInDaysAsString(), other.lookbackPeriodInDaysAsString()) && Objects.equals(this.savingsPlansTypeAsString(), other.savingsPlansTypeAsString()) && Objects.equals(this.termInYearsAsString(), other.termInYearsAsString()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.instanceFamily(), other.instanceFamily()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.offeringId(), other.offeringId()) && Objects.equals(this.generationTimestamp(), other.generationTimestamp()) && Objects.equals(this.latestUsageTimestamp(), other.latestUsageTimestamp()) && Objects.equals(this.currentAverageHourlyOnDemandSpend(), other.currentAverageHourlyOnDemandSpend()) && Objects.equals(this.currentMaximumHourlyOnDemandSpend(), other.currentMaximumHourlyOnDemandSpend()) && Objects.equals(this.currentMinimumHourlyOnDemandSpend(), other.currentMinimumHourlyOnDemandSpend()) && Objects.equals(this.estimatedAverageUtilization(), other.estimatedAverageUtilization()) && Objects.equals(this.estimatedMonthlySavingsAmount(), other.estimatedMonthlySavingsAmount()) && Objects.equals(this.estimatedOnDemandCost(), other.estimatedOnDemandCost()) && Objects.equals(this.estimatedOnDemandCostWithCurrentCommitment(), other.estimatedOnDemandCostWithCurrentCommitment()) && Objects.equals(this.estimatedROI(), other.estimatedROI()) && Objects.equals(this.estimatedSPCost(), other.estimatedSPCost()) && Objects.equals(this.estimatedSavingsAmount(), other.estimatedSavingsAmount()) && Objects.equals(this.estimatedSavingsPercentage(), other.estimatedSavingsPercentage()) && Objects.equals(this.existingHourlyCommitment(), other.existingHourlyCommitment()) && Objects.equals(this.hourlyCommitmentToPurchase(), other.hourlyCommitmentToPurchase()) && Objects.equals(this.upfrontCost(), other.upfrontCost()) && Objects.equals(this.currentAverageCoverage(), other.currentAverageCoverage()) && Objects.equals(this.estimatedAverageCoverage(), other.estimatedAverageCoverage()) && this.hasMetricsOverLookbackPeriod() == other.hasMetricsOverLookbackPeriod() && Objects.equals(this.metricsOverLookbackPeriod(), other.metricsOverLookbackPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationDetailData").add("AccountScope", (Object)this.accountScopeAsString()).add("LookbackPeriodInDays", (Object)this.lookbackPeriodInDaysAsString()).add("SavingsPlansType", (Object)this.savingsPlansTypeAsString()).add("TermInYears", (Object)this.termInYearsAsString()).add("PaymentOption", (Object)this.paymentOptionAsString()).add("AccountId", (Object)this.accountId()).add("CurrencyCode", (Object)this.currencyCode()).add("InstanceFamily", (Object)this.instanceFamily()).add("Region", (Object)this.region()).add("OfferingId", (Object)this.offeringId()).add("GenerationTimestamp", (Object)this.generationTimestamp()).add("LatestUsageTimestamp", (Object)this.latestUsageTimestamp()).add("CurrentAverageHourlyOnDemandSpend", (Object)this.currentAverageHourlyOnDemandSpend()).add("CurrentMaximumHourlyOnDemandSpend", (Object)this.currentMaximumHourlyOnDemandSpend()).add("CurrentMinimumHourlyOnDemandSpend", (Object)this.currentMinimumHourlyOnDemandSpend()).add("EstimatedAverageUtilization", (Object)this.estimatedAverageUtilization()).add("EstimatedMonthlySavingsAmount", (Object)this.estimatedMonthlySavingsAmount()).add("EstimatedOnDemandCost", (Object)this.estimatedOnDemandCost()).add("EstimatedOnDemandCostWithCurrentCommitment", (Object)this.estimatedOnDemandCostWithCurrentCommitment()).add("EstimatedROI", (Object)this.estimatedROI()).add("EstimatedSPCost", (Object)this.estimatedSPCost()).add("EstimatedSavingsAmount", (Object)this.estimatedSavingsAmount()).add("EstimatedSavingsPercentage", (Object)this.estimatedSavingsPercentage()).add("ExistingHourlyCommitment", (Object)this.existingHourlyCommitment()).add("HourlyCommitmentToPurchase", (Object)this.hourlyCommitmentToPurchase()).add("UpfrontCost", (Object)this.upfrontCost()).add("CurrentAverageCoverage", (Object)this.currentAverageCoverage()).add("EstimatedAverageCoverage", (Object)this.estimatedAverageCoverage()).add("MetricsOverLookbackPeriod", this.hasMetricsOverLookbackPeriod() ? this.metricsOverLookbackPeriod() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountScope": {
                return Optional.ofNullable(clazz.cast(this.accountScopeAsString()));
            }
            case "LookbackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookbackPeriodInDaysAsString()));
            }
            case "SavingsPlansType": {
                return Optional.ofNullable(clazz.cast(this.savingsPlansTypeAsString()));
            }
            case "TermInYears": {
                return Optional.ofNullable(clazz.cast(this.termInYearsAsString()));
            }
            case "PaymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "InstanceFamily": {
                return Optional.ofNullable(clazz.cast(this.instanceFamily()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "OfferingId": {
                return Optional.ofNullable(clazz.cast(this.offeringId()));
            }
            case "GenerationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.generationTimestamp()));
            }
            case "LatestUsageTimestamp": {
                return Optional.ofNullable(clazz.cast(this.latestUsageTimestamp()));
            }
            case "CurrentAverageHourlyOnDemandSpend": {
                return Optional.ofNullable(clazz.cast(this.currentAverageHourlyOnDemandSpend()));
            }
            case "CurrentMaximumHourlyOnDemandSpend": {
                return Optional.ofNullable(clazz.cast(this.currentMaximumHourlyOnDemandSpend()));
            }
            case "CurrentMinimumHourlyOnDemandSpend": {
                return Optional.ofNullable(clazz.cast(this.currentMinimumHourlyOnDemandSpend()));
            }
            case "EstimatedAverageUtilization": {
                return Optional.ofNullable(clazz.cast(this.estimatedAverageUtilization()));
            }
            case "EstimatedMonthlySavingsAmount": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlySavingsAmount()));
            }
            case "EstimatedOnDemandCost": {
                return Optional.ofNullable(clazz.cast(this.estimatedOnDemandCost()));
            }
            case "EstimatedOnDemandCostWithCurrentCommitment": {
                return Optional.ofNullable(clazz.cast(this.estimatedOnDemandCostWithCurrentCommitment()));
            }
            case "EstimatedROI": {
                return Optional.ofNullable(clazz.cast(this.estimatedROI()));
            }
            case "EstimatedSPCost": {
                return Optional.ofNullable(clazz.cast(this.estimatedSPCost()));
            }
            case "EstimatedSavingsAmount": {
                return Optional.ofNullable(clazz.cast(this.estimatedSavingsAmount()));
            }
            case "EstimatedSavingsPercentage": {
                return Optional.ofNullable(clazz.cast(this.estimatedSavingsPercentage()));
            }
            case "ExistingHourlyCommitment": {
                return Optional.ofNullable(clazz.cast(this.existingHourlyCommitment()));
            }
            case "HourlyCommitmentToPurchase": {
                return Optional.ofNullable(clazz.cast(this.hourlyCommitmentToPurchase()));
            }
            case "UpfrontCost": {
                return Optional.ofNullable(clazz.cast(this.upfrontCost()));
            }
            case "CurrentAverageCoverage": {
                return Optional.ofNullable(clazz.cast(this.currentAverageCoverage()));
            }
            case "EstimatedAverageCoverage": {
                return Optional.ofNullable(clazz.cast(this.estimatedAverageCoverage()));
            }
            case "MetricsOverLookbackPeriod": {
                return Optional.ofNullable(clazz.cast(this.metricsOverLookbackPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationDetailData, T> g) {
        return obj -> g.apply((RecommendationDetailData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountScope;
        private String lookbackPeriodInDays;
        private String savingsPlansType;
        private String termInYears;
        private String paymentOption;
        private String accountId;
        private String currencyCode;
        private String instanceFamily;
        private String region;
        private String offeringId;
        private String generationTimestamp;
        private String latestUsageTimestamp;
        private String currentAverageHourlyOnDemandSpend;
        private String currentMaximumHourlyOnDemandSpend;
        private String currentMinimumHourlyOnDemandSpend;
        private String estimatedAverageUtilization;
        private String estimatedMonthlySavingsAmount;
        private String estimatedOnDemandCost;
        private String estimatedOnDemandCostWithCurrentCommitment;
        private String estimatedROI;
        private String estimatedSPCost;
        private String estimatedSavingsAmount;
        private String estimatedSavingsPercentage;
        private String existingHourlyCommitment;
        private String hourlyCommitmentToPurchase;
        private String upfrontCost;
        private String currentAverageCoverage;
        private String estimatedAverageCoverage;
        private List<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationDetailData model) {
            this.accountScope(model.accountScope);
            this.lookbackPeriodInDays(model.lookbackPeriodInDays);
            this.savingsPlansType(model.savingsPlansType);
            this.termInYears(model.termInYears);
            this.paymentOption(model.paymentOption);
            this.accountId(model.accountId);
            this.currencyCode(model.currencyCode);
            this.instanceFamily(model.instanceFamily);
            this.region(model.region);
            this.offeringId(model.offeringId);
            this.generationTimestamp(model.generationTimestamp);
            this.latestUsageTimestamp(model.latestUsageTimestamp);
            this.currentAverageHourlyOnDemandSpend(model.currentAverageHourlyOnDemandSpend);
            this.currentMaximumHourlyOnDemandSpend(model.currentMaximumHourlyOnDemandSpend);
            this.currentMinimumHourlyOnDemandSpend(model.currentMinimumHourlyOnDemandSpend);
            this.estimatedAverageUtilization(model.estimatedAverageUtilization);
            this.estimatedMonthlySavingsAmount(model.estimatedMonthlySavingsAmount);
            this.estimatedOnDemandCost(model.estimatedOnDemandCost);
            this.estimatedOnDemandCostWithCurrentCommitment(model.estimatedOnDemandCostWithCurrentCommitment);
            this.estimatedROI(model.estimatedROI);
            this.estimatedSPCost(model.estimatedSPCost);
            this.estimatedSavingsAmount(model.estimatedSavingsAmount);
            this.estimatedSavingsPercentage(model.estimatedSavingsPercentage);
            this.existingHourlyCommitment(model.existingHourlyCommitment);
            this.hourlyCommitmentToPurchase(model.hourlyCommitmentToPurchase);
            this.upfrontCost(model.upfrontCost);
            this.currentAverageCoverage(model.currentAverageCoverage);
            this.estimatedAverageCoverage(model.estimatedAverageCoverage);
            this.metricsOverLookbackPeriod(model.metricsOverLookbackPeriod);
        }

        public final String getAccountScope() {
            return this.accountScope;
        }

        public final void setAccountScope(String accountScope) {
            this.accountScope = accountScope;
        }

        @Override
        public final Builder accountScope(String accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        @Override
        public final Builder accountScope(AccountScope accountScope) {
            this.accountScope(accountScope == null ? null : accountScope.toString());
            return this;
        }

        public final String getLookbackPeriodInDays() {
            return this.lookbackPeriodInDays;
        }

        public final void setLookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        @Override
        public final Builder lookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        @Override
        public final Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays) {
            this.lookbackPeriodInDays(lookbackPeriodInDays == null ? null : lookbackPeriodInDays.toString());
            return this;
        }

        public final String getSavingsPlansType() {
            return this.savingsPlansType;
        }

        public final void setSavingsPlansType(String savingsPlansType) {
            this.savingsPlansType = savingsPlansType;
        }

        @Override
        public final Builder savingsPlansType(String savingsPlansType) {
            this.savingsPlansType = savingsPlansType;
            return this;
        }

        @Override
        public final Builder savingsPlansType(SupportedSavingsPlansType savingsPlansType) {
            this.savingsPlansType(savingsPlansType == null ? null : savingsPlansType.toString());
            return this;
        }

        public final String getTermInYears() {
            return this.termInYears;
        }

        public final void setTermInYears(String termInYears) {
            this.termInYears = termInYears;
        }

        @Override
        public final Builder termInYears(String termInYears) {
            this.termInYears = termInYears;
            return this;
        }

        @Override
        public final Builder termInYears(TermInYears termInYears) {
            this.termInYears(termInYears == null ? null : termInYears.toString());
            return this;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getInstanceFamily() {
            return this.instanceFamily;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final String getGenerationTimestamp() {
            return this.generationTimestamp;
        }

        public final void setGenerationTimestamp(String generationTimestamp) {
            this.generationTimestamp = generationTimestamp;
        }

        @Override
        public final Builder generationTimestamp(String generationTimestamp) {
            this.generationTimestamp = generationTimestamp;
            return this;
        }

        public final String getLatestUsageTimestamp() {
            return this.latestUsageTimestamp;
        }

        public final void setLatestUsageTimestamp(String latestUsageTimestamp) {
            this.latestUsageTimestamp = latestUsageTimestamp;
        }

        @Override
        public final Builder latestUsageTimestamp(String latestUsageTimestamp) {
            this.latestUsageTimestamp = latestUsageTimestamp;
            return this;
        }

        public final String getCurrentAverageHourlyOnDemandSpend() {
            return this.currentAverageHourlyOnDemandSpend;
        }

        public final void setCurrentAverageHourlyOnDemandSpend(String currentAverageHourlyOnDemandSpend) {
            this.currentAverageHourlyOnDemandSpend = currentAverageHourlyOnDemandSpend;
        }

        @Override
        public final Builder currentAverageHourlyOnDemandSpend(String currentAverageHourlyOnDemandSpend) {
            this.currentAverageHourlyOnDemandSpend = currentAverageHourlyOnDemandSpend;
            return this;
        }

        public final String getCurrentMaximumHourlyOnDemandSpend() {
            return this.currentMaximumHourlyOnDemandSpend;
        }

        public final void setCurrentMaximumHourlyOnDemandSpend(String currentMaximumHourlyOnDemandSpend) {
            this.currentMaximumHourlyOnDemandSpend = currentMaximumHourlyOnDemandSpend;
        }

        @Override
        public final Builder currentMaximumHourlyOnDemandSpend(String currentMaximumHourlyOnDemandSpend) {
            this.currentMaximumHourlyOnDemandSpend = currentMaximumHourlyOnDemandSpend;
            return this;
        }

        public final String getCurrentMinimumHourlyOnDemandSpend() {
            return this.currentMinimumHourlyOnDemandSpend;
        }

        public final void setCurrentMinimumHourlyOnDemandSpend(String currentMinimumHourlyOnDemandSpend) {
            this.currentMinimumHourlyOnDemandSpend = currentMinimumHourlyOnDemandSpend;
        }

        @Override
        public final Builder currentMinimumHourlyOnDemandSpend(String currentMinimumHourlyOnDemandSpend) {
            this.currentMinimumHourlyOnDemandSpend = currentMinimumHourlyOnDemandSpend;
            return this;
        }

        public final String getEstimatedAverageUtilization() {
            return this.estimatedAverageUtilization;
        }

        public final void setEstimatedAverageUtilization(String estimatedAverageUtilization) {
            this.estimatedAverageUtilization = estimatedAverageUtilization;
        }

        @Override
        public final Builder estimatedAverageUtilization(String estimatedAverageUtilization) {
            this.estimatedAverageUtilization = estimatedAverageUtilization;
            return this;
        }

        public final String getEstimatedMonthlySavingsAmount() {
            return this.estimatedMonthlySavingsAmount;
        }

        public final void setEstimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount) {
            this.estimatedMonthlySavingsAmount = estimatedMonthlySavingsAmount;
        }

        @Override
        public final Builder estimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount) {
            this.estimatedMonthlySavingsAmount = estimatedMonthlySavingsAmount;
            return this;
        }

        public final String getEstimatedOnDemandCost() {
            return this.estimatedOnDemandCost;
        }

        public final void setEstimatedOnDemandCost(String estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
        }

        @Override
        public final Builder estimatedOnDemandCost(String estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
            return this;
        }

        public final String getEstimatedOnDemandCostWithCurrentCommitment() {
            return this.estimatedOnDemandCostWithCurrentCommitment;
        }

        public final void setEstimatedOnDemandCostWithCurrentCommitment(String estimatedOnDemandCostWithCurrentCommitment) {
            this.estimatedOnDemandCostWithCurrentCommitment = estimatedOnDemandCostWithCurrentCommitment;
        }

        @Override
        public final Builder estimatedOnDemandCostWithCurrentCommitment(String estimatedOnDemandCostWithCurrentCommitment) {
            this.estimatedOnDemandCostWithCurrentCommitment = estimatedOnDemandCostWithCurrentCommitment;
            return this;
        }

        public final String getEstimatedROI() {
            return this.estimatedROI;
        }

        public final void setEstimatedROI(String estimatedROI) {
            this.estimatedROI = estimatedROI;
        }

        @Override
        public final Builder estimatedROI(String estimatedROI) {
            this.estimatedROI = estimatedROI;
            return this;
        }

        public final String getEstimatedSPCost() {
            return this.estimatedSPCost;
        }

        public final void setEstimatedSPCost(String estimatedSPCost) {
            this.estimatedSPCost = estimatedSPCost;
        }

        @Override
        public final Builder estimatedSPCost(String estimatedSPCost) {
            this.estimatedSPCost = estimatedSPCost;
            return this;
        }

        public final String getEstimatedSavingsAmount() {
            return this.estimatedSavingsAmount;
        }

        public final void setEstimatedSavingsAmount(String estimatedSavingsAmount) {
            this.estimatedSavingsAmount = estimatedSavingsAmount;
        }

        @Override
        public final Builder estimatedSavingsAmount(String estimatedSavingsAmount) {
            this.estimatedSavingsAmount = estimatedSavingsAmount;
            return this;
        }

        public final String getEstimatedSavingsPercentage() {
            return this.estimatedSavingsPercentage;
        }

        public final void setEstimatedSavingsPercentage(String estimatedSavingsPercentage) {
            this.estimatedSavingsPercentage = estimatedSavingsPercentage;
        }

        @Override
        public final Builder estimatedSavingsPercentage(String estimatedSavingsPercentage) {
            this.estimatedSavingsPercentage = estimatedSavingsPercentage;
            return this;
        }

        public final String getExistingHourlyCommitment() {
            return this.existingHourlyCommitment;
        }

        public final void setExistingHourlyCommitment(String existingHourlyCommitment) {
            this.existingHourlyCommitment = existingHourlyCommitment;
        }

        @Override
        public final Builder existingHourlyCommitment(String existingHourlyCommitment) {
            this.existingHourlyCommitment = existingHourlyCommitment;
            return this;
        }

        public final String getHourlyCommitmentToPurchase() {
            return this.hourlyCommitmentToPurchase;
        }

        public final void setHourlyCommitmentToPurchase(String hourlyCommitmentToPurchase) {
            this.hourlyCommitmentToPurchase = hourlyCommitmentToPurchase;
        }

        @Override
        public final Builder hourlyCommitmentToPurchase(String hourlyCommitmentToPurchase) {
            this.hourlyCommitmentToPurchase = hourlyCommitmentToPurchase;
            return this;
        }

        public final String getUpfrontCost() {
            return this.upfrontCost;
        }

        public final void setUpfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
        }

        @Override
        public final Builder upfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
            return this;
        }

        public final String getCurrentAverageCoverage() {
            return this.currentAverageCoverage;
        }

        public final void setCurrentAverageCoverage(String currentAverageCoverage) {
            this.currentAverageCoverage = currentAverageCoverage;
        }

        @Override
        public final Builder currentAverageCoverage(String currentAverageCoverage) {
            this.currentAverageCoverage = currentAverageCoverage;
            return this;
        }

        public final String getEstimatedAverageCoverage() {
            return this.estimatedAverageCoverage;
        }

        public final void setEstimatedAverageCoverage(String estimatedAverageCoverage) {
            this.estimatedAverageCoverage = estimatedAverageCoverage;
        }

        @Override
        public final Builder estimatedAverageCoverage(String estimatedAverageCoverage) {
            this.estimatedAverageCoverage = estimatedAverageCoverage;
            return this;
        }

        public final List<RecommendationDetailHourlyMetrics.Builder> getMetricsOverLookbackPeriod() {
            List<RecommendationDetailHourlyMetrics.Builder> result = MetricsOverLookbackPeriodCopier.copyToBuilder(this.metricsOverLookbackPeriod);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricsOverLookbackPeriod(Collection<RecommendationDetailHourlyMetrics.BuilderImpl> metricsOverLookbackPeriod) {
            this.metricsOverLookbackPeriod = MetricsOverLookbackPeriodCopier.copyFromBuilder(metricsOverLookbackPeriod);
        }

        @Override
        public final Builder metricsOverLookbackPeriod(Collection<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod) {
            this.metricsOverLookbackPeriod = MetricsOverLookbackPeriodCopier.copy(metricsOverLookbackPeriod);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsOverLookbackPeriod(RecommendationDetailHourlyMetrics ... metricsOverLookbackPeriod) {
            this.metricsOverLookbackPeriod(Arrays.asList(metricsOverLookbackPeriod));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsOverLookbackPeriod(Consumer<RecommendationDetailHourlyMetrics.Builder> ... metricsOverLookbackPeriod) {
            this.metricsOverLookbackPeriod(Stream.of(metricsOverLookbackPeriod).map(c -> (RecommendationDetailHourlyMetrics)((RecommendationDetailHourlyMetrics.Builder)RecommendationDetailHourlyMetrics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RecommendationDetailData build() {
            return new RecommendationDetailData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationDetailData> {
        public Builder accountScope(String var1);

        public Builder accountScope(AccountScope var1);

        public Builder lookbackPeriodInDays(String var1);

        public Builder lookbackPeriodInDays(LookbackPeriodInDays var1);

        public Builder savingsPlansType(String var1);

        public Builder savingsPlansType(SupportedSavingsPlansType var1);

        public Builder termInYears(String var1);

        public Builder termInYears(TermInYears var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);

        public Builder accountId(String var1);

        public Builder currencyCode(String var1);

        public Builder instanceFamily(String var1);

        public Builder region(String var1);

        public Builder offeringId(String var1);

        public Builder generationTimestamp(String var1);

        public Builder latestUsageTimestamp(String var1);

        public Builder currentAverageHourlyOnDemandSpend(String var1);

        public Builder currentMaximumHourlyOnDemandSpend(String var1);

        public Builder currentMinimumHourlyOnDemandSpend(String var1);

        public Builder estimatedAverageUtilization(String var1);

        public Builder estimatedMonthlySavingsAmount(String var1);

        public Builder estimatedOnDemandCost(String var1);

        public Builder estimatedOnDemandCostWithCurrentCommitment(String var1);

        public Builder estimatedROI(String var1);

        public Builder estimatedSPCost(String var1);

        public Builder estimatedSavingsAmount(String var1);

        public Builder estimatedSavingsPercentage(String var1);

        public Builder existingHourlyCommitment(String var1);

        public Builder hourlyCommitmentToPurchase(String var1);

        public Builder upfrontCost(String var1);

        public Builder currentAverageCoverage(String var1);

        public Builder estimatedAverageCoverage(String var1);

        public Builder metricsOverLookbackPeriod(Collection<RecommendationDetailHourlyMetrics> var1);

        public Builder metricsOverLookbackPeriod(RecommendationDetailHourlyMetrics ... var1);

        public Builder metricsOverLookbackPeriod(Consumer<RecommendationDetailHourlyMetrics.Builder> ... var1);
    }
}

