/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about your recommended reservation purchase.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservationPurchaseRecommendationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservationPurchaseRecommendationDetail.Builder, ReservationPurchaseRecommendationDetail> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ReservationPurchaseRecommendationDetail::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<InstanceDetails> INSTANCE_DETAILS_FIELD = SdkField
            .<InstanceDetails> builder(MarshallingType.SDK_POJO).memberName("InstanceDetails")
            .getter(getter(ReservationPurchaseRecommendationDetail::instanceDetails)).setter(setter(Builder::instanceDetails))
            .constructor(InstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceDetails").build()).build();

    private static final SdkField<String> RECOMMENDED_NUMBER_OF_INSTANCES_TO_PURCHASE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecommendedNumberOfInstancesToPurchase")
            .getter(getter(ReservationPurchaseRecommendationDetail::recommendedNumberOfInstancesToPurchase))
            .setter(setter(Builder::recommendedNumberOfInstancesToPurchase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RecommendedNumberOfInstancesToPurchase").build()).build();

    private static final SdkField<String> RECOMMENDED_NORMALIZED_UNITS_TO_PURCHASE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecommendedNormalizedUnitsToPurchase")
            .getter(getter(ReservationPurchaseRecommendationDetail::recommendedNormalizedUnitsToPurchase))
            .setter(setter(Builder::recommendedNormalizedUnitsToPurchase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RecommendedNormalizedUnitsToPurchase").build()).build();

    private static final SdkField<String> MINIMUM_NUMBER_OF_INSTANCES_USED_PER_HOUR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MinimumNumberOfInstancesUsedPerHour")
            .getter(getter(ReservationPurchaseRecommendationDetail::minimumNumberOfInstancesUsedPerHour))
            .setter(setter(Builder::minimumNumberOfInstancesUsedPerHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MinimumNumberOfInstancesUsedPerHour").build()).build();

    private static final SdkField<String> MINIMUM_NORMALIZED_UNITS_USED_PER_HOUR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MinimumNormalizedUnitsUsedPerHour")
            .getter(getter(ReservationPurchaseRecommendationDetail::minimumNormalizedUnitsUsedPerHour))
            .setter(setter(Builder::minimumNormalizedUnitsUsedPerHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumNormalizedUnitsUsedPerHour")
                    .build()).build();

    private static final SdkField<String> MAXIMUM_NUMBER_OF_INSTANCES_USED_PER_HOUR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaximumNumberOfInstancesUsedPerHour")
            .getter(getter(ReservationPurchaseRecommendationDetail::maximumNumberOfInstancesUsedPerHour))
            .setter(setter(Builder::maximumNumberOfInstancesUsedPerHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MaximumNumberOfInstancesUsedPerHour").build()).build();

    private static final SdkField<String> MAXIMUM_NORMALIZED_UNITS_USED_PER_HOUR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaximumNormalizedUnitsUsedPerHour")
            .getter(getter(ReservationPurchaseRecommendationDetail::maximumNormalizedUnitsUsedPerHour))
            .setter(setter(Builder::maximumNormalizedUnitsUsedPerHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumNormalizedUnitsUsedPerHour")
                    .build()).build();

    private static final SdkField<String> AVERAGE_NUMBER_OF_INSTANCES_USED_PER_HOUR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AverageNumberOfInstancesUsedPerHour")
            .getter(getter(ReservationPurchaseRecommendationDetail::averageNumberOfInstancesUsedPerHour))
            .setter(setter(Builder::averageNumberOfInstancesUsedPerHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AverageNumberOfInstancesUsedPerHour").build()).build();

    private static final SdkField<String> AVERAGE_NORMALIZED_UNITS_USED_PER_HOUR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AverageNormalizedUnitsUsedPerHour")
            .getter(getter(ReservationPurchaseRecommendationDetail::averageNormalizedUnitsUsedPerHour))
            .setter(setter(Builder::averageNormalizedUnitsUsedPerHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageNormalizedUnitsUsedPerHour")
                    .build()).build();

    private static final SdkField<String> AVERAGE_UTILIZATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AverageUtilization").getter(getter(ReservationPurchaseRecommendationDetail::averageUtilization))
            .setter(setter(Builder::averageUtilization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageUtilization").build())
            .build();

    private static final SdkField<String> ESTIMATED_BREAK_EVEN_IN_MONTHS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedBreakEvenInMonths")
            .getter(getter(ReservationPurchaseRecommendationDetail::estimatedBreakEvenInMonths))
            .setter(setter(Builder::estimatedBreakEvenInMonths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedBreakEvenInMonths").build())
            .build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(ReservationPurchaseRecommendationDetail::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<String> ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedMonthlySavingsAmount")
            .getter(getter(ReservationPurchaseRecommendationDetail::estimatedMonthlySavingsAmount))
            .setter(setter(Builder::estimatedMonthlySavingsAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlySavingsAmount")
                    .build()).build();

    private static final SdkField<String> ESTIMATED_MONTHLY_SAVINGS_PERCENTAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedMonthlySavingsPercentage")
            .getter(getter(ReservationPurchaseRecommendationDetail::estimatedMonthlySavingsPercentage))
            .setter(setter(Builder::estimatedMonthlySavingsPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlySavingsPercentage")
                    .build()).build();

    private static final SdkField<String> ESTIMATED_MONTHLY_ON_DEMAND_COST_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedMonthlyOnDemandCost")
            .getter(getter(ReservationPurchaseRecommendationDetail::estimatedMonthlyOnDemandCost))
            .setter(setter(Builder::estimatedMonthlyOnDemandCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlyOnDemandCost")
                    .build()).build();

    private static final SdkField<String> ESTIMATED_RESERVATION_COST_FOR_LOOKBACK_PERIOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedReservationCostForLookbackPeriod")
            .getter(getter(ReservationPurchaseRecommendationDetail::estimatedReservationCostForLookbackPeriod))
            .setter(setter(Builder::estimatedReservationCostForLookbackPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EstimatedReservationCostForLookbackPeriod").build()).build();

    private static final SdkField<String> UPFRONT_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpfrontCost").getter(getter(ReservationPurchaseRecommendationDetail::upfrontCost))
            .setter(setter(Builder::upfrontCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontCost").build()).build();

    private static final SdkField<String> RECURRING_STANDARD_MONTHLY_COST_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecurringStandardMonthlyCost")
            .getter(getter(ReservationPurchaseRecommendationDetail::recurringStandardMonthlyCost))
            .setter(setter(Builder::recurringStandardMonthlyCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringStandardMonthlyCost")
                    .build()).build();

    private static final SdkField<ReservedCapacityDetails> RESERVED_CAPACITY_DETAILS_FIELD = SdkField
            .<ReservedCapacityDetails> builder(MarshallingType.SDK_POJO).memberName("ReservedCapacityDetails")
            .getter(getter(ReservationPurchaseRecommendationDetail::reservedCapacityDetails))
            .setter(setter(Builder::reservedCapacityDetails)).constructor(ReservedCapacityDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCapacityDetails").build())
            .build();

    private static final SdkField<String> RECOMMENDED_NUMBER_OF_CAPACITY_UNITS_TO_PURCHASE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecommendedNumberOfCapacityUnitsToPurchase")
            .getter(getter(ReservationPurchaseRecommendationDetail::recommendedNumberOfCapacityUnitsToPurchase))
            .setter(setter(Builder::recommendedNumberOfCapacityUnitsToPurchase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RecommendedNumberOfCapacityUnitsToPurchase").build()).build();

    private static final SdkField<String> MINIMUM_NUMBER_OF_CAPACITY_UNITS_USED_PER_HOUR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MinimumNumberOfCapacityUnitsUsedPerHour")
            .getter(getter(ReservationPurchaseRecommendationDetail::minimumNumberOfCapacityUnitsUsedPerHour))
            .setter(setter(Builder::minimumNumberOfCapacityUnitsUsedPerHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MinimumNumberOfCapacityUnitsUsedPerHour").build()).build();

    private static final SdkField<String> MAXIMUM_NUMBER_OF_CAPACITY_UNITS_USED_PER_HOUR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaximumNumberOfCapacityUnitsUsedPerHour")
            .getter(getter(ReservationPurchaseRecommendationDetail::maximumNumberOfCapacityUnitsUsedPerHour))
            .setter(setter(Builder::maximumNumberOfCapacityUnitsUsedPerHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MaximumNumberOfCapacityUnitsUsedPerHour").build()).build();

    private static final SdkField<String> AVERAGE_NUMBER_OF_CAPACITY_UNITS_USED_PER_HOUR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AverageNumberOfCapacityUnitsUsedPerHour")
            .getter(getter(ReservationPurchaseRecommendationDetail::averageNumberOfCapacityUnitsUsedPerHour))
            .setter(setter(Builder::averageNumberOfCapacityUnitsUsedPerHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AverageNumberOfCapacityUnitsUsedPerHour").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            INSTANCE_DETAILS_FIELD, RECOMMENDED_NUMBER_OF_INSTANCES_TO_PURCHASE_FIELD,
            RECOMMENDED_NORMALIZED_UNITS_TO_PURCHASE_FIELD, MINIMUM_NUMBER_OF_INSTANCES_USED_PER_HOUR_FIELD,
            MINIMUM_NORMALIZED_UNITS_USED_PER_HOUR_FIELD, MAXIMUM_NUMBER_OF_INSTANCES_USED_PER_HOUR_FIELD,
            MAXIMUM_NORMALIZED_UNITS_USED_PER_HOUR_FIELD, AVERAGE_NUMBER_OF_INSTANCES_USED_PER_HOUR_FIELD,
            AVERAGE_NORMALIZED_UNITS_USED_PER_HOUR_FIELD, AVERAGE_UTILIZATION_FIELD, ESTIMATED_BREAK_EVEN_IN_MONTHS_FIELD,
            CURRENCY_CODE_FIELD, ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD, ESTIMATED_MONTHLY_SAVINGS_PERCENTAGE_FIELD,
            ESTIMATED_MONTHLY_ON_DEMAND_COST_FIELD, ESTIMATED_RESERVATION_COST_FOR_LOOKBACK_PERIOD_FIELD, UPFRONT_COST_FIELD,
            RECURRING_STANDARD_MONTHLY_COST_FIELD, RESERVED_CAPACITY_DETAILS_FIELD,
            RECOMMENDED_NUMBER_OF_CAPACITY_UNITS_TO_PURCHASE_FIELD, MINIMUM_NUMBER_OF_CAPACITY_UNITS_USED_PER_HOUR_FIELD,
            MAXIMUM_NUMBER_OF_CAPACITY_UNITS_USED_PER_HOUR_FIELD, AVERAGE_NUMBER_OF_CAPACITY_UNITS_USED_PER_HOUR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final InstanceDetails instanceDetails;

    private final String recommendedNumberOfInstancesToPurchase;

    private final String recommendedNormalizedUnitsToPurchase;

    private final String minimumNumberOfInstancesUsedPerHour;

    private final String minimumNormalizedUnitsUsedPerHour;

    private final String maximumNumberOfInstancesUsedPerHour;

    private final String maximumNormalizedUnitsUsedPerHour;

    private final String averageNumberOfInstancesUsedPerHour;

    private final String averageNormalizedUnitsUsedPerHour;

    private final String averageUtilization;

    private final String estimatedBreakEvenInMonths;

    private final String currencyCode;

    private final String estimatedMonthlySavingsAmount;

    private final String estimatedMonthlySavingsPercentage;

    private final String estimatedMonthlyOnDemandCost;

    private final String estimatedReservationCostForLookbackPeriod;

    private final String upfrontCost;

    private final String recurringStandardMonthlyCost;

    private final ReservedCapacityDetails reservedCapacityDetails;

    private final String recommendedNumberOfCapacityUnitsToPurchase;

    private final String minimumNumberOfCapacityUnitsUsedPerHour;

    private final String maximumNumberOfCapacityUnitsUsedPerHour;

    private final String averageNumberOfCapacityUnitsUsedPerHour;

    private ReservationPurchaseRecommendationDetail(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.instanceDetails = builder.instanceDetails;
        this.recommendedNumberOfInstancesToPurchase = builder.recommendedNumberOfInstancesToPurchase;
        this.recommendedNormalizedUnitsToPurchase = builder.recommendedNormalizedUnitsToPurchase;
        this.minimumNumberOfInstancesUsedPerHour = builder.minimumNumberOfInstancesUsedPerHour;
        this.minimumNormalizedUnitsUsedPerHour = builder.minimumNormalizedUnitsUsedPerHour;
        this.maximumNumberOfInstancesUsedPerHour = builder.maximumNumberOfInstancesUsedPerHour;
        this.maximumNormalizedUnitsUsedPerHour = builder.maximumNormalizedUnitsUsedPerHour;
        this.averageNumberOfInstancesUsedPerHour = builder.averageNumberOfInstancesUsedPerHour;
        this.averageNormalizedUnitsUsedPerHour = builder.averageNormalizedUnitsUsedPerHour;
        this.averageUtilization = builder.averageUtilization;
        this.estimatedBreakEvenInMonths = builder.estimatedBreakEvenInMonths;
        this.currencyCode = builder.currencyCode;
        this.estimatedMonthlySavingsAmount = builder.estimatedMonthlySavingsAmount;
        this.estimatedMonthlySavingsPercentage = builder.estimatedMonthlySavingsPercentage;
        this.estimatedMonthlyOnDemandCost = builder.estimatedMonthlyOnDemandCost;
        this.estimatedReservationCostForLookbackPeriod = builder.estimatedReservationCostForLookbackPeriod;
        this.upfrontCost = builder.upfrontCost;
        this.recurringStandardMonthlyCost = builder.recurringStandardMonthlyCost;
        this.reservedCapacityDetails = builder.reservedCapacityDetails;
        this.recommendedNumberOfCapacityUnitsToPurchase = builder.recommendedNumberOfCapacityUnitsToPurchase;
        this.minimumNumberOfCapacityUnitsUsedPerHour = builder.minimumNumberOfCapacityUnitsUsedPerHour;
        this.maximumNumberOfCapacityUnitsUsedPerHour = builder.maximumNumberOfCapacityUnitsUsedPerHour;
        this.averageNumberOfCapacityUnitsUsedPerHour = builder.averageNumberOfCapacityUnitsUsedPerHour;
    }

    /**
     * <p>
     * The account that this Reserved Instance (RI) recommendation is for.
     * </p>
     * 
     * @return The account that this Reserved Instance (RI) recommendation is for.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Details about the reservations that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return Details about the reservations that Amazon Web Services recommends that you purchase.
     */
    public final InstanceDetails instanceDetails() {
        return instanceDetails;
    }

    /**
     * <p>
     * The number of instances that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return The number of instances that Amazon Web Services recommends that you purchase.
     */
    public final String recommendedNumberOfInstancesToPurchase() {
        return recommendedNumberOfInstancesToPurchase;
    }

    /**
     * <p>
     * The number of normalized units that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return The number of normalized units that Amazon Web Services recommends that you purchase.
     */
    public final String recommendedNormalizedUnitsToPurchase() {
        return recommendedNormalizedUnitsToPurchase;
    }

    /**
     * <p>
     * The minimum number of instances that you used in an hour during the historical period. Amazon Web Services uses
     * this to calculate your recommended reservation purchases.
     * </p>
     * 
     * @return The minimum number of instances that you used in an hour during the historical period. Amazon Web
     *         Services uses this to calculate your recommended reservation purchases.
     */
    public final String minimumNumberOfInstancesUsedPerHour() {
        return minimumNumberOfInstancesUsedPerHour;
    }

    /**
     * <p>
     * The minimum number of normalized units that you used in an hour during the historical period. Amazon Web Services
     * uses this to calculate your recommended reservation purchases.
     * </p>
     * 
     * @return The minimum number of normalized units that you used in an hour during the historical period. Amazon Web
     *         Services uses this to calculate your recommended reservation purchases.
     */
    public final String minimumNormalizedUnitsUsedPerHour() {
        return minimumNormalizedUnitsUsedPerHour;
    }

    /**
     * <p>
     * The maximum number of instances that you used in an hour during the historical period. Amazon Web Services uses
     * this to calculate your recommended reservation purchases.
     * </p>
     * 
     * @return The maximum number of instances that you used in an hour during the historical period. Amazon Web
     *         Services uses this to calculate your recommended reservation purchases.
     */
    public final String maximumNumberOfInstancesUsedPerHour() {
        return maximumNumberOfInstancesUsedPerHour;
    }

    /**
     * <p>
     * The maximum number of normalized units that you used in an hour during the historical period. Amazon Web Services
     * uses this to calculate your recommended reservation purchases.
     * </p>
     * 
     * @return The maximum number of normalized units that you used in an hour during the historical period. Amazon Web
     *         Services uses this to calculate your recommended reservation purchases.
     */
    public final String maximumNormalizedUnitsUsedPerHour() {
        return maximumNormalizedUnitsUsedPerHour;
    }

    /**
     * <p>
     * The average number of instances that you used in an hour during the historical period. Amazon Web Services uses
     * this to calculate your recommended reservation purchases.
     * </p>
     * 
     * @return The average number of instances that you used in an hour during the historical period. Amazon Web
     *         Services uses this to calculate your recommended reservation purchases.
     */
    public final String averageNumberOfInstancesUsedPerHour() {
        return averageNumberOfInstancesUsedPerHour;
    }

    /**
     * <p>
     * The average number of normalized units that you used in an hour during the historical period. Amazon Web Services
     * uses this to calculate your recommended reservation purchases.
     * </p>
     * 
     * @return The average number of normalized units that you used in an hour during the historical period. Amazon Web
     *         Services uses this to calculate your recommended reservation purchases.
     */
    public final String averageNormalizedUnitsUsedPerHour() {
        return averageNormalizedUnitsUsedPerHour;
    }

    /**
     * <p>
     * The average utilization of your recommendations. Amazon Web Services uses this to calculate your recommended
     * reservation purchases.
     * </p>
     * 
     * @return The average utilization of your recommendations. Amazon Web Services uses this to calculate your
     *         recommended reservation purchases.
     */
    public final String averageUtilization() {
        return averageUtilization;
    }

    /**
     * <p>
     * How long Amazon Web Services estimates that it takes for this recommendation to start saving you money, in
     * months.
     * </p>
     * 
     * @return How long Amazon Web Services estimates that it takes for this recommendation to start saving you money,
     *         in months.
     */
    public final String estimatedBreakEvenInMonths() {
        return estimatedBreakEvenInMonths;
    }

    /**
     * <p>
     * The currency code that Amazon Web Services used to calculate the costs for this recommendation.
     * </p>
     * 
     * @return The currency code that Amazon Web Services used to calculate the costs for this recommendation.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * How much Amazon Web Services estimates that this specific recommendation might save you in a month.
     * </p>
     * 
     * @return How much Amazon Web Services estimates that this specific recommendation might save you in a month.
     */
    public final String estimatedMonthlySavingsAmount() {
        return estimatedMonthlySavingsAmount;
    }

    /**
     * <p>
     * How much Amazon Web Services estimates that this specific recommendation might save you in a month, as a
     * percentage of your overall costs.
     * </p>
     * 
     * @return How much Amazon Web Services estimates that this specific recommendation might save you in a month, as a
     *         percentage of your overall costs.
     */
    public final String estimatedMonthlySavingsPercentage() {
        return estimatedMonthlySavingsPercentage;
    }

    /**
     * <p>
     * How much Amazon Web Services estimates that you spend on On-Demand Instances in a month.
     * </p>
     * 
     * @return How much Amazon Web Services estimates that you spend on On-Demand Instances in a month.
     */
    public final String estimatedMonthlyOnDemandCost() {
        return estimatedMonthlyOnDemandCost;
    }

    /**
     * <p>
     * How much Amazon Web Services estimates that you might spend for all usage during the specified historical period
     * if you had a reservation.
     * </p>
     * 
     * @return How much Amazon Web Services estimates that you might spend for all usage during the specified historical
     *         period if you had a reservation.
     */
    public final String estimatedReservationCostForLookbackPeriod() {
        return estimatedReservationCostForLookbackPeriod;
    }

    /**
     * <p>
     * How much purchasing this recommendation costs you upfront.
     * </p>
     * 
     * @return How much purchasing this recommendation costs you upfront.
     */
    public final String upfrontCost() {
        return upfrontCost;
    }

    /**
     * <p>
     * How much purchasing this recommendation costs you on a monthly basis.
     * </p>
     * 
     * @return How much purchasing this recommendation costs you on a monthly basis.
     */
    public final String recurringStandardMonthlyCost() {
        return recurringStandardMonthlyCost;
    }

    /**
     * <p>
     * Details about the reservations that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return Details about the reservations that Amazon Web Services recommends that you purchase.
     */
    public final ReservedCapacityDetails reservedCapacityDetails() {
        return reservedCapacityDetails;
    }

    /**
     * <p>
     * The number of reserved capacity units that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return The number of reserved capacity units that Amazon Web Services recommends that you purchase.
     */
    public final String recommendedNumberOfCapacityUnitsToPurchase() {
        return recommendedNumberOfCapacityUnitsToPurchase;
    }

    /**
     * <p>
     * The minimum number of provisioned capacity units that you used in an hour during the historical period. Amazon
     * Web Services uses this to calculate your recommended reservation purchases.
     * </p>
     * 
     * @return The minimum number of provisioned capacity units that you used in an hour during the historical period.
     *         Amazon Web Services uses this to calculate your recommended reservation purchases.
     */
    public final String minimumNumberOfCapacityUnitsUsedPerHour() {
        return minimumNumberOfCapacityUnitsUsedPerHour;
    }

    /**
     * <p>
     * The maximum number of provisioned capacity units that you used in an hour during the historical period. Amazon
     * Web Services uses this to calculate your recommended reservation purchases.
     * </p>
     * 
     * @return The maximum number of provisioned capacity units that you used in an hour during the historical period.
     *         Amazon Web Services uses this to calculate your recommended reservation purchases.
     */
    public final String maximumNumberOfCapacityUnitsUsedPerHour() {
        return maximumNumberOfCapacityUnitsUsedPerHour;
    }

    /**
     * <p>
     * The average number of provisioned capacity units that you used in an hour during the historical period. Amazon
     * Web Services uses this to calculate your recommended reservation purchases.
     * </p>
     * 
     * @return The average number of provisioned capacity units that you used in an hour during the historical period.
     *         Amazon Web Services uses this to calculate your recommended reservation purchases.
     */
    public final String averageNumberOfCapacityUnitsUsedPerHour() {
        return averageNumberOfCapacityUnitsUsedPerHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(recommendedNumberOfInstancesToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(recommendedNormalizedUnitsToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(minimumNumberOfInstancesUsedPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(minimumNormalizedUnitsUsedPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(maximumNumberOfInstancesUsedPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(maximumNormalizedUnitsUsedPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(averageNumberOfInstancesUsedPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(averageNormalizedUnitsUsedPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(averageUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedBreakEvenInMonths());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlySavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlySavingsPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlyOnDemandCost());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedReservationCostForLookbackPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontCost());
        hashCode = 31 * hashCode + Objects.hashCode(recurringStandardMonthlyCost());
        hashCode = 31 * hashCode + Objects.hashCode(reservedCapacityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(recommendedNumberOfCapacityUnitsToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(minimumNumberOfCapacityUnitsUsedPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(maximumNumberOfCapacityUnitsUsedPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(averageNumberOfCapacityUnitsUsedPerHour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationPurchaseRecommendationDetail)) {
            return false;
        }
        ReservationPurchaseRecommendationDetail other = (ReservationPurchaseRecommendationDetail) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(instanceDetails(), other.instanceDetails())
                && Objects.equals(recommendedNumberOfInstancesToPurchase(), other.recommendedNumberOfInstancesToPurchase())
                && Objects.equals(recommendedNormalizedUnitsToPurchase(), other.recommendedNormalizedUnitsToPurchase())
                && Objects.equals(minimumNumberOfInstancesUsedPerHour(), other.minimumNumberOfInstancesUsedPerHour())
                && Objects.equals(minimumNormalizedUnitsUsedPerHour(), other.minimumNormalizedUnitsUsedPerHour())
                && Objects.equals(maximumNumberOfInstancesUsedPerHour(), other.maximumNumberOfInstancesUsedPerHour())
                && Objects.equals(maximumNormalizedUnitsUsedPerHour(), other.maximumNormalizedUnitsUsedPerHour())
                && Objects.equals(averageNumberOfInstancesUsedPerHour(), other.averageNumberOfInstancesUsedPerHour())
                && Objects.equals(averageNormalizedUnitsUsedPerHour(), other.averageNormalizedUnitsUsedPerHour())
                && Objects.equals(averageUtilization(), other.averageUtilization())
                && Objects.equals(estimatedBreakEvenInMonths(), other.estimatedBreakEvenInMonths())
                && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(estimatedMonthlySavingsAmount(), other.estimatedMonthlySavingsAmount())
                && Objects.equals(estimatedMonthlySavingsPercentage(), other.estimatedMonthlySavingsPercentage())
                && Objects.equals(estimatedMonthlyOnDemandCost(), other.estimatedMonthlyOnDemandCost())
                && Objects.equals(estimatedReservationCostForLookbackPeriod(), other.estimatedReservationCostForLookbackPeriod())
                && Objects.equals(upfrontCost(), other.upfrontCost())
                && Objects.equals(recurringStandardMonthlyCost(), other.recurringStandardMonthlyCost())
                && Objects.equals(reservedCapacityDetails(), other.reservedCapacityDetails())
                && Objects.equals(recommendedNumberOfCapacityUnitsToPurchase(),
                        other.recommendedNumberOfCapacityUnitsToPurchase())
                && Objects.equals(minimumNumberOfCapacityUnitsUsedPerHour(), other.minimumNumberOfCapacityUnitsUsedPerHour())
                && Objects.equals(maximumNumberOfCapacityUnitsUsedPerHour(), other.maximumNumberOfCapacityUnitsUsedPerHour())
                && Objects.equals(averageNumberOfCapacityUnitsUsedPerHour(), other.averageNumberOfCapacityUnitsUsedPerHour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservationPurchaseRecommendationDetail").add("AccountId", accountId())
                .add("InstanceDetails", instanceDetails())
                .add("RecommendedNumberOfInstancesToPurchase", recommendedNumberOfInstancesToPurchase())
                .add("RecommendedNormalizedUnitsToPurchase", recommendedNormalizedUnitsToPurchase())
                .add("MinimumNumberOfInstancesUsedPerHour", minimumNumberOfInstancesUsedPerHour())
                .add("MinimumNormalizedUnitsUsedPerHour", minimumNormalizedUnitsUsedPerHour())
                .add("MaximumNumberOfInstancesUsedPerHour", maximumNumberOfInstancesUsedPerHour())
                .add("MaximumNormalizedUnitsUsedPerHour", maximumNormalizedUnitsUsedPerHour())
                .add("AverageNumberOfInstancesUsedPerHour", averageNumberOfInstancesUsedPerHour())
                .add("AverageNormalizedUnitsUsedPerHour", averageNormalizedUnitsUsedPerHour())
                .add("AverageUtilization", averageUtilization()).add("EstimatedBreakEvenInMonths", estimatedBreakEvenInMonths())
                .add("CurrencyCode", currencyCode()).add("EstimatedMonthlySavingsAmount", estimatedMonthlySavingsAmount())
                .add("EstimatedMonthlySavingsPercentage", estimatedMonthlySavingsPercentage())
                .add("EstimatedMonthlyOnDemandCost", estimatedMonthlyOnDemandCost())
                .add("EstimatedReservationCostForLookbackPeriod", estimatedReservationCostForLookbackPeriod())
                .add("UpfrontCost", upfrontCost()).add("RecurringStandardMonthlyCost", recurringStandardMonthlyCost())
                .add("ReservedCapacityDetails", reservedCapacityDetails())
                .add("RecommendedNumberOfCapacityUnitsToPurchase", recommendedNumberOfCapacityUnitsToPurchase())
                .add("MinimumNumberOfCapacityUnitsUsedPerHour", minimumNumberOfCapacityUnitsUsedPerHour())
                .add("MaximumNumberOfCapacityUnitsUsedPerHour", maximumNumberOfCapacityUnitsUsedPerHour())
                .add("AverageNumberOfCapacityUnitsUsedPerHour", averageNumberOfCapacityUnitsUsedPerHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "InstanceDetails":
            return Optional.ofNullable(clazz.cast(instanceDetails()));
        case "RecommendedNumberOfInstancesToPurchase":
            return Optional.ofNullable(clazz.cast(recommendedNumberOfInstancesToPurchase()));
        case "RecommendedNormalizedUnitsToPurchase":
            return Optional.ofNullable(clazz.cast(recommendedNormalizedUnitsToPurchase()));
        case "MinimumNumberOfInstancesUsedPerHour":
            return Optional.ofNullable(clazz.cast(minimumNumberOfInstancesUsedPerHour()));
        case "MinimumNormalizedUnitsUsedPerHour":
            return Optional.ofNullable(clazz.cast(minimumNormalizedUnitsUsedPerHour()));
        case "MaximumNumberOfInstancesUsedPerHour":
            return Optional.ofNullable(clazz.cast(maximumNumberOfInstancesUsedPerHour()));
        case "MaximumNormalizedUnitsUsedPerHour":
            return Optional.ofNullable(clazz.cast(maximumNormalizedUnitsUsedPerHour()));
        case "AverageNumberOfInstancesUsedPerHour":
            return Optional.ofNullable(clazz.cast(averageNumberOfInstancesUsedPerHour()));
        case "AverageNormalizedUnitsUsedPerHour":
            return Optional.ofNullable(clazz.cast(averageNormalizedUnitsUsedPerHour()));
        case "AverageUtilization":
            return Optional.ofNullable(clazz.cast(averageUtilization()));
        case "EstimatedBreakEvenInMonths":
            return Optional.ofNullable(clazz.cast(estimatedBreakEvenInMonths()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "EstimatedMonthlySavingsAmount":
            return Optional.ofNullable(clazz.cast(estimatedMonthlySavingsAmount()));
        case "EstimatedMonthlySavingsPercentage":
            return Optional.ofNullable(clazz.cast(estimatedMonthlySavingsPercentage()));
        case "EstimatedMonthlyOnDemandCost":
            return Optional.ofNullable(clazz.cast(estimatedMonthlyOnDemandCost()));
        case "EstimatedReservationCostForLookbackPeriod":
            return Optional.ofNullable(clazz.cast(estimatedReservationCostForLookbackPeriod()));
        case "UpfrontCost":
            return Optional.ofNullable(clazz.cast(upfrontCost()));
        case "RecurringStandardMonthlyCost":
            return Optional.ofNullable(clazz.cast(recurringStandardMonthlyCost()));
        case "ReservedCapacityDetails":
            return Optional.ofNullable(clazz.cast(reservedCapacityDetails()));
        case "RecommendedNumberOfCapacityUnitsToPurchase":
            return Optional.ofNullable(clazz.cast(recommendedNumberOfCapacityUnitsToPurchase()));
        case "MinimumNumberOfCapacityUnitsUsedPerHour":
            return Optional.ofNullable(clazz.cast(minimumNumberOfCapacityUnitsUsedPerHour()));
        case "MaximumNumberOfCapacityUnitsUsedPerHour":
            return Optional.ofNullable(clazz.cast(maximumNumberOfCapacityUnitsUsedPerHour()));
        case "AverageNumberOfCapacityUnitsUsedPerHour":
            return Optional.ofNullable(clazz.cast(averageNumberOfCapacityUnitsUsedPerHour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservationPurchaseRecommendationDetail, T> g) {
        return obj -> g.apply((ReservationPurchaseRecommendationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservationPurchaseRecommendationDetail> {
        /**
         * <p>
         * The account that this Reserved Instance (RI) recommendation is for.
         * </p>
         * 
         * @param accountId
         *        The account that this Reserved Instance (RI) recommendation is for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Details about the reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param instanceDetails
         *        Details about the reservations that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceDetails(InstanceDetails instanceDetails);

        /**
         * <p>
         * Details about the reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceDetails.Builder} avoiding the
         * need to create one manually via {@link InstanceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceDetails(InstanceDetails)}.
         * 
         * @param instanceDetails
         *        a consumer that will call methods on {@link InstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceDetails(InstanceDetails)
         */
        default Builder instanceDetails(Consumer<InstanceDetails.Builder> instanceDetails) {
            return instanceDetails(InstanceDetails.builder().applyMutation(instanceDetails).build());
        }

        /**
         * <p>
         * The number of instances that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param recommendedNumberOfInstancesToPurchase
         *        The number of instances that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedNumberOfInstancesToPurchase(String recommendedNumberOfInstancesToPurchase);

        /**
         * <p>
         * The number of normalized units that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param recommendedNormalizedUnitsToPurchase
         *        The number of normalized units that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedNormalizedUnitsToPurchase(String recommendedNormalizedUnitsToPurchase);

        /**
         * <p>
         * The minimum number of instances that you used in an hour during the historical period. Amazon Web Services
         * uses this to calculate your recommended reservation purchases.
         * </p>
         * 
         * @param minimumNumberOfInstancesUsedPerHour
         *        The minimum number of instances that you used in an hour during the historical period. Amazon Web
         *        Services uses this to calculate your recommended reservation purchases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumNumberOfInstancesUsedPerHour(String minimumNumberOfInstancesUsedPerHour);

        /**
         * <p>
         * The minimum number of normalized units that you used in an hour during the historical period. Amazon Web
         * Services uses this to calculate your recommended reservation purchases.
         * </p>
         * 
         * @param minimumNormalizedUnitsUsedPerHour
         *        The minimum number of normalized units that you used in an hour during the historical period. Amazon
         *        Web Services uses this to calculate your recommended reservation purchases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumNormalizedUnitsUsedPerHour(String minimumNormalizedUnitsUsedPerHour);

        /**
         * <p>
         * The maximum number of instances that you used in an hour during the historical period. Amazon Web Services
         * uses this to calculate your recommended reservation purchases.
         * </p>
         * 
         * @param maximumNumberOfInstancesUsedPerHour
         *        The maximum number of instances that you used in an hour during the historical period. Amazon Web
         *        Services uses this to calculate your recommended reservation purchases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumNumberOfInstancesUsedPerHour(String maximumNumberOfInstancesUsedPerHour);

        /**
         * <p>
         * The maximum number of normalized units that you used in an hour during the historical period. Amazon Web
         * Services uses this to calculate your recommended reservation purchases.
         * </p>
         * 
         * @param maximumNormalizedUnitsUsedPerHour
         *        The maximum number of normalized units that you used in an hour during the historical period. Amazon
         *        Web Services uses this to calculate your recommended reservation purchases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumNormalizedUnitsUsedPerHour(String maximumNormalizedUnitsUsedPerHour);

        /**
         * <p>
         * The average number of instances that you used in an hour during the historical period. Amazon Web Services
         * uses this to calculate your recommended reservation purchases.
         * </p>
         * 
         * @param averageNumberOfInstancesUsedPerHour
         *        The average number of instances that you used in an hour during the historical period. Amazon Web
         *        Services uses this to calculate your recommended reservation purchases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder averageNumberOfInstancesUsedPerHour(String averageNumberOfInstancesUsedPerHour);

        /**
         * <p>
         * The average number of normalized units that you used in an hour during the historical period. Amazon Web
         * Services uses this to calculate your recommended reservation purchases.
         * </p>
         * 
         * @param averageNormalizedUnitsUsedPerHour
         *        The average number of normalized units that you used in an hour during the historical period. Amazon
         *        Web Services uses this to calculate your recommended reservation purchases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder averageNormalizedUnitsUsedPerHour(String averageNormalizedUnitsUsedPerHour);

        /**
         * <p>
         * The average utilization of your recommendations. Amazon Web Services uses this to calculate your recommended
         * reservation purchases.
         * </p>
         * 
         * @param averageUtilization
         *        The average utilization of your recommendations. Amazon Web Services uses this to calculate your
         *        recommended reservation purchases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder averageUtilization(String averageUtilization);

        /**
         * <p>
         * How long Amazon Web Services estimates that it takes for this recommendation to start saving you money, in
         * months.
         * </p>
         * 
         * @param estimatedBreakEvenInMonths
         *        How long Amazon Web Services estimates that it takes for this recommendation to start saving you
         *        money, in months.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedBreakEvenInMonths(String estimatedBreakEvenInMonths);

        /**
         * <p>
         * The currency code that Amazon Web Services used to calculate the costs for this recommendation.
         * </p>
         * 
         * @param currencyCode
         *        The currency code that Amazon Web Services used to calculate the costs for this recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * How much Amazon Web Services estimates that this specific recommendation might save you in a month.
         * </p>
         * 
         * @param estimatedMonthlySavingsAmount
         *        How much Amazon Web Services estimates that this specific recommendation might save you in a month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount);

        /**
         * <p>
         * How much Amazon Web Services estimates that this specific recommendation might save you in a month, as a
         * percentage of your overall costs.
         * </p>
         * 
         * @param estimatedMonthlySavingsPercentage
         *        How much Amazon Web Services estimates that this specific recommendation might save you in a month, as
         *        a percentage of your overall costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlySavingsPercentage(String estimatedMonthlySavingsPercentage);

        /**
         * <p>
         * How much Amazon Web Services estimates that you spend on On-Demand Instances in a month.
         * </p>
         * 
         * @param estimatedMonthlyOnDemandCost
         *        How much Amazon Web Services estimates that you spend on On-Demand Instances in a month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlyOnDemandCost(String estimatedMonthlyOnDemandCost);

        /**
         * <p>
         * How much Amazon Web Services estimates that you might spend for all usage during the specified historical
         * period if you had a reservation.
         * </p>
         * 
         * @param estimatedReservationCostForLookbackPeriod
         *        How much Amazon Web Services estimates that you might spend for all usage during the specified
         *        historical period if you had a reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedReservationCostForLookbackPeriod(String estimatedReservationCostForLookbackPeriod);

        /**
         * <p>
         * How much purchasing this recommendation costs you upfront.
         * </p>
         * 
         * @param upfrontCost
         *        How much purchasing this recommendation costs you upfront.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontCost(String upfrontCost);

        /**
         * <p>
         * How much purchasing this recommendation costs you on a monthly basis.
         * </p>
         * 
         * @param recurringStandardMonthlyCost
         *        How much purchasing this recommendation costs you on a monthly basis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringStandardMonthlyCost(String recurringStandardMonthlyCost);

        /**
         * <p>
         * Details about the reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param reservedCapacityDetails
         *        Details about the reservations that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedCapacityDetails(ReservedCapacityDetails reservedCapacityDetails);

        /**
         * <p>
         * Details about the reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReservedCapacityDetails.Builder} avoiding
         * the need to create one manually via {@link ReservedCapacityDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReservedCapacityDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #reservedCapacityDetails(ReservedCapacityDetails)}.
         * 
         * @param reservedCapacityDetails
         *        a consumer that will call methods on {@link ReservedCapacityDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedCapacityDetails(ReservedCapacityDetails)
         */
        default Builder reservedCapacityDetails(Consumer<ReservedCapacityDetails.Builder> reservedCapacityDetails) {
            return reservedCapacityDetails(ReservedCapacityDetails.builder().applyMutation(reservedCapacityDetails).build());
        }

        /**
         * <p>
         * The number of reserved capacity units that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param recommendedNumberOfCapacityUnitsToPurchase
         *        The number of reserved capacity units that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedNumberOfCapacityUnitsToPurchase(String recommendedNumberOfCapacityUnitsToPurchase);

        /**
         * <p>
         * The minimum number of provisioned capacity units that you used in an hour during the historical period.
         * Amazon Web Services uses this to calculate your recommended reservation purchases.
         * </p>
         * 
         * @param minimumNumberOfCapacityUnitsUsedPerHour
         *        The minimum number of provisioned capacity units that you used in an hour during the historical
         *        period. Amazon Web Services uses this to calculate your recommended reservation purchases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumNumberOfCapacityUnitsUsedPerHour(String minimumNumberOfCapacityUnitsUsedPerHour);

        /**
         * <p>
         * The maximum number of provisioned capacity units that you used in an hour during the historical period.
         * Amazon Web Services uses this to calculate your recommended reservation purchases.
         * </p>
         * 
         * @param maximumNumberOfCapacityUnitsUsedPerHour
         *        The maximum number of provisioned capacity units that you used in an hour during the historical
         *        period. Amazon Web Services uses this to calculate your recommended reservation purchases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumNumberOfCapacityUnitsUsedPerHour(String maximumNumberOfCapacityUnitsUsedPerHour);

        /**
         * <p>
         * The average number of provisioned capacity units that you used in an hour during the historical period.
         * Amazon Web Services uses this to calculate your recommended reservation purchases.
         * </p>
         * 
         * @param averageNumberOfCapacityUnitsUsedPerHour
         *        The average number of provisioned capacity units that you used in an hour during the historical
         *        period. Amazon Web Services uses this to calculate your recommended reservation purchases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder averageNumberOfCapacityUnitsUsedPerHour(String averageNumberOfCapacityUnitsUsedPerHour);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private InstanceDetails instanceDetails;

        private String recommendedNumberOfInstancesToPurchase;

        private String recommendedNormalizedUnitsToPurchase;

        private String minimumNumberOfInstancesUsedPerHour;

        private String minimumNormalizedUnitsUsedPerHour;

        private String maximumNumberOfInstancesUsedPerHour;

        private String maximumNormalizedUnitsUsedPerHour;

        private String averageNumberOfInstancesUsedPerHour;

        private String averageNormalizedUnitsUsedPerHour;

        private String averageUtilization;

        private String estimatedBreakEvenInMonths;

        private String currencyCode;

        private String estimatedMonthlySavingsAmount;

        private String estimatedMonthlySavingsPercentage;

        private String estimatedMonthlyOnDemandCost;

        private String estimatedReservationCostForLookbackPeriod;

        private String upfrontCost;

        private String recurringStandardMonthlyCost;

        private ReservedCapacityDetails reservedCapacityDetails;

        private String recommendedNumberOfCapacityUnitsToPurchase;

        private String minimumNumberOfCapacityUnitsUsedPerHour;

        private String maximumNumberOfCapacityUnitsUsedPerHour;

        private String averageNumberOfCapacityUnitsUsedPerHour;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationPurchaseRecommendationDetail model) {
            accountId(model.accountId);
            instanceDetails(model.instanceDetails);
            recommendedNumberOfInstancesToPurchase(model.recommendedNumberOfInstancesToPurchase);
            recommendedNormalizedUnitsToPurchase(model.recommendedNormalizedUnitsToPurchase);
            minimumNumberOfInstancesUsedPerHour(model.minimumNumberOfInstancesUsedPerHour);
            minimumNormalizedUnitsUsedPerHour(model.minimumNormalizedUnitsUsedPerHour);
            maximumNumberOfInstancesUsedPerHour(model.maximumNumberOfInstancesUsedPerHour);
            maximumNormalizedUnitsUsedPerHour(model.maximumNormalizedUnitsUsedPerHour);
            averageNumberOfInstancesUsedPerHour(model.averageNumberOfInstancesUsedPerHour);
            averageNormalizedUnitsUsedPerHour(model.averageNormalizedUnitsUsedPerHour);
            averageUtilization(model.averageUtilization);
            estimatedBreakEvenInMonths(model.estimatedBreakEvenInMonths);
            currencyCode(model.currencyCode);
            estimatedMonthlySavingsAmount(model.estimatedMonthlySavingsAmount);
            estimatedMonthlySavingsPercentage(model.estimatedMonthlySavingsPercentage);
            estimatedMonthlyOnDemandCost(model.estimatedMonthlyOnDemandCost);
            estimatedReservationCostForLookbackPeriod(model.estimatedReservationCostForLookbackPeriod);
            upfrontCost(model.upfrontCost);
            recurringStandardMonthlyCost(model.recurringStandardMonthlyCost);
            reservedCapacityDetails(model.reservedCapacityDetails);
            recommendedNumberOfCapacityUnitsToPurchase(model.recommendedNumberOfCapacityUnitsToPurchase);
            minimumNumberOfCapacityUnitsUsedPerHour(model.minimumNumberOfCapacityUnitsUsedPerHour);
            maximumNumberOfCapacityUnitsUsedPerHour(model.maximumNumberOfCapacityUnitsUsedPerHour);
            averageNumberOfCapacityUnitsUsedPerHour(model.averageNumberOfCapacityUnitsUsedPerHour);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final InstanceDetails.Builder getInstanceDetails() {
            return instanceDetails != null ? instanceDetails.toBuilder() : null;
        }

        public final void setInstanceDetails(InstanceDetails.BuilderImpl instanceDetails) {
            this.instanceDetails = instanceDetails != null ? instanceDetails.build() : null;
        }

        @Override
        public final Builder instanceDetails(InstanceDetails instanceDetails) {
            this.instanceDetails = instanceDetails;
            return this;
        }

        public final String getRecommendedNumberOfInstancesToPurchase() {
            return recommendedNumberOfInstancesToPurchase;
        }

        public final void setRecommendedNumberOfInstancesToPurchase(String recommendedNumberOfInstancesToPurchase) {
            this.recommendedNumberOfInstancesToPurchase = recommendedNumberOfInstancesToPurchase;
        }

        @Override
        public final Builder recommendedNumberOfInstancesToPurchase(String recommendedNumberOfInstancesToPurchase) {
            this.recommendedNumberOfInstancesToPurchase = recommendedNumberOfInstancesToPurchase;
            return this;
        }

        public final String getRecommendedNormalizedUnitsToPurchase() {
            return recommendedNormalizedUnitsToPurchase;
        }

        public final void setRecommendedNormalizedUnitsToPurchase(String recommendedNormalizedUnitsToPurchase) {
            this.recommendedNormalizedUnitsToPurchase = recommendedNormalizedUnitsToPurchase;
        }

        @Override
        public final Builder recommendedNormalizedUnitsToPurchase(String recommendedNormalizedUnitsToPurchase) {
            this.recommendedNormalizedUnitsToPurchase = recommendedNormalizedUnitsToPurchase;
            return this;
        }

        public final String getMinimumNumberOfInstancesUsedPerHour() {
            return minimumNumberOfInstancesUsedPerHour;
        }

        public final void setMinimumNumberOfInstancesUsedPerHour(String minimumNumberOfInstancesUsedPerHour) {
            this.minimumNumberOfInstancesUsedPerHour = minimumNumberOfInstancesUsedPerHour;
        }

        @Override
        public final Builder minimumNumberOfInstancesUsedPerHour(String minimumNumberOfInstancesUsedPerHour) {
            this.minimumNumberOfInstancesUsedPerHour = minimumNumberOfInstancesUsedPerHour;
            return this;
        }

        public final String getMinimumNormalizedUnitsUsedPerHour() {
            return minimumNormalizedUnitsUsedPerHour;
        }

        public final void setMinimumNormalizedUnitsUsedPerHour(String minimumNormalizedUnitsUsedPerHour) {
            this.minimumNormalizedUnitsUsedPerHour = minimumNormalizedUnitsUsedPerHour;
        }

        @Override
        public final Builder minimumNormalizedUnitsUsedPerHour(String minimumNormalizedUnitsUsedPerHour) {
            this.minimumNormalizedUnitsUsedPerHour = minimumNormalizedUnitsUsedPerHour;
            return this;
        }

        public final String getMaximumNumberOfInstancesUsedPerHour() {
            return maximumNumberOfInstancesUsedPerHour;
        }

        public final void setMaximumNumberOfInstancesUsedPerHour(String maximumNumberOfInstancesUsedPerHour) {
            this.maximumNumberOfInstancesUsedPerHour = maximumNumberOfInstancesUsedPerHour;
        }

        @Override
        public final Builder maximumNumberOfInstancesUsedPerHour(String maximumNumberOfInstancesUsedPerHour) {
            this.maximumNumberOfInstancesUsedPerHour = maximumNumberOfInstancesUsedPerHour;
            return this;
        }

        public final String getMaximumNormalizedUnitsUsedPerHour() {
            return maximumNormalizedUnitsUsedPerHour;
        }

        public final void setMaximumNormalizedUnitsUsedPerHour(String maximumNormalizedUnitsUsedPerHour) {
            this.maximumNormalizedUnitsUsedPerHour = maximumNormalizedUnitsUsedPerHour;
        }

        @Override
        public final Builder maximumNormalizedUnitsUsedPerHour(String maximumNormalizedUnitsUsedPerHour) {
            this.maximumNormalizedUnitsUsedPerHour = maximumNormalizedUnitsUsedPerHour;
            return this;
        }

        public final String getAverageNumberOfInstancesUsedPerHour() {
            return averageNumberOfInstancesUsedPerHour;
        }

        public final void setAverageNumberOfInstancesUsedPerHour(String averageNumberOfInstancesUsedPerHour) {
            this.averageNumberOfInstancesUsedPerHour = averageNumberOfInstancesUsedPerHour;
        }

        @Override
        public final Builder averageNumberOfInstancesUsedPerHour(String averageNumberOfInstancesUsedPerHour) {
            this.averageNumberOfInstancesUsedPerHour = averageNumberOfInstancesUsedPerHour;
            return this;
        }

        public final String getAverageNormalizedUnitsUsedPerHour() {
            return averageNormalizedUnitsUsedPerHour;
        }

        public final void setAverageNormalizedUnitsUsedPerHour(String averageNormalizedUnitsUsedPerHour) {
            this.averageNormalizedUnitsUsedPerHour = averageNormalizedUnitsUsedPerHour;
        }

        @Override
        public final Builder averageNormalizedUnitsUsedPerHour(String averageNormalizedUnitsUsedPerHour) {
            this.averageNormalizedUnitsUsedPerHour = averageNormalizedUnitsUsedPerHour;
            return this;
        }

        public final String getAverageUtilization() {
            return averageUtilization;
        }

        public final void setAverageUtilization(String averageUtilization) {
            this.averageUtilization = averageUtilization;
        }

        @Override
        public final Builder averageUtilization(String averageUtilization) {
            this.averageUtilization = averageUtilization;
            return this;
        }

        public final String getEstimatedBreakEvenInMonths() {
            return estimatedBreakEvenInMonths;
        }

        public final void setEstimatedBreakEvenInMonths(String estimatedBreakEvenInMonths) {
            this.estimatedBreakEvenInMonths = estimatedBreakEvenInMonths;
        }

        @Override
        public final Builder estimatedBreakEvenInMonths(String estimatedBreakEvenInMonths) {
            this.estimatedBreakEvenInMonths = estimatedBreakEvenInMonths;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getEstimatedMonthlySavingsAmount() {
            return estimatedMonthlySavingsAmount;
        }

        public final void setEstimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount) {
            this.estimatedMonthlySavingsAmount = estimatedMonthlySavingsAmount;
        }

        @Override
        public final Builder estimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount) {
            this.estimatedMonthlySavingsAmount = estimatedMonthlySavingsAmount;
            return this;
        }

        public final String getEstimatedMonthlySavingsPercentage() {
            return estimatedMonthlySavingsPercentage;
        }

        public final void setEstimatedMonthlySavingsPercentage(String estimatedMonthlySavingsPercentage) {
            this.estimatedMonthlySavingsPercentage = estimatedMonthlySavingsPercentage;
        }

        @Override
        public final Builder estimatedMonthlySavingsPercentage(String estimatedMonthlySavingsPercentage) {
            this.estimatedMonthlySavingsPercentage = estimatedMonthlySavingsPercentage;
            return this;
        }

        public final String getEstimatedMonthlyOnDemandCost() {
            return estimatedMonthlyOnDemandCost;
        }

        public final void setEstimatedMonthlyOnDemandCost(String estimatedMonthlyOnDemandCost) {
            this.estimatedMonthlyOnDemandCost = estimatedMonthlyOnDemandCost;
        }

        @Override
        public final Builder estimatedMonthlyOnDemandCost(String estimatedMonthlyOnDemandCost) {
            this.estimatedMonthlyOnDemandCost = estimatedMonthlyOnDemandCost;
            return this;
        }

        public final String getEstimatedReservationCostForLookbackPeriod() {
            return estimatedReservationCostForLookbackPeriod;
        }

        public final void setEstimatedReservationCostForLookbackPeriod(String estimatedReservationCostForLookbackPeriod) {
            this.estimatedReservationCostForLookbackPeriod = estimatedReservationCostForLookbackPeriod;
        }

        @Override
        public final Builder estimatedReservationCostForLookbackPeriod(String estimatedReservationCostForLookbackPeriod) {
            this.estimatedReservationCostForLookbackPeriod = estimatedReservationCostForLookbackPeriod;
            return this;
        }

        public final String getUpfrontCost() {
            return upfrontCost;
        }

        public final void setUpfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
        }

        @Override
        public final Builder upfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
            return this;
        }

        public final String getRecurringStandardMonthlyCost() {
            return recurringStandardMonthlyCost;
        }

        public final void setRecurringStandardMonthlyCost(String recurringStandardMonthlyCost) {
            this.recurringStandardMonthlyCost = recurringStandardMonthlyCost;
        }

        @Override
        public final Builder recurringStandardMonthlyCost(String recurringStandardMonthlyCost) {
            this.recurringStandardMonthlyCost = recurringStandardMonthlyCost;
            return this;
        }

        public final ReservedCapacityDetails.Builder getReservedCapacityDetails() {
            return reservedCapacityDetails != null ? reservedCapacityDetails.toBuilder() : null;
        }

        public final void setReservedCapacityDetails(ReservedCapacityDetails.BuilderImpl reservedCapacityDetails) {
            this.reservedCapacityDetails = reservedCapacityDetails != null ? reservedCapacityDetails.build() : null;
        }

        @Override
        public final Builder reservedCapacityDetails(ReservedCapacityDetails reservedCapacityDetails) {
            this.reservedCapacityDetails = reservedCapacityDetails;
            return this;
        }

        public final String getRecommendedNumberOfCapacityUnitsToPurchase() {
            return recommendedNumberOfCapacityUnitsToPurchase;
        }

        public final void setRecommendedNumberOfCapacityUnitsToPurchase(String recommendedNumberOfCapacityUnitsToPurchase) {
            this.recommendedNumberOfCapacityUnitsToPurchase = recommendedNumberOfCapacityUnitsToPurchase;
        }

        @Override
        public final Builder recommendedNumberOfCapacityUnitsToPurchase(String recommendedNumberOfCapacityUnitsToPurchase) {
            this.recommendedNumberOfCapacityUnitsToPurchase = recommendedNumberOfCapacityUnitsToPurchase;
            return this;
        }

        public final String getMinimumNumberOfCapacityUnitsUsedPerHour() {
            return minimumNumberOfCapacityUnitsUsedPerHour;
        }

        public final void setMinimumNumberOfCapacityUnitsUsedPerHour(String minimumNumberOfCapacityUnitsUsedPerHour) {
            this.minimumNumberOfCapacityUnitsUsedPerHour = minimumNumberOfCapacityUnitsUsedPerHour;
        }

        @Override
        public final Builder minimumNumberOfCapacityUnitsUsedPerHour(String minimumNumberOfCapacityUnitsUsedPerHour) {
            this.minimumNumberOfCapacityUnitsUsedPerHour = minimumNumberOfCapacityUnitsUsedPerHour;
            return this;
        }

        public final String getMaximumNumberOfCapacityUnitsUsedPerHour() {
            return maximumNumberOfCapacityUnitsUsedPerHour;
        }

        public final void setMaximumNumberOfCapacityUnitsUsedPerHour(String maximumNumberOfCapacityUnitsUsedPerHour) {
            this.maximumNumberOfCapacityUnitsUsedPerHour = maximumNumberOfCapacityUnitsUsedPerHour;
        }

        @Override
        public final Builder maximumNumberOfCapacityUnitsUsedPerHour(String maximumNumberOfCapacityUnitsUsedPerHour) {
            this.maximumNumberOfCapacityUnitsUsedPerHour = maximumNumberOfCapacityUnitsUsedPerHour;
            return this;
        }

        public final String getAverageNumberOfCapacityUnitsUsedPerHour() {
            return averageNumberOfCapacityUnitsUsedPerHour;
        }

        public final void setAverageNumberOfCapacityUnitsUsedPerHour(String averageNumberOfCapacityUnitsUsedPerHour) {
            this.averageNumberOfCapacityUnitsUsedPerHour = averageNumberOfCapacityUnitsUsedPerHour;
        }

        @Override
        public final Builder averageNumberOfCapacityUnitsUsedPerHour(String averageNumberOfCapacityUnitsUsedPerHour) {
            this.averageNumberOfCapacityUnitsUsedPerHour = averageNumberOfCapacityUnitsUsedPerHour;
            return this;
        }

        @Override
        public ReservationPurchaseRecommendationDetail build() {
            return new ReservationPurchaseRecommendationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
