/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSavingsPlanPurchaseRecommendationDetailsResponse extends CostExplorerResponse
        implements
        ToCopyableBuilder<GetSavingsPlanPurchaseRecommendationDetailsResponse.Builder, GetSavingsPlanPurchaseRecommendationDetailsResponse> {
    private static final SdkField<String> RECOMMENDATION_DETAIL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationDetailId")
            .getter(getter(GetSavingsPlanPurchaseRecommendationDetailsResponse::recommendationDetailId))
            .setter(setter(Builder::recommendationDetailId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationDetailId").build())
            .build();

    private static final SdkField<RecommendationDetailData> RECOMMENDATION_DETAIL_DATA_FIELD = SdkField
            .<RecommendationDetailData> builder(MarshallingType.SDK_POJO).memberName("RecommendationDetailData")
            .getter(getter(GetSavingsPlanPurchaseRecommendationDetailsResponse::recommendationDetailData))
            .setter(setter(Builder::recommendationDetailData)).constructor(RecommendationDetailData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationDetailData").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RECOMMENDATION_DETAIL_ID_FIELD, RECOMMENDATION_DETAIL_DATA_FIELD));

    private final String recommendationDetailId;

    private final RecommendationDetailData recommendationDetailData;

    private GetSavingsPlanPurchaseRecommendationDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.recommendationDetailId = builder.recommendationDetailId;
        this.recommendationDetailData = builder.recommendationDetailData;
    }

    /**
     * <p>
     * The ID that is associated with the Savings Plan recommendation.
     * </p>
     * 
     * @return The ID that is associated with the Savings Plan recommendation.
     */
    public final String recommendationDetailId() {
        return recommendationDetailId;
    }

    /**
     * <p>
     * Contains detailed information about a specific Savings Plan recommendation.
     * </p>
     * 
     * @return Contains detailed information about a specific Savings Plan recommendation.
     */
    public final RecommendationDetailData recommendationDetailData() {
        return recommendationDetailData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recommendationDetailId());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationDetailData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSavingsPlanPurchaseRecommendationDetailsResponse)) {
            return false;
        }
        GetSavingsPlanPurchaseRecommendationDetailsResponse other = (GetSavingsPlanPurchaseRecommendationDetailsResponse) obj;
        return Objects.equals(recommendationDetailId(), other.recommendationDetailId())
                && Objects.equals(recommendationDetailData(), other.recommendationDetailData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSavingsPlanPurchaseRecommendationDetailsResponse")
                .add("RecommendationDetailId", recommendationDetailId())
                .add("RecommendationDetailData", recommendationDetailData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommendationDetailId":
            return Optional.ofNullable(clazz.cast(recommendationDetailId()));
        case "RecommendationDetailData":
            return Optional.ofNullable(clazz.cast(recommendationDetailData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSavingsPlanPurchaseRecommendationDetailsResponse, T> g) {
        return obj -> g.apply((GetSavingsPlanPurchaseRecommendationDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSavingsPlanPurchaseRecommendationDetailsResponse> {
        /**
         * <p>
         * The ID that is associated with the Savings Plan recommendation.
         * </p>
         * 
         * @param recommendationDetailId
         *        The ID that is associated with the Savings Plan recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationDetailId(String recommendationDetailId);

        /**
         * <p>
         * Contains detailed information about a specific Savings Plan recommendation.
         * </p>
         * 
         * @param recommendationDetailData
         *        Contains detailed information about a specific Savings Plan recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationDetailData(RecommendationDetailData recommendationDetailData);

        /**
         * <p>
         * Contains detailed information about a specific Savings Plan recommendation.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationDetailData.Builder}
         * avoiding the need to create one manually via {@link RecommendationDetailData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationDetailData.Builder#build()} is called immediately
         * and its result is passed to {@link #recommendationDetailData(RecommendationDetailData)}.
         * 
         * @param recommendationDetailData
         *        a consumer that will call methods on {@link RecommendationDetailData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationDetailData(RecommendationDetailData)
         */
        default Builder recommendationDetailData(Consumer<RecommendationDetailData.Builder> recommendationDetailData) {
            return recommendationDetailData(RecommendationDetailData.builder().applyMutation(recommendationDetailData).build());
        }
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private String recommendationDetailId;

        private RecommendationDetailData recommendationDetailData;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSavingsPlanPurchaseRecommendationDetailsResponse model) {
            super(model);
            recommendationDetailId(model.recommendationDetailId);
            recommendationDetailData(model.recommendationDetailData);
        }

        public final String getRecommendationDetailId() {
            return recommendationDetailId;
        }

        public final void setRecommendationDetailId(String recommendationDetailId) {
            this.recommendationDetailId = recommendationDetailId;
        }

        @Override
        public final Builder recommendationDetailId(String recommendationDetailId) {
            this.recommendationDetailId = recommendationDetailId;
            return this;
        }

        public final RecommendationDetailData.Builder getRecommendationDetailData() {
            return recommendationDetailData != null ? recommendationDetailData.toBuilder() : null;
        }

        public final void setRecommendationDetailData(RecommendationDetailData.BuilderImpl recommendationDetailData) {
            this.recommendationDetailData = recommendationDetailData != null ? recommendationDetailData.build() : null;
        }

        @Override
        public final Builder recommendationDetailData(RecommendationDetailData recommendationDetailData) {
            this.recommendationDetailData = recommendationDetailData;
            return this;
        }

        @Override
        public GetSavingsPlanPurchaseRecommendationDetailsResponse build() {
            return new GetSavingsPlanPurchaseRecommendationDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
