/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When you create or update a cost category, you can define the <code>CostCategoryRule</code> rule type as
 * <code>INHERITED_VALUE</code>. This rule type adds the flexibility to define a rule that dynamically inherits the cost
 * category value from the dimension value that's defined by <code>CostCategoryInheritedValueDimension</code>. For
 * example, suppose that you want to dynamically group costs that are based on the value of a specific tag key. First,
 * choose an inherited value rule type, and then choose the tag dimension and specify the tag key to use.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CostCategoryInheritedValueDimension implements SdkPojo, Serializable,
        ToCopyableBuilder<CostCategoryInheritedValueDimension.Builder, CostCategoryInheritedValueDimension> {
    private static final SdkField<String> DIMENSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DimensionName").getter(getter(CostCategoryInheritedValueDimension::dimensionNameAsString))
            .setter(setter(Builder::dimensionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionName").build()).build();

    private static final SdkField<String> DIMENSION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DimensionKey").getter(getter(CostCategoryInheritedValueDimension::dimensionKey))
            .setter(setter(Builder::dimensionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_NAME_FIELD,
            DIMENSION_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dimensionName;

    private final String dimensionKey;

    private CostCategoryInheritedValueDimension(BuilderImpl builder) {
        this.dimensionName = builder.dimensionName;
        this.dimensionKey = builder.dimensionKey;
    }

    /**
     * <p>
     * The name of the dimension that's used to group costs.
     * </p>
     * <p>
     * If you specify <code>LINKED_ACCOUNT_NAME</code>, the cost category value is based on account name. If you specify
     * <code>TAG</code>, the cost category value is based on the value of the specified tag key.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dimensionName}
     * will return {@link CostCategoryInheritedValueDimensionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #dimensionNameAsString}.
     * </p>
     * 
     * @return The name of the dimension that's used to group costs.</p>
     *         <p>
     *         If you specify <code>LINKED_ACCOUNT_NAME</code>, the cost category value is based on account name. If you
     *         specify <code>TAG</code>, the cost category value is based on the value of the specified tag key.
     * @see CostCategoryInheritedValueDimensionName
     */
    public final CostCategoryInheritedValueDimensionName dimensionName() {
        return CostCategoryInheritedValueDimensionName.fromValue(dimensionName);
    }

    /**
     * <p>
     * The name of the dimension that's used to group costs.
     * </p>
     * <p>
     * If you specify <code>LINKED_ACCOUNT_NAME</code>, the cost category value is based on account name. If you specify
     * <code>TAG</code>, the cost category value is based on the value of the specified tag key.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dimensionName}
     * will return {@link CostCategoryInheritedValueDimensionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #dimensionNameAsString}.
     * </p>
     * 
     * @return The name of the dimension that's used to group costs.</p>
     *         <p>
     *         If you specify <code>LINKED_ACCOUNT_NAME</code>, the cost category value is based on account name. If you
     *         specify <code>TAG</code>, the cost category value is based on the value of the specified tag key.
     * @see CostCategoryInheritedValueDimensionName
     */
    public final String dimensionNameAsString() {
        return dimensionName;
    }

    /**
     * <p>
     * The key to extract cost category values.
     * </p>
     * 
     * @return The key to extract cost category values.
     */
    public final String dimensionKey() {
        return dimensionKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensionNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dimensionKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostCategoryInheritedValueDimension)) {
            return false;
        }
        CostCategoryInheritedValueDimension other = (CostCategoryInheritedValueDimension) obj;
        return Objects.equals(dimensionNameAsString(), other.dimensionNameAsString())
                && Objects.equals(dimensionKey(), other.dimensionKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CostCategoryInheritedValueDimension").add("DimensionName", dimensionNameAsString())
                .add("DimensionKey", dimensionKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DimensionName":
            return Optional.ofNullable(clazz.cast(dimensionNameAsString()));
        case "DimensionKey":
            return Optional.ofNullable(clazz.cast(dimensionKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DimensionName", DIMENSION_NAME_FIELD);
        map.put("DimensionKey", DIMENSION_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CostCategoryInheritedValueDimension, T> g) {
        return obj -> g.apply((CostCategoryInheritedValueDimension) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CostCategoryInheritedValueDimension> {
        /**
         * <p>
         * The name of the dimension that's used to group costs.
         * </p>
         * <p>
         * If you specify <code>LINKED_ACCOUNT_NAME</code>, the cost category value is based on account name. If you
         * specify <code>TAG</code>, the cost category value is based on the value of the specified tag key.
         * </p>
         * 
         * @param dimensionName
         *        The name of the dimension that's used to group costs.</p>
         *        <p>
         *        If you specify <code>LINKED_ACCOUNT_NAME</code>, the cost category value is based on account name. If
         *        you specify <code>TAG</code>, the cost category value is based on the value of the specified tag key.
         * @see CostCategoryInheritedValueDimensionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryInheritedValueDimensionName
         */
        Builder dimensionName(String dimensionName);

        /**
         * <p>
         * The name of the dimension that's used to group costs.
         * </p>
         * <p>
         * If you specify <code>LINKED_ACCOUNT_NAME</code>, the cost category value is based on account name. If you
         * specify <code>TAG</code>, the cost category value is based on the value of the specified tag key.
         * </p>
         * 
         * @param dimensionName
         *        The name of the dimension that's used to group costs.</p>
         *        <p>
         *        If you specify <code>LINKED_ACCOUNT_NAME</code>, the cost category value is based on account name. If
         *        you specify <code>TAG</code>, the cost category value is based on the value of the specified tag key.
         * @see CostCategoryInheritedValueDimensionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryInheritedValueDimensionName
         */
        Builder dimensionName(CostCategoryInheritedValueDimensionName dimensionName);

        /**
         * <p>
         * The key to extract cost category values.
         * </p>
         * 
         * @param dimensionKey
         *        The key to extract cost category values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionKey(String dimensionKey);
    }

    static final class BuilderImpl implements Builder {
        private String dimensionName;

        private String dimensionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CostCategoryInheritedValueDimension model) {
            dimensionName(model.dimensionName);
            dimensionKey(model.dimensionKey);
        }

        public final String getDimensionName() {
            return dimensionName;
        }

        public final void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        @Override
        public final Builder dimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
            return this;
        }

        @Override
        public final Builder dimensionName(CostCategoryInheritedValueDimensionName dimensionName) {
            this.dimensionName(dimensionName == null ? null : dimensionName.toString());
            return this;
        }

        public final String getDimensionKey() {
            return dimensionKey;
        }

        public final void setDimensionKey(String dimensionKey) {
            this.dimensionKey = dimensionKey;
        }

        @Override
        public final Builder dimensionKey(String dimensionKey) {
            this.dimensionKey = dimensionKey;
            return this;
        }

        @Override
        public CostCategoryInheritedValueDimension build() {
            return new CostCategoryInheritedValueDimension(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
