/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCommitmentPurchaseAnalysesRequest extends CostExplorerRequest implements
        ToCopyableBuilder<ListCommitmentPurchaseAnalysesRequest.Builder, ListCommitmentPurchaseAnalysesRequest> {
    private static final SdkField<String> ANALYSIS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisStatus").getter(getter(ListCommitmentPurchaseAnalysesRequest::analysisStatusAsString))
            .setter(setter(Builder::analysisStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisStatus").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(ListCommitmentPurchaseAnalysesRequest::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(ListCommitmentPurchaseAnalysesRequest::pageSize))
            .setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<List<String>> ANALYSIS_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AnalysisIds")
            .getter(getter(ListCommitmentPurchaseAnalysesRequest::analysisIds))
            .setter(setter(Builder::analysisIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_STATUS_FIELD,
            NEXT_PAGE_TOKEN_FIELD, PAGE_SIZE_FIELD, ANALYSIS_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String analysisStatus;

    private final String nextPageToken;

    private final Integer pageSize;

    private final List<String> analysisIds;

    private ListCommitmentPurchaseAnalysesRequest(BuilderImpl builder) {
        super(builder);
        this.analysisStatus = builder.analysisStatus;
        this.nextPageToken = builder.nextPageToken;
        this.pageSize = builder.pageSize;
        this.analysisIds = builder.analysisIds;
    }

    /**
     * <p>
     * The status of the analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisStatus}
     * will return {@link AnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analysisStatusAsString}.
     * </p>
     * 
     * @return The status of the analysis.
     * @see AnalysisStatus
     */
    public final AnalysisStatus analysisStatus() {
        return AnalysisStatus.fromValue(analysisStatus);
    }

    /**
     * <p>
     * The status of the analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisStatus}
     * will return {@link AnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analysisStatusAsString}.
     * </p>
     * 
     * @return The status of the analysis.
     * @see AnalysisStatus
     */
    public final String analysisStatusAsString() {
        return analysisStatus;
    }

    /**
     * <p>
     * The token to retrieve the next set of results.
     * </p>
     * 
     * @return The token to retrieve the next set of results.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * The number of analyses that you want returned in a single response object.
     * </p>
     * 
     * @return The number of analyses that you want returned in a single response object.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnalysisIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnalysisIds() {
        return analysisIds != null && !(analysisIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The analysis IDs associated with the commitment purchase analyses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalysisIds} method.
     * </p>
     * 
     * @return The analysis IDs associated with the commitment purchase analyses.
     */
    public final List<String> analysisIds() {
        return analysisIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analysisStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalysisIds() ? analysisIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommitmentPurchaseAnalysesRequest)) {
            return false;
        }
        ListCommitmentPurchaseAnalysesRequest other = (ListCommitmentPurchaseAnalysesRequest) obj;
        return Objects.equals(analysisStatusAsString(), other.analysisStatusAsString())
                && Objects.equals(nextPageToken(), other.nextPageToken()) && Objects.equals(pageSize(), other.pageSize())
                && hasAnalysisIds() == other.hasAnalysisIds() && Objects.equals(analysisIds(), other.analysisIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCommitmentPurchaseAnalysesRequest").add("AnalysisStatus", analysisStatusAsString())
                .add("NextPageToken", nextPageToken()).add("PageSize", pageSize())
                .add("AnalysisIds", hasAnalysisIds() ? analysisIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnalysisStatus":
            return Optional.ofNullable(clazz.cast(analysisStatusAsString()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "AnalysisIds":
            return Optional.ofNullable(clazz.cast(analysisIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnalysisStatus", ANALYSIS_STATUS_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        map.put("PageSize", PAGE_SIZE_FIELD);
        map.put("AnalysisIds", ANALYSIS_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCommitmentPurchaseAnalysesRequest, T> g) {
        return obj -> g.apply((ListCommitmentPurchaseAnalysesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCommitmentPurchaseAnalysesRequest> {
        /**
         * <p>
         * The status of the analysis.
         * </p>
         * 
         * @param analysisStatus
         *        The status of the analysis.
         * @see AnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisStatus
         */
        Builder analysisStatus(String analysisStatus);

        /**
         * <p>
         * The status of the analysis.
         * </p>
         * 
         * @param analysisStatus
         *        The status of the analysis.
         * @see AnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisStatus
         */
        Builder analysisStatus(AnalysisStatus analysisStatus);

        /**
         * <p>
         * The token to retrieve the next set of results.
         * </p>
         * 
         * @param nextPageToken
         *        The token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The number of analyses that you want returned in a single response object.
         * </p>
         * 
         * @param pageSize
         *        The number of analyses that you want returned in a single response object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * The analysis IDs associated with the commitment purchase analyses.
         * </p>
         * 
         * @param analysisIds
         *        The analysis IDs associated with the commitment purchase analyses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisIds(Collection<String> analysisIds);

        /**
         * <p>
         * The analysis IDs associated with the commitment purchase analyses.
         * </p>
         * 
         * @param analysisIds
         *        The analysis IDs associated with the commitment purchase analyses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisIds(String... analysisIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String analysisStatus;

        private String nextPageToken;

        private Integer pageSize;

        private List<String> analysisIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommitmentPurchaseAnalysesRequest model) {
            super(model);
            analysisStatus(model.analysisStatus);
            nextPageToken(model.nextPageToken);
            pageSize(model.pageSize);
            analysisIds(model.analysisIds);
        }

        public final String getAnalysisStatus() {
            return analysisStatus;
        }

        public final void setAnalysisStatus(String analysisStatus) {
            this.analysisStatus = analysisStatus;
        }

        @Override
        public final Builder analysisStatus(String analysisStatus) {
            this.analysisStatus = analysisStatus;
            return this;
        }

        @Override
        public final Builder analysisStatus(AnalysisStatus analysisStatus) {
            this.analysisStatus(analysisStatus == null ? null : analysisStatus.toString());
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final Collection<String> getAnalysisIds() {
            if (analysisIds instanceof SdkAutoConstructList) {
                return null;
            }
            return analysisIds;
        }

        public final void setAnalysisIds(Collection<String> analysisIds) {
            this.analysisIds = AnalysisIdsCopier.copy(analysisIds);
        }

        @Override
        public final Builder analysisIds(Collection<String> analysisIds) {
            this.analysisIds = AnalysisIdsCopier.copy(analysisIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisIds(String... analysisIds) {
            analysisIds(Arrays.asList(analysisIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCommitmentPurchaseAnalysesRequest build() {
            return new ListCommitmentPurchaseAnalysesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
