/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result that's associated with a time period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultByTime implements SdkPojo, Serializable, ToCopyableBuilder<ResultByTime.Builder, ResultByTime> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .memberName("TimePeriod").getter(getter(ResultByTime::timePeriod)).setter(setter(Builder::timePeriod))
            .constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final SdkField<Map<String, MetricValue>> TOTAL_FIELD = SdkField
            .<Map<String, MetricValue>> builder(MarshallingType.MAP)
            .memberName("Total")
            .getter(getter(ResultByTime::total))
            .setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<MetricValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Group>> GROUPS_FIELD = SdkField
            .<List<Group>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(ResultByTime::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Group> builder(MarshallingType.SDK_POJO)
                                            .constructor(Group::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ESTIMATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Estimated").getter(getter(ResultByTime::estimated)).setter(setter(Builder::estimated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Estimated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD,
            TOTAL_FIELD, GROUPS_FIELD, ESTIMATED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DateInterval timePeriod;

    private final Map<String, MetricValue> total;

    private final List<Group> groups;

    private final Boolean estimated;

    private ResultByTime(BuilderImpl builder) {
        this.timePeriod = builder.timePeriod;
        this.total = builder.total;
        this.groups = builder.groups;
        this.estimated = builder.estimated;
    }

    /**
     * <p>
     * The time period that the result covers.
     * </p>
     * 
     * @return The time period that the result covers.
     */
    public final DateInterval timePeriod() {
        return timePeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the Total property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTotal() {
        return total != null && !(total instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The total amount of cost or usage accrued during the time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTotal} method.
     * </p>
     * 
     * @return The total amount of cost or usage accrued during the time period.
     */
    public final Map<String, MetricValue> total() {
        return total;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The groups that this time period includes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return The groups that this time period includes.
     */
    public final List<Group> groups() {
        return groups;
    }

    /**
     * <p>
     * Determines whether the result is estimated.
     * </p>
     * 
     * @return Determines whether the result is estimated.
     */
    public final Boolean estimated() {
        return estimated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasTotal() ? total() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(estimated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultByTime)) {
            return false;
        }
        ResultByTime other = (ResultByTime) obj;
        return Objects.equals(timePeriod(), other.timePeriod()) && hasTotal() == other.hasTotal()
                && Objects.equals(total(), other.total()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups()) && Objects.equals(estimated(), other.estimated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResultByTime").add("TimePeriod", timePeriod()).add("Total", hasTotal() ? total() : null)
                .add("Groups", hasGroups() ? groups() : null).add("Estimated", estimated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "Estimated":
            return Optional.ofNullable(clazz.cast(estimated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TimePeriod", TIME_PERIOD_FIELD);
        map.put("Total", TOTAL_FIELD);
        map.put("Groups", GROUPS_FIELD);
        map.put("Estimated", ESTIMATED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResultByTime, T> g) {
        return obj -> g.apply((ResultByTime) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultByTime> {
        /**
         * <p>
         * The time period that the result covers.
         * </p>
         * 
         * @param timePeriod
         *        The time period that the result covers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * <p>
         * The time period that the result covers.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateInterval.Builder} avoiding the need
         * to create one manually via {@link DateInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }

        /**
         * <p>
         * The total amount of cost or usage accrued during the time period.
         * </p>
         * 
         * @param total
         *        The total amount of cost or usage accrued during the time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Map<String, MetricValue> total);

        /**
         * <p>
         * The groups that this time period includes.
         * </p>
         * 
         * @param groups
         *        The groups that this time period includes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<Group> groups);

        /**
         * <p>
         * The groups that this time period includes.
         * </p>
         * 
         * @param groups
         *        The groups that this time period includes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Group... groups);

        /**
         * <p>
         * The groups that this time period includes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.Group.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.costexplorer.model.Group#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.Group.Builder#build()} is called immediately and
         * its result is passed to {@link #groups(List<Group>)}.
         * 
         * @param groups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.Group.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(java.util.Collection<Group>)
         */
        Builder groups(Consumer<Group.Builder>... groups);

        /**
         * <p>
         * Determines whether the result is estimated.
         * </p>
         * 
         * @param estimated
         *        Determines whether the result is estimated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimated(Boolean estimated);
    }

    static final class BuilderImpl implements Builder {
        private DateInterval timePeriod;

        private Map<String, MetricValue> total = DefaultSdkAutoConstructMap.getInstance();

        private List<Group> groups = DefaultSdkAutoConstructList.getInstance();

        private Boolean estimated;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultByTime model) {
            timePeriod(model.timePeriod);
            total(model.total);
            groups(model.groups);
            estimated(model.estimated);
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final Map<String, MetricValue.Builder> getTotal() {
            Map<String, MetricValue.Builder> result = MetricsCopier.copyToBuilder(this.total);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTotal(Map<String, MetricValue.BuilderImpl> total) {
            this.total = MetricsCopier.copyFromBuilder(total);
        }

        @Override
        public final Builder total(Map<String, MetricValue> total) {
            this.total = MetricsCopier.copy(total);
            return this;
        }

        public final List<Group.Builder> getGroups() {
            List<Group.Builder> result = GroupsCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<Group.BuilderImpl> groups) {
            this.groups = GroupsCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<Group> groups) {
            this.groups = GroupsCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Group... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<Group.Builder>... groups) {
            groups(Stream.of(groups).map(c -> Group.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEstimated() {
            return estimated;
        }

        public final void setEstimated(Boolean estimated) {
            this.estimated = estimated;
        }

        @Override
        public final Builder estimated(Boolean estimated) {
            this.estimated = estimated;
            return this;
        }

        @Override
        public ResultByTime build() {
            return new ResultByTime(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
