/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary metrics for your Savings Plans Purchase Recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansPurchaseRecommendationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansPurchaseRecommendationSummary.Builder, SavingsPlansPurchaseRecommendationSummary> {
    private static final SdkField<String> ESTIMATED_ROI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedROI").getter(getter(SavingsPlansPurchaseRecommendationSummary::estimatedROI))
            .setter(setter(Builder::estimatedROI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedROI").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(SavingsPlansPurchaseRecommendationSummary::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<String> ESTIMATED_TOTAL_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedTotalCost").getter(getter(SavingsPlansPurchaseRecommendationSummary::estimatedTotalCost))
            .setter(setter(Builder::estimatedTotalCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTotalCost").build())
            .build();

    private static final SdkField<String> CURRENT_ON_DEMAND_SPEND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentOnDemandSpend").getter(getter(SavingsPlansPurchaseRecommendationSummary::currentOnDemandSpend))
            .setter(setter(Builder::currentOnDemandSpend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentOnDemandSpend").build())
            .build();

    private static final SdkField<String> ESTIMATED_SAVINGS_AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedSavingsAmount")
            .getter(getter(SavingsPlansPurchaseRecommendationSummary::estimatedSavingsAmount))
            .setter(setter(Builder::estimatedSavingsAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSavingsAmount").build())
            .build();

    private static final SdkField<String> TOTAL_RECOMMENDATION_COUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TotalRecommendationCount")
            .getter(getter(SavingsPlansPurchaseRecommendationSummary::totalRecommendationCount))
            .setter(setter(Builder::totalRecommendationCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRecommendationCount").build())
            .build();

    private static final SdkField<String> DAILY_COMMITMENT_TO_PURCHASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DailyCommitmentToPurchase")
            .getter(getter(SavingsPlansPurchaseRecommendationSummary::dailyCommitmentToPurchase))
            .setter(setter(Builder::dailyCommitmentToPurchase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyCommitmentToPurchase").build())
            .build();

    private static final SdkField<String> HOURLY_COMMITMENT_TO_PURCHASE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HourlyCommitmentToPurchase")
            .getter(getter(SavingsPlansPurchaseRecommendationSummary::hourlyCommitmentToPurchase))
            .setter(setter(Builder::hourlyCommitmentToPurchase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyCommitmentToPurchase").build())
            .build();

    private static final SdkField<String> ESTIMATED_SAVINGS_PERCENTAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedSavingsPercentage")
            .getter(getter(SavingsPlansPurchaseRecommendationSummary::estimatedSavingsPercentage))
            .setter(setter(Builder::estimatedSavingsPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSavingsPercentage").build())
            .build();

    private static final SdkField<String> ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedMonthlySavingsAmount")
            .getter(getter(SavingsPlansPurchaseRecommendationSummary::estimatedMonthlySavingsAmount))
            .setter(setter(Builder::estimatedMonthlySavingsAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlySavingsAmount")
                    .build()).build();

    private static final SdkField<String> ESTIMATED_ON_DEMAND_COST_WITH_CURRENT_COMMITMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedOnDemandCostWithCurrentCommitment")
            .getter(getter(SavingsPlansPurchaseRecommendationSummary::estimatedOnDemandCostWithCurrentCommitment))
            .setter(setter(Builder::estimatedOnDemandCostWithCurrentCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EstimatedOnDemandCostWithCurrentCommitment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ESTIMATED_ROI_FIELD,
            CURRENCY_CODE_FIELD, ESTIMATED_TOTAL_COST_FIELD, CURRENT_ON_DEMAND_SPEND_FIELD, ESTIMATED_SAVINGS_AMOUNT_FIELD,
            TOTAL_RECOMMENDATION_COUNT_FIELD, DAILY_COMMITMENT_TO_PURCHASE_FIELD, HOURLY_COMMITMENT_TO_PURCHASE_FIELD,
            ESTIMATED_SAVINGS_PERCENTAGE_FIELD, ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD,
            ESTIMATED_ON_DEMAND_COST_WITH_CURRENT_COMMITMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String estimatedROI;

    private final String currencyCode;

    private final String estimatedTotalCost;

    private final String currentOnDemandSpend;

    private final String estimatedSavingsAmount;

    private final String totalRecommendationCount;

    private final String dailyCommitmentToPurchase;

    private final String hourlyCommitmentToPurchase;

    private final String estimatedSavingsPercentage;

    private final String estimatedMonthlySavingsAmount;

    private final String estimatedOnDemandCostWithCurrentCommitment;

    private SavingsPlansPurchaseRecommendationSummary(BuilderImpl builder) {
        this.estimatedROI = builder.estimatedROI;
        this.currencyCode = builder.currencyCode;
        this.estimatedTotalCost = builder.estimatedTotalCost;
        this.currentOnDemandSpend = builder.currentOnDemandSpend;
        this.estimatedSavingsAmount = builder.estimatedSavingsAmount;
        this.totalRecommendationCount = builder.totalRecommendationCount;
        this.dailyCommitmentToPurchase = builder.dailyCommitmentToPurchase;
        this.hourlyCommitmentToPurchase = builder.hourlyCommitmentToPurchase;
        this.estimatedSavingsPercentage = builder.estimatedSavingsPercentage;
        this.estimatedMonthlySavingsAmount = builder.estimatedMonthlySavingsAmount;
        this.estimatedOnDemandCostWithCurrentCommitment = builder.estimatedOnDemandCostWithCurrentCommitment;
    }

    /**
     * <p>
     * The estimated return on investment that's based on the recommended Savings Plans and estimated savings.
     * </p>
     * 
     * @return The estimated return on investment that's based on the recommended Savings Plans and estimated savings.
     */
    public final String estimatedROI() {
        return estimatedROI;
    }

    /**
     * <p>
     * The currency code that Amazon Web Services used to generate the recommendations and present potential savings.
     * </p>
     * 
     * @return The currency code that Amazon Web Services used to generate the recommendations and present potential
     *         savings.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The estimated total cost of the usage after purchasing the recommended Savings Plans. This is a sum of the cost
     * of Savings Plans during this term, and the remaining On-Demand usage.
     * </p>
     * 
     * @return The estimated total cost of the usage after purchasing the recommended Savings Plans. This is a sum of
     *         the cost of Savings Plans during this term, and the remaining On-Demand usage.
     */
    public final String estimatedTotalCost() {
        return estimatedTotalCost;
    }

    /**
     * <p>
     * The current total on demand spend of the applicable usage types over the lookback period.
     * </p>
     * 
     * @return The current total on demand spend of the applicable usage types over the lookback period.
     */
    public final String currentOnDemandSpend() {
        return currentOnDemandSpend;
    }

    /**
     * <p>
     * The estimated total savings over the lookback period, based on the purchase of the recommended Savings Plans.
     * </p>
     * 
     * @return The estimated total savings over the lookback period, based on the purchase of the recommended Savings
     *         Plans.
     */
    public final String estimatedSavingsAmount() {
        return estimatedSavingsAmount;
    }

    /**
     * <p>
     * The aggregate number of Savings Plans recommendations that exist for your account.
     * </p>
     * 
     * @return The aggregate number of Savings Plans recommendations that exist for your account.
     */
    public final String totalRecommendationCount() {
        return totalRecommendationCount;
    }

    /**
     * <p>
     * The recommended Savings Plans cost on a daily (24 hourly) basis.
     * </p>
     * 
     * @return The recommended Savings Plans cost on a daily (24 hourly) basis.
     */
    public final String dailyCommitmentToPurchase() {
        return dailyCommitmentToPurchase;
    }

    /**
     * <p>
     * The recommended hourly commitment that's based on the recommendation parameters.
     * </p>
     * 
     * @return The recommended hourly commitment that's based on the recommendation parameters.
     */
    public final String hourlyCommitmentToPurchase() {
        return hourlyCommitmentToPurchase;
    }

    /**
     * <p>
     * The estimated savings relative to the total cost of On-Demand usage, over the lookback period. This is calculated
     * as <code>estimatedSavingsAmount</code>/ <code>CurrentOnDemandSpend</code>*100.
     * </p>
     * 
     * @return The estimated savings relative to the total cost of On-Demand usage, over the lookback period. This is
     *         calculated as <code>estimatedSavingsAmount</code>/ <code>CurrentOnDemandSpend</code>*100.
     */
    public final String estimatedSavingsPercentage() {
        return estimatedSavingsPercentage;
    }

    /**
     * <p>
     * The estimated monthly savings amount that's based on the recommended Savings Plans purchase.
     * </p>
     * 
     * @return The estimated monthly savings amount that's based on the recommended Savings Plans purchase.
     */
    public final String estimatedMonthlySavingsAmount() {
        return estimatedMonthlySavingsAmount;
    }

    /**
     * <p>
     * The estimated On-Demand costs you expect with no additional commitment. It's based on your usage of the selected
     * time period and the Savings Plans you own.
     * </p>
     * 
     * @return The estimated On-Demand costs you expect with no additional commitment. It's based on your usage of the
     *         selected time period and the Savings Plans you own.
     */
    public final String estimatedOnDemandCostWithCurrentCommitment() {
        return estimatedOnDemandCostWithCurrentCommitment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(estimatedROI());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTotalCost());
        hashCode = 31 * hashCode + Objects.hashCode(currentOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedSavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(totalRecommendationCount());
        hashCode = 31 * hashCode + Objects.hashCode(dailyCommitmentToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(hourlyCommitmentToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedSavingsPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlySavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedOnDemandCostWithCurrentCommitment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansPurchaseRecommendationSummary)) {
            return false;
        }
        SavingsPlansPurchaseRecommendationSummary other = (SavingsPlansPurchaseRecommendationSummary) obj;
        return Objects.equals(estimatedROI(), other.estimatedROI())
                && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(estimatedTotalCost(), other.estimatedTotalCost())
                && Objects.equals(currentOnDemandSpend(), other.currentOnDemandSpend())
                && Objects.equals(estimatedSavingsAmount(), other.estimatedSavingsAmount())
                && Objects.equals(totalRecommendationCount(), other.totalRecommendationCount())
                && Objects.equals(dailyCommitmentToPurchase(), other.dailyCommitmentToPurchase())
                && Objects.equals(hourlyCommitmentToPurchase(), other.hourlyCommitmentToPurchase())
                && Objects.equals(estimatedSavingsPercentage(), other.estimatedSavingsPercentage())
                && Objects.equals(estimatedMonthlySavingsAmount(), other.estimatedMonthlySavingsAmount())
                && Objects.equals(estimatedOnDemandCostWithCurrentCommitment(),
                        other.estimatedOnDemandCostWithCurrentCommitment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlansPurchaseRecommendationSummary").add("EstimatedROI", estimatedROI())
                .add("CurrencyCode", currencyCode()).add("EstimatedTotalCost", estimatedTotalCost())
                .add("CurrentOnDemandSpend", currentOnDemandSpend()).add("EstimatedSavingsAmount", estimatedSavingsAmount())
                .add("TotalRecommendationCount", totalRecommendationCount())
                .add("DailyCommitmentToPurchase", dailyCommitmentToPurchase())
                .add("HourlyCommitmentToPurchase", hourlyCommitmentToPurchase())
                .add("EstimatedSavingsPercentage", estimatedSavingsPercentage())
                .add("EstimatedMonthlySavingsAmount", estimatedMonthlySavingsAmount())
                .add("EstimatedOnDemandCostWithCurrentCommitment", estimatedOnDemandCostWithCurrentCommitment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EstimatedROI":
            return Optional.ofNullable(clazz.cast(estimatedROI()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "EstimatedTotalCost":
            return Optional.ofNullable(clazz.cast(estimatedTotalCost()));
        case "CurrentOnDemandSpend":
            return Optional.ofNullable(clazz.cast(currentOnDemandSpend()));
        case "EstimatedSavingsAmount":
            return Optional.ofNullable(clazz.cast(estimatedSavingsAmount()));
        case "TotalRecommendationCount":
            return Optional.ofNullable(clazz.cast(totalRecommendationCount()));
        case "DailyCommitmentToPurchase":
            return Optional.ofNullable(clazz.cast(dailyCommitmentToPurchase()));
        case "HourlyCommitmentToPurchase":
            return Optional.ofNullable(clazz.cast(hourlyCommitmentToPurchase()));
        case "EstimatedSavingsPercentage":
            return Optional.ofNullable(clazz.cast(estimatedSavingsPercentage()));
        case "EstimatedMonthlySavingsAmount":
            return Optional.ofNullable(clazz.cast(estimatedMonthlySavingsAmount()));
        case "EstimatedOnDemandCostWithCurrentCommitment":
            return Optional.ofNullable(clazz.cast(estimatedOnDemandCostWithCurrentCommitment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EstimatedROI", ESTIMATED_ROI_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("EstimatedTotalCost", ESTIMATED_TOTAL_COST_FIELD);
        map.put("CurrentOnDemandSpend", CURRENT_ON_DEMAND_SPEND_FIELD);
        map.put("EstimatedSavingsAmount", ESTIMATED_SAVINGS_AMOUNT_FIELD);
        map.put("TotalRecommendationCount", TOTAL_RECOMMENDATION_COUNT_FIELD);
        map.put("DailyCommitmentToPurchase", DAILY_COMMITMENT_TO_PURCHASE_FIELD);
        map.put("HourlyCommitmentToPurchase", HOURLY_COMMITMENT_TO_PURCHASE_FIELD);
        map.put("EstimatedSavingsPercentage", ESTIMATED_SAVINGS_PERCENTAGE_FIELD);
        map.put("EstimatedMonthlySavingsAmount", ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD);
        map.put("EstimatedOnDemandCostWithCurrentCommitment", ESTIMATED_ON_DEMAND_COST_WITH_CURRENT_COMMITMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansPurchaseRecommendationSummary, T> g) {
        return obj -> g.apply((SavingsPlansPurchaseRecommendationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansPurchaseRecommendationSummary> {
        /**
         * <p>
         * The estimated return on investment that's based on the recommended Savings Plans and estimated savings.
         * </p>
         * 
         * @param estimatedROI
         *        The estimated return on investment that's based on the recommended Savings Plans and estimated
         *        savings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedROI(String estimatedROI);

        /**
         * <p>
         * The currency code that Amazon Web Services used to generate the recommendations and present potential
         * savings.
         * </p>
         * 
         * @param currencyCode
         *        The currency code that Amazon Web Services used to generate the recommendations and present potential
         *        savings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The estimated total cost of the usage after purchasing the recommended Savings Plans. This is a sum of the
         * cost of Savings Plans during this term, and the remaining On-Demand usage.
         * </p>
         * 
         * @param estimatedTotalCost
         *        The estimated total cost of the usage after purchasing the recommended Savings Plans. This is a sum of
         *        the cost of Savings Plans during this term, and the remaining On-Demand usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTotalCost(String estimatedTotalCost);

        /**
         * <p>
         * The current total on demand spend of the applicable usage types over the lookback period.
         * </p>
         * 
         * @param currentOnDemandSpend
         *        The current total on demand spend of the applicable usage types over the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentOnDemandSpend(String currentOnDemandSpend);

        /**
         * <p>
         * The estimated total savings over the lookback period, based on the purchase of the recommended Savings Plans.
         * </p>
         * 
         * @param estimatedSavingsAmount
         *        The estimated total savings over the lookback period, based on the purchase of the recommended Savings
         *        Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedSavingsAmount(String estimatedSavingsAmount);

        /**
         * <p>
         * The aggregate number of Savings Plans recommendations that exist for your account.
         * </p>
         * 
         * @param totalRecommendationCount
         *        The aggregate number of Savings Plans recommendations that exist for your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRecommendationCount(String totalRecommendationCount);

        /**
         * <p>
         * The recommended Savings Plans cost on a daily (24 hourly) basis.
         * </p>
         * 
         * @param dailyCommitmentToPurchase
         *        The recommended Savings Plans cost on a daily (24 hourly) basis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyCommitmentToPurchase(String dailyCommitmentToPurchase);

        /**
         * <p>
         * The recommended hourly commitment that's based on the recommendation parameters.
         * </p>
         * 
         * @param hourlyCommitmentToPurchase
         *        The recommended hourly commitment that's based on the recommendation parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyCommitmentToPurchase(String hourlyCommitmentToPurchase);

        /**
         * <p>
         * The estimated savings relative to the total cost of On-Demand usage, over the lookback period. This is
         * calculated as <code>estimatedSavingsAmount</code>/ <code>CurrentOnDemandSpend</code>*100.
         * </p>
         * 
         * @param estimatedSavingsPercentage
         *        The estimated savings relative to the total cost of On-Demand usage, over the lookback period. This is
         *        calculated as <code>estimatedSavingsAmount</code>/ <code>CurrentOnDemandSpend</code>*100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedSavingsPercentage(String estimatedSavingsPercentage);

        /**
         * <p>
         * The estimated monthly savings amount that's based on the recommended Savings Plans purchase.
         * </p>
         * 
         * @param estimatedMonthlySavingsAmount
         *        The estimated monthly savings amount that's based on the recommended Savings Plans purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount);

        /**
         * <p>
         * The estimated On-Demand costs you expect with no additional commitment. It's based on your usage of the
         * selected time period and the Savings Plans you own.
         * </p>
         * 
         * @param estimatedOnDemandCostWithCurrentCommitment
         *        The estimated On-Demand costs you expect with no additional commitment. It's based on your usage of
         *        the selected time period and the Savings Plans you own.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedOnDemandCostWithCurrentCommitment(String estimatedOnDemandCostWithCurrentCommitment);
    }

    static final class BuilderImpl implements Builder {
        private String estimatedROI;

        private String currencyCode;

        private String estimatedTotalCost;

        private String currentOnDemandSpend;

        private String estimatedSavingsAmount;

        private String totalRecommendationCount;

        private String dailyCommitmentToPurchase;

        private String hourlyCommitmentToPurchase;

        private String estimatedSavingsPercentage;

        private String estimatedMonthlySavingsAmount;

        private String estimatedOnDemandCostWithCurrentCommitment;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansPurchaseRecommendationSummary model) {
            estimatedROI(model.estimatedROI);
            currencyCode(model.currencyCode);
            estimatedTotalCost(model.estimatedTotalCost);
            currentOnDemandSpend(model.currentOnDemandSpend);
            estimatedSavingsAmount(model.estimatedSavingsAmount);
            totalRecommendationCount(model.totalRecommendationCount);
            dailyCommitmentToPurchase(model.dailyCommitmentToPurchase);
            hourlyCommitmentToPurchase(model.hourlyCommitmentToPurchase);
            estimatedSavingsPercentage(model.estimatedSavingsPercentage);
            estimatedMonthlySavingsAmount(model.estimatedMonthlySavingsAmount);
            estimatedOnDemandCostWithCurrentCommitment(model.estimatedOnDemandCostWithCurrentCommitment);
        }

        public final String getEstimatedROI() {
            return estimatedROI;
        }

        public final void setEstimatedROI(String estimatedROI) {
            this.estimatedROI = estimatedROI;
        }

        @Override
        public final Builder estimatedROI(String estimatedROI) {
            this.estimatedROI = estimatedROI;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getEstimatedTotalCost() {
            return estimatedTotalCost;
        }

        public final void setEstimatedTotalCost(String estimatedTotalCost) {
            this.estimatedTotalCost = estimatedTotalCost;
        }

        @Override
        public final Builder estimatedTotalCost(String estimatedTotalCost) {
            this.estimatedTotalCost = estimatedTotalCost;
            return this;
        }

        public final String getCurrentOnDemandSpend() {
            return currentOnDemandSpend;
        }

        public final void setCurrentOnDemandSpend(String currentOnDemandSpend) {
            this.currentOnDemandSpend = currentOnDemandSpend;
        }

        @Override
        public final Builder currentOnDemandSpend(String currentOnDemandSpend) {
            this.currentOnDemandSpend = currentOnDemandSpend;
            return this;
        }

        public final String getEstimatedSavingsAmount() {
            return estimatedSavingsAmount;
        }

        public final void setEstimatedSavingsAmount(String estimatedSavingsAmount) {
            this.estimatedSavingsAmount = estimatedSavingsAmount;
        }

        @Override
        public final Builder estimatedSavingsAmount(String estimatedSavingsAmount) {
            this.estimatedSavingsAmount = estimatedSavingsAmount;
            return this;
        }

        public final String getTotalRecommendationCount() {
            return totalRecommendationCount;
        }

        public final void setTotalRecommendationCount(String totalRecommendationCount) {
            this.totalRecommendationCount = totalRecommendationCount;
        }

        @Override
        public final Builder totalRecommendationCount(String totalRecommendationCount) {
            this.totalRecommendationCount = totalRecommendationCount;
            return this;
        }

        public final String getDailyCommitmentToPurchase() {
            return dailyCommitmentToPurchase;
        }

        public final void setDailyCommitmentToPurchase(String dailyCommitmentToPurchase) {
            this.dailyCommitmentToPurchase = dailyCommitmentToPurchase;
        }

        @Override
        public final Builder dailyCommitmentToPurchase(String dailyCommitmentToPurchase) {
            this.dailyCommitmentToPurchase = dailyCommitmentToPurchase;
            return this;
        }

        public final String getHourlyCommitmentToPurchase() {
            return hourlyCommitmentToPurchase;
        }

        public final void setHourlyCommitmentToPurchase(String hourlyCommitmentToPurchase) {
            this.hourlyCommitmentToPurchase = hourlyCommitmentToPurchase;
        }

        @Override
        public final Builder hourlyCommitmentToPurchase(String hourlyCommitmentToPurchase) {
            this.hourlyCommitmentToPurchase = hourlyCommitmentToPurchase;
            return this;
        }

        public final String getEstimatedSavingsPercentage() {
            return estimatedSavingsPercentage;
        }

        public final void setEstimatedSavingsPercentage(String estimatedSavingsPercentage) {
            this.estimatedSavingsPercentage = estimatedSavingsPercentage;
        }

        @Override
        public final Builder estimatedSavingsPercentage(String estimatedSavingsPercentage) {
            this.estimatedSavingsPercentage = estimatedSavingsPercentage;
            return this;
        }

        public final String getEstimatedMonthlySavingsAmount() {
            return estimatedMonthlySavingsAmount;
        }

        public final void setEstimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount) {
            this.estimatedMonthlySavingsAmount = estimatedMonthlySavingsAmount;
        }

        @Override
        public final Builder estimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount) {
            this.estimatedMonthlySavingsAmount = estimatedMonthlySavingsAmount;
            return this;
        }

        public final String getEstimatedOnDemandCostWithCurrentCommitment() {
            return estimatedOnDemandCostWithCurrentCommitment;
        }

        public final void setEstimatedOnDemandCostWithCurrentCommitment(String estimatedOnDemandCostWithCurrentCommitment) {
            this.estimatedOnDemandCostWithCurrentCommitment = estimatedOnDemandCostWithCurrentCommitment;
        }

        @Override
        public final Builder estimatedOnDemandCostWithCurrentCommitment(String estimatedOnDemandCostWithCurrentCommitment) {
            this.estimatedOnDemandCostWithCurrentCommitment = estimatedOnDemandCostWithCurrentCommitment;
            return this;
        }

        @Override
        public SavingsPlansPurchaseRecommendationSummary build() {
            return new SavingsPlansPurchaseRecommendationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
