/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The cost allocation tag structure. This includes detailed metadata for the <code>CostAllocationTag</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CostAllocationTag implements SdkPojo, Serializable,
        ToCopyableBuilder<CostAllocationTag.Builder, CostAllocationTag> {
    private static final SdkField<String> TAG_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TagKey")
            .getter(getter(CostAllocationTag::tagKey)).setter(setter(Builder::tagKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CostAllocationTag::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CostAllocationTag::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> LAST_UPDATED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedDate").getter(getter(CostAllocationTag::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDate").build()).build();

    private static final SdkField<String> LAST_USED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUsedDate").getter(getter(CostAllocationTag::lastUsedDate)).setter(setter(Builder::lastUsedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUsedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_KEY_FIELD, TYPE_FIELD,
            STATUS_FIELD, LAST_UPDATED_DATE_FIELD, LAST_USED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tagKey;

    private final String type;

    private final String status;

    private final String lastUpdatedDate;

    private final String lastUsedDate;

    private CostAllocationTag(BuilderImpl builder) {
        this.tagKey = builder.tagKey;
        this.type = builder.type;
        this.status = builder.status;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.lastUsedDate = builder.lastUsedDate;
    }

    /**
     * <p>
     * The key for the cost allocation tag.
     * </p>
     * 
     * @return The key for the cost allocation tag.
     */
    public final String tagKey() {
        return tagKey;
    }

    /**
     * <p>
     * The type of cost allocation tag. You can use <code>AWSGenerated</code> or <code>UserDefined</code> type tags.
     * <code>AWSGenerated</code> type tags are tags that Amazon Web Services defines and applies to support Amazon Web
     * Services resources for cost allocation purposes. <code>UserDefined</code> type tags are tags that you define,
     * create, and apply to resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CostAllocationTagType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of cost allocation tag. You can use <code>AWSGenerated</code> or <code>UserDefined</code> type
     *         tags. <code>AWSGenerated</code> type tags are tags that Amazon Web Services defines and applies to
     *         support Amazon Web Services resources for cost allocation purposes. <code>UserDefined</code> type tags
     *         are tags that you define, create, and apply to resources.
     * @see CostAllocationTagType
     */
    public final CostAllocationTagType type() {
        return CostAllocationTagType.fromValue(type);
    }

    /**
     * <p>
     * The type of cost allocation tag. You can use <code>AWSGenerated</code> or <code>UserDefined</code> type tags.
     * <code>AWSGenerated</code> type tags are tags that Amazon Web Services defines and applies to support Amazon Web
     * Services resources for cost allocation purposes. <code>UserDefined</code> type tags are tags that you define,
     * create, and apply to resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CostAllocationTagType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of cost allocation tag. You can use <code>AWSGenerated</code> or <code>UserDefined</code> type
     *         tags. <code>AWSGenerated</code> type tags are tags that Amazon Web Services defines and applies to
     *         support Amazon Web Services resources for cost allocation purposes. <code>UserDefined</code> type tags
     *         are tags that you define, create, and apply to resources.
     * @see CostAllocationTagType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The status of a cost allocation tag.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CostAllocationTagStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a cost allocation tag.
     * @see CostAllocationTagStatus
     */
    public final CostAllocationTagStatus status() {
        return CostAllocationTagStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a cost allocation tag.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CostAllocationTagStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a cost allocation tag.
     * @see CostAllocationTagStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The last date that the tag was either activated or deactivated.
     * </p>
     * 
     * @return The last date that the tag was either activated or deactivated.
     */
    public final String lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The last month that the tag was used on an Amazon Web Services resource.
     * </p>
     * 
     * @return The last month that the tag was used on an Amazon Web Services resource.
     */
    public final String lastUsedDate() {
        return lastUsedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUsedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostAllocationTag)) {
            return false;
        }
        CostAllocationTag other = (CostAllocationTag) obj;
        return Objects.equals(tagKey(), other.tagKey()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(lastUsedDate(), other.lastUsedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CostAllocationTag").add("TagKey", tagKey()).add("Type", typeAsString())
                .add("Status", statusAsString()).add("LastUpdatedDate", lastUpdatedDate()).add("LastUsedDate", lastUsedDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagKey":
            return Optional.ofNullable(clazz.cast(tagKey()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "LastUsedDate":
            return Optional.ofNullable(clazz.cast(lastUsedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TagKey", TAG_KEY_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("LastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        map.put("LastUsedDate", LAST_USED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CostAllocationTag, T> g) {
        return obj -> g.apply((CostAllocationTag) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CostAllocationTag> {
        /**
         * <p>
         * The key for the cost allocation tag.
         * </p>
         * 
         * @param tagKey
         *        The key for the cost allocation tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKey(String tagKey);

        /**
         * <p>
         * The type of cost allocation tag. You can use <code>AWSGenerated</code> or <code>UserDefined</code> type tags.
         * <code>AWSGenerated</code> type tags are tags that Amazon Web Services defines and applies to support Amazon
         * Web Services resources for cost allocation purposes. <code>UserDefined</code> type tags are tags that you
         * define, create, and apply to resources.
         * </p>
         * 
         * @param type
         *        The type of cost allocation tag. You can use <code>AWSGenerated</code> or <code>UserDefined</code>
         *        type tags. <code>AWSGenerated</code> type tags are tags that Amazon Web Services defines and applies
         *        to support Amazon Web Services resources for cost allocation purposes. <code>UserDefined</code> type
         *        tags are tags that you define, create, and apply to resources.
         * @see CostAllocationTagType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostAllocationTagType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of cost allocation tag. You can use <code>AWSGenerated</code> or <code>UserDefined</code> type tags.
         * <code>AWSGenerated</code> type tags are tags that Amazon Web Services defines and applies to support Amazon
         * Web Services resources for cost allocation purposes. <code>UserDefined</code> type tags are tags that you
         * define, create, and apply to resources.
         * </p>
         * 
         * @param type
         *        The type of cost allocation tag. You can use <code>AWSGenerated</code> or <code>UserDefined</code>
         *        type tags. <code>AWSGenerated</code> type tags are tags that Amazon Web Services defines and applies
         *        to support Amazon Web Services resources for cost allocation purposes. <code>UserDefined</code> type
         *        tags are tags that you define, create, and apply to resources.
         * @see CostAllocationTagType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostAllocationTagType
         */
        Builder type(CostAllocationTagType type);

        /**
         * <p>
         * The status of a cost allocation tag.
         * </p>
         * 
         * @param status
         *        The status of a cost allocation tag.
         * @see CostAllocationTagStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostAllocationTagStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a cost allocation tag.
         * </p>
         * 
         * @param status
         *        The status of a cost allocation tag.
         * @see CostAllocationTagStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostAllocationTagStatus
         */
        Builder status(CostAllocationTagStatus status);

        /**
         * <p>
         * The last date that the tag was either activated or deactivated.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The last date that the tag was either activated or deactivated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(String lastUpdatedDate);

        /**
         * <p>
         * The last month that the tag was used on an Amazon Web Services resource.
         * </p>
         * 
         * @param lastUsedDate
         *        The last month that the tag was used on an Amazon Web Services resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUsedDate(String lastUsedDate);
    }

    static final class BuilderImpl implements Builder {
        private String tagKey;

        private String type;

        private String status;

        private String lastUpdatedDate;

        private String lastUsedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CostAllocationTag model) {
            tagKey(model.tagKey);
            type(model.type);
            status(model.status);
            lastUpdatedDate(model.lastUpdatedDate);
            lastUsedDate(model.lastUsedDate);
        }

        public final String getTagKey() {
            return tagKey;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CostAllocationTagType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CostAllocationTagStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(String lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(String lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final String getLastUsedDate() {
            return lastUsedDate;
        }

        public final void setLastUsedDate(String lastUsedDate) {
            this.lastUsedDate = lastUsedDate;
        }

        @Override
        public final Builder lastUsedDate(String lastUsedDate) {
            this.lastUsedDate = lastUsedDate;
            return this;
        }

        @Override
        public CostAllocationTag build() {
            return new CostAllocationTag(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
