/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Utilization metrics for the instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EC2ResourceUtilization implements SdkPojo, Serializable,
        ToCopyableBuilder<EC2ResourceUtilization.Builder, EC2ResourceUtilization> {
    private static final SdkField<String> MAX_CPU_UTILIZATION_PERCENTAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxCpuUtilizationPercentage")
            .getter(getter(EC2ResourceUtilization::maxCpuUtilizationPercentage))
            .setter(setter(Builder::maxCpuUtilizationPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCpuUtilizationPercentage")
                    .build()).build();

    private static final SdkField<String> MAX_MEMORY_UTILIZATION_PERCENTAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxMemoryUtilizationPercentage")
            .getter(getter(EC2ResourceUtilization::maxMemoryUtilizationPercentage))
            .setter(setter(Builder::maxMemoryUtilizationPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxMemoryUtilizationPercentage")
                    .build()).build();

    private static final SdkField<String> MAX_STORAGE_UTILIZATION_PERCENTAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxStorageUtilizationPercentage")
            .getter(getter(EC2ResourceUtilization::maxStorageUtilizationPercentage))
            .setter(setter(Builder::maxStorageUtilizationPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxStorageUtilizationPercentage")
                    .build()).build();

    private static final SdkField<EBSResourceUtilization> EBS_RESOURCE_UTILIZATION_FIELD = SdkField
            .<EBSResourceUtilization> builder(MarshallingType.SDK_POJO).memberName("EBSResourceUtilization")
            .getter(getter(EC2ResourceUtilization::ebsResourceUtilization)).setter(setter(Builder::ebsResourceUtilization))
            .constructor(EBSResourceUtilization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSResourceUtilization").build())
            .build();

    private static final SdkField<DiskResourceUtilization> DISK_RESOURCE_UTILIZATION_FIELD = SdkField
            .<DiskResourceUtilization> builder(MarshallingType.SDK_POJO).memberName("DiskResourceUtilization")
            .getter(getter(EC2ResourceUtilization::diskResourceUtilization)).setter(setter(Builder::diskResourceUtilization))
            .constructor(DiskResourceUtilization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskResourceUtilization").build())
            .build();

    private static final SdkField<NetworkResourceUtilization> NETWORK_RESOURCE_UTILIZATION_FIELD = SdkField
            .<NetworkResourceUtilization> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkResourceUtilization")
            .getter(getter(EC2ResourceUtilization::networkResourceUtilization))
            .setter(setter(Builder::networkResourceUtilization))
            .constructor(NetworkResourceUtilization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkResourceUtilization").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAX_CPU_UTILIZATION_PERCENTAGE_FIELD, MAX_MEMORY_UTILIZATION_PERCENTAGE_FIELD,
            MAX_STORAGE_UTILIZATION_PERCENTAGE_FIELD, EBS_RESOURCE_UTILIZATION_FIELD, DISK_RESOURCE_UTILIZATION_FIELD,
            NETWORK_RESOURCE_UTILIZATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String maxCpuUtilizationPercentage;

    private final String maxMemoryUtilizationPercentage;

    private final String maxStorageUtilizationPercentage;

    private final EBSResourceUtilization ebsResourceUtilization;

    private final DiskResourceUtilization diskResourceUtilization;

    private final NetworkResourceUtilization networkResourceUtilization;

    private EC2ResourceUtilization(BuilderImpl builder) {
        this.maxCpuUtilizationPercentage = builder.maxCpuUtilizationPercentage;
        this.maxMemoryUtilizationPercentage = builder.maxMemoryUtilizationPercentage;
        this.maxStorageUtilizationPercentage = builder.maxStorageUtilizationPercentage;
        this.ebsResourceUtilization = builder.ebsResourceUtilization;
        this.diskResourceUtilization = builder.diskResourceUtilization;
        this.networkResourceUtilization = builder.networkResourceUtilization;
    }

    /**
     * <p>
     * The maximum observed or expected CPU utilization of the instance.
     * </p>
     * 
     * @return The maximum observed or expected CPU utilization of the instance.
     */
    public final String maxCpuUtilizationPercentage() {
        return maxCpuUtilizationPercentage;
    }

    /**
     * <p>
     * The maximum observed or expected memory utilization of the instance.
     * </p>
     * 
     * @return The maximum observed or expected memory utilization of the instance.
     */
    public final String maxMemoryUtilizationPercentage() {
        return maxMemoryUtilizationPercentage;
    }

    /**
     * <p>
     * The maximum observed or expected storage utilization of the instance. This doesn't include EBS storage.
     * </p>
     * 
     * @return The maximum observed or expected storage utilization of the instance. This doesn't include EBS storage.
     */
    public final String maxStorageUtilizationPercentage() {
        return maxStorageUtilizationPercentage;
    }

    /**
     * <p>
     * The EBS field that contains a list of EBS metrics that are associated with the current instance.
     * </p>
     * 
     * @return The EBS field that contains a list of EBS metrics that are associated with the current instance.
     */
    public final EBSResourceUtilization ebsResourceUtilization() {
        return ebsResourceUtilization;
    }

    /**
     * <p>
     * The field that contains a list of disk (local storage) metrics that are associated with the current instance.
     * </p>
     * 
     * @return The field that contains a list of disk (local storage) metrics that are associated with the current
     *         instance.
     */
    public final DiskResourceUtilization diskResourceUtilization() {
        return diskResourceUtilization;
    }

    /**
     * <p>
     * The network field that contains a list of network metrics that are associated with the current instance.
     * </p>
     * 
     * @return The network field that contains a list of network metrics that are associated with the current instance.
     */
    public final NetworkResourceUtilization networkResourceUtilization() {
        return networkResourceUtilization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxCpuUtilizationPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(maxMemoryUtilizationPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(maxStorageUtilizationPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(ebsResourceUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(diskResourceUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(networkResourceUtilization());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2ResourceUtilization)) {
            return false;
        }
        EC2ResourceUtilization other = (EC2ResourceUtilization) obj;
        return Objects.equals(maxCpuUtilizationPercentage(), other.maxCpuUtilizationPercentage())
                && Objects.equals(maxMemoryUtilizationPercentage(), other.maxMemoryUtilizationPercentage())
                && Objects.equals(maxStorageUtilizationPercentage(), other.maxStorageUtilizationPercentage())
                && Objects.equals(ebsResourceUtilization(), other.ebsResourceUtilization())
                && Objects.equals(diskResourceUtilization(), other.diskResourceUtilization())
                && Objects.equals(networkResourceUtilization(), other.networkResourceUtilization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EC2ResourceUtilization").add("MaxCpuUtilizationPercentage", maxCpuUtilizationPercentage())
                .add("MaxMemoryUtilizationPercentage", maxMemoryUtilizationPercentage())
                .add("MaxStorageUtilizationPercentage", maxStorageUtilizationPercentage())
                .add("EBSResourceUtilization", ebsResourceUtilization())
                .add("DiskResourceUtilization", diskResourceUtilization())
                .add("NetworkResourceUtilization", networkResourceUtilization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxCpuUtilizationPercentage":
            return Optional.ofNullable(clazz.cast(maxCpuUtilizationPercentage()));
        case "MaxMemoryUtilizationPercentage":
            return Optional.ofNullable(clazz.cast(maxMemoryUtilizationPercentage()));
        case "MaxStorageUtilizationPercentage":
            return Optional.ofNullable(clazz.cast(maxStorageUtilizationPercentage()));
        case "EBSResourceUtilization":
            return Optional.ofNullable(clazz.cast(ebsResourceUtilization()));
        case "DiskResourceUtilization":
            return Optional.ofNullable(clazz.cast(diskResourceUtilization()));
        case "NetworkResourceUtilization":
            return Optional.ofNullable(clazz.cast(networkResourceUtilization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaxCpuUtilizationPercentage", MAX_CPU_UTILIZATION_PERCENTAGE_FIELD);
        map.put("MaxMemoryUtilizationPercentage", MAX_MEMORY_UTILIZATION_PERCENTAGE_FIELD);
        map.put("MaxStorageUtilizationPercentage", MAX_STORAGE_UTILIZATION_PERCENTAGE_FIELD);
        map.put("EBSResourceUtilization", EBS_RESOURCE_UTILIZATION_FIELD);
        map.put("DiskResourceUtilization", DISK_RESOURCE_UTILIZATION_FIELD);
        map.put("NetworkResourceUtilization", NETWORK_RESOURCE_UTILIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EC2ResourceUtilization, T> g) {
        return obj -> g.apply((EC2ResourceUtilization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EC2ResourceUtilization> {
        /**
         * <p>
         * The maximum observed or expected CPU utilization of the instance.
         * </p>
         * 
         * @param maxCpuUtilizationPercentage
         *        The maximum observed or expected CPU utilization of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCpuUtilizationPercentage(String maxCpuUtilizationPercentage);

        /**
         * <p>
         * The maximum observed or expected memory utilization of the instance.
         * </p>
         * 
         * @param maxMemoryUtilizationPercentage
         *        The maximum observed or expected memory utilization of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxMemoryUtilizationPercentage(String maxMemoryUtilizationPercentage);

        /**
         * <p>
         * The maximum observed or expected storage utilization of the instance. This doesn't include EBS storage.
         * </p>
         * 
         * @param maxStorageUtilizationPercentage
         *        The maximum observed or expected storage utilization of the instance. This doesn't include EBS
         *        storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxStorageUtilizationPercentage(String maxStorageUtilizationPercentage);

        /**
         * <p>
         * The EBS field that contains a list of EBS metrics that are associated with the current instance.
         * </p>
         * 
         * @param ebsResourceUtilization
         *        The EBS field that contains a list of EBS metrics that are associated with the current instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsResourceUtilization(EBSResourceUtilization ebsResourceUtilization);

        /**
         * <p>
         * The EBS field that contains a list of EBS metrics that are associated with the current instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link EBSResourceUtilization.Builder} avoiding
         * the need to create one manually via {@link EBSResourceUtilization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EBSResourceUtilization.Builder#build()} is called immediately and
         * its result is passed to {@link #ebsResourceUtilization(EBSResourceUtilization)}.
         * 
         * @param ebsResourceUtilization
         *        a consumer that will call methods on {@link EBSResourceUtilization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsResourceUtilization(EBSResourceUtilization)
         */
        default Builder ebsResourceUtilization(Consumer<EBSResourceUtilization.Builder> ebsResourceUtilization) {
            return ebsResourceUtilization(EBSResourceUtilization.builder().applyMutation(ebsResourceUtilization).build());
        }

        /**
         * <p>
         * The field that contains a list of disk (local storage) metrics that are associated with the current instance.
         * </p>
         * 
         * @param diskResourceUtilization
         *        The field that contains a list of disk (local storage) metrics that are associated with the current
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskResourceUtilization(DiskResourceUtilization diskResourceUtilization);

        /**
         * <p>
         * The field that contains a list of disk (local storage) metrics that are associated with the current instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link DiskResourceUtilization.Builder} avoiding
         * the need to create one manually via {@link DiskResourceUtilization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DiskResourceUtilization.Builder#build()} is called immediately
         * and its result is passed to {@link #diskResourceUtilization(DiskResourceUtilization)}.
         * 
         * @param diskResourceUtilization
         *        a consumer that will call methods on {@link DiskResourceUtilization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diskResourceUtilization(DiskResourceUtilization)
         */
        default Builder diskResourceUtilization(Consumer<DiskResourceUtilization.Builder> diskResourceUtilization) {
            return diskResourceUtilization(DiskResourceUtilization.builder().applyMutation(diskResourceUtilization).build());
        }

        /**
         * <p>
         * The network field that contains a list of network metrics that are associated with the current instance.
         * </p>
         * 
         * @param networkResourceUtilization
         *        The network field that contains a list of network metrics that are associated with the current
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkResourceUtilization(NetworkResourceUtilization networkResourceUtilization);

        /**
         * <p>
         * The network field that contains a list of network metrics that are associated with the current instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkResourceUtilization.Builder}
         * avoiding the need to create one manually via {@link NetworkResourceUtilization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkResourceUtilization.Builder#build()} is called immediately
         * and its result is passed to {@link #networkResourceUtilization(NetworkResourceUtilization)}.
         * 
         * @param networkResourceUtilization
         *        a consumer that will call methods on {@link NetworkResourceUtilization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkResourceUtilization(NetworkResourceUtilization)
         */
        default Builder networkResourceUtilization(Consumer<NetworkResourceUtilization.Builder> networkResourceUtilization) {
            return networkResourceUtilization(NetworkResourceUtilization.builder().applyMutation(networkResourceUtilization)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String maxCpuUtilizationPercentage;

        private String maxMemoryUtilizationPercentage;

        private String maxStorageUtilizationPercentage;

        private EBSResourceUtilization ebsResourceUtilization;

        private DiskResourceUtilization diskResourceUtilization;

        private NetworkResourceUtilization networkResourceUtilization;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2ResourceUtilization model) {
            maxCpuUtilizationPercentage(model.maxCpuUtilizationPercentage);
            maxMemoryUtilizationPercentage(model.maxMemoryUtilizationPercentage);
            maxStorageUtilizationPercentage(model.maxStorageUtilizationPercentage);
            ebsResourceUtilization(model.ebsResourceUtilization);
            diskResourceUtilization(model.diskResourceUtilization);
            networkResourceUtilization(model.networkResourceUtilization);
        }

        public final String getMaxCpuUtilizationPercentage() {
            return maxCpuUtilizationPercentage;
        }

        public final void setMaxCpuUtilizationPercentage(String maxCpuUtilizationPercentage) {
            this.maxCpuUtilizationPercentage = maxCpuUtilizationPercentage;
        }

        @Override
        public final Builder maxCpuUtilizationPercentage(String maxCpuUtilizationPercentage) {
            this.maxCpuUtilizationPercentage = maxCpuUtilizationPercentage;
            return this;
        }

        public final String getMaxMemoryUtilizationPercentage() {
            return maxMemoryUtilizationPercentage;
        }

        public final void setMaxMemoryUtilizationPercentage(String maxMemoryUtilizationPercentage) {
            this.maxMemoryUtilizationPercentage = maxMemoryUtilizationPercentage;
        }

        @Override
        public final Builder maxMemoryUtilizationPercentage(String maxMemoryUtilizationPercentage) {
            this.maxMemoryUtilizationPercentage = maxMemoryUtilizationPercentage;
            return this;
        }

        public final String getMaxStorageUtilizationPercentage() {
            return maxStorageUtilizationPercentage;
        }

        public final void setMaxStorageUtilizationPercentage(String maxStorageUtilizationPercentage) {
            this.maxStorageUtilizationPercentage = maxStorageUtilizationPercentage;
        }

        @Override
        public final Builder maxStorageUtilizationPercentage(String maxStorageUtilizationPercentage) {
            this.maxStorageUtilizationPercentage = maxStorageUtilizationPercentage;
            return this;
        }

        public final EBSResourceUtilization.Builder getEbsResourceUtilization() {
            return ebsResourceUtilization != null ? ebsResourceUtilization.toBuilder() : null;
        }

        public final void setEbsResourceUtilization(EBSResourceUtilization.BuilderImpl ebsResourceUtilization) {
            this.ebsResourceUtilization = ebsResourceUtilization != null ? ebsResourceUtilization.build() : null;
        }

        @Override
        public final Builder ebsResourceUtilization(EBSResourceUtilization ebsResourceUtilization) {
            this.ebsResourceUtilization = ebsResourceUtilization;
            return this;
        }

        public final DiskResourceUtilization.Builder getDiskResourceUtilization() {
            return diskResourceUtilization != null ? diskResourceUtilization.toBuilder() : null;
        }

        public final void setDiskResourceUtilization(DiskResourceUtilization.BuilderImpl diskResourceUtilization) {
            this.diskResourceUtilization = diskResourceUtilization != null ? diskResourceUtilization.build() : null;
        }

        @Override
        public final Builder diskResourceUtilization(DiskResourceUtilization diskResourceUtilization) {
            this.diskResourceUtilization = diskResourceUtilization;
            return this;
        }

        public final NetworkResourceUtilization.Builder getNetworkResourceUtilization() {
            return networkResourceUtilization != null ? networkResourceUtilization.toBuilder() : null;
        }

        public final void setNetworkResourceUtilization(NetworkResourceUtilization.BuilderImpl networkResourceUtilization) {
            this.networkResourceUtilization = networkResourceUtilization != null ? networkResourceUtilization.build() : null;
        }

        @Override
        public final Builder networkResourceUtilization(NetworkResourceUtilization networkResourceUtilization) {
            this.networkResourceUtilization = networkResourceUtilization;
            return this;
        }

        @Override
        public EC2ResourceUtilization build() {
            return new EC2ResourceUtilization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
