/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUsageForecastResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetUsageForecastResponse.Builder, GetUsageForecastResponse> {
    private static final SdkField<MetricValue> TOTAL_FIELD = SdkField.<MetricValue> builder(MarshallingType.SDK_POJO)
            .memberName("Total").getter(getter(GetUsageForecastResponse::total)).setter(setter(Builder::total))
            .constructor(MetricValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()).build();

    private static final SdkField<List<ForecastResult>> FORECAST_RESULTS_BY_TIME_FIELD = SdkField
            .<List<ForecastResult>> builder(MarshallingType.LIST)
            .memberName("ForecastResultsByTime")
            .getter(getter(GetUsageForecastResponse::forecastResultsByTime))
            .setter(setter(Builder::forecastResultsByTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastResultsByTime").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ForecastResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(ForecastResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_FIELD,
            FORECAST_RESULTS_BY_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final MetricValue total;

    private final List<ForecastResult> forecastResultsByTime;

    private GetUsageForecastResponse(BuilderImpl builder) {
        super(builder);
        this.total = builder.total;
        this.forecastResultsByTime = builder.forecastResultsByTime;
    }

    /**
     * <p>
     * How much you're forecasted to use over the forecast period.
     * </p>
     * 
     * @return How much you're forecasted to use over the forecast period.
     */
    public final MetricValue total() {
        return total;
    }

    /**
     * For responses, this returns true if the service returned a value for the ForecastResultsByTime property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasForecastResultsByTime() {
        return forecastResultsByTime != null && !(forecastResultsByTime instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The forecasts for your query, in order. For <code>DAILY</code> forecasts, this is a list of days. For
     * <code>MONTHLY</code> forecasts, this is a list of months.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasForecastResultsByTime} method.
     * </p>
     * 
     * @return The forecasts for your query, in order. For <code>DAILY</code> forecasts, this is a list of days. For
     *         <code>MONTHLY</code> forecasts, this is a list of months.
     */
    public final List<ForecastResult> forecastResultsByTime() {
        return forecastResultsByTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(hasForecastResultsByTime() ? forecastResultsByTime() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsageForecastResponse)) {
            return false;
        }
        GetUsageForecastResponse other = (GetUsageForecastResponse) obj;
        return Objects.equals(total(), other.total()) && hasForecastResultsByTime() == other.hasForecastResultsByTime()
                && Objects.equals(forecastResultsByTime(), other.forecastResultsByTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUsageForecastResponse").add("Total", total())
                .add("ForecastResultsByTime", hasForecastResultsByTime() ? forecastResultsByTime() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        case "ForecastResultsByTime":
            return Optional.ofNullable(clazz.cast(forecastResultsByTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Total", TOTAL_FIELD);
        map.put("ForecastResultsByTime", FORECAST_RESULTS_BY_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUsageForecastResponse, T> g) {
        return obj -> g.apply((GetUsageForecastResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetUsageForecastResponse> {
        /**
         * <p>
         * How much you're forecasted to use over the forecast period.
         * </p>
         * 
         * @param total
         *        How much you're forecasted to use over the forecast period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(MetricValue total);

        /**
         * <p>
         * How much you're forecasted to use over the forecast period.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricValue.Builder} avoiding the need to
         * create one manually via {@link MetricValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricValue.Builder#build()} is called immediately and its result
         * is passed to {@link #total(MetricValue)}.
         * 
         * @param total
         *        a consumer that will call methods on {@link MetricValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #total(MetricValue)
         */
        default Builder total(Consumer<MetricValue.Builder> total) {
            return total(MetricValue.builder().applyMutation(total).build());
        }

        /**
         * <p>
         * The forecasts for your query, in order. For <code>DAILY</code> forecasts, this is a list of days. For
         * <code>MONTHLY</code> forecasts, this is a list of months.
         * </p>
         * 
         * @param forecastResultsByTime
         *        The forecasts for your query, in order. For <code>DAILY</code> forecasts, this is a list of days. For
         *        <code>MONTHLY</code> forecasts, this is a list of months.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastResultsByTime(Collection<ForecastResult> forecastResultsByTime);

        /**
         * <p>
         * The forecasts for your query, in order. For <code>DAILY</code> forecasts, this is a list of days. For
         * <code>MONTHLY</code> forecasts, this is a list of months.
         * </p>
         * 
         * @param forecastResultsByTime
         *        The forecasts for your query, in order. For <code>DAILY</code> forecasts, this is a list of days. For
         *        <code>MONTHLY</code> forecasts, this is a list of months.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastResultsByTime(ForecastResult... forecastResultsByTime);

        /**
         * <p>
         * The forecasts for your query, in order. For <code>DAILY</code> forecasts, this is a list of days. For
         * <code>MONTHLY</code> forecasts, this is a list of months.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.ForecastResult.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.costexplorer.model.ForecastResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.ForecastResult.Builder#build()} is called
         * immediately and its result is passed to {@link #forecastResultsByTime(List<ForecastResult>)}.
         * 
         * @param forecastResultsByTime
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.ForecastResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forecastResultsByTime(java.util.Collection<ForecastResult>)
         */
        Builder forecastResultsByTime(Consumer<ForecastResult.Builder>... forecastResultsByTime);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private MetricValue total;

        private List<ForecastResult> forecastResultsByTime = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsageForecastResponse model) {
            super(model);
            total(model.total);
            forecastResultsByTime(model.forecastResultsByTime);
        }

        public final MetricValue.Builder getTotal() {
            return total != null ? total.toBuilder() : null;
        }

        public final void setTotal(MetricValue.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        @Override
        public final Builder total(MetricValue total) {
            this.total = total;
            return this;
        }

        public final List<ForecastResult.Builder> getForecastResultsByTime() {
            List<ForecastResult.Builder> result = ForecastResultsByTimeCopier.copyToBuilder(this.forecastResultsByTime);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setForecastResultsByTime(Collection<ForecastResult.BuilderImpl> forecastResultsByTime) {
            this.forecastResultsByTime = ForecastResultsByTimeCopier.copyFromBuilder(forecastResultsByTime);
        }

        @Override
        public final Builder forecastResultsByTime(Collection<ForecastResult> forecastResultsByTime) {
            this.forecastResultsByTime = ForecastResultsByTimeCopier.copy(forecastResultsByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastResultsByTime(ForecastResult... forecastResultsByTime) {
            forecastResultsByTime(Arrays.asList(forecastResultsByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastResultsByTime(Consumer<ForecastResult.Builder>... forecastResultsByTime) {
            forecastResultsByTime(Stream.of(forecastResultsByTime).map(c -> ForecastResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetUsageForecastResponse build() {
            return new GetUsageForecastResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
