/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The measurement of how well you're using your existing Savings Plans.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansUtilization implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansUtilization.Builder, SavingsPlansUtilization> {
    private static final SdkField<String> TOTAL_COMMITMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TotalCommitment").getter(getter(SavingsPlansUtilization::totalCommitment))
            .setter(setter(Builder::totalCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCommitment").build()).build();

    private static final SdkField<String> USED_COMMITMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsedCommitment").getter(getter(SavingsPlansUtilization::usedCommitment))
            .setter(setter(Builder::usedCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsedCommitment").build()).build();

    private static final SdkField<String> UNUSED_COMMITMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnusedCommitment").getter(getter(SavingsPlansUtilization::unusedCommitment))
            .setter(setter(Builder::unusedCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnusedCommitment").build()).build();

    private static final SdkField<String> UTILIZATION_PERCENTAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UtilizationPercentage").getter(getter(SavingsPlansUtilization::utilizationPercentage))
            .setter(setter(Builder::utilizationPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtilizationPercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_COMMITMENT_FIELD,
            USED_COMMITMENT_FIELD, UNUSED_COMMITMENT_FIELD, UTILIZATION_PERCENTAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String totalCommitment;

    private final String usedCommitment;

    private final String unusedCommitment;

    private final String utilizationPercentage;

    private SavingsPlansUtilization(BuilderImpl builder) {
        this.totalCommitment = builder.totalCommitment;
        this.usedCommitment = builder.usedCommitment;
        this.unusedCommitment = builder.unusedCommitment;
        this.utilizationPercentage = builder.utilizationPercentage;
    }

    /**
     * <p>
     * The total amount of Savings Plans commitment that's been purchased in an account (or set of accounts).
     * </p>
     * 
     * @return The total amount of Savings Plans commitment that's been purchased in an account (or set of accounts).
     */
    public final String totalCommitment() {
        return totalCommitment;
    }

    /**
     * <p>
     * The amount of your Savings Plans commitment that was consumed from Savings Plans eligible usage in a specific
     * period.
     * </p>
     * 
     * @return The amount of your Savings Plans commitment that was consumed from Savings Plans eligible usage in a
     *         specific period.
     */
    public final String usedCommitment() {
        return usedCommitment;
    }

    /**
     * <p>
     * The amount of your Savings Plans commitment that wasn't consumed from Savings Plans eligible usage in a specific
     * period.
     * </p>
     * 
     * @return The amount of your Savings Plans commitment that wasn't consumed from Savings Plans eligible usage in a
     *         specific period.
     */
    public final String unusedCommitment() {
        return unusedCommitment;
    }

    /**
     * <p>
     * The amount of <code>UsedCommitment</code> divided by the <code>TotalCommitment</code> for your Savings Plans.
     * </p>
     * 
     * @return The amount of <code>UsedCommitment</code> divided by the <code>TotalCommitment</code> for your Savings
     *         Plans.
     */
    public final String utilizationPercentage() {
        return utilizationPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(usedCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(unusedCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(utilizationPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansUtilization)) {
            return false;
        }
        SavingsPlansUtilization other = (SavingsPlansUtilization) obj;
        return Objects.equals(totalCommitment(), other.totalCommitment())
                && Objects.equals(usedCommitment(), other.usedCommitment())
                && Objects.equals(unusedCommitment(), other.unusedCommitment())
                && Objects.equals(utilizationPercentage(), other.utilizationPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlansUtilization").add("TotalCommitment", totalCommitment())
                .add("UsedCommitment", usedCommitment()).add("UnusedCommitment", unusedCommitment())
                .add("UtilizationPercentage", utilizationPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalCommitment":
            return Optional.ofNullable(clazz.cast(totalCommitment()));
        case "UsedCommitment":
            return Optional.ofNullable(clazz.cast(usedCommitment()));
        case "UnusedCommitment":
            return Optional.ofNullable(clazz.cast(unusedCommitment()));
        case "UtilizationPercentage":
            return Optional.ofNullable(clazz.cast(utilizationPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TotalCommitment", TOTAL_COMMITMENT_FIELD);
        map.put("UsedCommitment", USED_COMMITMENT_FIELD);
        map.put("UnusedCommitment", UNUSED_COMMITMENT_FIELD);
        map.put("UtilizationPercentage", UTILIZATION_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansUtilization, T> g) {
        return obj -> g.apply((SavingsPlansUtilization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansUtilization> {
        /**
         * <p>
         * The total amount of Savings Plans commitment that's been purchased in an account (or set of accounts).
         * </p>
         * 
         * @param totalCommitment
         *        The total amount of Savings Plans commitment that's been purchased in an account (or set of accounts).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCommitment(String totalCommitment);

        /**
         * <p>
         * The amount of your Savings Plans commitment that was consumed from Savings Plans eligible usage in a specific
         * period.
         * </p>
         * 
         * @param usedCommitment
         *        The amount of your Savings Plans commitment that was consumed from Savings Plans eligible usage in a
         *        specific period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usedCommitment(String usedCommitment);

        /**
         * <p>
         * The amount of your Savings Plans commitment that wasn't consumed from Savings Plans eligible usage in a
         * specific period.
         * </p>
         * 
         * @param unusedCommitment
         *        The amount of your Savings Plans commitment that wasn't consumed from Savings Plans eligible usage in
         *        a specific period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedCommitment(String unusedCommitment);

        /**
         * <p>
         * The amount of <code>UsedCommitment</code> divided by the <code>TotalCommitment</code> for your Savings Plans.
         * </p>
         * 
         * @param utilizationPercentage
         *        The amount of <code>UsedCommitment</code> divided by the <code>TotalCommitment</code> for your Savings
         *        Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utilizationPercentage(String utilizationPercentage);
    }

    static final class BuilderImpl implements Builder {
        private String totalCommitment;

        private String usedCommitment;

        private String unusedCommitment;

        private String utilizationPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansUtilization model) {
            totalCommitment(model.totalCommitment);
            usedCommitment(model.usedCommitment);
            unusedCommitment(model.unusedCommitment);
            utilizationPercentage(model.utilizationPercentage);
        }

        public final String getTotalCommitment() {
            return totalCommitment;
        }

        public final void setTotalCommitment(String totalCommitment) {
            this.totalCommitment = totalCommitment;
        }

        @Override
        public final Builder totalCommitment(String totalCommitment) {
            this.totalCommitment = totalCommitment;
            return this;
        }

        public final String getUsedCommitment() {
            return usedCommitment;
        }

        public final void setUsedCommitment(String usedCommitment) {
            this.usedCommitment = usedCommitment;
        }

        @Override
        public final Builder usedCommitment(String usedCommitment) {
            this.usedCommitment = usedCommitment;
            return this;
        }

        public final String getUnusedCommitment() {
            return unusedCommitment;
        }

        public final void setUnusedCommitment(String unusedCommitment) {
            this.unusedCommitment = unusedCommitment;
        }

        @Override
        public final Builder unusedCommitment(String unusedCommitment) {
            this.unusedCommitment = unusedCommitment;
            return this;
        }

        public final String getUtilizationPercentage() {
            return utilizationPercentage;
        }

        public final void setUtilizationPercentage(String utilizationPercentage) {
            this.utilizationPercentage = utilizationPercentage;
        }

        @Override
        public final Builder utilizationPercentage(String utilizationPercentage) {
            this.utilizationPercentage = utilizationPercentage;
            return this;
        }

        @Override
        public SavingsPlansUtilization build() {
            return new SavingsPlansUtilization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
