/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single daily or monthly Savings Plans utilization rate and details for your account. A management account in an
 * organization have access to member accounts. You can use <code>GetDimensionValues</code> to determine the possible
 * dimension values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansUtilizationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansUtilizationDetail.Builder, SavingsPlansUtilizationDetail> {
    private static final SdkField<String> SAVINGS_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SavingsPlanArn").getter(getter(SavingsPlansUtilizationDetail::savingsPlanArn))
            .setter(setter(Builder::savingsPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlanArn").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(SavingsPlansUtilizationDetail::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<SavingsPlansUtilization> UTILIZATION_FIELD = SdkField
            .<SavingsPlansUtilization> builder(MarshallingType.SDK_POJO).memberName("Utilization")
            .getter(getter(SavingsPlansUtilizationDetail::utilization)).setter(setter(Builder::utilization))
            .constructor(SavingsPlansUtilization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Utilization").build()).build();

    private static final SdkField<SavingsPlansSavings> SAVINGS_FIELD = SdkField
            .<SavingsPlansSavings> builder(MarshallingType.SDK_POJO).memberName("Savings")
            .getter(getter(SavingsPlansUtilizationDetail::savings)).setter(setter(Builder::savings))
            .constructor(SavingsPlansSavings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Savings").build()).build();

    private static final SdkField<SavingsPlansAmortizedCommitment> AMORTIZED_COMMITMENT_FIELD = SdkField
            .<SavingsPlansAmortizedCommitment> builder(MarshallingType.SDK_POJO).memberName("AmortizedCommitment")
            .getter(getter(SavingsPlansUtilizationDetail::amortizedCommitment)).setter(setter(Builder::amortizedCommitment))
            .constructor(SavingsPlansAmortizedCommitment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmortizedCommitment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLAN_ARN_FIELD,
            ATTRIBUTES_FIELD, UTILIZATION_FIELD, SAVINGS_FIELD, AMORTIZED_COMMITMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String savingsPlanArn;

    private final Map<String, String> attributes;

    private final SavingsPlansUtilization utilization;

    private final SavingsPlansSavings savings;

    private final SavingsPlansAmortizedCommitment amortizedCommitment;

    private SavingsPlansUtilizationDetail(BuilderImpl builder) {
        this.savingsPlanArn = builder.savingsPlanArn;
        this.attributes = builder.attributes;
        this.utilization = builder.utilization;
        this.savings = builder.savings;
        this.amortizedCommitment = builder.amortizedCommitment;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) for a particular Savings Plan.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) for a particular Savings Plan.
     */
    public final String savingsPlanArn() {
        return savingsPlanArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The attribute that applies to a specific <code>Dimension</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The attribute that applies to a specific <code>Dimension</code>.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans
     * eligible.
     * </p>
     * 
     * @return A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings
     *         Plans eligible.
     */
    public final SavingsPlansUtilization utilization() {
        return utilization;
    }

    /**
     * <p>
     * The amount saved by using existing Savings Plans. Savings returns both net savings from savings plans and also
     * the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.
     * </p>
     * 
     * @return The amount saved by using existing Savings Plans. Savings returns both net savings from savings plans and
     *         also the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.
     */
    public final SavingsPlansSavings savings() {
        return savings;
    }

    /**
     * <p>
     * The total amortized commitment for a Savings Plans. Includes the sum of the upfront and recurring Savings Plans
     * fees.
     * </p>
     * 
     * @return The total amortized commitment for a Savings Plans. Includes the sum of the upfront and recurring Savings
     *         Plans fees.
     */
    public final SavingsPlansAmortizedCommitment amortizedCommitment() {
        return amortizedCommitment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(utilization());
        hashCode = 31 * hashCode + Objects.hashCode(savings());
        hashCode = 31 * hashCode + Objects.hashCode(amortizedCommitment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansUtilizationDetail)) {
            return false;
        }
        SavingsPlansUtilizationDetail other = (SavingsPlansUtilizationDetail) obj;
        return Objects.equals(savingsPlanArn(), other.savingsPlanArn()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(utilization(), other.utilization())
                && Objects.equals(savings(), other.savings())
                && Objects.equals(amortizedCommitment(), other.amortizedCommitment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlansUtilizationDetail").add("SavingsPlanArn", savingsPlanArn())
                .add("Attributes", hasAttributes() ? attributes() : null).add("Utilization", utilization())
                .add("Savings", savings()).add("AmortizedCommitment", amortizedCommitment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SavingsPlanArn":
            return Optional.ofNullable(clazz.cast(savingsPlanArn()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "Utilization":
            return Optional.ofNullable(clazz.cast(utilization()));
        case "Savings":
            return Optional.ofNullable(clazz.cast(savings()));
        case "AmortizedCommitment":
            return Optional.ofNullable(clazz.cast(amortizedCommitment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SavingsPlanArn", SAVINGS_PLAN_ARN_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("Utilization", UTILIZATION_FIELD);
        map.put("Savings", SAVINGS_FIELD);
        map.put("AmortizedCommitment", AMORTIZED_COMMITMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansUtilizationDetail, T> g) {
        return obj -> g.apply((SavingsPlansUtilizationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansUtilizationDetail> {
        /**
         * <p>
         * The unique Amazon Resource Name (ARN) for a particular Savings Plan.
         * </p>
         * 
         * @param savingsPlanArn
         *        The unique Amazon Resource Name (ARN) for a particular Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanArn(String savingsPlanArn);

        /**
         * <p>
         * The attribute that applies to a specific <code>Dimension</code>.
         * </p>
         * 
         * @param attributes
         *        The attribute that applies to a specific <code>Dimension</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans
         * eligible.
         * </p>
         * 
         * @param utilization
         *        A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings
         *        Plans eligible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utilization(SavingsPlansUtilization utilization);

        /**
         * <p>
         * A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans
         * eligible.
         * </p>
         * This is a convenience method that creates an instance of the {@link SavingsPlansUtilization.Builder} avoiding
         * the need to create one manually via {@link SavingsPlansUtilization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SavingsPlansUtilization.Builder#build()} is called immediately
         * and its result is passed to {@link #utilization(SavingsPlansUtilization)}.
         * 
         * @param utilization
         *        a consumer that will call methods on {@link SavingsPlansUtilization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #utilization(SavingsPlansUtilization)
         */
        default Builder utilization(Consumer<SavingsPlansUtilization.Builder> utilization) {
            return utilization(SavingsPlansUtilization.builder().applyMutation(utilization).build());
        }

        /**
         * <p>
         * The amount saved by using existing Savings Plans. Savings returns both net savings from savings plans and
         * also the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.
         * </p>
         * 
         * @param savings
         *        The amount saved by using existing Savings Plans. Savings returns both net savings from savings plans
         *        and also the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization
         *        rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savings(SavingsPlansSavings savings);

        /**
         * <p>
         * The amount saved by using existing Savings Plans. Savings returns both net savings from savings plans and
         * also the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.
         * </p>
         * This is a convenience method that creates an instance of the {@link SavingsPlansSavings.Builder} avoiding the
         * need to create one manually via {@link SavingsPlansSavings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SavingsPlansSavings.Builder#build()} is called immediately and
         * its result is passed to {@link #savings(SavingsPlansSavings)}.
         * 
         * @param savings
         *        a consumer that will call methods on {@link SavingsPlansSavings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savings(SavingsPlansSavings)
         */
        default Builder savings(Consumer<SavingsPlansSavings.Builder> savings) {
            return savings(SavingsPlansSavings.builder().applyMutation(savings).build());
        }

        /**
         * <p>
         * The total amortized commitment for a Savings Plans. Includes the sum of the upfront and recurring Savings
         * Plans fees.
         * </p>
         * 
         * @param amortizedCommitment
         *        The total amortized commitment for a Savings Plans. Includes the sum of the upfront and recurring
         *        Savings Plans fees.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amortizedCommitment(SavingsPlansAmortizedCommitment amortizedCommitment);

        /**
         * <p>
         * The total amortized commitment for a Savings Plans. Includes the sum of the upfront and recurring Savings
         * Plans fees.
         * </p>
         * This is a convenience method that creates an instance of the {@link SavingsPlansAmortizedCommitment.Builder}
         * avoiding the need to create one manually via {@link SavingsPlansAmortizedCommitment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SavingsPlansAmortizedCommitment.Builder#build()} is called
         * immediately and its result is passed to {@link #amortizedCommitment(SavingsPlansAmortizedCommitment)}.
         * 
         * @param amortizedCommitment
         *        a consumer that will call methods on {@link SavingsPlansAmortizedCommitment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amortizedCommitment(SavingsPlansAmortizedCommitment)
         */
        default Builder amortizedCommitment(Consumer<SavingsPlansAmortizedCommitment.Builder> amortizedCommitment) {
            return amortizedCommitment(SavingsPlansAmortizedCommitment.builder().applyMutation(amortizedCommitment).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String savingsPlanArn;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private SavingsPlansUtilization utilization;

        private SavingsPlansSavings savings;

        private SavingsPlansAmortizedCommitment amortizedCommitment;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansUtilizationDetail model) {
            savingsPlanArn(model.savingsPlanArn);
            attributes(model.attributes);
            utilization(model.utilization);
            savings(model.savings);
            amortizedCommitment(model.amortizedCommitment);
        }

        public final String getSavingsPlanArn() {
            return savingsPlanArn;
        }

        public final void setSavingsPlanArn(String savingsPlanArn) {
            this.savingsPlanArn = savingsPlanArn;
        }

        @Override
        public final Builder savingsPlanArn(String savingsPlanArn) {
            this.savingsPlanArn = savingsPlanArn;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final SavingsPlansUtilization.Builder getUtilization() {
            return utilization != null ? utilization.toBuilder() : null;
        }

        public final void setUtilization(SavingsPlansUtilization.BuilderImpl utilization) {
            this.utilization = utilization != null ? utilization.build() : null;
        }

        @Override
        public final Builder utilization(SavingsPlansUtilization utilization) {
            this.utilization = utilization;
            return this;
        }

        public final SavingsPlansSavings.Builder getSavings() {
            return savings != null ? savings.toBuilder() : null;
        }

        public final void setSavings(SavingsPlansSavings.BuilderImpl savings) {
            this.savings = savings != null ? savings.build() : null;
        }

        @Override
        public final Builder savings(SavingsPlansSavings savings) {
            this.savings = savings;
            return this;
        }

        public final SavingsPlansAmortizedCommitment.Builder getAmortizedCommitment() {
            return amortizedCommitment != null ? amortizedCommitment.toBuilder() : null;
        }

        public final void setAmortizedCommitment(SavingsPlansAmortizedCommitment.BuilderImpl amortizedCommitment) {
            this.amortizedCommitment = amortizedCommitment != null ? amortizedCommitment.build() : null;
        }

        @Override
        public final Builder amortizedCommitment(SavingsPlansAmortizedCommitment amortizedCommitment) {
            this.amortizedCommitment = amortizedCommitment;
            return this;
        }

        @Override
        public SavingsPlansUtilizationDetail build() {
            return new SavingsPlansUtilizationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
