/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on recommended instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetInstance implements SdkPojo, Serializable, ToCopyableBuilder<TargetInstance.Builder, TargetInstance> {
    private static final SdkField<String> ESTIMATED_MONTHLY_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedMonthlyCost").getter(getter(TargetInstance::estimatedMonthlyCost))
            .setter(setter(Builder::estimatedMonthlyCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlyCost").build())
            .build();

    private static final SdkField<String> ESTIMATED_MONTHLY_SAVINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedMonthlySavings").getter(getter(TargetInstance::estimatedMonthlySavings))
            .setter(setter(Builder::estimatedMonthlySavings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlySavings").build())
            .build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(TargetInstance::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<Boolean> DEFAULT_TARGET_INSTANCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DefaultTargetInstance").getter(getter(TargetInstance::defaultTargetInstance))
            .setter(setter(Builder::defaultTargetInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultTargetInstance").build())
            .build();

    private static final SdkField<ResourceDetails> RESOURCE_DETAILS_FIELD = SdkField
            .<ResourceDetails> builder(MarshallingType.SDK_POJO).memberName("ResourceDetails")
            .getter(getter(TargetInstance::resourceDetails)).setter(setter(Builder::resourceDetails))
            .constructor(ResourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetails").build()).build();

    private static final SdkField<ResourceUtilization> EXPECTED_RESOURCE_UTILIZATION_FIELD = SdkField
            .<ResourceUtilization> builder(MarshallingType.SDK_POJO)
            .memberName("ExpectedResourceUtilization")
            .getter(getter(TargetInstance::expectedResourceUtilization))
            .setter(setter(Builder::expectedResourceUtilization))
            .constructor(ResourceUtilization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedResourceUtilization")
                    .build()).build();

    private static final SdkField<List<String>> PLATFORM_DIFFERENCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PlatformDifferences")
            .getter(getter(TargetInstance::platformDifferencesAsStrings))
            .setter(setter(Builder::platformDifferencesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformDifferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ESTIMATED_MONTHLY_COST_FIELD,
            ESTIMATED_MONTHLY_SAVINGS_FIELD, CURRENCY_CODE_FIELD, DEFAULT_TARGET_INSTANCE_FIELD, RESOURCE_DETAILS_FIELD,
            EXPECTED_RESOURCE_UTILIZATION_FIELD, PLATFORM_DIFFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String estimatedMonthlyCost;

    private final String estimatedMonthlySavings;

    private final String currencyCode;

    private final Boolean defaultTargetInstance;

    private final ResourceDetails resourceDetails;

    private final ResourceUtilization expectedResourceUtilization;

    private final List<String> platformDifferences;

    private TargetInstance(BuilderImpl builder) {
        this.estimatedMonthlyCost = builder.estimatedMonthlyCost;
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
        this.currencyCode = builder.currencyCode;
        this.defaultTargetInstance = builder.defaultTargetInstance;
        this.resourceDetails = builder.resourceDetails;
        this.expectedResourceUtilization = builder.expectedResourceUtilization;
        this.platformDifferences = builder.platformDifferences;
    }

    /**
     * <p>
     * The expected cost to operate this instance type on a monthly basis.
     * </p>
     * 
     * @return The expected cost to operate this instance type on a monthly basis.
     */
    public final String estimatedMonthlyCost() {
        return estimatedMonthlyCost;
    }

    /**
     * <p>
     * The estimated savings that result from modification, on a monthly basis.
     * </p>
     * 
     * @return The estimated savings that result from modification, on a monthly basis.
     */
    public final String estimatedMonthlySavings() {
        return estimatedMonthlySavings;
    }

    /**
     * <p>
     * The currency code that Amazon Web Services used to calculate the costs for this instance.
     * </p>
     * 
     * @return The currency code that Amazon Web Services used to calculate the costs for this instance.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * Determines whether this recommendation is the defaulted Amazon Web Services recommendation.
     * </p>
     * 
     * @return Determines whether this recommendation is the defaulted Amazon Web Services recommendation.
     */
    public final Boolean defaultTargetInstance() {
        return defaultTargetInstance;
    }

    /**
     * <p>
     * Details on the target instance type.
     * </p>
     * 
     * @return Details on the target instance type.
     */
    public final ResourceDetails resourceDetails() {
        return resourceDetails;
    }

    /**
     * <p>
     * The expected utilization metrics for target instance type.
     * </p>
     * 
     * @return The expected utilization metrics for target instance type.
     */
    public final ResourceUtilization expectedResourceUtilization() {
        return expectedResourceUtilization;
    }

    /**
     * <p>
     * Explains the actions that you might need to take to successfully migrate your workloads from the current instance
     * type to the recommended instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlatformDifferences} method.
     * </p>
     * 
     * @return Explains the actions that you might need to take to successfully migrate your workloads from the current
     *         instance type to the recommended instance type.
     */
    public final List<PlatformDifference> platformDifferences() {
        return PlatformDifferencesCopier.copyStringToEnum(platformDifferences);
    }

    /**
     * For responses, this returns true if the service returned a value for the PlatformDifferences property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPlatformDifferences() {
        return platformDifferences != null && !(platformDifferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Explains the actions that you might need to take to successfully migrate your workloads from the current instance
     * type to the recommended instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlatformDifferences} method.
     * </p>
     * 
     * @return Explains the actions that you might need to take to successfully migrate your workloads from the current
     *         instance type to the recommended instance type.
     */
    public final List<String> platformDifferencesAsStrings() {
        return platformDifferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlyCost());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlySavings());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTargetInstance());
        hashCode = 31 * hashCode + Objects.hashCode(resourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(expectedResourceUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlatformDifferences() ? platformDifferencesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetInstance)) {
            return false;
        }
        TargetInstance other = (TargetInstance) obj;
        return Objects.equals(estimatedMonthlyCost(), other.estimatedMonthlyCost())
                && Objects.equals(estimatedMonthlySavings(), other.estimatedMonthlySavings())
                && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(defaultTargetInstance(), other.defaultTargetInstance())
                && Objects.equals(resourceDetails(), other.resourceDetails())
                && Objects.equals(expectedResourceUtilization(), other.expectedResourceUtilization())
                && hasPlatformDifferences() == other.hasPlatformDifferences()
                && Objects.equals(platformDifferencesAsStrings(), other.platformDifferencesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetInstance").add("EstimatedMonthlyCost", estimatedMonthlyCost())
                .add("EstimatedMonthlySavings", estimatedMonthlySavings()).add("CurrencyCode", currencyCode())
                .add("DefaultTargetInstance", defaultTargetInstance()).add("ResourceDetails", resourceDetails())
                .add("ExpectedResourceUtilization", expectedResourceUtilization())
                .add("PlatformDifferences", hasPlatformDifferences() ? platformDifferencesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EstimatedMonthlyCost":
            return Optional.ofNullable(clazz.cast(estimatedMonthlyCost()));
        case "EstimatedMonthlySavings":
            return Optional.ofNullable(clazz.cast(estimatedMonthlySavings()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "DefaultTargetInstance":
            return Optional.ofNullable(clazz.cast(defaultTargetInstance()));
        case "ResourceDetails":
            return Optional.ofNullable(clazz.cast(resourceDetails()));
        case "ExpectedResourceUtilization":
            return Optional.ofNullable(clazz.cast(expectedResourceUtilization()));
        case "PlatformDifferences":
            return Optional.ofNullable(clazz.cast(platformDifferencesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EstimatedMonthlyCost", ESTIMATED_MONTHLY_COST_FIELD);
        map.put("EstimatedMonthlySavings", ESTIMATED_MONTHLY_SAVINGS_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("DefaultTargetInstance", DEFAULT_TARGET_INSTANCE_FIELD);
        map.put("ResourceDetails", RESOURCE_DETAILS_FIELD);
        map.put("ExpectedResourceUtilization", EXPECTED_RESOURCE_UTILIZATION_FIELD);
        map.put("PlatformDifferences", PLATFORM_DIFFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetInstance, T> g) {
        return obj -> g.apply((TargetInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetInstance> {
        /**
         * <p>
         * The expected cost to operate this instance type on a monthly basis.
         * </p>
         * 
         * @param estimatedMonthlyCost
         *        The expected cost to operate this instance type on a monthly basis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlyCost(String estimatedMonthlyCost);

        /**
         * <p>
         * The estimated savings that result from modification, on a monthly basis.
         * </p>
         * 
         * @param estimatedMonthlySavings
         *        The estimated savings that result from modification, on a monthly basis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlySavings(String estimatedMonthlySavings);

        /**
         * <p>
         * The currency code that Amazon Web Services used to calculate the costs for this instance.
         * </p>
         * 
         * @param currencyCode
         *        The currency code that Amazon Web Services used to calculate the costs for this instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * Determines whether this recommendation is the defaulted Amazon Web Services recommendation.
         * </p>
         * 
         * @param defaultTargetInstance
         *        Determines whether this recommendation is the defaulted Amazon Web Services recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTargetInstance(Boolean defaultTargetInstance);

        /**
         * <p>
         * Details on the target instance type.
         * </p>
         * 
         * @param resourceDetails
         *        Details on the target instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDetails(ResourceDetails resourceDetails);

        /**
         * <p>
         * Details on the target instance type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceDetails.Builder} avoiding the
         * need to create one manually via {@link ResourceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceDetails(ResourceDetails)}.
         * 
         * @param resourceDetails
         *        a consumer that will call methods on {@link ResourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceDetails(ResourceDetails)
         */
        default Builder resourceDetails(Consumer<ResourceDetails.Builder> resourceDetails) {
            return resourceDetails(ResourceDetails.builder().applyMutation(resourceDetails).build());
        }

        /**
         * <p>
         * The expected utilization metrics for target instance type.
         * </p>
         * 
         * @param expectedResourceUtilization
         *        The expected utilization metrics for target instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedResourceUtilization(ResourceUtilization expectedResourceUtilization);

        /**
         * <p>
         * The expected utilization metrics for target instance type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceUtilization.Builder} avoiding the
         * need to create one manually via {@link ResourceUtilization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceUtilization.Builder#build()} is called immediately and
         * its result is passed to {@link #expectedResourceUtilization(ResourceUtilization)}.
         * 
         * @param expectedResourceUtilization
         *        a consumer that will call methods on {@link ResourceUtilization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expectedResourceUtilization(ResourceUtilization)
         */
        default Builder expectedResourceUtilization(Consumer<ResourceUtilization.Builder> expectedResourceUtilization) {
            return expectedResourceUtilization(ResourceUtilization.builder().applyMutation(expectedResourceUtilization).build());
        }

        /**
         * <p>
         * Explains the actions that you might need to take to successfully migrate your workloads from the current
         * instance type to the recommended instance type.
         * </p>
         * 
         * @param platformDifferences
         *        Explains the actions that you might need to take to successfully migrate your workloads from the
         *        current instance type to the recommended instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformDifferencesWithStrings(Collection<String> platformDifferences);

        /**
         * <p>
         * Explains the actions that you might need to take to successfully migrate your workloads from the current
         * instance type to the recommended instance type.
         * </p>
         * 
         * @param platformDifferences
         *        Explains the actions that you might need to take to successfully migrate your workloads from the
         *        current instance type to the recommended instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformDifferencesWithStrings(String... platformDifferences);

        /**
         * <p>
         * Explains the actions that you might need to take to successfully migrate your workloads from the current
         * instance type to the recommended instance type.
         * </p>
         * 
         * @param platformDifferences
         *        Explains the actions that you might need to take to successfully migrate your workloads from the
         *        current instance type to the recommended instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformDifferences(Collection<PlatformDifference> platformDifferences);

        /**
         * <p>
         * Explains the actions that you might need to take to successfully migrate your workloads from the current
         * instance type to the recommended instance type.
         * </p>
         * 
         * @param platformDifferences
         *        Explains the actions that you might need to take to successfully migrate your workloads from the
         *        current instance type to the recommended instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformDifferences(PlatformDifference... platformDifferences);
    }

    static final class BuilderImpl implements Builder {
        private String estimatedMonthlyCost;

        private String estimatedMonthlySavings;

        private String currencyCode;

        private Boolean defaultTargetInstance;

        private ResourceDetails resourceDetails;

        private ResourceUtilization expectedResourceUtilization;

        private List<String> platformDifferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TargetInstance model) {
            estimatedMonthlyCost(model.estimatedMonthlyCost);
            estimatedMonthlySavings(model.estimatedMonthlySavings);
            currencyCode(model.currencyCode);
            defaultTargetInstance(model.defaultTargetInstance);
            resourceDetails(model.resourceDetails);
            expectedResourceUtilization(model.expectedResourceUtilization);
            platformDifferencesWithStrings(model.platformDifferences);
        }

        public final String getEstimatedMonthlyCost() {
            return estimatedMonthlyCost;
        }

        public final void setEstimatedMonthlyCost(String estimatedMonthlyCost) {
            this.estimatedMonthlyCost = estimatedMonthlyCost;
        }

        @Override
        public final Builder estimatedMonthlyCost(String estimatedMonthlyCost) {
            this.estimatedMonthlyCost = estimatedMonthlyCost;
            return this;
        }

        public final String getEstimatedMonthlySavings() {
            return estimatedMonthlySavings;
        }

        public final void setEstimatedMonthlySavings(String estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
        }

        @Override
        public final Builder estimatedMonthlySavings(String estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Boolean getDefaultTargetInstance() {
            return defaultTargetInstance;
        }

        public final void setDefaultTargetInstance(Boolean defaultTargetInstance) {
            this.defaultTargetInstance = defaultTargetInstance;
        }

        @Override
        public final Builder defaultTargetInstance(Boolean defaultTargetInstance) {
            this.defaultTargetInstance = defaultTargetInstance;
            return this;
        }

        public final ResourceDetails.Builder getResourceDetails() {
            return resourceDetails != null ? resourceDetails.toBuilder() : null;
        }

        public final void setResourceDetails(ResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        @Override
        public final Builder resourceDetails(ResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        public final ResourceUtilization.Builder getExpectedResourceUtilization() {
            return expectedResourceUtilization != null ? expectedResourceUtilization.toBuilder() : null;
        }

        public final void setExpectedResourceUtilization(ResourceUtilization.BuilderImpl expectedResourceUtilization) {
            this.expectedResourceUtilization = expectedResourceUtilization != null ? expectedResourceUtilization.build() : null;
        }

        @Override
        public final Builder expectedResourceUtilization(ResourceUtilization expectedResourceUtilization) {
            this.expectedResourceUtilization = expectedResourceUtilization;
            return this;
        }

        public final Collection<String> getPlatformDifferences() {
            if (platformDifferences instanceof SdkAutoConstructList) {
                return null;
            }
            return platformDifferences;
        }

        public final void setPlatformDifferences(Collection<String> platformDifferences) {
            this.platformDifferences = PlatformDifferencesCopier.copy(platformDifferences);
        }

        @Override
        public final Builder platformDifferencesWithStrings(Collection<String> platformDifferences) {
            this.platformDifferences = PlatformDifferencesCopier.copy(platformDifferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformDifferencesWithStrings(String... platformDifferences) {
            platformDifferencesWithStrings(Arrays.asList(platformDifferences));
            return this;
        }

        @Override
        public final Builder platformDifferences(Collection<PlatformDifference> platformDifferences) {
            this.platformDifferences = PlatformDifferencesCopier.copyEnumToString(platformDifferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformDifferences(PlatformDifference... platformDifferences) {
            platformDifferences(Arrays.asList(platformDifferences));
            return this;
        }

        @Override
        public TargetInstance build() {
            return new TargetInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
