/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCostAllocationTagsStatusRequest extends CostExplorerRequest implements
        ToCopyableBuilder<UpdateCostAllocationTagsStatusRequest.Builder, UpdateCostAllocationTagsStatusRequest> {
    private static final SdkField<List<CostAllocationTagStatusEntry>> COST_ALLOCATION_TAGS_STATUS_FIELD = SdkField
            .<List<CostAllocationTagStatusEntry>> builder(MarshallingType.LIST)
            .memberName("CostAllocationTagsStatus")
            .getter(getter(UpdateCostAllocationTagsStatusRequest::costAllocationTagsStatus))
            .setter(setter(Builder::costAllocationTagsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostAllocationTagsStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CostAllocationTagStatusEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(CostAllocationTagStatusEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COST_ALLOCATION_TAGS_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CostAllocationTagStatusEntry> costAllocationTagsStatus;

    private UpdateCostAllocationTagsStatusRequest(BuilderImpl builder) {
        super(builder);
        this.costAllocationTagsStatus = builder.costAllocationTagsStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the CostAllocationTagsStatus property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCostAllocationTagsStatus() {
        return costAllocationTagsStatus != null && !(costAllocationTagsStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <code>CostAllocationTagStatusEntry</code> objects that are used to update cost allocation tags status
     * for this request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCostAllocationTagsStatus} method.
     * </p>
     * 
     * @return The list of <code>CostAllocationTagStatusEntry</code> objects that are used to update cost allocation
     *         tags status for this request.
     */
    public final List<CostAllocationTagStatusEntry> costAllocationTagsStatus() {
        return costAllocationTagsStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCostAllocationTagsStatus() ? costAllocationTagsStatus() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCostAllocationTagsStatusRequest)) {
            return false;
        }
        UpdateCostAllocationTagsStatusRequest other = (UpdateCostAllocationTagsStatusRequest) obj;
        return hasCostAllocationTagsStatus() == other.hasCostAllocationTagsStatus()
                && Objects.equals(costAllocationTagsStatus(), other.costAllocationTagsStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCostAllocationTagsStatusRequest")
                .add("CostAllocationTagsStatus", hasCostAllocationTagsStatus() ? costAllocationTagsStatus() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CostAllocationTagsStatus":
            return Optional.ofNullable(clazz.cast(costAllocationTagsStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CostAllocationTagsStatus", COST_ALLOCATION_TAGS_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCostAllocationTagsStatusRequest, T> g) {
        return obj -> g.apply((UpdateCostAllocationTagsStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateCostAllocationTagsStatusRequest> {
        /**
         * <p>
         * The list of <code>CostAllocationTagStatusEntry</code> objects that are used to update cost allocation tags
         * status for this request.
         * </p>
         * 
         * @param costAllocationTagsStatus
         *        The list of <code>CostAllocationTagStatusEntry</code> objects that are used to update cost allocation
         *        tags status for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costAllocationTagsStatus(Collection<CostAllocationTagStatusEntry> costAllocationTagsStatus);

        /**
         * <p>
         * The list of <code>CostAllocationTagStatusEntry</code> objects that are used to update cost allocation tags
         * status for this request.
         * </p>
         * 
         * @param costAllocationTagsStatus
         *        The list of <code>CostAllocationTagStatusEntry</code> objects that are used to update cost allocation
         *        tags status for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costAllocationTagsStatus(CostAllocationTagStatusEntry... costAllocationTagsStatus);

        /**
         * <p>
         * The list of <code>CostAllocationTagStatusEntry</code> objects that are used to update cost allocation tags
         * status for this request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.CostAllocationTagStatusEntry.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.costexplorer.model.CostAllocationTagStatusEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.CostAllocationTagStatusEntry.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #costAllocationTagsStatus(List<CostAllocationTagStatusEntry>)}.
         * 
         * @param costAllocationTagsStatus
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.CostAllocationTagStatusEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costAllocationTagsStatus(java.util.Collection<CostAllocationTagStatusEntry>)
         */
        Builder costAllocationTagsStatus(Consumer<CostAllocationTagStatusEntry.Builder>... costAllocationTagsStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private List<CostAllocationTagStatusEntry> costAllocationTagsStatus = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCostAllocationTagsStatusRequest model) {
            super(model);
            costAllocationTagsStatus(model.costAllocationTagsStatus);
        }

        public final List<CostAllocationTagStatusEntry.Builder> getCostAllocationTagsStatus() {
            List<CostAllocationTagStatusEntry.Builder> result = CostAllocationTagStatusListCopier
                    .copyToBuilder(this.costAllocationTagsStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCostAllocationTagsStatus(
                Collection<CostAllocationTagStatusEntry.BuilderImpl> costAllocationTagsStatus) {
            this.costAllocationTagsStatus = CostAllocationTagStatusListCopier.copyFromBuilder(costAllocationTagsStatus);
        }

        @Override
        public final Builder costAllocationTagsStatus(Collection<CostAllocationTagStatusEntry> costAllocationTagsStatus) {
            this.costAllocationTagsStatus = CostAllocationTagStatusListCopier.copy(costAllocationTagsStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costAllocationTagsStatus(CostAllocationTagStatusEntry... costAllocationTagsStatus) {
            costAllocationTagsStatus(Arrays.asList(costAllocationTagsStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costAllocationTagsStatus(Consumer<CostAllocationTagStatusEntry.Builder>... costAllocationTagsStatus) {
            costAllocationTagsStatus(Stream.of(costAllocationTagsStatus)
                    .map(c -> CostAllocationTagStatusEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCostAllocationTagsStatusRequest build() {
            return new UpdateCostAllocationTagsStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
